package com.ptteng.common.skill.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.apache.commons.collections.map.AbstractHashedMap;
import org.apache.commons.collections.map.HashedMap;
import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.skill.model.UserClassRelation;
import com.ptteng.common.skill.service.UserClassRelationService;


import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class UserClassRelationServiceImpl extends BaseDaoServiceImpl implements UserClassRelationService {


    private static final Log log = LogFactory.getLog(UserClassRelationServiceImpl.class);


    @Override
    public Long insert(UserClassRelation userClassRelation) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + userClassRelation);

        if (userClassRelation == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        userClassRelation.setCreateAt(currentTimeMillis);
        userClassRelation.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(userClassRelation);
        } catch (DaoException e) {
            log.error(" insert wrong : " + userClassRelation);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<UserClassRelation> insertList(List<UserClassRelation> userClassRelationList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (userClassRelationList == null ? "null" : userClassRelationList.size()));

        List<UserClassRelation> resultList = null;

        if (CollectionUtils.isEmpty(userClassRelationList)) {
            return new ArrayList<UserClassRelation>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (UserClassRelation userClassRelation : userClassRelationList) {
            userClassRelation.setCreateAt(currentTimeMillis);
            userClassRelation.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<UserClassRelation>) dao.batchSave(userClassRelationList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + userClassRelationList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(UserClassRelation.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(UserClassRelation userClassRelation) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (userClassRelation == null ? "null" : userClassRelation.getId()));

        boolean result = false;

        if (userClassRelation == null) {
            return true;
        }

        userClassRelation.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(userClassRelation);
        } catch (DaoException e) {
            log.error(" update wrong : " + userClassRelation);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + userClassRelation);
        }
        return result;
    }


    @Override
    public boolean updateList(List<UserClassRelation> userClassRelationList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (userClassRelationList == null ? "null" : userClassRelationList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(userClassRelationList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (UserClassRelation userClassRelation : userClassRelationList) {
            userClassRelation.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(userClassRelationList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + userClassRelationList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + userClassRelationList.size());

        return result;
    }


    @Override
    public UserClassRelation getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        UserClassRelation userClassRelation = null;

        if (id == null) {
            return userClassRelation;
        }

        try {
            userClassRelation = (UserClassRelation) dao.get(UserClassRelation.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return userClassRelation;
    }




    @Override
    public List<UserClassRelation> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<UserClassRelation> userClassRelation = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<UserClassRelation>();
        }

        try {
            userClassRelation = (List<UserClassRelation>) dao.getList(UserClassRelation.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (userClassRelation == null ? "null" : userClassRelation.size()));

        return userClassRelation;
    }


    

//@param
//@return
//@throws ServiceException
//@throws ServiceDaoException
     
    @Override
    public List<Long>  getUserClassRelationIdsByUid(Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

        if(log.isInfoEnabled()){
            log.info(" get ids by uid,start,limit  : " + uid+" , "+start+" , "+limit );
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getUserClassRelationIdsByUid", new Object[] { uid},start,limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by uid,start,limit)  : " + uid+" , "+start+" , "+limit );
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if(log.isInfoEnabled()){
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;



    }

    @Override
    public Long getUserClassRelationIdsByUidAndStatus(Long uid, Integer status) throws ServiceException, ServiceDaoException {
        if(log.isInfoEnabled()){
            log.info(" get ids by uid,status : " + uid+" , "+status );
        }
        Long id = null;

        // TODO 参数检查!

        try {



            id = (Long) dao.getMapping("getUserClassRelationIdsByUidAndStatus", new Object[] {uid,status });

        } catch (DaoException e) {
            log.error(" get ids  wrong by uid,status : " + uid+" , "+status );
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if(log.isInfoEnabled()){
            log.info(" get ids success : " + id);
        }
        return id;
    }

    @Override
    public Integer countUserClassRelationIdsByUid(Long uid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" count ids by uid  : " + uid);
        }
        Integer count = null;


        try {

            count = dao.count("getUserClassRelationIdsByUid", new Object[]{uid});


        } catch (DaoException e) {
            log.error(" count ids  wrong by uid)  : " + uid);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;
    }

    

//@param
//@return
//@throws ServiceException
//@throws ServiceDaoException
     
    @Override
    public Long  getUserClassRelationIdByCidAndUid(Long cid,Long uid)throws ServiceException, ServiceDaoException{

        if(log.isInfoEnabled()){
            log.info(" get id by cid,uid  : " + cid+" , "+uid );
        }
        Long id = null;

        // TODO 参数检查!

        try {



            id = (Long) dao.getMapping("getUserClassRelationIdByCidAndUid", new Object[] {cid,uid });
        } catch (DaoException e) {
            log.error(" get id wrong by cid,uid  : " + cid+" , "+uid );
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if(log.isInfoEnabled()){
            log.info(" get id success : " + id);
        }
        return id;


    }




    @Override
    public Long getUserClassRelationIdByCidAndUidAndStatus(Long cid, Long uid, Integer status) throws ServiceException, ServiceDaoException {
        if(log.isInfoEnabled()){
            log.info(" get ids by cid,uid,status : "+cid+" , " + uid+" , "+status );
        }
        Long id = null;

        // TODO 参数检查!

        try {

            id = (Long) dao.getMapping("getUserClassRelationIdByCidAndUidAndStatus", new Object[] {cid,uid,status });

        } catch (DaoException e) {
            log.error(" get ids  wrong by cid,uid,status : "+cid+" , " + uid+" , "+status );
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if(log.isInfoEnabled()){
            log.info(" get ids success : " + id);
        }
        return id;
    }

    @Override
    public List<Long> getUserClassRelationIdByOidAndUid(Long oid, Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if(log.isInfoEnabled()){
            log.info(" get id by oid,uid  : " + oid+" , "+uid );
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getUserClassRelationIdByOidAndUid", new Object[] {oid,uid},start,limit, false);

        } catch (DaoException e) {
            log.error(" get id wrong by oid,uid  : " + oid+" , "+uid );
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if(log.isInfoEnabled()){
            log.info(" get id success : " + idList);
        }
        return idList;
    }

    
//@param
//@return
//@throws ServiceException
//@throws ServiceDaoException
     
    @Override
    public List<Long> getUserClassRelationIdsByCid(Long cid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by cid,start,limit  : " + cid + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getUserClassRelationIdsByCid", new Object[]{cid}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by cid,start,limit)  : " + cid + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }


    
//@param
//@return
//@throws ServiceException
//@throws ServiceDaoException
     
    @Override
    public Integer countUserClassRelationIdsByCid(Long cid) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by cid  : " + cid);
        }
        Integer count = null;


        try {

            count = dao.count("getUserClassRelationIdsByCid", new Object[]{cid});


        } catch (DaoException e) {
            log.error(" count ids  wrong by cid)  : " + cid);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    @Override
    public List<Long> getUserClassRelationIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getUserClassRelationIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countUserClassRelationIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getUserClassRelationIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getUserClassRelationIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

    @Override
    public Map<Long,Map<Long,Long>> getUidNumRelationListByCids(List<Long> cids, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by cids,start,limit  : " + cids + " , " + start + " , " + limit);
        }
        Map<Long, Map<Long, Long>> cid_Map = new HashMap<>();

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {

            for(Long cid:cids) {
                Map<Long,Long> uid_num = new HashMap<>();
                List<Long> idList = dao.getIdList("getUserClassRelationIdsByCid", new Object[]{cid}, start, limit, false);
                List<UserClassRelation> objects = getObjectsByIds(idList);
                for(UserClassRelation object:objects){
                    uid_num.put(object.getUid(),object.getNum());
                }
                cid_Map.put(cid,uid_num);
            }

        } catch (DaoException e) {
            log.error(" get ids  wrong by cids,start,limit)  : " + cids + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (cid_Map == null ? "null" : cid_Map.size()));
        }
        return cid_Map;
    }

    @Override
    public Map<Long,Map<Long,String>> getUidSwearRelationListByCids(List<Long> cids, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException
    {
        if (log.isInfoEnabled()) {
            log.info(" get ids by cids,start,limit  : " + cids + " , " + start + " , " + limit);
        }
        Map<Long, Map<Long, String>> cid_Map = new HashMap<>();

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {

            for(Long cid:cids) {
                Map<Long,String> uid_swear = new HashMap<>();
                List<Long> idList = dao.getIdList("getUserClassRelationIdsByCid", new Object[]{cid}, start, limit, false);
                List<UserClassRelation> objects = getObjectsByIds(idList);
                for(UserClassRelation object:objects){
                    uid_swear.put(object.getUid(),object.getSwear());
                }
                cid_Map.put(cid,uid_swear);
            }

        } catch (DaoException e) {
            log.error(" get ids  wrong by cids,start,limit)  : " + cids + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (cid_Map == null ? "null" : cid_Map.size()));
        }
        return cid_Map;
    }


	@Override
	public List<Long> getUserIdsByCid(Long cid, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {

        log.info(" get userIDS   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getUserIdsByCidOfUserClassRelation", new Object[]{cid}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get userIDS  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get userIDS success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }

}

