package com.ptteng.common.skill.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.skill.model.TaskSkillRelation;
import com.ptteng.common.skill.service.TaskSkillRelationService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class TaskSkillRelationServiceImpl extends BaseDaoServiceImpl implements TaskSkillRelationService {

 

	private static final Log log = LogFactory.getLog(TaskSkillRelationServiceImpl.class);



		   
		@Override
		public Long insert(TaskSkillRelation taskSkillRelation)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + taskSkillRelation);

		if (taskSkillRelation == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		taskSkillRelation.setCreateAt(currentTimeMillis);
		taskSkillRelation.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(taskSkillRelation);
		} catch (DaoException e) {
			log.error(" insert wrong : " + taskSkillRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<TaskSkillRelation> insertList(List<TaskSkillRelation> taskSkillRelationList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (taskSkillRelationList == null ? "null" : taskSkillRelationList.size()));
      
		List<TaskSkillRelation> resultList = null;

		if (CollectionUtils.isEmpty(taskSkillRelationList)) {
			return new ArrayList<TaskSkillRelation>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (TaskSkillRelation taskSkillRelation : taskSkillRelationList) {
			taskSkillRelation.setCreateAt(currentTimeMillis);
			taskSkillRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<TaskSkillRelation>) dao.batchSave(taskSkillRelationList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + taskSkillRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(TaskSkillRelation.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(TaskSkillRelation taskSkillRelation)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (taskSkillRelation == null ? "null" : taskSkillRelation.getId()));

		boolean result = false;

		if (taskSkillRelation == null) {
			return true;
		}

		taskSkillRelation.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(taskSkillRelation);
		} catch (DaoException e) {
			log.error(" update wrong : " + taskSkillRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + taskSkillRelation);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<TaskSkillRelation> taskSkillRelationList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (taskSkillRelationList == null ? "null" : taskSkillRelationList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(taskSkillRelationList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (TaskSkillRelation taskSkillRelation : taskSkillRelationList) {
			taskSkillRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(taskSkillRelationList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + taskSkillRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + taskSkillRelationList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public TaskSkillRelation getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		TaskSkillRelation taskSkillRelation = null;

		if (id == null) {
			return taskSkillRelation;
		}

		try {
			taskSkillRelation = (TaskSkillRelation) dao.get(TaskSkillRelation.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return taskSkillRelation;		
		}	
		  
    	   
		@Override
		public List<TaskSkillRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<TaskSkillRelation> taskSkillRelation = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<TaskSkillRelation>();
		}

		try {
			taskSkillRelation = (List<TaskSkillRelation>) dao.getList(TaskSkillRelation.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (taskSkillRelation == null ? "null" : taskSkillRelation.size()));
    
		return taskSkillRelation;	
		}	
		  
    	
		
	
	
			
			
		
//
//@param 
//@return 
//@throws ServiceException
//@throws ServiceDaoException
	 
	 @Override
	public Long  getTaskSkillRelationIdByTidAndSid(Long tid,Long sid)throws ServiceException, ServiceDaoException{
		
		      if(log.isInfoEnabled()){
	  log.info(" get id by tid,sid  : " + tid+" , "+sid );
	  }
	  Long id = null;
	
      // TODO 参数检查!
      
	try {
		
	
	
        id = (Long) dao.getMapping("getTaskSkillRelationIdByTidAndSid", new Object[] {tid,sid });
   } catch (DaoException e) {
			log.error(" get id wrong by tid,sid  : " + tid+" , "+sid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get id success : " + id);
   }
		return id;
        
	
	
	
	
	}
	
			
			
		
//
//@param 
//@return 
//@throws ServiceException
//@throws ServiceDaoException
	 
	 @Override
	public List<Long>  getTaskSkillRelationIdsBySid(Long sid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by sid,start,limit  : " + sid+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getTaskSkillRelationIdsBySid", new Object[] { sid},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by sid,start,limit)  : " + sid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}

	@Override
	public List<Long> getSidsByOid(Long oid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		if(log.isInfoEnabled()){
			log.info(" get ids by oid,start,limit  : " + oid+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getSidsByOid", new Object[] { oid},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by oid,start,limit)  : " + oid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}


	
//
//@param 
//@return 
//@throws ServiceException
//@throws ServiceDaoException
	 
	 @Override
	public List<Long>  getTaskSkillRelationIdsByTid(Long tid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by tid,start,limit  : " + tid+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getTaskSkillRelationIdsByTid", new Object[] { tid},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by tid,start,limit)  : " + tid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}

	@Override
	public List<Long> getSkillIdsByTid(Long tid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		if(log.isInfoEnabled()){
			log.info(" get sids by tid,start,limit  : " + tid+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getSidsByTid", new Object[] { tid},start,limit, false);


		} catch (DaoException e) {
			log.error(" get sids  wrong by tid,start,limit)  : " + tid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get sids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;

	}


	
//
//@param 
//@return 
//@throws ServiceException
//@throws ServiceDaoException
	 
	 @Override
	public Integer  countTaskSkillRelationIdsBySid(Long sid)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by sid  : " + sid );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getTaskSkillRelationIdsBySid", new Object[] { sid});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by sid)  : " + sid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		
//
//@param 
//@return 
//@throws ServiceException
//@throws ServiceDaoException
	 
	 @Override
	public Integer  countTaskSkillRelationIdsByTid(Long tid)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by tid  : " + tid );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getTaskSkillRelationIdsByTid", new Object[] { tid});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by tid)  : " + tid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getTaskSkillRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getTaskSkillRelationIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countTaskSkillRelationIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getTaskSkillRelationIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getTaskSkillRelationIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

