package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.Servert;
import com.ptteng.common.skill.service.ServertService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class ServertServiceImpl extends BaseDaoServiceImpl implements ServertService {

 

	private static final Log log = LogFactory.getLog(ServertServiceImpl.class);



		   
		@Override
		public Long insert(Servert servert)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + servert);

		if (servert == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		servert.setCreateAt(currentTimeMillis);
		servert.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(servert);
		} catch (DaoException e) {
			log.error(" insert wrong : " + servert);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Servert> insertList(List<Servert> servertList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (servertList == null ? "null" : servertList.size()));
      
		List<Servert> resultList = null;

		if (CollectionUtils.isEmpty(servertList)) {
			return new ArrayList<Servert>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Servert servert : servertList) {
			servert.setCreateAt(currentTimeMillis);
			servert.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Servert>) dao.batchSave(servertList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + servertList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Servert.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Servert servert)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (servert == null ? "null" : servert.getId()));

		boolean result = false;

		if (servert == null) {
			return true;
		}

		servert.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(servert);
		} catch (DaoException e) {
			log.error(" update wrong : " + servert);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + servert);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Servert> servertList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (servertList == null ? "null" : servertList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(servertList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Servert servert : servertList) {
			servert.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(servertList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + servertList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + servertList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Servert getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Servert servert = null;

		if (id == null) {
			return servert;
		}

		try {
			servert = (Servert) dao.get(Servert.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return servert;		
		}	
		  
    	   
		@Override
		public List<Servert> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Servert> servert = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Servert>();
		}

		try {
			servert = (List<Servert>) dao.getList(Servert.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (servert == null ? "null" : servert.size()));
    
		return servert;	
		}	
		  
    	
		
	
	
			
			
		
//
//@param 
//@return 
//@throws ServiceException
//@throws ServiceDaoException
	 
	 @Override
	public List<Long>  getServertIdsByType(Integer type,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by type,start,limit  : " + type+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getServertIdsByType", new Object[] { type},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by type,start,limit)  : " + type+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		
//
//@param 
//@return 
//@throws ServiceException
//@throws ServiceDaoException
	 
	 @Override
	public Integer  countServertIdsByType(Integer type)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by type  : " + type );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getServertIdsByType", new Object[] { type});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by type)  : " + type );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getServertIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getServertIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countServertIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getServertIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getServertIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

