package com.ptteng.common.skill.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.skill.model.Qa;
import com.ptteng.common.skill.service.QaService;


import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class QaServiceImpl extends BaseDaoServiceImpl implements QaService {


    private static final Log log = LogFactory.getLog(QaServiceImpl.class);


    @Override
    public Long insert(Qa qa) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + qa);

        if (qa == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        qa.setCreateAt(currentTimeMillis);
        qa.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(qa);
        } catch (DaoException e) {
            log.error(" insert wrong : " + qa);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<Qa> insertList(List<Qa> qaList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (qaList == null ? "null" : qaList.size()));

        List<Qa> resultList = null;

        if (CollectionUtils.isEmpty(qaList)) {
            return new ArrayList<Qa>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (Qa qa : qaList) {
            qa.setCreateAt(currentTimeMillis);
            qa.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<Qa>) dao.batchSave(qaList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + qaList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(Qa.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(Qa qa) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (qa == null ? "null" : qa.getId()));

        boolean result = false;

        if (qa == null) {
            return true;
        }

        qa.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(qa);
        } catch (DaoException e) {
            log.error(" update wrong : " + qa);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + qa);
        }
        return result;
    }


    @Override
    public boolean updateList(List<Qa> qaList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (qaList == null ? "null" : qaList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(qaList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (Qa qa : qaList) {
            qa.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(qaList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + qaList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + qaList.size());

        return result;
    }


    @Override
    public Qa getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        Qa qa = null;

        if (id == null) {
            return qa;
        }

        try {
            qa = (Qa) dao.get(Qa.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return qa;
    }


    @Override
    public List<Qa> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<Qa> qa = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Qa>();
        }

        try {
            qa = (List<Qa>) dao.getList(Qa.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (qa == null ? "null" : qa.size()));

        return qa;
    }


    
//@param
//@return
//@throws ServiceException
//@throws ServiceDaoException
     
    @Override
    public List<Long> getQaIdsByOidAndTid(Long oid, Long tid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by oid,tid,start,limit  : " + oid + " , " + tid + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getQaIdsByOidAndTid", new Object[]{oid, tid}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by oid,tid,start,limit)  : " + oid + " , " + tid + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }


    
//@param
//@return
//@throws ServiceException
//@throws ServiceDaoException
     
    @Override
    public Integer countQaIdsByOidAndTid(Long oid, Long tid) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by oid,tid  : " + oid + " , " + tid);
        }
        Integer count = null;


        try {

            count = dao.count("getQaIdsByOidAndTid", new Object[]{oid, tid});


        } catch (DaoException e) {
            log.error(" count ids  wrong by oid,tid)  : " + oid + " , " + tid);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    @Override
    public List<Long> getQaIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getQaIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countQaIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getQaIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getQaIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

}

