package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.Order;
import com.ptteng.common.skill.service.OrderService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class OrderServiceImpl extends BaseDaoServiceImpl implements OrderService {

 

	private static final Log log = LogFactory.getLog(OrderServiceImpl.class);



		   
		@Override
		public Long insert(Order order)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + order);

		if (order == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		order.setCreateAt(currentTimeMillis);
		order.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(order);
		} catch (DaoException e) {
			log.error(" insert wrong : " + order);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Order> insertList(List<Order> orderList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (orderList == null ? "null" : orderList.size()));
      
		List<Order> resultList = null;

		if (CollectionUtils.isEmpty(orderList)) {
			return new ArrayList<Order>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Order order : orderList) {
			order.setCreateAt(currentTimeMillis);
			order.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Order>) dao.batchSave(orderList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + orderList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Order.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Order order)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (order == null ? "null" : order.getId()));

		boolean result = false;

		if (order == null) {
			return true;
		}

		order.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(order);
		} catch (DaoException e) {
			log.error(" update wrong : " + order);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + order);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Order> orderList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (orderList == null ? "null" : orderList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(orderList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Order order : orderList) {
			order.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(orderList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + orderList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + orderList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Order getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Order order = null;

		if (id == null) {
			return order;
		}

		try {
			order = (Order) dao.get(Order.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return order;		
		}

	@Override
	public Order getObjectByOrderId(String orderId) throws ServiceException, ServiceDaoException {
		log.info(" get data : " + orderId);

		Order order = null;

		if (orderId == null) {
			return order;
		}

		try {

			Long id = (Long) dao.getMapping("getObjectByOrderId",new Object[] {orderId});

			log.info("the id =" + id);
			order = (Order) dao.get(Order.class, id);

		} catch (DaoException e) {
			log.error(" get wrong : " + orderId);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" get data success : " + orderId);

		return order;
	}


	@Override
		public List<Order> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Order> order = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Order>();
		}

		try {
			order = (List<Order>) dao.getList(Order.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (order == null ? "null" : order.size()));
    
		return order;	
		}	
		  
    	
		
	
	
			
			
	
//
//@param 
//@return 
//@throws ServiceException
//@throws ServiceDaoException
	 
	 @Override
	public List<Long>  getOrderIdsByBuyer(Long buyer,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by buyer,start,limit  : " + buyer+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO �������!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getOrderIdsByBuyer", new Object[] { buyer},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by buyer,start,limit)  : " + buyer+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}

	@Override
	public List<Long> getOrderIdsByStatus(Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		if(log.isInfoEnabled()){
			log.info(" get ids by buyer,start,limit  : " + status+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO �������!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getOrderIdsByStatus", new Object[] { status},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by buyer,start,limit)  : " + status+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;	}


	
//
//@param 
//@return 
//@throws ServiceException
//@throws ServiceDaoException
	 
	 @Override
	public Integer  countOrderIdsByBuyer(Long buyer)throws ServiceException, ServiceDaoException{



		 if(log.isInfoEnabled()){
           log.info(" count ids by buyer  : " + buyer );
	     }
	 	   Integer count=null;
        
       

	try {
	   
		count = dao.count("getOrderIdsByBuyer", new Object[]{buyer});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by buyer)  : " + buyer );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}

	@Override
	public Integer countOrderIdsByStatus(Integer status) throws ServiceException, ServiceDaoException {
		if(log.isInfoEnabled()){
			log.info(" count ids by buyer  : " + status );
		}
		Integer count=null;



		try {

			count = dao.count("getOrderIdsByBuyer", new Object[]{status});


		} catch (DaoException e) {
			log.error(" count ids  wrong by buyer)  : " + status );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" count  success : " + count);
		}
		return count;
	}


	@Override
	public List<Long> getOrderIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getOrderIdsAll", new Object[]{}, start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countOrderIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getOrderIdsAll", new Object[]{});
		} catch (DaoException e) {
			log.error(" count by getOrderIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}






//	@Override
//	public List<Long> getOrderIds(Integer start, Integer limit)
//			throws ServiceException, ServiceDaoException {
//
//		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
//		List<Long> idList = null;
//
//
//
//		if (start == null) {
//			start = 0;
//		}
//
//		if (limit == null) {
//			limit = Integer.MAX_VALUE;
//		}
//
//		try {
//			idList = dao.getIdList("getOrderIdsAll", new Object[]{}, start, limit, false);
//		} catch (DaoException e) {
//			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
//			log.error(e);
//			e.printStackTrace();
//			throw new ServiceDaoException(e);
//		}
//		if (log.isInfoEnabled()) {
//			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
//		}
//		return idList;
//	}



















}

