package com.ptteng.common.skill.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.skill.model.Document;
import com.ptteng.common.skill.service.DocumentService;


import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class DocumentServiceImpl extends BaseDaoServiceImpl implements DocumentService {


    private static final Log log = LogFactory.getLog(DocumentServiceImpl.class);


    @Override
    public Long insert(Document document) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + document);

        if (document == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        document.setCreateAt(currentTimeMillis);
        document.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(document);
        } catch (DaoException e) {
            log.error(" insert wrong : " + document);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<Document> insertList(List<Document> documentList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (documentList == null ? "null" : documentList.size()));

        List<Document> resultList = null;

        if (CollectionUtils.isEmpty(documentList)) {
            return new ArrayList<Document>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (Document document : documentList) {
            document.setCreateAt(currentTimeMillis);
            document.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<Document>) dao.batchSave(documentList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + documentList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(Document.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(Document document) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (document == null ? "null" : document.getId()));

        boolean result = false;

        if (document == null) {
            return true;
        }

        document.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(document);
        } catch (DaoException e) {
            log.error(" update wrong : " + document);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + document);
        }
        return result;
    }


    @Override
    public boolean updateList(List<Document> documentList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (documentList == null ? "null" : documentList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(documentList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (Document document : documentList) {
            document.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(documentList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + documentList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + documentList.size());

        return result;
    }


    @Override
    public Document getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        Document document = null;

        if (id == null) {
            return document;
        }

        try {
            document = (Document) dao.get(Document.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return document;
    }


    @Override
    public List<Document> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<Document> document = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Document>();
        }

        try {
            document = (List<Document>) dao.getList(Document.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (document == null ? "null" : document.size()));

        return document;
    }


    //
   // @param
   // @return
   // @throws ServiceException
   // @throws ServiceDaoException
     //
    @Override
    public List<Long> getDocumentIdBySid(Long sid) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get id by sid  : " + sid);
        }
        List<Long> id = null;

        // TODO 参数检查!

        try {


            id = dao.getIdList("getDocumentIdBySid", new Object[]{sid}, 0, Integer.MAX_VALUE, false);
        } catch (DaoException e) {
            log.error(" get id wrong by sid  : " + sid);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get id success : " + id);
        }
        return id;


    }


    //
   // @param
   // @return
   // @throws ServiceException
   // @throws ServiceDaoException
     //
    @Override
    public List<Long> getDocumentIdByOidAndType(Long oid, Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get id by sid  : " + oid + " , " + start + " , " + limit);
        }
        List<Long> id = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {


            id = dao.getIdList("getDocumentIdByOidAndType", new Object[]{oid, type}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get id wrong by oid  : " + oid);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get id success : " + id);
        }
        return id;


    }


    @Override
    public Integer countDocumentIdByOidAndType(Long oid, Integer type) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" count id by oid and type  : " + oid + " , " + type);
        }
        Integer count = null;


        try {

            count = dao.count("getDocumentIdByOidAndType", new Object[]{oid, type});


        } catch (DaoException e) {
            log.error(" count id error by oid and type  : " + oid + " , " + type);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;
    }


    @Override
    public List<Long> getDocumentIdBySidAndType(Long sid, Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get ids by sid,type,start,limit  : " + sid + " , " + type + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getDocumentIdsBySidAndType", new Object[]{sid, type}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by sid,type,start,limit  : " + sid + " , " + type + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }

    @Override
    public Integer countDocumentIdBySidAndType(Long sid, Integer type) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" count id by sid and type  : " + sid + " , " + type);
        }
        Integer count = null;


        try {

            count = dao.count("getDocumentIdsBySidAndType", new Object[]{sid, type});


        } catch (DaoException e) {
            log.error(" count id error by sid and type  : " + sid + " , " + type);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;
    }


    @Override
    public List<Long> getDocumentIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getDocumentIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }

    @Override
    public List<Long> getDocumentIdsByType(Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info(" get ids  by type,start,limit  ================== " + type + " , " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getDocumentIdsByType", new Object[]{type}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by type,start,limit : " + type + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countDocumentIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getDocumentIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getDocumentIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

}

