package com.ptteng.common.skill.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.skill.model.Classes;
import com.ptteng.common.skill.service.ClassesService;


import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class ClassesServiceImpl extends BaseDaoServiceImpl implements ClassesService {


    private static final Log log = LogFactory.getLog(ClassesServiceImpl.class);


    @Override
    public Long insert(Classes classes) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + classes);

        if (classes == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        classes.setCreateAt(currentTimeMillis);
        classes.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(classes);
        } catch (DaoException e) {
            log.error(" insert wrong : " + classes);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<Classes> insertList(List<Classes> classesList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (classesList == null ? "null" : classesList.size()));

        List<Classes> resultList = null;

        if (CollectionUtils.isEmpty(classesList)) {
            return new ArrayList<Classes>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (Classes classes : classesList) {
            classes.setCreateAt(currentTimeMillis);
            classes.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<Classes>) dao.batchSave(classesList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + classesList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(Classes.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(Classes classes) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (classes == null ? "null" : classes.getId()));

        boolean result = false;

        if (classes == null) {
            return true;
        }

        classes.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(classes);
        } catch (DaoException e) {
            log.error(" update wrong : " + classes);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + classes);
        }
        return result;
    }


    @Override
    public boolean updateList(List<Classes> classesList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (classesList == null ? "null" : classesList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(classesList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (Classes classes : classesList) {
            classes.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(classesList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + classesList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + classesList.size());

        return result;
    }


    @Override
    public Classes getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        Classes classes = null;

        if (id == null) {
            return classes;
        }

        try {
            classes = (Classes) dao.get(Classes.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return classes;
    }


    @Override
    public List<Classes> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<Classes> classes = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Classes>();
        }

        try {
            classes = (List<Classes>) dao.getList(Classes.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (classes == null ? "null" : classes.size()));

        return classes;
    }


    //  
   //   @param
   //   @return
   //   @throws ServiceException
   //   @throws ServiceDaoException
   //  /
    @Override
    public List<Long> getClassesIdsByOidAndGrade(Long oid, Long grade, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by oid,grade,start,limit  : " + oid + " , " + grade + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getClassesIdsByOidAndGrade", new Object[]{oid, grade}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by oid,grade,start,limit)  : " + oid + " , " + grade + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }


    //
   //   @param
   //   @return
   //   @throws ServiceException
   //   @throws ServiceDaoException
     //
    @Override
    public List<Long> getClassesIdsByName(String name, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get id by name  : " + name);
        }
        List<Long> ids = null;

        // TODO 参数检查!

        try {


            ids = dao.getIdList("getClassesIdsByName", new Object[]{name}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get id wrong by name  : " + name);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + ids);
        }
        return ids;


    }


    //  
   //   @param
   //   @return
   //   @throws ServiceException
   //   @throws ServiceDaoException
   //  /
    @Override
    public List<Long> getClassesIdsByOid(Long oid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by oid,start,limit  : " + oid + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getClassesIdsByOid", new Object[]{oid}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by oid,start,limit)  : " + oid + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }

    @Override
    public List<Long> getClassesIdsByType(String type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get ids by type,start,limit  : " + type + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getClassesIdsByType", new Object[]{type}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by type,start,limit)  : " + type + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }

    @Override
    public List<Long> getClassesIdsByOidAndName(Long oid, String name, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get ids by oid,name,start,limit  : " + oid + " , " + name + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getClassesIdsByOidAndName", new Object[]{oid,name}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by oid,name,start,limit  : " + oid + " , " + name + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public List<Long> getClassesIdsByOidAndNameAndType(Long oid, String name,String type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get ids by oid,name,type,start,limit  : " + oid + " , " + name + " , " + type + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getClassesIdsByOidAndNameAndType", new Object[]{oid,name,type}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by oid,name,type,start,limit  : " + oid + " , " + name + " , " + type + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }

    @Override
    public List<Long> getClassesIdsByOidAndType(Long oid, String type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get ids by oid,type,start,limit  : " + oid + " , " + type + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getClassesIdsByOidAndType", new Object[]{oid,type}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by type,name,start,limit  : " + oid + " , " + type + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }

    @Override
    public List<Long> getClassesIdsByTypeAndName(String type, String name, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get ids by type,name,start,limit  : " + type + " , " + name + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getClassesIdsByTypeAndName", new Object[]{type,name}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by type,name,start,limit  : " + type + " , " + name + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    //  
   //   @param
   //   @return
   //   @throws ServiceException
   //   @throws ServiceDaoException
   //  /
    @Override
    public Integer countClassesIdsByOidAndGrade(Long oid, Long grade) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by oid,grade  : " + oid + " , " + grade);
        }
        Integer count = null;


        try {

            count = dao.count("getClassesIdsByOidAndGrade", new Object[]{oid, grade});


        } catch (DaoException e) {
            log.error(" count ids  wrong by oid,grade)  : " + oid + " , " + grade);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    //  
   //   @param
   //   @return
   //   @throws ServiceException
   //   @throws ServiceDaoException
   //
    @Override
    public Integer countClassesIdsByOid(Long oid) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by oid  : " + oid);
        }
        Integer count = null;


        try {

            count = dao.count("getClassesIdsByOid", new Object[]{oid});


        } catch (DaoException e) {
            log.error(" count ids  wrong by oid)  : " + oid);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }

    @Override
    public Integer countClassesIdsByType(String type) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" count ids by type  : " + type);
        }
        Integer count = null;


        try {

            count = dao.count("getClassesIdsByType", new Object[]{type});


        } catch (DaoException e) {
            log.error(" count ids  wrong by type  : " + type);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;
    }


    @Override
    public List<Long> getClassesIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getClassesIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countClassesIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getClassesIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getClassesIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

    @Override
    public List<Long> getClassesIdsbyOccupation(Long oid, Long start, Long limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by oid,oid  : " + oid + " , start " + start + " , limit "+limit);
        }
        List<Long> classesIdList = null;


        try {

            classesIdList = dao.getIdList("getClassesIdsbyOccupation", new Object[]{oid, start, limit}, 0, Integer.MAX_VALUE, false);


        } catch (DaoException e) {
            log.error(" count ids  wrong by oid,oid  : " + oid + " , start " + start + " , limit "+limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get classesID success : " + classesIdList);
        }
        return classesIdList;
    }

    @Override
    public List<Long> getClassesIdsbyOccupationAndType(Long oid, String type, Long start, Long limit, Integer classesStart, Integer classesSize) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get ids by oid,type,oid  : " + oid + " , type "+type+" start " + start + " , limit "+limit);
        }
        List<Long> classesIdList = null;


        try {

            classesIdList = dao.getIdList("getClassesIdsbyOccupationAndType", new Object[]{oid, start, limit, type}, classesStart, classesSize, false);


        } catch (DaoException e) {
            log.error(" count ids  wrong by oid,oid  : " + oid + " , type "+type+" start " + start + " , limit "+limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get classesID success : " + classesIdList);
        }
        return classesIdList;
    }

}

