package com.ptteng.common.skill.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.skill.model.Article;
import com.ptteng.common.skill.service.ArticleService;


import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class ArticleServiceImpl extends BaseDaoServiceImpl implements ArticleService {


    private static final Log log = LogFactory.getLog(ArticleServiceImpl.class);


    @Override
    public Long insert(Article article) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + article);

        if (article == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        article.setCreateAt(currentTimeMillis);
        article.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(article);
        } catch (DaoException e) {
            log.error(" insert wrong : " + article);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<Article> insertList(List<Article> articleList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (articleList == null ? "null" : articleList.size()));

        List<Article> resultList = null;

        if (CollectionUtils.isEmpty(articleList)) {
            return new ArrayList<Article>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (Article article : articleList) {
            article.setCreateAt(currentTimeMillis);
            article.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<Article>) dao.batchSave(articleList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + articleList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(Article.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(Article article) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (article == null ? "null" : article.getId()));

        boolean result = false;

        if (article == null) {
            return true;
        }

        article.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(article);
        } catch (DaoException e) {
            log.error(" update wrong : " + article);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + article);
        }
        return result;
    }


    @Override
    public boolean updateList(List<Article> articleList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (articleList == null ? "null" : articleList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(articleList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (Article article : articleList) {
            article.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(articleList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + articleList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + articleList.size());

        return result;
    }


    @Override
    public Article getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        Article article = null;

        if (id == null) {
            return article;
        }

        try {
            article = (Article) dao.get(Article.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return article;
    }


    @Override
    public List<Article> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<Article> article = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Article>();
        }

        try {
            article = (List<Article>) dao.getList(Article.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (article == null ? "null" : article.size()));

        return article;
    }


    
//@param
//@return
//@throws ServiceException
//@throws ServiceDaoException
     
    @Override
    public List<Long> getArticleIdsByCidAndType(Long cid, String type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by cid,type,start,limit  : " + cid + " , " + type + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getArticleIdsByCidAndType", new Object[]{cid, type}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by cid,type,start,limit)  : " + cid + " , " + type + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }

    @Override
    public List<Long> getArticleIdsByUidAndType(Long uid, String type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get ids by uid,type,start,limit  : " + uid + " , " + type + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getArticleIdsByUidAndType", new Object[]{uid, type}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by cid,type,start,limit)  : " + uid + " , " + type + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;    }

    @Override
    public Integer counttArticleIdsByUidAndType(Long uid, String type) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" count ids by uid,type  : " + uid + " , " + type);
        }
        Integer count = null;


        try {

            count = dao.count("getArticleIdsByUidAndType", new Object[]{uid, type});


        } catch (DaoException e) {
            log.error(" count ids  wrong by uid,type)  : " + uid + " , " + type);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;    }


    
//@param
//@return
//@throws ServiceException
//@throws ServiceDaoException
     
    @Override
    public Integer countArticleIdsByCidAndType(Long cid, String type) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by cid,type  : " + cid + " , " + type);
        }
        Integer count = null;


        try {

            count = dao.count("getArticleIdsByCidAndType", new Object[]{cid, type});


        } catch (DaoException e) {
            log.error(" count ids  wrong by cid,type)  : " + cid + " , " + type);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    @Override
    public List<Long> getArticleIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getArticleIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countArticleIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getArticleIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getArticleIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

    @Override
    public Long getLastArticleIdByUidAndCid(Long uid, Long cid) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get lastArticleId by uid , cid  : " + uid + " , " + cid);
        }
        Long articleId = null;
        List<Long> articleIds = null;
        List<Long> articleIdList = null;

        try {

            articleIds = dao.getIdList("getArticleIdsByUidAndCid", new Object[]{uid, cid}, 0, Integer.MAX_VALUE, false);
            Long id = articleIds.get(0);
            Article article = getObjectById(id);
            Long dailyTime = article.getDailyTime();

            articleIdList = dao.getIdList("getArticlrIdsByUidAndCidAndDailyTime",new Object[]{uid,cid,dailyTime},0,Integer.MAX_VALUE,false);
            articleId = articleIdList.get(0);

        } catch (DaoException e) {
            log.error(" get lastArticleId wrong by uid , cid)  : " + uid + " , " + cid);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get lastArticleId : " + articleId);
        }
        return articleId;
    }

    @Override
    public List<Long> getArticleIdByUidAndCid(Long uid, Long cid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get articleId by uid , cid  : " + uid + " , " + cid);
        }
        Long articleId = null;
        List<Long> articleIds = null;
        List<Long> articleIdList = null;

        try {

            articleIds = dao.getIdList("getArticleIdsByUidAndCid", new Object[]{uid, cid}, start, limit, false);

        } catch (DaoException e) {
            log.error(" get articleId wrong by uid , cid)  : " + uid + " , " + cid);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get articleId : " + articleId);
        }
        return articleIds;
    }

    @Override
    public List<Long> getArticleIdsByOidAndType(Long oid, String type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get ids by cid,type,start,limit  : " + oid + " , " + type + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getArticleIdsByOidAndType", new Object[]{oid, type}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by oid,type,start,limit)  : " + oid + " , " + type + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }

    @Override
    public Integer countArticleIdsByOidAndType(Long oid, String type) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by oid,type  : " + oid + " , " + type);
        }
        Integer count = null;


        try {

            count = dao.count("getArticleIdsByOidAndType", new Object[]{oid, type});


        } catch (DaoException e) {
            log.error(" count ids  wrong by oid,type)  : " + oid + " , " + type);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;
    }

}

