package com.ptteng.common.skill.controller;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.skill.model.Review;
import com.ptteng.common.skill.model.User;
import com.ptteng.common.skill.service.ReviewService;
import com.ptteng.common.skill.service.UserService;

/**
 * Review  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class ReviewController {
	private static final Log log = LogFactory.getLog(ReviewController.class);

	@Autowired
	private ReviewService reviewService;
	
	@Autowired
	private UserService userService;





	
	
	    		
			
    /**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	
		@RequestMapping(value = "/a/review/search/query", method = RequestMethod.GET)
	public String getReviewIdsByUidJsonList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long uid) throws Exception {


	
		log.info("get review of uid  = " + uid );

		try {
			
			

			Set<Long> uids=new HashSet();
			 List<User> users=new ArrayList();
			List<Long> ids= reviewService.getReviewIdsByUid(uid,0,Integer.MAX_VALUE);
	     log.info("get countReviewIdsByUid size is " + ids.size());

			List<Review> reviewList = reviewService.getObjectsByIds(ids);
			log.info("get review data is " + reviewList.size());
		
			
			if(CollectionUtils.isEmpty(reviewList)){
				
			}else{
				for(Review review:reviewList){
					uids.add(review.getUid());
					uids.add(review.getRid());
				}
				users=this.userService.getObjectsByIds(new ArrayList(uids));
			}
		   

			Integer total = reviewService. countReviewIdsByUid(uid);
			log.info("get review count is " + total);

			model.addAttribute("code", 0);
		
			
			model.addAttribute("total", total);

			model.addAttribute("reviewList", reviewList);
			model.addAttribute("users", users);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get review of uid  = " + uid);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/review/json/reviewListJson";
	}

	
	
		
	

	
	
	
}

