package com.ptteng.common.skill.controller;

import com.ptteng.common.skill.model.ClassTeam;
import com.ptteng.common.skill.model.User;
import com.ptteng.common.skill.service.ClassTeamService;
import com.ptteng.common.skill.service.UserService;
import com.ptteng.common.skill.util.DynamicUtil;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 前台：课堂小组管理
 *
 * @Author ruanshaonan
 * @Description
 * @Date 9:04 2018/7/3
 */
@Controller
public class ClassTeamController {
    private static final Log log = LogFactory.getLog(ClassTeamController.class);

    @Autowired
    private ClassTeamService classTeamService;

    @Autowired
    private UserService userService;

    /**
     * 获取小组列表
     *
     * @return
     * @Author ruanshaonan
     * @Description
     * @Date 10:16 2018/6/27
     * @Param oid：职业id
     */
    @RequestMapping(value = "/a/u/class/team/list/{oid}", method = RequestMethod.GET)
    public String getClassTeamList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                   @PathVariable("oid") Long oid)
            throws Exception {

        log.info("getClassTeamList= oid=" + oid);

        try {
            Map<String, Object> sqlMap = DynamicUtil.getClassTeamByOid(oid);
            log.info("sqlMap=" + sqlMap);
            List<Long> ids = classTeamService.getIdsByDynamicCondition(ClassTeam.class, sqlMap, 0, Integer.MAX_VALUE);
            log.info("ids=" + ids.size());
            if (CollectionUtils.isEmpty(ids)) {
                model.addAttribute("code", -60002);
                return "/common/success";
            }
            List<ClassTeam> classTeams = classTeamService.getObjectsByIds(ids);
            model.addAttribute("classTeamList", classTeams);
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error("getClassTeamList error=" + t.getMessage(),t);
            model.addAttribute("code", -1);
            return "/common/success";
        }
        return "/common-skill-service/classTeam/json/classTeamListJson";
    }

    /**
     * 获取小组成员列表
     *
     * @Author ruanshaonan
     * @Description
     * @Date 12:20 2018/6/27
     * @Param id：小组id
     */
    @RequestMapping(value = "/a/u/class/team/users/{id}", method = RequestMethod.GET)
    public String getGroupUsers(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model, @PathVariable("id") Long id)
            throws Exception {

        log.info("getGroupUsers==id==" + id);

        List<User> userList = new ArrayList<>();
        try {
            Map<String, Object> sqlMap = DynamicUtil.getMemberByGroupId(id);
            List<Long> groupUserIds = userService.getIdsByDynamicCondition(User.class, sqlMap, 0, Integer.MAX_VALUE);
            log.info("groupUserIds=" + groupUserIds.size());
            if (CollectionUtils.isEmpty(groupUserIds)) {
                model.addAttribute("code", -60004);
                return "/common/success";
            }
            userList = userService.getObjectsByIds(groupUserIds);
            log.info("get group user success==userList=" + userList.size());
        } catch (Throwable throwable) {
            throwable.printStackTrace();
            log.error("get group user fail=" + id + "=msg=" + throwable.getMessage(),throwable);
            model.addAttribute("code", -1);
            return "/common/success";
        }
        model.addAttribute("code", 0);
        model.addAttribute("userList", userList);
        return "/common-skill-service/classTeam/json/classTeamUserListJson";
    }

}

