package com.ptteng.common.skill.util;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.ptteng.common.skill.model.BranchInstitute;
import com.ptteng.common.skill.model.Occupation;
import com.ptteng.common.skill.model.User;
import com.ptteng.common.skill.service.BranchInstituteService;
import com.ptteng.common.skill.service.OccupationService;
import com.ptteng.common.skill.service.UserService;
import com.ptteng.common.skill.util.UserUtil;
import com.qding.common.util.DataUtils;
@Component
public class CommonUtil {

    @Autowired
    private  UserService userService;


    @Autowired
    private  OccupationService occupationService;


    @Autowired
    private  BranchInstituteService branchInstituteService;

    private static final Log log = LogFactory.getLog(CommonUtil.class);

    public  String setUserShowName(Long uid) {
        String userNick = null;
        BranchInstitute branchDetail=null;
        Occupation userOccupation=null;
        try {

            //无名、散修和外门展示学号，只有内门及内门以上的用户展示昵称
            //有分院展示分院，有职业展示职业
            String branch = null;
            User user=userService.getObjectById(uid);
            if (DataUtils.isNotNullOrEmpty(user.getBranch())) {
                Long userBranch = user.getBranch().longValue();
                 branchDetail = branchInstituteService.getObjectById(userBranch);
                branch = branchDetail.getName() + "分院|";
            }
            log.info("user branch is:" + branch);
            String userOccupationName = null;
            long userNumber = user.getStudyNumber();
            int identity = user.getIdentity();
            log.info("identity is :" + identity);
            if (!user.getOid().equals(User.Occupation_None)) {
                Long userOid = user.getOid();
                 userOccupation = occupationService.getObjectById(userOid);
                userOccupationName = userOccupation.getName().toUpperCase();
            }

            //10、无名弟子 20、散修弟子 30、外门弟子 40、内门弟子  50、首席弟子  55 荣耀师兄 60、真传弟子  70、修真长老

            userNick=UserUtil.convertName(user,branchDetail,userOccupation);
        }catch (Throwable t) {
            log.error("error is " , t);
        }
        log.info("userNick  is:" + userNick);
        return  userNick;
    }
}
