package com.ptteng.common.skill.controller;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.skill.model.BranchInstitute;
import com.ptteng.common.skill.model.Constant;
import com.ptteng.common.skill.model.Message;
import com.ptteng.common.skill.model.Occupation;
import com.ptteng.common.skill.model.Teacher;
import com.ptteng.common.skill.model.User;
import com.ptteng.common.skill.model.UserClassRelation;
import com.ptteng.common.skill.service.BranchInstituteService;
import com.ptteng.common.skill.service.ConstantService;
import com.ptteng.common.skill.service.MessageService;
import com.ptteng.common.skill.service.OccupationService;
import com.ptteng.common.skill.service.TeacherService;
import com.ptteng.common.skill.service.UserClassRelationService;
import com.ptteng.common.skill.service.UserService;
import com.ptteng.common.skill.util.CheckDataUtil;
import com.ptteng.common.skill.util.DynamicUtil;
import com.ptteng.common.skill.util.LogUtil;
import com.ptteng.common.skill.util.UserUtil;
import com.qding.common.util.DataUtils;
import com.qding.common.util.HttpClientUtil;
import com.qding.common.util.http.cookie.CookieUtil;



/**
 * Teacher  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class TeacherController {
    private static final Log log = LogFactory.getLog(TeacherController.class);

    @Autowired
    private TeacherService teacherService;

    @Autowired
    private UserService userService;

    @Autowired
    private MessageService messageService;

    @Autowired
    private OccupationService occupationService;

    @Autowired
    private CookieUtil cookieUtil;

    @Autowired
    private ConstantService constantService;
    @Autowired
    private UserClassRelationService userClassRelationService;

    @Autowired
    private BranchInstituteService branchInstituteService;


    /**
     * 1.新建师兄弟关系
     *
     * @param request
     * @param response
     * @param model
     * @param teacherUid
     * @param oid
     * @return
     */
    @RequestMapping(value = "/a/u/teacher", method = RequestMethod.POST)
    public String appointTeacher(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                 Long teacherUid, Long oid) {

        User student = (User) request.getAttribute("user");
        Long studentUid = student.getId();
        String logStr = LogUtil.convertParam(studentUid, " want to get a teacher by teacherUid=", teacherUid, " oid=", oid);
        log.info(logStr);

        try {
            /* 校验关键参数 */
            if (CheckDataUtil.isNull(teacherUid) && CheckDataUtil.isNull(oid)) {
                log.info(studentUid + " cann`t be appointed a teacher with losting parameter");
                model.addAttribute("code", -15002);
                return "/common/success";
            }
            /**
             * 前台加入班级，用户身份是散修弟子，所以师兄身份是外门弟子，但是外门弟子太少，所以暂时先用内门弟子;
             * 排序方式是散修弟子数online_now
             */
            //Integer identify = User.IDENTIFY_40;
            String orderBy = Teacher.online_now;

			/* teacherUid为空，按职业随机给师弟分配师兄 */
            if (CheckDataUtil.isNull(teacherUid)) {
            	//Todo  重新写
                //按顺序遍历该职业内门、首席、真传弟子，如果内门弟子没有人就把散修弟子分配给首席或真传弟子
                for (int identify = 40; identify <= 70; identify += 10) {
                    if (identify == 70) {
						/* 没有可分配师兄则报错返回 */
                        log.info(" there is not a teacher for oid=" + oid);
                        model.addAttribute("code", -15007);
					   /* 发送系统消息给修真院收官者 */
                        sendMessageToGM(student);
                        return "/common/success";
                    }
                    Map<String, Object> paramList = DynamicUtil.getTeacherInfoListParam(oid, identify, orderBy, false);
                    log.info("get param:" + paramList);
                    //从结业真传里寻找
                    if(paramList.isEmpty()){
                        paramList = DynamicUtil.getTeacherInfoListParamFromSuccessor(oid, identify, orderBy, false);
                        log.info("get param:" + paramList);
                    }
                    List<Long> uidList = userService.getIdsByDynamicCondition(User.class, paramList, 0, Integer.MAX_VALUE);
                    if (CollectionUtils.isNotEmpty(uidList)) {
                        teacherUid = uidList.get(0);
                        log.info("identify is:" + identify + "teacherUid is:" + teacherUid + " has the least online students");
                        break;
                    }

                }
            }

            Teacher teacherInfo = teacherService.getObjectById(teacherUid);
            if (CheckDataUtil.isNull(teacherInfo)) {
                //如果筛选出来的人未加到teacher表中，那么添加一下
                addTeacher(teacherUid);
            }
			/* 更新用户数据 */
            student.setTeacherId(teacherUid);
            userService.update(student);
            log.info(studentUid + " get a teacher, teacherUid:" + teacherUid);

			/* 更新统计数据 */
            teacherService.addTeacherRelationToStundent(student, teacherUid);
			/* 推送系统通知 */
            User teacher = userService.getObjectById(teacherUid);
            sendMessageToStudent(student, teacher, true);
            sendMessageToTeacher(student, teacher, true);

            sendPrivateMessageToStudent(student, teacher,true);

            model.addAttribute("code", 0);
            model.addAttribute("id", teacherUid);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("failed in appointing a teacher to " + studentUid);
            model.addAttribute("code", -1);
        }

        return "/common/insert";

    }

    public void sendPrivateMessageToStudent(User student, User teacher, boolean action) throws ServiceException, ServiceDaoException {

        //用户信息要重新获取一遍， 不然消息就不能实时更新
        student = userService.getObjectById(student.getId());
        teacher = userService.getObjectById(teacher.getId());
        Long uid = student.getId();
        Long teacherUid = teacher.getId();

        //根据不同性别展示不同文案
        Long sex = teacher.getSex();

        int privateMessageCount = 0;

        //  获取师兄数据
        String userNick = setUserShowName(teacherUid);
        String notifyMessage = "<span class=\"font-16px  system-alert-outline  " +
                "ng-scope\"><a data-mid=\"67054\" ng-click=\"sendAlertMsg(li.id)\" target=\"_blank\" href=\"/school/"
                + teacherUid + "/class\"><span class=\"font-green\">" + userNick + "</span> </a> 给你发送了一条" +
                "<a ng-click=\"sendAlertMsg(li.id)\"  target=\"_blank\" href=\"/school/" + uid + "/privateDetail/" + teacherUid + "/\"><span class='font-green'>私信</span></a></span>";
        Long timeStr = new Date().getTime();
        SimpleDateFormat timeType = new SimpleDateFormat("yyyy-MM-dd ");
        String nowTime = timeType.format(new Date(Long.parseLong(String.valueOf(timeStr))));
//                    Long minTodayUnix = timeType.parse(nowTime).getTime();
//                    List<Long> messagesTodayUnixList = messageService.getMessagesTodayUnixList(student.getId(), minTodayUnix, 0, Integer.MAX_VALUE);
//                    int TodayNum = messagesTodayUnixList.size();
        List<Long> users = this.constantService.getConstantIdsByType(Message.Type_privateCount, 0, Integer.MAX_VALUE);
        List<Constant> constantsUsersList = constantService.getObjectsByIds(users);
        for (Constant constant : constantsUsersList) {
            if (Message.Name_privateMessageCount.equals(constant.getName())) {
                privateMessageCount = Integer.valueOf(constant.getValue());
            }
        }
//                    if (TodayNum <= privateMessageCount) {
        //生成一条系统通知 type 为notify
        Message notifyItem = new Message();
        notifyItem.setSendId(teacher.getId());
        notifyItem.setReceiveId(student.getId());
        notifyItem.setSendName(teacher.getNick());
        notifyItem.setReceiveName(student.getNick());
        notifyItem.setContent(notifyMessage);
        notifyItem.setStatus(Message.STATUS_UNDELETE);
        notifyItem.setUnread(Message.Status_Unread);
        notifyItem.setType(Message.NOTIFY_TYPE);
        notifyItem.setReceiveId(student.getId());
        Long mid=messageService.insert(notifyItem);

        String content;

        if (sex==null){
            content = LogUtil.convertString("<span  class=\\\"font-16px system-alert-outline \\\">欢迎加入修真院！我是你的师兄<a data-mid=", mid,
                    " ng-click=\\\"sendAlertMsg(li.id)\\\" target=\"_blank\" href=\\\"/school/", teacherUid,
                    "/class\\\"><span class=\\\"font-green\\\">",
                    teacher.getNick(), "</span> </a>，如果在学习过程中遇到任何问题，欢迎私信m我~  </span>");

        }else if (sex==1){
            //师姐
            content = LogUtil.convertString("<span  class=\\\"font-16px system-alert-outline \\\">欢迎加入修真院！我是你的师姐<a data-mid=", mid,
                    " ng-click=\\\"sendAlertMsg(li.id)\\\" target=\"_blank\" href=\\\"/school/", teacherUid,
                    "/class\\\"><span class=\\\"font-green\\\">",
                    teacher.getNick(), "</span> </a>，如果在学习过程中遇到任何问题，欢迎私信m我~  </span>");

        }else {
            content = LogUtil.convertString("<span  class=\\\"font-16px system-alert-outline \\\">欢迎加入修真院！我是你的师兄<a data-mid=", mid,
                    " ng-click=\\\"sendAlertMsg(li.id)\\\" target=\"_blank\" href=\\\"/school/", teacherUid,
                    "/class\\\"><span class=\\\"font-green\\\">",
                    teacher.getNick(), "</span> </a>，如果在学习过程中遇到任何问题，欢迎私信m我~  </span>");

        }

        Message message1 = messageService.getObjectById(mid);
        message1.setContent(content);

        Integer unreadNum = student.getIsLook() + 1;
        student.setIsLook(unreadNum);
        student.setLatestMsg("notify");

        log.info(student.getIsLook());
        userService.update(student);

        Message item = new Message();
        item.setSendId(teacherUid);
        item.setReceiveId(student.getId());
        item.setSendName(student.getNick());
        item.setReceiveName(student.getNick());
        item.setContent(content);
        item.setStatus(Message.STATUS_UNDELETE);
        item.setUnread(Message.Status_Unread);
        item.setType(Message.PRIVATE_TYPE);
        item.setReceiveId(uid);
        messageService.insert(item);
//                    }
    }



    /**
     * 添加用户拓展信息
     *
     * @param uid
     * @return
     * @throws Exception
     */
    public Teacher addTeacher(Long uid) throws Exception {

        Teacher teacher = new Teacher();
        try {
            if (CheckDataUtil.isNotNull(uid)) {
                teacher.setId(uid);
                teacherService.insert(teacher);
                log.info(" insert a teacher ,the new teacher id :" + uid);
                teacher = teacherService.getObjectById(uid);
            }
        } catch (Exception t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add teacher error ");
        }

        return teacher;
    }


    /**
     * 推送即时消息给修真院守关者
     * @param student
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public void sendMessageToGM(User student) throws ServiceException, ServiceDaoException {

        log.info(" sendMessageToGM start ,student id " + student.getId());
        List<Message> messages = new ArrayList<>();
        Long studentUid = student.getId();
        String studentNick = student.getNick();
        Long oid = student.getOid();
        log.info(" user oid = " + oid);
        String occupationName = "无名";
        Occupation occupation = occupationService.getObjectById(oid);
        if (DataUtils.isNullOrEmpty(occupation)) {
        } else {
            occupationName = occupation.getName();
        }
        //查找该职业下的所有真传弟子
        List<Long> leaderIds = userService.getIdsByOidAndIdentity(oid, User.Identity_Offical, 0, Integer.MAX_VALUE);
        log.info(" leader ids = " + leaderIds);
        if (CollectionUtils.isEmpty(leaderIds)) {
            //如果没有真传弟子，则发送给守关人
            leaderIds.add(User.SGUID);
        }
        log.info(" leader size = " + leaderIds.size() + " ids = " + leaderIds);
        List<User> leaders = userService.getObjectsByIds(leaderIds);
        for (User leader : leaders) {
            Long GMuid = leader.getId();
            String nick = leader.getNick();
            Integer unLook = leader.getIsLook() + 1;
            leader.setIsLook(unLook);
            leader.setLatestMsg(Message.CLASS_TYPE);

            Message message = new Message();
            message.setStatus(Message.STATUS_UNDELETE);
            message.setReceiveName(nick);
            message.setSendName("admin");
            message.setSendId(0L);
            message.setContent(leader.getMobile());
            message.setReceiveId(GMuid);
            message.setUnread(Message.Status_Unread);
            message.setType(Message.CLASS_TYPE);
            message.setRelationId(studentUid);
            messages.add(message);

        }
        log.info(" messages size = " + messages.size());
        List<Message> newMessages = messageService.insertList(messages);
        userService.updateList(leaders);
        String content = "";
        for (Message message : newMessages) {
            log.info(" message content = " + message.getContent());
            Long mid = message.getId();
            content = LogUtil.convertString("<span  class=\\\"font-16px system-alert-outline \\\"><a data-mid=", mid,
                    " ng-click=\\\"sendAlertMsg(li.id)\\\" target=\"_blank\" href=\\\"/school/", studentUid,
                    "/class\\\"><span class=\\\"font-green\\\">", occupationName,
                    "新学员 ", studentNick, "</span> </a>无师兄可分配，请在后台手动指定师兄</span>");
            adminSend(message.getContent(), content);
            message.setContent(content);
        }
        messageService.updateList(newMessages);
    }


    /**
     * 推送新建关系的即时消息给师弟
     * action == true, 建立关系
     * action == false, 解除关系
     * @param student
     * @param teacher
     * @param action
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public void sendMessageToStudent(User student, User teacher, boolean action) throws ServiceException, ServiceDaoException {

        //初始化消息属性
        Long studentUid = student.getId();
        String nick = student.getNick();
        String mobile = student.getMobile();
        Long teacherUid = teacher.getId();
        String userNick = setUserShowName(teacherUid);
        log.info(" userNick:" + userNick);

        //设置消息内容
        String content = "";

        //插入消息
        Message message = new Message();
        message.setStatus(1);
        message.setReceiveName(nick);
        message.setSendName("admin");
        message.setSendId(0L);
        message.setContent(content);
        message.setReceiveId(studentUid);
        message.setUnread(1);
        message.setType(Message.CLASS_TYPE);
        message.setRelationId(teacherUid);
        Long mid = messageService.insert(message);

        //消息插入成功后执行
        if (DataUtils.isNotNullOrEmpty(mid)) {
            if (action) {
                content = LogUtil.convertString("<span  class=\\\"font-16px system-alert-outline \\\">系统分配 <a data-mid=", mid,
                        " ng-click=\\\"sendAlertMsg(li.id)\\\" target=\"_blank\" href=\\\"/school/", teacherUid,
                        "/class\\\"><span class=\\\"font-green\\\">",
                        userNick, "</span> </a> 担任您的师兄</span>");
            } else {
                content = LogUtil.convertString("<span  class=\\\"font-16px system-alert-outline \\\"><a data-mid=", mid,
                        " ng-click=\\\"sendAlertMsg(li.id)\\\"  target=\"_blank\" href=\\\"/school/", teacherUid,
                        "/class\\\"><span class=\\\"font-green\\\">",
                        userNick, "</span> </a> 已与您解除师兄弟关系</span>");
            }

            Message message1 = messageService.getObjectById(mid);
            message1.setContent(content);
            boolean isOk = messageService.update(message1);

            if (isOk) {
                log.info("user : " + studentUid + " send : " + content);
                adminSend(mobile, content);

                //更新未读消息
                Integer unLook = student.getIsLook() + 1;
                student.setIsLook(unLook);
                student.setLatestMsg(Message.CLASS_TYPE);
                userService.update(student);
            }
        }
    }


    /**
     * 推送新建关系的即时消息给师兄
     * action == true, 建立关系
     * action == false, 解除关系
     *
     * @param student
     * @param teacher
     * @param action
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public void sendMessageToTeacher(User student, User teacher, boolean action) throws ServiceException, ServiceDaoException {
        log.info(" sendMessageToTeacher start ");

        Long teacherUid = teacher.getId();
        String nick = teacher.getNick();
        String mobile = teacher.getMobile();
        Long studentUid = student.getId();
        String userNick = setUserShowName(studentUid);
        log.info("student userNick:" + userNick);

        String content = "";

        Message message = new Message();
        message.setStatus(1);
        message.setReceiveName(nick);
        message.setSendName("admin");
        message.setSendId(0L);
        message.setContent(content);
        message.setReceiveId(teacherUid);
        message.setUnread(1);
        message.setType(Message.CLASS_TYPE);
        message.setRelationId(studentUid);
        Long mid = messageService.insert(message);

        if (DataUtils.isNotNullOrEmpty(mid)) {
            if (action) {
                content = LogUtil.convertString("<span  class=\\\"font-16px system-alert-outline \\\">系统分配 <a data-mid=", mid,
                        " ng-click=\\\"sendAlertMsg(li.id)\\\" target=\"_blank\" href=\\\"/school/", studentUid,
                        "/class\\\"><span class=\\\"font-green\\\">",
                        userNick, "</span> </a> 成为您的师弟</span>");

            } else {
                content = LogUtil.convertString("<span  class=\\\"font-16px system-alert-outline \\\"><a data-mid=", mid,
                        " ng-click=\\\"sendAlertMsg(li.id)\\\" target=\"_blank\" href=\\\"/school/", studentUid,
                        "/class\\\"><span class=\\\"font-green\\\">",
                        userNick, "</span> </a> 已与您解除师兄弟关系</span>");
            }

            Message message1 = messageService.getObjectById(mid);
            message1.setContent(content);
            boolean isOk = messageService.update(message1);

            if (isOk) {
                log.info("user : " + teacherUid + " send : " + content);
                adminSend(mobile, content);
                message.setContent(content);
                messageService.update(message);

                Integer unLook = teacher.getIsLook() + 1;
                teacher.setIsLook(unLook);
                teacher.setLatestMsg(Message.CLASS_TYPE);
                userService.update(teacher);
            }
        }
    }


    /**
     * 19.退出班级
     *
     * @param request
     * @param response
     * @param model
     * @return
     */
    @RequestMapping(value = "/a/u/classes", method = RequestMethod.PUT)
    public String quitClasses(HttpServletRequest request, HttpServletResponse response, ModelMap model) {

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();

        log.info(uid + " want to quit his class");

        try {
            Long now = System.currentTimeMillis();
            Long userClassID = user.getUserClassID();

			/*校验用户是否已结业*/
            Long graduateAt = user.getGraduateAt();
           
            if (User.STATUS_Graduate.intValue()==user.getStatus().intValue()) {
                model.addAttribute("code", -18000);
                return "/data/json";
            }

            if (userClassID == null) {
                model.addAttribute("code", -10081);
                log.info("userClassRelation is null");
                return "/common/failure";
            }

            UserClassRelation relation = userClassRelationService.getObjectById(userClassID);
            Integer status = relation.getStatus();

            // 1 学习中  0 已退出
            if (status.equals(1)) {
                  /* 入班级2天后才能退,不知道有什么意义囧 */
                Integer judge = 1;
                Long quitAt = relation.getQuitAt();  // 退出时间
                Long days = 0L;
                if (DataUtils.isNullOrEmpty(quitAt)) {
                    log.info(" user hasn't quited class ever ");
                } else {
                    log.info(" user has quited classes ever ,quitAt = " + quitAt);
                    Long duration = now - quitAt;
                    days = TimeUnit.MILLISECONDS.toDays(duration) + 1;
                    log.info("days:" + days);
                    judge = days.compareTo(2L);
                }
                if (judge > 0) {

                    relation.setStatus(0);
                    relation.setQuitAt(now);
                    userClassRelationService.update(relation);
                    //解除师兄弟关系
                    relieveRelation(user);
                    //修改用户相关信息
                   
                    user.setCid(User.Classes_None);
                    user.setOid(User.Occupation_None);
                    user.setUserClassID(-1L);
                    user.setStudyNumber(User.Study_Number_None);
                    user.setIdentity(User.Identity_Unname);
                    userService.update(user);

                } else {
                    Long leftDays = 3 - days;

                    model.addAttribute("code", -10082);
                    log.info(" user has to wait " + leftDays + " days");
                    return "/common/failure";
                }

            } else {
                model.addAttribute("code", -10083);
                log.info("you have quit the class");
                return "/common/failure";
            }

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("quit classes error,cid is  " + user.getCid());
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

    public void relieveRelation(User student) throws Exception {

        Long teacherId = student.getTeacherId();
        log.info(" user " + student.getId() + " want to quit class ,so relieve master-apprentice relation ,teacher id " + teacherId);
        if (DataUtils.isNullOrEmpty(teacherId)
                || User.TeacherID_None.equals(teacherId)) {
            log.info(" user don't have teacher ");
        } else {
            User teacher = userService.getObjectById(teacherId);
            //修改统计值
            List<User> students = new ArrayList<>();
            students.add(student);
            teacherService.dropTeacherRelationToStundent(students, teacherId);
            //发送消息
            sendMessageToStudent(student, teacher, false);
            sendMessageToTeacher(student, teacher, false);
            //teacherId设为null
            student.setTeacherId(User.TeacherID_None);
        }


    }


    public String setUserShowName(Long uid) {
        String userNick = null;
        BranchInstitute branchDetail=null;
        Occupation userOccupation=null;
        try {

            //无名、散修和外门展示学号，只有内门及内门以上的用户展示昵称
            //有分院展示分院，有职业展示职业
            String branch = null;
            User user = userService.getObjectById(uid);
            if (DataUtils.isNotNullOrEmpty(user.getBranch())) {
                Long userBranch = user.getBranch().longValue();
                 branchDetail = branchInstituteService.getObjectById(userBranch);
                branch = branchDetail.getName() + "分院|";
            }
            log.info("user branch is:" + branch);
            String userOccupationName = null;
            long userNumber = user.getStudyNumber();
            int identity = user.getIdentity();
            log.info("identity is :" + identity);
            if (!user.getOid().equals(User.Occupation_None)) {
                Long userOid = user.getOid();
                 userOccupation = occupationService.getObjectById(userOid);
                userOccupationName = userOccupation.getName().toUpperCase();
            }

            //10、无名弟子 20、散修弟子 30、外门弟子 40、内门弟子  50、首席弟子  55 荣耀师兄 60、真传弟子  70、修真长老
            userNick=UserUtil.convertName(user,branchDetail,userOccupation);
            
        } catch (Throwable t) {
            log.error("error is ", t);
        }
        log.info("userNick  is:" + userNick);
        return userNick;
    }

    public static String adminSend(String mobile, String content) {
        String param = "{\n" +
                "    \"target_type\" : \"users\", \n" +
                "    \"target\" : [\"" + mobile + "\"],   \n" +
                "                                   \n" +
                "                                   \n" +
                "    \"msg\" : {\n" +
                "        \"type\" : \"txt\",\n" +
                "        \"msg\" : \"" + content + "\" \n" +
                "        },\n" +
                "    \"from\" : \"admin\"\n" +
                "}";
        String result = HttpClientUtil.sendPostRequestByJavaSetHeader("https://a1.easemob.com/jnshu4/jnshu4/messages", param, "application/json", "Bearer YWMtwJlMnN7iEeW93dWWI_R-hgAAAVRiEFRny8NEKnIG6-Gu_yibQ4d46AkTlmM");
        log.info(result);
        return result;
    }
}

