package com.ptteng.common.skill.controller;

import com.ptteng.common.skill.model.*;
import com.ptteng.common.skill.service.*;
import com.ptteng.common.skill.util.SymptomUtil;
import com.ptteng.common.skill.util.WeekUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;


import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * Week  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class WeekController {
	private static final Log log = LogFactory.getLog(WeekController.class);

	@Autowired
	private WeekService weekService;

	@Autowired
	private UserSymptomRelationService userSymptomRelationService;

	@Autowired
	private SymptomService symptomService;

	@Autowired
	private TaskService taskService;

	@Autowired
	private UserService userService;


    

    		

	
	
	


	
	
	    		
			
    /**
	 * 
	 * @param 
	 * @return 


	 */
	
		@RequestMapping(value = "/a/week/query/search", method = RequestMethod.GET)
	public String getWeekIdsByUidJsonList(HttpServletRequest request,
                                          HttpServletResponse response, ModelMap model, Integer page,
                                          Integer size, Long uid) throws Exception {


		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			List<Long> ids= weekService.getWeekIdsByUid(uid,start,size);
	     	log.info("get countWeekIdsByUid size is " + ids.size());

			List<Week> weekList = weekService.getObjectsByIds(ids);
			log.info("get week data is " + weekList.size());

			List<UserSymptomRelation> relations=new ArrayList();

			Set<Long> wids=new HashSet();
			Set<Long> tids=new HashSet();
			Set<Long> uids=new HashSet();
			Map<Long,Set<Long>> wid_sids=new HashMap();
			for(Week week:weekList){
				wids.add(week.getId());
				tids.add(week.getCurrentTID());
				tids.add(week.getPlanTID());
				uids.add(week.getUid());
				uids.add(week.getSid());
				uids.add(week.getHid());

			}

			List<Long> relationIDS=this.userSymptomRelationService.getUserSymptomRelationIdsByUid(uid,0, Integer.MAX_VALUE);
			if(CollectionUtils.isEmpty(relationIDS)){

			}else{
				 relations=this.userSymptomRelationService.getObjectsByIds(relationIDS);

				 for(UserSymptomRelation relation:relations){

					 Set<Long> sids=null;
					 Long wid=relation.getWid();
					 sids=wid_sids.get(wid);
					 if(CollectionUtils.isEmpty(sids)){
					 	sids=new HashSet();
					 }
					 sids.add(relation.getSid());
					 wid_sids.put(wid,sids);
					 log.info(wid_sids);
				 }
			}

			// 1.get symptoms
	        Map<String, Object> paramList = SymptomUtil.getDynamicParam(uid,null,null, new ArrayList(wids),null,null,
					null,null,null,null,null, false);
			log.info("classTimetableListParam=" + paramList);
			List<Long> symptomIDS = symptomService.getIdsByDynamicCondition(ClassTimetable.class, paramList, 0, Integer.MAX_VALUE);
			log.info("symptomIDS= " + symptomIDS.size());
			List<Symptom> symptoms=symptomService.getObjectsByIds(symptomIDS);

			//2. get tasks

			log.info("taskIDS= " + tids.size());
			List<Task> tasks=taskService.getObjectsByIds(new ArrayList(tids));

			//3 get users

			log.info("users= " + uids.size());
			List<User> users=userService.getObjectsByIds(new ArrayList(uids));



			Integer total = weekService. countWeekIdsByUid(uid);
			log.info("get week count is " + total);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			
			model.addAttribute("total", total);

			model.addAttribute("weeks", weekList);
			model.addAttribute("relations", wid_sids);
			model.addAttribute("symptoms", symptoms);
			model.addAttribute("tasks", tasks);
			model.addAttribute("users", users);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get week list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/week/json/weekListJson";
	}

	
	
		
	
	

	@RequestMapping(value = "/a/week/{id}", method = RequestMethod.GET)
	public String getWeekJson(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			Week week = weekService.getObjectById(id);
			log.info("get week data is " + week);

			model.addAttribute("code", 0);

			model.addAttribute("week", week);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get week error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/week/json/weekDetailJson";
	}




	
	
	@RequestMapping(value = "/a/multi/week", method = RequestMethod.GET)
	public String getMultiWeekJson(HttpServletRequest request,
                                   HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			
		List<Long> idList = new ArrayList();	
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			

			List<Week> weekList = weekService.getObjectsByIds(idList);
			log.info("get  week data is " + weekList);

			model.addAttribute("code", 0);			
			model.addAttribute("total",weekList.size());

			model.addAttribute("weekList", weekList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get week error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/week/json/weekListJson";
	}
	
	
	
	
	
}

