package com.ptteng.common.skill.controller;

import com.ptteng.common.skill.model.Uevent;
import com.ptteng.common.skill.service.UeventService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Uevent  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class UeventController {
	private static final Log log = LogFactory.getLog(UeventController.class);

	@Autowired
	private UeventService ueventService;





			
    /**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	
		@RequestMapping(value = "/a/uevent/search/query", method = RequestMethod.GET)
	public String getUeventIdsByUidJsonList(HttpServletRequest request,
                                            HttpServletResponse response, ModelMap model, Integer page,
                                            Integer size, Long uid) throws Exception {


		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);
			Integer total=0;
			List<Uevent> ueventList=new ArrayList();
		try {
			if(uid==null){
				log.info(" uid is null ,so return ");

			}else{

				List<Long> ids= ueventService.getUeventIdsByUid(uid,start,size);
				log.info("get countUeventIdsByUid size is " + ids.size());

				ueventList = ueventService.getObjectsByIds(ids);
				log.info("get uevent data is " + ueventList.size());

				total = ueventService. countUeventIdsByUid(uid);
				log.info("get uevent count is " + total);



			}


			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);

			model.addAttribute("total", total);
			model.addAttribute("ueventList", ueventList);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get uevent list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/uevent/json/ueventListJson";
	}

	
	

	
	
	
}

