package com.ptteng.common.skill.controller;

import com.ptteng.common.skill.model.Article;
import com.ptteng.common.skill.model.ClassTimetable;
import com.ptteng.common.skill.model.School;
import com.ptteng.common.skill.model.User;
import com.ptteng.common.skill.service.*;
import com.ptteng.common.skill.util.DynamicUtil;
import com.qding.common.util.DataUtils;
import com.qding.common.util.TimeUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * School  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class StatisticsController {
    private static final Log log = LogFactory.getLog(StatisticsController.class);


    @Autowired
    private SchoolService schoolService;

    @Autowired
    private UserService userService;

    @Autowired
    private ClassTimetableService classTimetableService;


    @Autowired
    private ArticleService articleService;


    /**
     * show
     *
     * @param schoolId 学校id
     * @param branchId 分院id
     * @return java.lang.String
     * @throws Exception 异常信息
     * @author lishaobo
     * @date 2018/5/11
     */
    @RequestMapping(value = "/a/user/statistics", method = RequestMethod.GET)
    public String getUserStatistics(ModelMap model, Long schoolId, Long branchId) throws Exception {
        /**
         * show
         * @param [model, schoolId, branchId]
         * @return java.lang.String
         * @exception Exception 异常信息
         * @author lishaobo
         * @date 2018/5/11
         */
        log.info("getUserStatistics: schoolId is " + schoolId + " ,branchId=" + branchId);
        try {
            Map<String, Object> sqlMap = DynamicUtil.getUserOccupationStatisticsBySchoolIdAndBranchId(schoolId, branchId);
            List<Object[]> result = (List<Object[]>) userService.getObjectByDynamicCondition(User.class, sqlMap, 0, Integer.MAX_VALUE);
            String[] keys = {"id", "name", "count"};
            model.addAttribute("code", 0);
            model.addAttribute("items", result);
            model.addAttribute("keys", keys);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage(), t);
            log.error("get user statistics error");
        }
        return "common/statisticsGroup";
    }

    /**
     * show
     *
     * @param schoolId 学校id
     * @param branchId 分院id
     * @return java.lang.String
     * @throws Exception 异常信息
     * @author lishaobo
     * @date 2018/5/11
     */
    @RequestMapping(value = "/a/article/statistics", method = RequestMethod.GET)
    public String getArticleStatistics(ModelMap model, Long schoolId, Long branchId, Long startTime, Long endTime) throws Exception {

        log.info("getArticleStatistics: schoolId is " + schoolId + " ,branchId is " + branchId + " ,startTime is " + startTime + " ,endTime is " + endTime);
        if (DataUtils.isNullOrEmpty(startTime)) {
            startTime = TimeUtil.getTimesTodayZoreMillis();
        }
        if (DataUtils.isNullOrEmpty(endTime)) {
            endTime = TimeUtil.getTimesTodayLastMillis();
        }
        try {
            Map<String, Object> sqlMap = DynamicUtil.getArticleStatisticsBySchoolIdAndBranchId(schoolId, branchId, Article.TYPE_DAILT, startTime, endTime);
            Object[] result = (Object[]) userService.getObjectByDynamicCondition(User.class, sqlMap, 0, Integer.MAX_VALUE);
            List<Object[]> items = new ArrayList<>();
            items.add(result);
            String[] keys = {"studentCount", "articleCount"};
            model.addAttribute("code", 0);
            model.addAttribute("items", items);
            model.addAttribute("keys", keys);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage(), t);
            log.error("get user statistics error");
        }
        return "common/statisticsGroup";
    }

    /**
     * show
     * 校园首页：合作学校数、校园学员数、校园学员日报数 3项数据
     *
     * @return java.lang.String
     * @throws Exception 异常信息
     * @author ruanshaonan
     * @date 2018/5/12
     */
    @RequestMapping(value = "/a/school/statistics", method = RequestMethod.GET)
    public String getSchoolStatistics(ModelMap model, Long schoolId, Long startTime, Long endTime) throws Exception {

        log.info("getArticleStatistics: ");
        try {
            int schoolCount = 0;
            int studentCount = 0;
            int articleCount = 0;

            //查询单个校园数据
            if (DataUtils.isNotNullOrEmpty(schoolId)) {
                schoolCount = 1;
                List<Long> schoolIds = new ArrayList<>();
                schoolIds.add(schoolId);
                Map<String, Object> schoolStudentCountParam = DynamicUtil.getSchoolStudentIds(schoolIds);
                List<Long> uidList = userService.getIdsByDynamicCondition(User.class, schoolStudentCountParam, 0, Integer.MAX_VALUE);
                studentCount = uidList.size();
                log.info("studentCount===" + studentCount);

                if (studentCount == 0) {
                    articleCount = 0;
                } else {
                    Map<String, Object> schoolDailyCountParam = DynamicUtil.getSchoolDailyCount(uidList);
                    articleCount = ((BigInteger) articleService.getObjectByDynamicCondition(Article.class, schoolDailyCountParam, 0, Integer.MAX_VALUE)).intValue();
                }
                log.info("articleCount===" + articleCount);
            }
            //查询所有合作校园数据
            else {
                Map<String, Object> corporateSchoolCountParam = DynamicUtil.getCorporateSchool();
                List<Long> schoolIds = schoolService.getIdsByDynamicCondition(School.class, corporateSchoolCountParam, 0, Integer.MAX_VALUE);
                schoolCount = schoolIds.size();
                log.info("schoolCount==" + schoolCount);
                if (schoolCount == 0) {
                    studentCount = 0;
                    articleCount = 0;
                } else {
                    Map<String, Object> schoolStudentCountParam = DynamicUtil.getSchoolStudentIds(schoolIds);
                    List<Long> uidList = userService.getIdsByDynamicCondition(User.class, schoolStudentCountParam, 0, Integer.MAX_VALUE);
                    studentCount = uidList.size();
                    if (studentCount == 0) {
                        articleCount = 0;
                    } else {
                        Map<String, Object> schoolDailyCountParam = DynamicUtil.getSchoolDailyCount(uidList);
                        articleCount = ((BigInteger) articleService.getObjectByDynamicCondition(Article.class, schoolDailyCountParam, 0, Integer.MAX_VALUE)).intValue();
                    }
                }
                log.info("studentCount===" + studentCount);
                log.info("articleCount===" + articleCount);
            }

            model.addAttribute("code", 0);
            model.addAttribute("schoolCount", schoolCount);
            model.addAttribute("userCount", studentCount);
            model.addAttribute("articleCount", articleCount);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage(), t);
            log.error("get user statistics error");
            model.addAttribute("code", -1);
        }

        return "/common/corporateSchoolStatistics";
    }


    /**
     * 小课堂总数统计
     *
     * @Author ruanshaonan
     * @Description
     * @Date 14:06 2018/6/28
     */
    @RequestMapping(value = "/a/class/statistics ", method = RequestMethod.GET)
    public String getClassStatistics(ModelMap model) throws Exception {

        log.info("getClassStatistics: ");
        try {
            Map<String, Object> sqlMap = DynamicUtil.countClassTimetable();
            Object classCount = classTimetableService.getObjectByDynamicCondition(ClassTimetable.class, sqlMap, 0, Integer.MAX_VALUE);
            log.info("classTimetableCount===" + classCount);
            model.addAttribute("code", 0);
            model.addAttribute("totalClasses", classCount);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage(), t);
            log.error("get user statistics error");
            model.addAttribute("code", -1);
        }
        return "/common/classStatistic";
    }


}

