package com.ptteng.common.skill.controller;

import com.ptteng.common.skill.model.Product;
import com.ptteng.common.skill.service.ProductService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import com.ptteng.common.skill.util.DynamicUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * Product  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class ProductController {
	private static final Log log = LogFactory.getLog(ProductController.class);

	@Autowired
	private ProductService productService;



    /**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	//产品列表
	@RequestMapping(value = "/a/product/search", method = RequestMethod.GET)
	public String getproductList(HttpServletRequest request,
								 HttpServletResponse response, ModelMap model, Integer page, Integer size,
								 String name,String industry,Integer status,String client) throws Exception {
		log.info("name"+name+"industry"+industry+"status"+status+"page"+page+"size"+size+"client"+client);
		/* 1 默认分页 */
		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
		try{
			//初始值
			Long total =0L;
			//动态查询
			Map<String,Object> paramList = DynamicUtil.getProductListParam(name,industry,status,client,false);
			log.info("paramList size =" + paramList.size());
			//获取产品Id列表
			List<Long> productIdList = productService.getIdsByDynamicCondition(Product.class,paramList,start,size);
			//获取total
			Map<String,Object> paramCount = DynamicUtil.getProductListParam(name,industry,status,client,true);
			List<Long> productsIdCount = productService.getIdsByDynamicCondition(Product.class,paramCount, 0, Integer.MAX_VALUE);
			if (CollectionUtils.isNotEmpty(productsIdCount)) {
				total = productsIdCount.get(0);
			}
			//获取products列表
			List<Product> productList = productService.getObjectsByIds(productIdList);
			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			model.addAttribute("total",total);
			model.addAttribute("productList",productList);
		}catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error(" search product list error ");
			model.addAttribute("code", -1);
		}
		return "/common-skill-service/product/json/productListJson";
	}

    

    

	//产品详情
	@RequestMapping(value = "/a/product/detail/{id}", method = RequestMethod.GET)
	public String getProductJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			Product product = productService.getObjectById(id);
//			log.info("get product data is " + product);

			model.addAttribute("code", 0);

			model.addAttribute("product", product);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get product error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/product/json/productDetailJson";
	}

	
}

