package com.ptteng.common.skill.controller;

import com.ptteng.common.skill.model.*;
import com.ptteng.common.skill.service.*;
import com.ptteng.common.skill.util.DynamicUtil;
import com.ptteng.skill.service.model.UserTaskRelation;
import com.ptteng.skill.service.service.UserTaskRelationService;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * UserSkillRelation  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class UserSkillRelationController {
	private static final Log log = LogFactory.getLog(UserSkillRelationController.class);

	@Autowired
	private UserSkillRelationService userSkillRelationService;
	@Autowired
	private SkillService skillService;
	@Autowired
	private UserService userService;
	@Autowired
	private OccupationService occupationService;
	@Autowired
	private ClassesService classesService;
	@Autowired
	private ArticleService articleService;
	@Autowired
	private UserTaskRelationService userTaskRelationService;
	@Autowired
	private TaskSkillRelationService taskSkillRelationService;
	/**
	 *获取用户技能
	 * 根据uid和oid
	 * @param request
	 * @param response
	 * @param model
	 * @return
	 * @throws Exception
	 */

	@RequestMapping(value = "/a/user/{uid}/{oid}/skill/detail", method = RequestMethod.GET)
	public String getUserSkillRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,@PathVariable Long uid,@PathVariable Long oid)
			throws Exception {
		log.info("oid is :" + oid + " get user "+uid+" skills  start  " );
		if (DataUtils.isNullOrEmpty(uid) || DataUtils.isNullOrEmpty(oid)){
			log.info("uid or oid  cannot  null");
			model.addAttribute("code",-1000);
			return "/common/success";
		}
		List<UserTaskRelation> userTaskRelationList = new ArrayList<>();
		HashMap<Long, List> skillMap = new HashMap<>();
		try {
			//获得用户已完成的任务id
				Map<String, Object> params = DynamicUtil.getUserTaskRelationIdsIdsByUidAndOid(uid, oid);
				List<Long> userTaskRelationIds = userTaskRelationService.getIdsByDynamicCondition(UserTaskRelation.class,params,0,Integer.MAX_VALUE);
				log.info("userTaskRelationIds  is " + userTaskRelationIds);
				if(CollectionUtils.isEmpty(userTaskRelationIds)){

				}else {
					userTaskRelationList = userTaskRelationService.getObjectsByIds(userTaskRelationIds);
						log.info("userTaskRelationList size is " +  userTaskRelationList.size());
					if(CollectionUtils.isNotEmpty(userTaskRelationList)) {
						List<Skill> skillList = new ArrayList<>();
						for (UserTaskRelation userTaskRelation : userTaskRelationList) {
							Long taskId = userTaskRelation.getTid();
							List<Long> skillIdsByTid = taskSkillRelationService.getSkillIdsByTid(taskId, 0, Integer.MAX_VALUE);
							if(CollectionUtils.isNotEmpty(skillIdsByTid)){
								skillList = skillService.getObjectsByIds(skillIdsByTid);
							}
							skillMap.put(taskId,skillList);
						}

					}
				}
			model.addAttribute("code",0);
			model.addAttribute("userTaskRelationList",userTaskRelationList);
			model.addAttribute("skillMap",skillMap);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get user skills  error  ");
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/skill/json/userTaskSkillListJson";
	}




	/**
	 * 获取完成技能的用户列表
	 * @param request
	 * @param response
	 * @param model
	 * @param page
	 * @param size
	 * @param sid
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/skill/{sid}/user/list", method = RequestMethod.GET)
	public String getUserSkillRelationIdsByUidJsonList(HttpServletRequest request,
													   HttpServletResponse response, ModelMap model, Integer page,
													   Integer size,@PathVariable Long sid) throws Exception {


		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {
			List<User> users  = new ArrayList<>();
			Set<Long> oIds = new HashSet<>();
			List<Occupation> occupations = new ArrayList<>();
			Set<Long> cIds = new HashSet<>();
			List<Classes> classesList = new ArrayList<>();
			List<Long> ids= userSkillRelationService.getUserSkillRelationIdsBySid(sid, start, size);
			log.info("get countUserSkillRelationIdsByUid size is " + ids.size());
			if(CollectionUtils.isEmpty(ids)){

			}else {
				List<UserSkillRelation> userSkillRelationList = userSkillRelationService.getObjectsByIds(ids);
				Set<Long> uids = new HashSet<>();
				for(UserSkillRelation userSkillRelation : userSkillRelationList){
					uids.add(userSkillRelation.getUid());
				}
				 users = userService.getObjectsByIds(new ArrayList<Long>(uids));
				 for(User user : users){
					 oIds.add(user.getOid());
					 cIds.add(user.getCid());
				 }
				if(oIds.size()>0){
					occupations = occupationService.getObjectsByIds(new ArrayList<Long>(oIds));
				}
				if(cIds.size()>0){
					classesList = classesService.getObjectsByIds(new ArrayList<Long>(cIds));
				}

			}
			Integer total = userSkillRelationService.countUserSkillRelationIdsBySid(sid);
			int totalPage = 1;
			if(total>0){
				totalPage = (total-1) / size + 1;
			}
			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			model.addAttribute("total", total);
			model.addAttribute("totalPage", totalPage);
			model.addAttribute("users", users);
			model.addAttribute("occupations", occupations);
			model.addAttribute("classesList", classesList);


		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get userSkillRelation list error,page is  " + start + " , size "
					+ size);
			model.addAttribute("code", -100000);
		}

		return "/skill-service/userTaskRelation/json/userTaskRelationListJson";	}





}

