package com.ptteng.common.skill.controller;

import com.ptteng.common.skill.model.*;
import com.ptteng.common.skill.service.OccupationService;
import com.ptteng.common.skill.service.SchoolPersonRelationService;
import com.ptteng.common.skill.service.SchoolService;
import com.ptteng.common.skill.service.UserService;
import com.ptteng.common.skill.util.DynamicUtil;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * School  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class SchoolController {
    private static final Log log = LogFactory.getLog(SchoolController.class);

    @Autowired
    private SchoolService schoolService;

    @Autowired
    private UserService userService;

    @Autowired
    private SchoolPersonRelationService schoolPersonRelationService;

    @Autowired
    private OccupationService occupationService;


   /**
   *@Author ruanshaonan
   *@Description 获取合作校园（已上架）列表
   *@Date 12:18 2018/5/16
   *@Param
   *@return
   */
    @RequestMapping(value = "/a/school", method = RequestMethod.GET)
    public String getSchoolList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                Integer page, Integer size) throws Exception {

        if (DataUtils.isNullOrEmpty(page)) {
            page = 1;
        }
        if (DataUtils.isNullOrEmpty(size)) {
            size = 10;
        }

        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        int limit = size + 1;
        Integer total = 0;

        Map<String, Object> params = DynamicUtil.getCorporateSchool();
        List<Long> schoolIds = schoolService.getIdsByDynamicCondition(School.class, params, start, limit);
        List<School> schools = schoolService.getObjectsByIds(schoolIds);
        total = schoolIds.size();

        model.addAttribute("code", 0);
        model.addAttribute("total", total);
        model.addAttribute("schoolList", schools);
        return "/common-skill-service/school/json/schoolListJson";
    }


    /**
     * 获取校园详情
     *
     * @param request
     * @param response
     * @param model
     * @param id：校园id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/school/{id}", method = RequestMethod.GET)
    public String getSchoolJson(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("get data : id= " + id);

        School school = null;
        List<SchoolPersonRelation> schoolPersonRelationList = new ArrayList<>();
        List<OccupationUser> resultUserList = new ArrayList<>();

        try {
            school = schoolService.getObjectById(id);
            log.info("get school data is " + school);
            if (DataUtils.isNotNullOrEmpty(school)) {
                //获取校园相关人员信息，返回到页面
                Map<String, Object> relationParams = DynamicUtil.getIdsBySchoolId(id);
                log.info("get relationParams:" + relationParams);
                List<Long> relationIds = schoolPersonRelationService.getIdsByDynamicCondition(SchoolPersonRelation.class,
                        relationParams, 0, Integer.MAX_VALUE);
                log.info("relationIds====" + relationIds.size());

                if (relationIds.size() > 0) {
                    schoolPersonRelationList = schoolPersonRelationService.getObjectsByIds(relationIds);
                    //根据人员id，获取人员信息
                    List<Long> uids = new ArrayList<>();
                    for (int i = 0; i < schoolPersonRelationList.size(); i++) {
                        uids.add(schoolPersonRelationList.get(i).getPersonId());
                    }
                    List<User> userList = userService.getObjectsByIds(uids);

                    //获取职业列表
                    Map<String, Object> getOccupationListParams = DynamicUtil.getUserOccupationStatisticsBySchoolIdAndBranchId(null, null);
                    List<Object[]> result = (List<Object[]>) occupationService.getObjectByDynamicCondition(Occupation.class, getOccupationListParams, 0, Integer.MAX_VALUE);
                    Map<Integer, String> occupationMap = new HashMap<>();
                    for (Object[] objects : result) {
                        occupationMap.put(Integer.parseInt(objects[0] + ""), (String) objects[1]);
                    }

                    //将职业名称添加到用户信息里
                    for (User user : userList) {
                        OccupationUser resultUser = new OccupationUser();
                        resultUser.setUser(user);
                        if (user.getOid() > 0) {
                            resultUser.setOccupation(occupationMap.get(Integer.parseInt(user.getOid() + "")));
                        } else {
                            resultUser.setOccupation(null);
                        }
                        resultUserList.add(resultUser);
                    }
                    log.info("resultUserList===" + resultUserList.size());
                }
            } else {
                model.addAttribute("code", -50002);
            }
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage() + "==get school error,id is  " + id);
            model.addAttribute("code", -100000);
        }

        model.addAttribute("code", 0);
        model.addAttribute("school", school);
        model.addAttribute("schoolPersonRelationList", schoolPersonRelationList);
        model.addAttribute("resultUserList", resultUserList);

        return "/common-skill-service/school/json/schoolDetailJson";
    }

}

