package com.ptteng.common.skill.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.StringUtil;
import com.ptteng.common.skill.model.*;
import com.ptteng.common.skill.service.*;
import com.ptteng.common.skill.util.DynamicUtil;
import com.ptteng.skill.service.model.UserTaskRelation;
import com.ptteng.skill.service.service.UserTaskRelationService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.HttpClientUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;

/**
 * UserTaskRelation  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class UserTaskRelationController {
    private static final Log log = LogFactory.getLog(UserTaskRelationController.class);

    @Autowired
    private UserTaskRelationService userTaskRelationService;
    @Autowired
    private ClassesService classesService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private UserService userService;
    @Autowired
    private OccupationService occupationService;
    @Autowired
    private TaskSkillRelationService taskSkillRelationService;
    @Autowired
    private UserSkillRelationService userSkillRelationService;
    @Autowired
    private SkillService skillService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private ConstantService constantService;

    private String easemob_token;

    @Autowired
    private UserScoreService userScoreService;

    /**
     * 任务的接受，提交，审核
     *
     * @param request
     * @param response
     * @param model
     * @param tid                   --任务ID，必填
     * @param type                  --类型：接受，提交，审核
     * @param userTaskRelationParam 提交任务的时候必填
     * @param userTaskRelationId    --审核任务时候必填
     * @param judgeResult           --审核任务时候必填
     * @param judgeRemark           --审核任务时候选填
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/task/{tid}/{type}", method = RequestMethod.POST)
    public String addUserTaskRelationJson(HttpServletRequest request,
                                          HttpServletResponse response, ModelMap model, @PathVariable Long tid,
                                          @PathVariable String type, UserTaskRelation userTaskRelationParam,
                                          Long userTaskRelationId, Integer judgeResult,
                                          String judgeRemark, Integer dailyScore) throws Exception {
        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        log.info(" user " + uid + " " + type + " task id " + tid);

        try {
            //校验任务是否存在
            Task task = taskService.getObjectById(tid);
            if (DataUtils.isNullOrEmpty(task)) {
                model.addAttribute("code", -16004);
                return "/data/json";

            }
            //校验是否领取过任务,任务领取和任务提交的时候需要做校验
            Long oldId = userTaskRelationService.getUserTaskRelationIdByTidAndUid(tid, uid);
            log.info(" oldId = " + oldId);
            UserTaskRelation userTaskRelation = new UserTaskRelation();
            Occupation occupation = new Occupation();
            User atUser = new User();
            /*第一步：校验*/
            switch (type) {
                case UserTaskRelation.RECEIVE:

                    if (DataUtils.isNotNullOrEmpty(oldId)) {
                        model.addAttribute("code", -17007);
                        return "/data/json";
                    }
                    Long taskOid = task.getOid();
                    userTaskRelation.setTid(tid);
                    userTaskRelation.setUid(uid);
                    Long cid = user.getCid();
                    //校验用户是否加入了班级
                    if (DataUtils.isNullOrEmpty(cid) ||
                            cid < 0) {
                        log.info(" user " + uid + " didn't add class ,so can't receive task ");
                        model.addAttribute("code", -16000);
                        return "/data/json";
                    } else {
                        //如果加入了班级，校验领取的任务是否是该职业下的
                        log.info(" user " + uid + " class is " + cid);
                        if (!taskOid.equals(user.getOid())) {
                            model.addAttribute("code", -16005);
                            return "/data/json";
                        }
                    }
                    userTaskRelation.setOid(user.getOid());
                    userTaskRelation.setReceiveAt(System.currentTimeMillis());
                    userTaskRelation.setId(null);
                    Long userTaskId = userTaskRelationService.insert(userTaskRelation);

                    log.info(" user " + uid + " receive task " + tid + " success ,id = " + userTaskId);
                    break;
                case UserTaskRelation.SUBMIT:
                    //校验参数
                    if (DataUtils.isNullOrEmpty(userTaskRelationParam.getResultUrl())
                            && DataUtils.isNullOrEmpty(userTaskRelationParam.getCodeUrl())) {
                        model.addAttribute("code", -16002);
                        return "/data/json";
                    }
                    if (DataUtils.isNullOrEmpty(oldId)) {
                        log.info(" userTaskId is null ,user didn't receive this task " + tid);
                        model.addAttribute("code", -16003);
                        return "/data/json";
                    }
                    occupation = occupationService.getObjectById(user.getOid());
                    userTaskRelation = userTaskRelationService.getObjectById(oldId);
                    if (UserTaskRelation.PROGRESS_SUBMITED == userTaskRelation.getProgress()) {
                        model.addAttribute("code", -17008);
                        return "/data/json";
                    }
                    userTaskRelation.setCodeUrl(userTaskRelationParam.getCodeUrl());
                    userTaskRelation.setResultUrl(userTaskRelationParam.getResultUrl());
                    userTaskRelation.setProgress(UserTaskRelation.PROGRESS_SUBMITED);
                    userTaskRelation.setSubmitAt(System.currentTimeMillis());
                    userTaskRelationService.update(userTaskRelation);
                    atUser = userService.getObjectById(user.getTeacherId());
                    if (atUser == null) {
                        log.info("atUser is null");
                    } else {
                        Long atMessageId = messageService
                                .insert(new Message(atUser.getId(), atUser
                                        .getNick(), Message.TASK_TYPE, oldId));

//                        int template = Message.TEMPLATE_120;
//                        Map<String, Object> map = new HashMap<>();
//                        map.put(Message.KEY_SUID, uid);
//                        map.put(Message.KEY_STUDY_NUM, user.getStudyNumber());
//                        map.put(Message.KEY_TUID, user.getTeacherId());
//                        map.put(Message.KEY_ONAME, occupation.getName());
//                        map.put(Message.KEY_TASK_NUM, task.getNum());


                        String atContent = "<span  class=\"font-16px system-alert-outline \">" +
                                "<a data-mid=22362 ng-click=\"sendAlertMsg(li.id)\" target=\"_blank\" href=\"/school/" + uid + "/class\">" +
                                "<span class=\"font-green\">" + user.getStudyNumber() + "师弟</span> </a>" +
                                "提交了 <a   data-mid=22362 ng-click=\"sendAlertMsg(li.id)\" class=\"font-orange\" target=\"_blank\" href=\"" +
                                "/school/" + user.getTeacherId() + "/judgeList/\" target=\"_blank\">" + occupation.getName() +
                                "的任务" + task.getNum() + "</a></span>";


                        adminSend(atUser.getMobile(), atContent);

//                        ObjectMapper json = new ObjectMapper();
//                        String atContent = json.writeValueAsString(map);

                        Message atMessage = messageService
                                .getObjectById(atMessageId);
//                        atMessage.setTemplate(template);

                        log.info("the atmessage=====" + atMessage);
                        if (null != atMessage) {
                            atMessage.setContent(atContent);
                            messageService.update(atMessage);
                        }
                        atUser.setIsLook(atUser.getIsLook() + 1);
                        atUser.setLatestMsg(Message.TASK_TYPE);
                        userService.update(atUser);
                    }
                    break;
                case UserTaskRelation.REVIEW:
                    log.info(" teacher " + uid + " judge task , userTaskRelationId " + userTaskRelationId + "judgeResult " + judgeResult + "dailyScore" + dailyScore + "judgeRemark" + judgeRemark);
                    if (DataUtils.isNullOrEmpty(userTaskRelationId)) {
                        model.addAttribute("code", -1000);
                        return "/data/json";
                    }
                    if (DataUtils.isNullOrEmpty(judgeResult)) {
                        model.addAttribute("code", -16006);
                        return "/data/json";
                    }
                    if (0 == judgeResult) {
                        if (StringUtil.isEmpty(judgeRemark)) {
                            model.addAttribute("code", -16007);
                            return "/data/json";
                        }
                    }
                    if (DataUtils.isNullOrEmpty(dailyScore)) {
                        model.addAttribute("code", -16011);
                        return "/data/json";
                    }

                    userTaskRelation = userTaskRelationService.getObjectById(userTaskRelationId);
                    userTaskRelation.setDailyScore(dailyScore);


                    if (DataUtils.isNullOrEmpty(userTaskRelation)) {
                        log.info(" userTaskId is null ,user didn't receive this task " + userTaskRelationId);
                        model.addAttribute("code", -1111);
                        return "/data/json";
                    }
                    log.info(" judge userTaskRelation start  ");
                    if (UserTaskRelation.PROGRESS_SUBMITED != userTaskRelation.getProgress()) {
                        log.info(" this task progress is not submit,can't check  ");
                        model.addAttribute("code", -16010);
                        return "/data/json";
                    }
                    Long studentId = userTaskRelation.getUid();
                    log.info(" tid = " + tid + " studentId = " + studentId);
                    userTaskRelation.setJudgeRemark(judgeRemark);

                    if (0 == judgeResult) {
                        userTaskRelation.setProgress(UserTaskRelation.PROGRESS_FAIL);
                        //审核不通过
                        atUser = userService.getObjectById(studentId);
                        occupation = occupationService.getObjectById(atUser.getOid());

                        if (atUser == null) {
                            log.info("atUser is null");
                        } else {
                            Long atMessageId = messageService
                                    .insert(new Message(atUser.getId(), atUser
                                            .getNick(), Message.TASK_TYPE, userTaskRelationId));

//                            int template = Message.TEMPLATE_121;
//                            Map<String, Object> map = new HashMap<>();
//                            map.put(Message.KEY_STUDY_NUM, user.getStudyNumber());
//                            map.put(Message.KEY_SUID, studentId);
//                            map.put(Message.KEY_ONAME, occupation.getName());
//                            map.put(Message.KEY_TASK_NUM, task.getNum());
//                            ObjectMapper json = new ObjectMapper();
//                            String atContent = json.writeValueAsString(map);

                            String atContent = "<span  class=\"font-16px system-alert-outline \">" +
                                    "<a data-mid=22362 ng-click=\"sendAlertMsg(li.id)\" target=\"_blank\" " +
                                    "href=\"/school/" + uid + "/class\"><span class=\"font-green\">" + user.getStudyNumber()
                                    + "师兄</span> </a>已拒绝了 <a   data-mid=22362 ng-click=\"sendAlertMsg(li.id)\"" +
                                    " class=\"font-orange\" target=\"_blank\" href=\"/school/" + studentId + "/task\" target=\"_blank\">你的" + occupation.getName() +
                                    "任务" + task.getNum() + "</a></span>";


                            adminSend(atUser.getMobile(), atContent);

                            Message atMessage = messageService
                                    .getObjectById(atMessageId);
//                            atMessage.setTemplate(template);

                            log.info("the atmessage=====" + atMessage);
                            if (null != atMessage) {
                                atMessage.setContent(atContent);
                                messageService.update(atMessage);
                            }
                            atUser.setIsLook(atUser.getIsLook() + 1);
                            atUser.setLatestMsg(Message.TASK_TYPE);
                            userService.update(atUser);
                        }

                    } else if (1 == judgeResult) {
                        //审核通过

                        userTaskRelation.setProgress(UserTaskRelation.PROGRESS_PASSED);
                        //如果审核通过，更新用户的最新任务以及价值
                        User student = userService.getObjectById(userTaskRelation.getUid());
                        student.setValue(student.getValue() == null ? new BigDecimal("0") : student.getValue());
                        log.info(" student " + userTaskRelation.getUid() + " last task id = " + student.getLastTaskId());

                        if (DataUtils.isNotNullOrEmpty(task)) {
                            log.info(" student value = " + student.getValue());
                            student.setValue(student.getValue().add(task.getValue() == null ? new BigDecimal("0") : task.getValue()));
                            log.info(" now student value = " + student.getValue());
                        }
                        student.setLastTaskId(userTaskRelation.getTid());
                        userService.update(student);
                        //如果审核通过，给用户新增技能
                        List<Long> skillIds = taskSkillRelationService.getSkillIdsByTid(tid, 0, Integer.MAX_VALUE);
                        log.info(" skillIds size = " + skillIds.size());
                        if (org.apache.commons.collections.CollectionUtils.isEmpty(skillIds)) {
                            log.info(" skillIds is empty ");
                        } else {
                            log.info(" add student skill " + skillIds);
                            List<UserSkillRelation> userSkillRelations = new ArrayList<>();
                            List<Skill> skills = skillService.getObjectsByIds(skillIds);
                            log.info(" skills size = " + skills.size());
                            for (Skill skill : skills) {
                                log.info(" ---------------- ");
                                UserSkillRelation userSkillRelation = new UserSkillRelation();
                                userSkillRelation.setUid(studentId);
                                userSkillRelation.setSid(skill.getId());
                                userSkillRelations.add(userSkillRelation);
                            }
                            log.info(" student " + studentId + " master skill size is " + userSkillRelations.size());
                            userSkillRelationService.insertList(userSkillRelations);
                        }
                        atUser = userService.getObjectById(studentId);
                        occupation = occupationService.getObjectById(atUser.getOid());

                        if (atUser == null) {
                            log.info("atUser is null");
                        } else {
                            Long atMessageId = messageService
                                    .insert(new Message(atUser.getId(), atUser
                                            .getNick(), Message.TASK_TYPE, userTaskRelationId));

//                            int template = Message.TEMPLATE_122;
//                            Map<String, Object> map = new HashMap<>();
//                            map.put(Message.KEY_STUDY_NUM, user.getStudyNumber());
//                            map.put(Message.KEY_SUID, studentId);
//                            map.put(Message.KEY_ONAME, occupation.getName());
//                            map.put(Message.KEY_TASK_NUM, task.getNum());
//                            ObjectMapper json = new ObjectMapper();
//                           String atContent = json.writeValueAsString(map);


                            String atContent = "<span  class=\"font-16px system-alert-outline \">" +
                                    "<a data-mid=22362 ng-click=\"sendAlertMsg(li.id)\" target=\"_blank\" " +
                                    "href=\"/school/" + uid + "/class\"><span class=\"font-green\">" + user.getStudyNumber()
                                    + "师兄</span> </a>已通过了 <a   data-mid=22362 ng-click=\"sendAlertMsg(li.id)\"" +
                                    " class=\"font-orange\" target=\"_blank\" href=\"/school/" + studentId + "/task\" target=\"_blank\">你的" + occupation.getName() +
                                    "任务" + task.getNum() + "</a></span>";


                            adminSend(atUser.getMobile(), atContent);

                            Message atMessage = messageService
                                    .getObjectById(atMessageId);

                            log.info("the atmessage=====" + atMessage);
                            if (null != atMessage) {
                                atMessage.setContent(atContent);

//                                atMessage.setTemplate(template);

                                messageService.update(atMessage);
                            }
                            atUser.setIsLook(atUser.getIsLook() + 1);
                            atUser.setLatestMsg(Message.TASK_TYPE);
                            userService.update(atUser);
                        }
                    } else {
                        model.addAttribute("code", -1003);
                        return "/data/json";
                    }

                    //不管审核是否通过，师兄自动加分
                    int teacherScore = user.getScore();
                    log.info("  teacher teacherScore = " + teacherScore);
                    int userIdentity = user.getIdentity();
                    if (userIdentity == User.IDENTIFY_40 || userIdentity == User.IDENTIFY_50) {
                        String taskJudge = constantService.getConstantValueByTypeAndName(Constant.Type_score, Constant.Name_taskJudge);
                        teacherScore = teacherScore + Integer.parseInt(taskJudge);
                        Long score = Long.parseLong(taskJudge);
                        log.info("  teacher teacherScore = " + teacherScore);
                        //log.info("score"+ score);
                        user.setScore(teacherScore);
                        userService.update(user);
                        //新增积分记录
                        UserScore userScore = new UserScore();
                        String comments = "任务审核奖励";
                        userScore.setUid(uid);
                        userScore.setComment(comments);
                        userScore.setScoreType(0);
                        userScore.setScore(score);
                        userScoreService.insert(userScore);
                        //发送消息
                        user.setIsLook(user.getIsLook() + 1);
                        user.setLatestMsg(Message.SCORE_TYPE);
                        userService.update(user);

                        Message message = new Message();
                        message.setStatus(1);
                        message.setReceiveName(user.getNick());
                        message.setSendName("admin");
                        message.setSendId(0L);
                        message.setContent("");
                        message.setReceiveId(uid);
                        message.setUnread(1);
                        message.setType("score");


                        Long mid = messageService.insert(message);

                        message = this.messageService.getObjectById(mid);
                        String content;


                        content = "<span  class=\"font-16px system-alert-outline \">您得到了积分奖励，" +
                                "<a   data-mid=22362 ng-click=\"sendAlertMsg(li.id)\" class=\"font-orange\" target=\"_blank\" href=\"" +
                                "/school/" + uid + "/score///0\" target=\"_blank\">点击查看</a></span>";
                        adminSend(user.getMobile(), content);
//                        message.setTemplate(Message.TEMPLATE_114);
                        message.setContent(content);
                        log.info("  message = " + message.getId());
                        messageService.update(message);
                    }

                    userTaskRelation.setJudgeAt(System.currentTimeMillis());
                    userTaskRelation.setJudgeUid(uid);
                    userTaskRelationService.update(userTaskRelation);
                    log.info("userTaskRelation is :" + userTaskRelation);
                    break;
            }

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add userTaskRelation error ");
            model.addAttribute("code", -1);
        }

        return "/data/json";
    }


    @PostConstruct
    private void updateEasemobToken() throws ServiceException,
            ServiceDaoException {
//        Long id = this.constantService.getConstantIdByTypeAndName(
//                Constant.Type_EaseMob, Constant.Name_Token);
//        if (id == null) {
//            log.error(" get easemob failure ");
//        } else {
//            Constant constant = this.constantService.getObjectById(id);
//            this.easemob_token = constant.getValue();
//            log.info(id + " get token is " + constant);
//
//        }
    }

    /**
     * 任务审核
     *
     * @param request
     * @param response
     * @param model
     * @param userTaskRelationId
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/task/judgement/teacher/{userTaskRelationId}", method = RequestMethod.PUT)
    public String updateUserTaskRelationJudgeJson(HttpServletRequest request,
                                                  HttpServletResponse response, ModelMap model,
                                                  @PathVariable Long userTaskRelationId, Integer judgeResult,
                                                  String judgeRemark) {
        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        log.info(" teacher " + uid + " judge task , userTaskRelationId " + userTaskRelationId + "judgeResult " + judgeResult);

        if (DataUtils.isNullOrEmpty(judgeResult)) {  //审核结果不能为空
            model.addAttribute("code", -16006);
            return "/data/json";
        }
        if (ObjectUtils.equals(0, judgeResult)) {  //当结果为“不通过”(等于0)时，审核备注不能为空
            if (StringUtil.isEmpty(judgeRemark)) {
                model.addAttribute("code", -16007);
                return "/data/json";
            }
        }

        try {
            UserTaskRelation userTaskRelation = userTaskRelationService.getObjectById(userTaskRelationId);

            if (DataUtils.isNullOrEmpty(userTaskRelation)) {
                log.info(" userTaskId is null ,user didn't receive this task " + userTaskRelationId);
                model.addAttribute("code", -1111);
                return "/data/json";
            }

            log.info(" judge userTaskRelation start  ");
            if (UserTaskRelation.PROGRESS_SUBMITED != userTaskRelation.getProgress()) {
                log.info(" this task progress is not submit, can't check ");
                model.addAttribute("code", -16010);
                return "/data/json";
            }

            Occupation occupation = occupationService.getObjectById(user.getOid());
            Long tid = userTaskRelation.getTid();
            //提交审核的任务
            Task task = taskService.getObjectById(tid);
            Long studentId = userTaskRelation.getUid();
            //提交任务的学员
            User atUser = userService.getObjectById(studentId);
            log.info(" tid = " + tid + " studentId = " + studentId);

            //要发送给提交任务审核的学员的消息内容
            String atContent;
            //消息模板
            int template = Message.TEMPLATE_NONE;

            if (ObjectUtils.equals(0, judgeResult)) {     //审核不通过

                userTaskRelation.setProgress(UserTaskRelation.PROGRESS_FAIL);

//                template = Message.TEMPLATE_121;
//                Map<String, Object> map = new HashMap<>();
//                map.put(Message.KEY_STUDY_NUM, user.getStudyNumber());
//                map.put(Message.KEY_SUID, studentId);
//                map.put(Message.KEY_ONAME, occupation.getName());
//                map.put(Message.KEY_TASK_NUM, task.getNum());
//                ObjectMapper json = new ObjectMapper();
//                atContent = json.writeValueAsString(map);

                atContent = "<span  class=\"font-16px system-alert-outline \">" +
                        "<a data-mid=22362 ng-click=\"sendAlertMsg(li.id)\" target=\"_blank\" " +
                        "href=\"/school/" + uid + "/class\"><span class=\"font-green\">" + user.getStudyNumber()
                        + "师兄</span> </a>已拒绝了 <a   data-mid=22362 ng-click=\"sendAlertMsg(li.id)\" target=\"_blank\" " +
                        " class=\"font-orange\" href=\"/school/" + studentId + "/task\" target=\"_blank\">你的" + occupation.getName() +
                        "任务" + task.getNum() + "</a></span>";

            } else if (ObjectUtils.equals(1, judgeResult)) {  //审核通过

                userTaskRelation.setProgress(UserTaskRelation.PROGRESS_PASSED);

//                template = Message.TEMPLATE_122;
//                Map<String, Object> map = new HashMap<>();
//                map.put(Message.KEY_STUDY_NUM, user.getStudyNumber());
//                map.put(Message.KEY_SUID, studentId);
//                map.put(Message.KEY_ONAME, occupation.getName());
//                map.put(Message.KEY_TASK_NUM, task.getNum());
//                ObjectMapper json = new ObjectMapper();
//                atContent = json.writeValueAsString(map);

                atContent = "<span  class=\"font-16px system-alert-outline \">" +
                        "<a data-mid=22362 ng-click=\"sendAlertMsg(li.id)\" target=\"_blank\" " +
                        "href=\"/school/" + uid + "/class\"><span class=\"font-green\">" + user.getStudyNumber()
                        + "师兄</span> </a>已通过了 <a   data-mid=22362 ng-click=\"sendAlertMsg(li.id)\"" +
                        " class=\"font-orange\" target=\"_blank\" href=\"/school/" + studentId + "/task\" target=\"_blank\">你的" + occupation.getName() +
                        "任务" + task.getNum() + "</a></span>";

                //如果审核通过，更新用户的最新任务以及价值
                User student = userService.getObjectById(userTaskRelation.getUid());
                student.setValue(student.getValue() == null ? new BigDecimal("0") : student.getValue());
                log.info(" student " + userTaskRelation.getUid() + " last task id = " + student.getLastTaskId());

                if (DataUtils.isNotNullOrEmpty(task)) {
                    log.info(" student value = " + student.getValue());
                    student.setValue(student.getValue().add(task.getValue() == null ? new BigDecimal("0") : task.getValue()));
                    log.info(" now student value = " + student.getValue());
                }
                student.setLastTaskId(userTaskRelation.getTid());
                userService.update(student);

                //如果审核通过，给用户新增技能
                List<Long> skillIds = taskSkillRelationService.getSkillIdsByTid(tid, 0, Integer.MAX_VALUE);
                log.info(" skillIds size = " + skillIds.size());
                if (CollectionUtils.isEmpty(skillIds)) {
                    log.info(" skillIds is empty ");
                } else {
                    log.info(" add student skill size " + skillIds.size());
                    List<UserSkillRelation> userSkillRelations = new ArrayList<>();
                    List<Skill> skills = skillService.getObjectsByIds(skillIds);
                    log.info(" skills size= " + skills.size());
                    for (Skill skill : skills) {
                        log.info(" ---------------- ");
                        UserSkillRelation userSkillRelation = new UserSkillRelation();
                        userSkillRelation.setUid(studentId);
                        userSkillRelation.setSid(skill.getId());
                        userSkillRelations.add(userSkillRelation);
                        log.info(" userSkillRelations size = " + userSkillRelations.size());
                    }
                    log.info(" userSkillRelations = " + userSkillRelations);
                    log.info(" student " + studentId + " master skill size is " + userSkillRelations.size());
                    userSkillRelationService.insertList(userSkillRelations);
                }

            } else {  //审核结果既不等于0，又不等于1
                model.addAttribute("code", -1003);
                return "/data/json";
            }

            //更新userTaskRelation
            userTaskRelation.setJudgeRemark(judgeRemark);
            userTaskRelation.setJudgeAt(System.currentTimeMillis());
            userTaskRelation.setJudgeUid(uid);
            userTaskRelationService.update(userTaskRelation);

            //发消息给提交任务审核的学员
            Message message = new Message();
            message.setSendId(0L);
            message.setReceiveId(atUser.getId());
            message.setSendName("admin");
            message.setReceiveName(atUser.getNick());
            message.setContent(atContent);

//            message.setTemplate(template);

            message.setUnread(Message.Status_Unread);
            message.setType(Message.TASK_TYPE);
            message.setRelationId(userTaskRelationId);

            Long atMessageId = messageService.insert(message);

            if (DataUtils.isNotNullOrEmpty(atMessageId)) {
                //提交任务审核的学员未读消息+1，消息类型为“任务审核”
                atUser.setIsLook(atUser.getIsLook() + 1);
                atUser.setLatestMsg(Message.TASK_TYPE);
                userService.update(atUser);

                //这个方法不清楚是什么意思
//                adminSend(atUser.getMobile(), atContent);
            }

            model.addAttribute("code", 0);
            model.addAttribute("userTaskRelation", userTaskRelation);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update userTaskRelation error,id is  " + userTaskRelationId);
            model.addAttribute("code", -1);

        }
        return "/data/json";
    }


    /*
    提交任务
     */
    @RequestMapping(value = "/a/u/task/judgement/{tid}", method = RequestMethod.PUT)
    public String updateUserTaskRelationJson(HttpServletRequest request,
                                             HttpServletResponse response, ModelMap model, UserTaskRelation userTaskRelation,
                                             @PathVariable Long tid) throws Exception {
        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        log.info(" user " + uid + " submit task id " + tid);

        try {
            //校验参数
            if (DataUtils.isNullOrEmpty(userTaskRelation.getResultUrl())
                    && DataUtils.isNullOrEmpty(userTaskRelation.getCodeUrl())) {
                model.addAttribute("code", -16002);
                return "/data/json";
            }
            //校验任务记录是否存在
            Long userTaskId = userTaskRelationService.getUserTaskRelationIdByTidAndUid(tid, uid);
            if (DataUtils.isNotNullOrEmpty(userTaskId)) {

                //校验进度是否已经是提交
                UserTaskRelation userTaskRelation1 = userTaskRelationService.getObjectById(userTaskId);
                if (UserTaskRelation.PROGRESS_SUBMITED == userTaskRelation1.getProgress()) {
                    model.addAttribute("code", -17008);
                    return "/data/json";
                }
                userTaskRelation1.setCodeUrl(userTaskRelation.getCodeUrl());
                userTaskRelation1.setResultUrl(userTaskRelation.getResultUrl());
                userTaskRelation1.setProgress(UserTaskRelation.PROGRESS_SUBMITED);
                userTaskRelation1.setSubmitAt(System.currentTimeMillis());
                userTaskRelationService.update(userTaskRelation1);
                Occupation occupation = occupationService.getObjectById(user.getOid());
                Task task = taskService.getObjectById(tid);

                User atUser = userService.getObjectById(user.getTeacherId());
                if (atUser == null) {
                    log.info("atUser is null");
                } else {
                    Long atMessageId = messageService
                            .insert(new Message(atUser.getId(), atUser
                                    .getNick(), Message.TASK_TYPE, userTaskId));

                    String atContent = "<span  class=\"font-16px system-alert-outline \">" +
                            "<a data-mid=22362 ng-click=\"sendAlertMsg(li.id)\" target=\"_blank\" href=\"/school/" + uid + "/class\">" +
                            "<span class=\"font-green\">" + user.getStudyNumber() + "师弟</span> </a>" +
                            "提交了 <a   data-mid=22362 ng-click=\"sendAlertMsg(li.id)\" class=\"font-orange\" target=\"_blank\" href=\"" +
                            "/school/" + user.getTeacherId() + "/judgeList/\" target=\"_blank\">" + occupation.getName() +
                            "的任务" + task.getNum() + "</a></span>";

//                    int template = Message.TEMPLATE_120;
//                    Map<String, Object> map = new HashMap<>();
//                    map.put(Message.KEY_SUID, uid);
//                    map.put(Message.KEY_STUDY_NUM, user.getStudyNumber());
//                    map.put(Message.KEY_TUID, user.getTeacherId());
//                    map.put(Message.KEY_ONAME, occupation.getName());
//                    map.put(Message.KEY_TASK_NUM, task.getNum());
//                    ObjectMapper json = new ObjectMapper();
//                    String atContent = json.writeValueAsString(map);

                    adminSend(atUser.getMobile(), atContent);

                    Message atMessage = messageService
                            .getObjectById(atMessageId);
//                    atMessage.setTemplate(template);

                    log.info("the atmessage=====" + atMessage);
                    if (null != atMessage) {
                        atMessage.setContent(atContent);
                        messageService.update(atMessage);
                    }
                    atUser.setIsLook(atUser.getIsLook() + 1);
                    atUser.setLatestMsg(Message.TASK_TYPE);
                    userService.update(atUser);
                }

            } else {
                log.info(" userTaskId is null ,user didn't receive this task " + tid);
                model.addAttribute("code", -16003);
                return "/data/json";
            }


            model.addAttribute("code", 0);
            model.addAttribute("userTaskRelation", userTaskRelation);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update userTaskRelation error,id is  " + userTaskRelation.getId());
            model.addAttribute("code", -1);

        }

        return "/data/json";
    }

    public String adminSend(String mobile, String content)
            throws ServiceException, ServiceDaoException {

        log.info("hhhhhhhhh");
        String param = "{\n" + "    \"target_type\" : \"users\", \n"
                + "    \"target\" : [\"" + mobile + "\"],   \n"
                + "                                   \n"
                + "                                   \n" + "    \"msg\" : {\n"
                + "        \"type\" : \"txt\",\n" + "        \"msg\" : \""
                + content + "\" \n" + "        },\n"
                + "    \"from\" : \"admin\"\n" + "}";

        String result = HttpClientUtil.sendPostRequestByJavaSetHeader(
                "https://a1.easemob.com/jnshu4/jnshu4/messages", param,
                "application/json", "Bearer " + this.easemob_token);
        log.info(param);
        log.info(result);

        log.info("hhhhhhhhh" + result);
        return result;
    }

    /**
     * 任务领取
     *
     * @param request
     * @param response
     * @param model
     * @param tid
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/task/judgement/{tid}", method = RequestMethod.POST)
    public String addUserTaskRelationJson(HttpServletRequest request,
                                          HttpServletResponse response, ModelMap model, @PathVariable Long tid) throws Exception {
        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        log.info(" user " + uid + " receive task id " + tid);

        try {
            //校验任务是否存在
            Task task = taskService.getObjectById(tid);
            if (DataUtils.isNullOrEmpty(task)) {
                model.addAttribute("code", -16004);
                return "/data/json";

            }
            //校验是否领取过任务
            Long oldId = userTaskRelationService.getUserTaskRelationIdByTidAndUid(tid, uid);
            log.info(" oldId = " + oldId);
            if (DataUtils.isNotNullOrEmpty(oldId)) {
                model.addAttribute("code", -17007);
                return "/data/json";
            }

            Long taskOid = task.getOid();

            UserTaskRelation userTaskRelation = new UserTaskRelation();
            userTaskRelation.setTid(tid);
            userTaskRelation.setUid(uid);
            Long cid = user.getCid();
            //校验用户是否加入了班级
            if (DataUtils.isNullOrEmpty(cid) ||
                    cid < 0) {
                log.info(" user " + uid + " didn't add class ,so can't receive task ");
                model.addAttribute("code", -16000);
                return "/data/json";
            } else {
                //如果加入了班级，校验领取的任务是否是该职业下的
                log.info(" user " + uid + " class is " + cid);
                if (!taskOid.equals(user.getOid())) {
                    model.addAttribute("code", -16005);
                    return "/data/json";
                }
            }
            userTaskRelation.setOid(user.getOid());
            userTaskRelation.setReceiveAt(System.currentTimeMillis());
            userTaskRelation.setId(null);
            Long userTaskId = userTaskRelationService.insert(userTaskRelation);

            log.info(" user " + uid + " receive task " + tid + " success ,id = " + userTaskId);
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add userTaskRelation error ");
            model.addAttribute("code", -1);
        }

        return "/data/json";
    }

    /**
     * 查看审核失败说明
     *
     * @param request
     * @param response
     * @param model
     * @param tid
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/task/judge/fail/{tid}", method = RequestMethod.GET)
    public String getUserTaskRelationJudgeFailJson(HttpServletRequest request,
                                                   HttpServletResponse response, ModelMap model, @PathVariable Long tid)
            throws Exception {

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        log.info(" user " + uid + " want to watch task judged fail's reason ,task is " + tid);

        try {
            UserTaskRelation userTaskRelation = new UserTaskRelation();
            User teacher = new User();
            Long userTaskId = userTaskRelationService.getUserTaskRelationIdByTidAndUid(tid, uid);
            if (DataUtils.isNotNullOrEmpty(userTaskId)) {
                userTaskRelation = userTaskRelationService.getObjectById(userTaskId);
                teacher = userService.getObjectById(user.getTeacherId());

            }
            model.addAttribute("code", 0);
            model.addAttribute("userTaskRelation", userTaskRelation);
            model.addAttribute("teacher", teacher);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error(" user " + uid + " want to watch task judged fail's reason error ,task is " + tid);
            model.addAttribute("code", -100000);
        }

        return "/skill-service/userTaskRelation/json/userTaskRelationFailJson";
    }

    /**
     * 获取师弟提审任务列表
     *
     * @param request
     * @param response
     * @param model
     * @param page
     * @param size
     * @param type     1–待审核  2--已审核
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/task/review/list", method = RequestMethod.GET)
    public String getUserTaskRelationIdsByUidAndOidJsonList(HttpServletRequest request,
                                                            HttpServletResponse response, ModelMap model, Integer page,
                                                            Integer size, Integer type) throws Exception {
        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        log.info(" user " + uid + " get student's task list ,type =  " + type);

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        log.info("pageList : page= " + start + " , size=" + size);
        try {
            if (DataUtils.isNullOrEmpty(type)) {
                model.addAttribute("code", -16008);
                return "/data/json";
            }
            if (!(UserTaskRelation.UNJUDGE == type || UserTaskRelation.JUDGE_FAILD == type ||
                    UserTaskRelation.JUDGE_PASS == type)) {
                model.addAttribute("code", -1003);
                return "/data/json";
            }

            Map<String, Object> map = DynamicUtil.getUserTaskListByTeacherId(uid, type, false);
            List<Long> ids = userTaskRelationService.getIdsByDynamicCondition(UserTaskRelation.class, map, start, size);
            List<UserTaskRelation> userTaskRelationList = new ArrayList<>();
            List<User> users = new ArrayList<>();
            List<Task> tasks = new ArrayList<>();
            List<Classes> classesList = new ArrayList<>();
            List<Occupation> occupations = new ArrayList<>();
            if (CollectionUtils.isEmpty(ids)) {
                log.info(" teacher " + uid + " doesn't have student ");
            } else {
                log.info(" teacher " + uid + " has unjudge task ,ids size = " + ids.size());
                userTaskRelationList = userTaskRelationService.getObjectsByIds(ids);
                if (CollectionUtils.isEmpty(userTaskRelationList)) {

                } else {
                    Set<Long> uids = new HashSet<>();
                    Set<Long> taskIds = new HashSet<>();
                    Set<Long> occupationIds = new HashSet<>();
                    Set<Long> classesIds = new HashSet<>();

                    for (UserTaskRelation userTaskRelation : userTaskRelationList) {
                        uids.add(userTaskRelation.getUid());
                        taskIds.add(userTaskRelation.getTid());
                        occupationIds.add(userTaskRelation.getOid());
                    }
                    users = userService.getObjectsByIds(new ArrayList<Long>(uids));
                    for (User user1 : users) {
                        classesIds.add(user1.getCid());
                    }
                    classesList = classesService.getObjectsByIds(new ArrayList<Long>(classesIds));
                    tasks = taskService.getObjectsByIds(new ArrayList<Long>(taskIds));
                    occupations = occupationService.getObjectsByIds(new ArrayList<Long>(occupationIds));
                }
            }

            int total = userTaskRelationService.getIdsByDynamicCondition(UserTaskRelation.class, map, 0, Integer.MAX_VALUE).size();
            log.info("get userTaskRelation count is " + total);
            int totalPage = 1;
            if (total > 0) {
                totalPage = (((total - 1)) / (size)) + 1;
            }


            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("userTaskRelationList", userTaskRelationList);
            model.addAttribute("users", users);
            model.addAttribute("tasks", tasks);
            model.addAttribute("occupations", occupations);
            model.addAttribute("classesList", classesList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get userTaskRelation list error,page is  " + start + " , size "
                    + size);
            model.addAttribute("code", -100000);
        }

        return "/skill-service/userTaskRelation/json/userTaskRelationListJson";
    }


    /**
     * 查看提审任务详情
     *
     * @param request
     * @param response
     * @param model
     * @param userTaskRelationId 用户任务Id
     * @return
     * @throws Exception
     */

    @RequestMapping(value = "/a/task/review/{userTaskRelationId}/detail", method = RequestMethod.GET)
    public String getUserTaskRelationJson(HttpServletRequest request,
                                          HttpServletResponse response, ModelMap model, @PathVariable Long userTaskRelationId)
            throws Exception {

        log.info("get userTaskRelation : id= " + userTaskRelationId);
        try {
            UserTaskRelation userTaskRelation = userTaskRelationService.getObjectById(userTaskRelationId);
            User user = new User();
            Occupation occupation = new Occupation();
            Classes classes = new Classes();
            Task task = new Task();
            log.info("get userTaskRelation  is " + userTaskRelation);
            if (DataUtils.isNullOrEmpty(userTaskRelation)) {
                model.addAttribute("code", -1111);
                return "/data/json";

            } else {
                task = taskService.getObjectById(userTaskRelation.getTid());
                user = userService.getObjectById(userTaskRelation.getUid());
                occupation = occupationService.getObjectById(user.getOid());
                classes = classesService.getObjectById(user.getCid());
            }
            model.addAttribute("code", 0);
            model.addAttribute("userTaskRelation", userTaskRelation);
            model.addAttribute("user", user);
            model.addAttribute("occupation", occupation);
            model.addAttribute("classes", classes);
            model.addAttribute("task", task);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get userTaskRelation error,id is  " + userTaskRelationId);
            model.addAttribute("code", -100000);
        }

        return "/skill-service/userTaskRelation/json/userTaskRelationDetailJson";
    }

    /**
     * 我的技能/个人技能--获取用户任务进度
     *
     * @param request
     * @param response
     * @param model
     * @return
     * @throws Exception
     */

    @RequestMapping(value = "/a/user/{uid}/task/progress", method = RequestMethod.GET)
    public String getUserTaskProressJson(HttpServletRequest request,
                                         HttpServletResponse response, ModelMap model, @PathVariable Long uid)
            throws Exception {
        /*User user = (User)request.getAttribute("user");
		Long uid = user.getId();*/
        log.info("get data  oid:" + uid);
        log.info("get user last task start ... ");
        try {
            List<UserTaskRelation> userTaskRelations = new ArrayList<>();
            Occupation occupation = new Occupation();
            Classes classes = new Classes();
            Task task = new Task();
            BigDecimal nextValue = new BigDecimal("0");
            User user = userService.getObjectById(uid);
            if (DataUtils.isNullOrEmpty(user)) {
                log.info("user  can not be empty");
                // 返回message应该为：用户不存在
                model.addAttribute("code", -2000);
                return "/data/json";
            }
            List<Long> userTaskRelationIds = userTaskRelationService.getUserTaskRelationIdsByUidAndOid(uid, user.getOid(), 0, Integer.MAX_VALUE);

            if (CollectionUtils.isEmpty(userTaskRelationIds)) {
                log.info(" user didn't take any task ");

            } else {
                log.info(" user  last complete task id = " + user.getLastTaskId());
                UserTaskRelation newUserTaskRelation = userTaskRelationService.getObjectById(userTaskRelationIds.get(0));
                log.info(" user last learning task id =  " + newUserTaskRelation.getTid());
                task = taskService.getObjectById(newUserTaskRelation.getTid());//task标示最后完成的一个任务
                task.setProgress(newUserTaskRelation.getProgress());
                occupation = occupationService.getObjectById(user.getOid());
                classes = classesService.getObjectById(user.getCid());
                //获取下一阶段的价值
                if (UserTaskRelation.PROGRESS_PASSED == newUserTaskRelation.getProgress()) {
                    log.info(" new task is passed,so next value is next task's value ");
                    List<Long> taskIds = taskService.getTaskIdsByOid(user.getOid(), 0, Integer.MAX_VALUE);
                    List<Task> tasks = taskService.getObjectsByIds(taskIds);
                    long num = task.getNum() + 1;
                    log.info(" num = " + num);
                    for (Task task1 : tasks) {
                        if (num == task1.getNum()) {
                            nextValue = task1.getValue() == null ? new BigDecimal("0") : task1.getValue();
                            log.info(" nextValue = " + nextValue);
                        }
                    }

                } else {
                    log.info(" new task don't complete,so next value is this task's value ");
                    nextValue = task.getValue() == null ? new BigDecimal("0") : task.getValue();
                }


                userTaskRelations = userTaskRelationService.getObjectsByIds(userTaskRelationIds);


            }

            model.addAttribute("code", 0);
            model.addAttribute("user", user);
            model.addAttribute("occupation", occupation);
            model.addAttribute("classes", classes);
            model.addAttribute("task", task);
            model.addAttribute("nextValue", nextValue);
            model.addAttribute("userTaskRelations", userTaskRelations);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get user last task   error  ");
            model.addAttribute("code", -100000);
        }

        return "/skill-service/userTaskRelation/json/userTaskRelationDetailJson";
    }

    @RequestMapping(value = "/a/userTaskRelation/{id}", method = RequestMethod.DELETE)
    public String deleteUserTaskRelationJson(HttpServletRequest request,
                                             HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("delete userTaskRelation : id= " + id);
        try {
            userTaskRelationService.delete(id);

            log.info("add userTaskRelation success");
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete userTaskRelation error,id is  " + id);
            model.addAttribute("code", -6004);

        }

        return "/data/json";
    }


}

