package com.ptteng.common.skill.controller;

import com.gemantic.common.util.MyListUtil;
import com.ptteng.common.skill.model.*;
import com.ptteng.common.skill.service.*;
import com.ptteng.common.skill.util.*;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import net.sf.json.JSONArray;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Answer  crud
 *
 * @author guchen
 * @Date 2018-01-19
 */
@Controller
public class AnswerController {
    private static final Log log = LogFactory.getLog(AnswerController.class);

    @Autowired
    private AnswerService answerService;

    @Autowired
    private QuestionService questionService;

    @Autowired
    private UserService userService;

    @Autowired
    private CookieUtil cookieUtil;

    @Autowired
    private OccupationService occupationService;

    @Autowired
    private TaskService taskService;

    @Autowired
    private GetUserFromCookieUtil getUserFromCookieUtil;

    @Autowired
    private UserArticleRelationService userArticleRelationService;

    @Autowired
    private QuestionLabelRelationService questionLabelRelationService;

    @Autowired
    private LabelService labelService;

    @Resource
    private CommonUtil commonUtil;

    @Resource
    private MessageService messageService;

    @Resource
    private QuestionCtrlUtil questionCtrlUtil;


    /**
     * 1 新增回答
     *
     * @param request
     * @param response
     * @param model
     * @param answer
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/v/answer", method = RequestMethod.POST)
    public String addAnswerJson(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model, Answer answer) throws Exception {

        log.info("update answer : answer= " + answer);

        //未登录返回-2，前端模态框提示用户重新登录
        Long userId = getUserFromCookieUtil.getUserFromCookie(request);
        log.info("userId is " + userId);
        if (DataUtils.isNullOrEmpty(userId)) {
            log.info("user no login");
            model.addAttribute("code", -2);
            return "/common/failure";
        }

        if (answer.getQuestionId() == null) {
            model.addAttribute("code", -29001);
            log.info("questionId is null");
            return "/common/failure";
        }

        if (answer.getContent() == null) {
            model.addAttribute("code", -29002);
            log.info("content is null");
            return "/common/failure";
        }


        try {
            answer.setId(null);
            answer.setLikeNum(0);
            answer.setIsLike(0);
            answer.setStatus(Constants.STATUS_SHOW);
            answer.setCreateBy(userId);
            answer.setUpdateBy(userId);

            Long id = answerService.insert(answer);
            if (DataUtils.isNullOrEmpty(id)) {
                log.info("add answer error ");
                model.addAttribute("code", -1);
                return "/common/failure";
            }

            //新增问题回答关系
            Question question = questionService.getObjectById(answer.getQuestionId());
            if (DataUtils.isNullOrEmpty(question)) {
                log.info("get question error :question is null");
                model.addAttribute("code", -28006);
                return "/common/failure";
            } else {
                log.info("get question data is " + question);
                question.setAnswerNum(question.getAnswerNum() + 1);
                boolean isUpdate = questionService.update(question);
                if (isUpdate) {
                    log.info(" update success.");
                } else {
                    model.addAttribute("code", -1);
                    return "/common/failure";
                }
            }

            //发信人 && 收件人
            User sender = userService.getObjectById(userId); //当前回答人
            User receiver = userService.getObjectById(question.getCreateBy()); //问题创建人

            //新增回答消息
            Message message = new Message();
            message.setSendId(sender.getId());
            message.setReceiveId(receiver.getId());
            message.setSendName(sender.getNick());
            message.setReceiveName(receiver.getNick());
            message.setContent(String.valueOf(id));//id为新增的回答的id
            message.setStatus(Message.STATUS_UNDELETE);
            message.setUnread(Message.Status_Unread);
            message.setType(Message.QUESTION_TYPE);
            message.setTemplate(Message.TEMPLATE_2);
            message.setRelationId(question.getId());
            message.setCreateBy(sender.getId());
            message.setUpdateBy(sender.getId());

            Long messageId = messageService.insert(message);
            if (DataUtils.isNullOrEmpty(messageId)) {
                log.info("add message error ");
                model.addAttribute("code", -1);
                return "/common/failure";
            } else {
                //若消息发送成功，收件人未读消息+1，消息类型为“question”
                receiver.setIsLook(receiver.getIsLook() + 1);
                receiver.setLatestMsg(Message.QUESTION_TYPE);
                userService.update(receiver);
            }

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add answer error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

    /**
     * 2 获取回答详情-jsp
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @param orderBy
     * @param sort
     * @param page
     * @param size
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/k/answer/{id}", method = RequestMethod.GET)
    public String getAnswerJson(
            HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id,
            Integer orderBy, Integer sort, Integer page, Integer size)
            throws Exception {

        log.info("get data : id= " + id);

        if (id == null) {
            model.addAttribute("code", -29005);
            log.info("id is null");
            return "/common/failure";
        }
        //初始化page size start
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        try {
            //当前问题所有回答的创建人的id集合
            List<Long> uidList = new ArrayList<>();

            //获取当前回答详情
            Answer theAnswer = answerService.getObjectById(id);
            if (DataUtils.isNullOrEmpty(theAnswer)) {
                log.info("get answer error :answer == null");
                model.addAttribute("code", -29004);
                return "/web-kenghu/common/404";
            } else {
                log.info("get answer data is " + theAnswer);
                uidList.add(theAnswer.getCreateBy());
            }

            //获取当前问题详情
            Question question = questionService.getObjectById(theAnswer.getQuestionId());
            log.info("get question data is " + question);

            //当问题不存在或者是问题被隐藏时，跳转到404
            if (DataUtils.isNullOrEmpty(question) || !question.getStatus().equals(1)) {
                log.info("get question error: question == null or this question has been hidden");
                model.addAttribute("code", -28006);
                return "/web-kenghu/common/404";
            }

            //处理module json字符串
            JSONArray moduleList = new JSONArray();
            if (StringUtils.isNotBlank(question.getModules())) {
                moduleList = JSONArray.fromObject(question.getModules());
            }

            //获取问题标签关系
            Map<String, Object> questionLabelRelationLisParamList = DynamicUtil.getQuestionLabelRelationListParam(null, question.getId().toString());
            log.info(" questionLabelRelationLisParamList size =  " + questionLabelRelationLisParamList.size());

            List<Long> questionLabelRelationIdList = questionLabelRelationService.getIdsByDynamicCondition(QuestionLabelRelation.class, questionLabelRelationLisParamList, 0, Integer.MAX_VALUE);
            List<QuestionLabelRelation> questionLabelRelationList = new ArrayList<>();
            if (CollectionUtils.isEmpty(questionLabelRelationIdList)) {
                log.info(" questionLabelRelationIdList is null ");
            } else {
                log.info(" questionLabelRelationIdList size =  " + questionLabelRelationIdList.size());
                questionLabelRelationList = questionLabelRelationService.getObjectsByIds(questionLabelRelationIdList);
            }

            //获取问题对应标签ids
            List<Long> labelIdList = new ArrayList<>();
            for (QuestionLabelRelation questionLabelRelation : questionLabelRelationList) {
                if (questionLabelRelation.getLabelId() != null) {
                    labelIdList.add(questionLabelRelation.getLabelId());
                }
            }

            //获取标签map
            Map<Long, Label> labelMap = new HashMap();
            if (CollectionUtils.isEmpty(labelIdList)) {
                log.info(" labelIdList is null ");
            } else {
                log.info(" labelIdList size =  " + labelIdList.size());
                labelMap = questionCtrlUtil.getLabelMap(labelIdList);
            }

            //获取回答列表的动态查询条件
            Map<String, Object> answerParamList = DynamicUtil.getAnswerListParam(null, null, null, null, null, question.getId().toString(), Constants.STATUS_SHOW, null, null, null, orderBy, sort);
            log.info(" paramList size =  " + answerParamList.size());

            //获取当前问题总的回答数total
            List<Long> allAnswer = answerService.getIdsByDynamicCondition(Answer.class, answerParamList, 0, Integer.MAX_VALUE);
            log.info("total is:" + allAnswer.size());

            //根据page和size获取回答list、并把回答者id添加到uidList中
            //此处size先手动+1，之后再根据“回答列表不包含当前正在查看的回答详情”的要求，当answerList.size()大于传入的size时，手动删除大于size的部分
            List<Long> answerIdList = answerService.getIdsByDynamicCondition(Answer.class, answerParamList, start, (size + 1));
            log.info("answerIdList size =" + answerIdList.size());
            List<Answer> answerList = new ArrayList<>();
            if (CollectionUtils.isEmpty(answerIdList)) {
                log.info(" answerIdList is empty ");
                model.addAttribute("size", 0);
                model.addAttribute("total", 0);
            } else {
                answerList = answerService.getObjectsByIds(answerIdList);
                log.info(" answerList size =  " + answerList.size());
                for (Answer answer : answerList) {
                    if (answer.getCreateBy() != null) {
                        uidList.add(answer.getCreateBy());
                    }
                }
            }

            //根据上面得到的uidList，获取userList，并把回答者的职业id添加到oidList
            List<User> userList = new ArrayList<>();
            List<Long> oidList = new ArrayList<>();
            Map<Long, User> userMap = new HashMap<>();

            if (CollectionUtils.isEmpty(uidList)) {
                log.info(" uidList is empty ");
            } else {
                log.info(" uidList size =  " + uidList.size());
                userList = userService.getObjectsByIds(uidList);
                userMap = MyListUtil.convert2Map(User.class.getDeclaredField("id"), userList);
                for (User user : userList) {
                    if (!user.getOid().equals(User.Occupation_None)) {
                        oidList.add(user.getOid());
                    }
                }
            }

            //拼出所有所得者的昵称，添加到nickMap中
            Map<Long, String> nickMap = new HashMap<>();

            if (CollectionUtils.isEmpty(oidList)) {
                log.info(" oidList is empty ");
            } else {
                log.info(" oidList size =  " + oidList.size());
                List<Occupation> occupationList = occupationService.getObjectsByIds(oidList);
                Map<Long, Occupation> occupationMap = MyListUtil.convert2Map(Occupation.class.getDeclaredField("id"), occupationList);
                for (User user : userList) {
                    if (!user.getOid().equals(User.Occupation_None)) {
                        nickMap.put(user.getId(), commonUtil.setUserShowName(user, occupationMap.get(user.getOid())));
                    } else {
                        nickMap.put(user.getId(), commonUtil.setUserShowName(user, null));
                    }

                }
            }

            //获取当前登录的用户id
            Answer userAnswer = null;
            Long userId = getUserFromCookieUtil.getUserFromCookie(request);
            if (DataUtils.isNullOrEmpty(userId)) {
                log.info("user no login");
            } else {
                //往model里添加当前登录用户curUser、和昵称curNickMap
                model = questionCtrlUtil.getCurUser(userId, model);

                //获取查询当前用户是否回答了该问题的动态条件
                Map<String, Object> userAnswerParamList = DynamicUtil.getAnswerListParam(null, null, null, null, UserArticleRelation.LIST_TYPE_CREATE, question.getId().toString(), Constants.STATUS_SHOW, userId, null, null, null, null);
                log.info(" userAnswerParamList size =  " + userAnswerParamList.size());

                //获取相关list(后台隐藏的回答视为失效，用户可以继续回答，同一个问题，用户可显示的回答只有一个)
                List<Long> userAnswerIdList = answerService.getIdsByDynamicCondition(Answer.class, userAnswerParamList, 0, Integer.MAX_VALUE);
                if (CollectionUtils.isEmpty(userAnswerIdList)) {
                    log.info(" userAnswerIdList is null ");
                    model.addAttribute("userAnswer", null);
                } else {
                    List<Answer> userAnswerList = answerService.getObjectsByIds(userAnswerIdList);
                    log.info(" userAnswerList size =  " + userAnswerList.size());
                    userAnswer = userAnswerList.get(0);
                    log.info(" userAnswer is : " + userAnswer);
                }
            }

            //回答列表中是否包含当前查看的回答，若不包含，先加进列表判断收藏点赞关系，再取出来
            Boolean isContain = false;
            if (answerIdList.contains(theAnswer.getId())) {
                log.info("answerIdList contain the answer");
                isContain = true;
            } else {
                answerIdList.add(theAnswer.getId());
                answerList.add(theAnswer);
            }

            //用户登录时，判断用户是否踩坑问题或者点赞回答
            List<Long> questionIdList = new ArrayList<>();
            questionIdList.add(question.getId());
            List<Question> questionList = new ArrayList<>();
            questionList.add(question);

            if (DataUtils.isNotNullOrEmpty(userId)) {
                questionCtrlUtil.checkQuestionAndAnswerLikeOrCollection(userId, questionIdList, questionList, answerIdList, answerList);
            }

            if (!isContain) { //原始的answerList不包含theAnswer，判断完curUser和theAnswer的关系后，从answerList中移除theAnswer
                answerList.remove(theAnswer);

                if (answerList.size() > size) {  //如果answerList.size()大于传入的size
                    answerList.remove((answerList.size() - 1));  //删除最后一各个对象
                }

            } else { //原始的answerList包含theAnswer，根据需求“回答列表不包含当前查看的回答详情”
                //声明一个待删除的对象，准备进行引用传递
                Answer waitForDeleteAnswer = null;

                //若当前的回答列表已经包含正在查看的回答，则更新正在查看的回答的isLike字段
                for (Answer answer : answerList) {
                    if (theAnswer.getId().equals(answer.getId())) {
                        theAnswer.setIsLike(answer.getIsLike());
                        waitForDeleteAnswer = answer;  //引用传递
                    }
                }

                //当待删除的对象不为空时，从answerList中移除这个待删除对象
                if (DataUtils.isNotNullOrEmpty(waitForDeleteAnswer)) {
                    answerList.remove(waitForDeleteAnswer);
                }
            }

            Integer totalPage = 1;
            Integer total = allAnswer.size();
            if (total > 0) {
                totalPage = (total - 1) / size + 1;
            }

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", answerList.size());
            model.addAttribute("pSize", size);
            model.addAttribute("total", total);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("theAnswer", theAnswer);
            model.addAttribute("userAnswer", userAnswer);
            model.addAttribute("answerList", answerList);
            model.addAttribute("question", question);
            model.addAttribute("moduleList", moduleList);
            model.addAttribute("userMap", userMap);
            model.addAttribute("nickMap", nickMap);
            model.addAttribute("labelMap", labelMap);
            model.addAttribute("questionLabelRelationList", questionLabelRelationList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get answer error,id is  " + id);
            model.addAttribute("code", -1);
        }

        return "/web-kenghu/answer/answerDetail";
    }


    /**
     * 3 修改回答
     *
     * @param request
     * @param response
     * @param model
     * @param answer
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/v/answer/{id}", method = RequestMethod.PUT)
    public String updateAnswerJson(HttpServletRequest request,
                                   HttpServletResponse response, ModelMap model, Answer answer,
                                   @PathVariable Long id) throws Exception {

        log.info("update answer : answer= " + answer);

        //未登录返回-2，前端模态框提示用户重新登录
        Long userId = getUserFromCookieUtil.getUserFromCookie(request);
        log.info("userId is " + userId);
        if (DataUtils.isNullOrEmpty(userId)) {
            log.info("user no login");
            model.addAttribute("code", -2);
            return "/common/failure";
        }

        if (id == null) {
            model.addAttribute("code", -29005);
            log.info("id is null");
            return "/common/failure";
        }

        if (answer.getContent() == null) {
            model.addAttribute("code", -29002);
            log.info("content is null");
            return "/common/failure";
        }

        try {

            Answer oldAnswer = answerService.getObjectById(id);
            log.info("get oldAnswer data is " + oldAnswer);
            if (DataUtils.isNullOrEmpty(oldAnswer)) {
                log.info("get oldAnswer error :oldAnswer is null");
                model.addAttribute("code", -29004);
                return "/common/failure";
            }

            oldAnswer.setContent(answer.getContent());
            oldAnswer.setUpdateBy(userId);

            boolean isUpdate = answerService.update(oldAnswer);
            if (isUpdate) {
                log.info(" update success.");
            } else {
                model.addAttribute("code", -1);
                return "/common/failure";
            }

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update answer error,id is  " + answer.getId());
            model.addAttribute("code", -1);

        }

        return "/common/success";
    }

    /**
     * 3.1 编辑回答-jsp
     *
     * @param request
     * @param response
     * @param model
     * @param question
     * @param labelIds
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/k/answer/edit", method = RequestMethod.GET)
    public String answerEdit(HttpServletRequest request,
                             HttpServletResponse response, ModelMap model, Question question,
                             String labelIds) throws Exception {

        return "/web-kenghu/answer/answerEdit";
    }

    /**
     * 4 搜索回答列表-我的回答/我的点赞
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @param oid
     * @param tid
     * @param uid
     * @param type       type 1-用户点赞(配合参数uid) 2-用户创建(配合参数createBy)
     * @param questionId
     * @param status
     * @param createBy
     * @param title
     * @param labelIds
     * @param orderBy
     * @param sort
     * @param page
     * @param size
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/k/answer/search", method = RequestMethod.GET)
    public String searchAnswerList(
            HttpServletRequest request, HttpServletResponse response, ModelMap model,
            Long id, Long oid, Long tid, Long uid, Integer type, Long questionId,
            Integer status, Long createBy, String title, String labelIds,
            Integer orderBy, Integer sort,
            Integer page, Integer size)
            throws Exception {

        //打印入参
        log.info("============================================");
        String paramStr = LogUtil.convertParam("/k/answer/search  by==id", id, "oid", oid, "tid", tid,
                "uid", uid, "type", type, "questionId", questionId, "status", status, "createBy", createBy, "title", title, "labelIds", labelIds,
                "orderBy", orderBy, "sort", sort, "page", page, "size", size);
        log.info(paramStr);

        //未登录返回-2，前端模态框提示用户重新登录
        Long userId = getUserFromCookieUtil.getUserFromCookie(request);
        log.info("userId is " + userId);
        if (DataUtils.isNullOrEmpty(userId)) {
            log.info("user no login");
            model.addAttribute("code", -2);
            return "/web-kenghu/answer/answerList";
        }

        //暂不支持获取他人信息，直接取当前用户id
        if (type == 1) {
            uid = userId;
        } else if (type == 2) {
            createBy = userId;
        }

        //初始化page size start
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        String pageStr = LogUtil.convertParam("page", page, "start", start, "size", size);
        log.info(pageStr);

        try {
            //当前登录的用户
            User curUser = userService.getObjectById(userId);

            //初始值
            List<Long> questionIdList = new ArrayList<>();
            List<Long> oidList = new ArrayList<>();
            List<Long> tidList = new ArrayList<>();
            List<Long> uidList = new ArrayList<>();
            String questionIdS = null;

            List<Question> questionList = new ArrayList<>();
            List<Occupation> occupationList = new ArrayList<>();
            List<Task> taskList = new ArrayList<>();
            List<User> userList = new ArrayList<>();
            Map<Long, Question> questionMap = new HashMap();

            //动态查询-获取参数列表
            if (null != questionId) {
                questionIdS = questionId.toString();
            }

            Map<String, Object> paramList = DynamicUtil.getAnswerListParam(id, oid, tid, uid, type, questionIdS, Constants.STATUS_SHOW, createBy, title, labelIds, orderBy, sort);
            log.info(" paramList size =  " + paramList.size());
            //获取相关list
            List<Long> answerIdList = answerService.getIdsByDynamicCondition(Answer.class, paramList, start, size);
            if (CollectionUtils.isEmpty(answerIdList)) {
                log.info(" answerIdList is null ");
                model.addAttribute("code", 0);
                model.addAttribute("size", 0);
                model.addAttribute("total", 0);
                model.addAttribute("uid", userId);
                model.addAttribute("curUser", curUser);
                model.addAttribute("type", type);
                return "/web-kenghu/answer/answerList";
            } else {
                log.info(" answerIdList size =  " + answerIdList.size());
            }

            //获取total
            List<Long> allAnswer = answerService.getIdsByDynamicCondition(Answer.class, paramList, 0, Integer.MAX_VALUE);
            log.info("total is:" + allAnswer.size());

            //获取关联list
            List<Answer> answerList = answerService.getObjectsByIds(answerIdList);
            for (Answer answer : answerList) {
                questionIdList.add(answer.getQuestionId());
                uidList.add(answer.getCreateBy());
            }

            if (CollectionUtils.isEmpty(questionIdList)) {
                log.info(" questionIdList is null ");
            } else {
                log.info(" questionIdList size =  " + questionIdList.size());
                questionList = questionService.getObjectsByIds(questionIdList);

                //一一映射
                questionMap = MyListUtil.convert2Map(Question.class.getDeclaredField("id"), questionList);
                for (Question question : questionList) {
                    oidList.add(question.getOid());
                    tidList.add(question.getTid());
                }
            }

            if (CollectionUtils.isEmpty(oidList)) {
                log.info(" oidList is null ");
            } else {
                log.info(" oidList size =  " + oidList.size());
                occupationList = occupationService.getObjectsByIds(oidList);
            }

            if (CollectionUtils.isEmpty(tidList)) {
                log.info(" tidList is null ");
            } else {
                log.info(" tidList size =  " + tidList.size());
                taskList = taskService.getObjectsByIds(tidList);
            }

            if (CollectionUtils.isEmpty(uidList)) {
                log.info(" uidList is null ");
            } else {
                log.info(" uidList size =  " + uidList.size());
                userList = userService.getObjectsByIds(uidList);
            }

            //用户是否点赞过或者收藏过
            log.info(" login user Id = " + userId);
            if (DataUtils.isNotNullOrEmpty(userId)) {
                questionCtrlUtil.checkQuestionAndAnswerLikeOrCollection(userId, questionIdList,questionList, answerIdList, answerList);
            }

            Integer totalPage = 1;
            Integer total = allAnswer.size();
            if (total > 0) {
                totalPage = (total - 1) / size + 1;
            }

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", answerList.size());
            model.addAttribute("pSize", size);
            model.addAttribute("uid", userId);
            model.addAttribute("curUser", curUser);
            model.addAttribute("type", type);
            model.addAttribute("total", total);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("answerList", answerList);
            model.addAttribute("questionMap", questionMap);
            model.addAttribute("questionList", questionList);
            model.addAttribute("occupationList", occupationList);
            model.addAttribute("taskList", taskList);
            model.addAttribute("userList", userList);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get label list error,page is " + page + " , size " + size);
            model.addAttribute("code", -1);
        }
        return "/web-kenghu/answer/answerList";
    }
}

