package com.ptteng.common.skill.controller;

import com.ptteng.common.skill.model.Iteration;
import com.ptteng.common.skill.model.Product;
import com.ptteng.common.skill.model.Project;
import com.ptteng.common.skill.model.Team;
import com.ptteng.common.skill.service.*;
import com.ptteng.common.skill.util.DynamicUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * Project  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class ProjectController {
	private static final Log log = LogFactory.getLog(ProjectController.class);

	@Autowired
	private ProjectService projectService;
	@Autowired
	private TeamService teamService;
	@Autowired
	private ProductService producService;
	@Autowired
	private IterationService iterationService;
	@Autowired
	private CookieUtil cookieUtil;
	@Autowired
	private UserService userService;

	//项目详情
	@RequestMapping(value = "/a/project/detail/{id}", method = RequestMethod.GET)
	public String getProjectJson(HttpServletRequest request,
								 HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		if (id==null){
			log.info("iteration id cannot be null");
			model.addAttribute("code", -22002);
		}
		try {
			Project project = projectService.getObjectById(id);
//			log.info("get project data is " + project);

			model.addAttribute("code", 0);

			model.addAttribute("project", project);

			//获取产品信息
			Product product= producService.getObjectById(project.getProductId());
			model.addAttribute("product", product);
			//获取迭代信息
			Iteration iteration = iterationService.getObjectById(project.getIterationId());
			model.addAttribute("iteration",iteration);
			//获取小组信息
			Team team = teamService.getObjectById(project.getTid());
			model.addAttribute("team",team);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get project error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/project/json/projectDetailJson2";
	}

	//项目详情批量获取
	@RequestMapping(value = "/a/project/detail", method = RequestMethod.GET)
	public String getProjectJson(HttpServletRequest request,
								 HttpServletResponse response, ModelMap model,  Long[] tid)
			throws Exception {

			List<Long> tidList = new ArrayList();
			List<Long> projectIdList = new ArrayList();
			List<Project> projectList =new ArrayList();

		try {
			if (tid == null) {
				log.info("not get any data ");
				model.addAttribute("code", -1000);
				return "/common/success";
			}else {
				tidList= Arrays.asList(tid);
				//获取项目Id列表
				int tidSize = tidList.size();
				for (int i=0;i<tidSize;i++){
					List<Long> projectIds = projectService.getProjectIdsByTidOrderByCreateAt(tidList.get(i),0,Integer.MAX_VALUE);
					int projectIdsSize = projectIds.size();
					for (int j=0;j<projectIdsSize;j++){
						projectIdList.add(projectIds.get(j));
					}
				}
				//获取项目列表
				projectList = projectService.getObjectsByIds(projectIdList);
				log.info("get  project data is " + projectList.size());
			}


				model.addAttribute("code", 0);
				model.addAttribute("total",projectList.size());
				model.addAttribute("projectList", projectList);

				//获取产品ID列表
				//获取迭代ID列表
				//获取小组ID列表
				List<Long> productIdList= new ArrayList();
				List<Long> iterationIdList= new ArrayList();
				List<Long> teamIdList=new ArrayList();
				int projectSize = projectList.size();
				for (int i=0;i<projectSize;i++){
					Project project=projectList.get(i);
					productIdList.add(project.getProductId());
					iterationIdList.add(project.getIterationId());
					teamIdList.add(project.getTid());
				}
				//获取产品列表
				List<Product> productList= producService.getObjectsByIds(productIdList);
				model.addAttribute("productList", productList);

				//获取迭代列表
				List<Iteration> iterationList=iterationService.getObjectsByIds(iterationIdList);
				model.addAttribute("iterationList",iterationList);

				//获取小组列表
				List<Team> teamList = teamService.getObjectsByIds(teamIdList);
				model.addAttribute("teams",teamList);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get project error " );
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/project/json/projectDetailJson";
	}

	//项目列表
	@RequestMapping(value = "/a/project/search", method = RequestMethod.GET)
	public String getMultiProjectJson(HttpServletRequest request,
									  HttpServletResponse response, ModelMap model, Integer page, Integer size,
									  Long tid ,String name,Long productId,Long iterationId,
									  Long startAt,Long endAt,Long finishStartAt,Long finishEndAt,
									  Long createBy,Long sid,Long status,Long createStartAt,Long createEndAt)
			throws Exception {
			/* 1 默认分页 */
		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		try {
			//初始值
			Long total =0L;
			//动态查询
			Map<String,Object> paramList = DynamicUtil.getProjectsListParam(tid ,name,productId,iterationId, startAt,
					endAt,finishStartAt,finishEndAt, createBy,sid,status,createStartAt,createEndAt,false);
			log.info("paramList size =" + paramList.size());
			//获取项目Id列表
			List<Long> projectsIdList = projectService.getIdsByDynamicCondition(Project.class,paramList,start,size);
			//获取total
			Map<String,Object> paramCount = DynamicUtil.getProjectsListParam(tid ,name,productId,iterationId, startAt,
					endAt,finishStartAt,finishEndAt, createBy,sid,status,createStartAt,createEndAt,true);
			List<Long> projectsIdCount = projectService.getIdsByDynamicCondition(Project.class,paramCount, 0, Integer.MAX_VALUE);
			if (CollectionUtils.isNotEmpty(projectsIdCount)) {
				total = projectsIdCount.get(0);
			}
			//获取项目列表
			List<Project> projectList = projectService.getObjectsByIds(projectsIdList);
			log.info("get  project data is " + projectList.size());


			model.addAttribute("code", 0);
			model.addAttribute("total",projectList.size());
			model.addAttribute("total",total);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			model.addAttribute("projectList", projectList);

			//获取产品ID列表
			//获取迭代ID列表
			//获取小组ID列表
			List<Long> productIdList= new ArrayList();
			List<Long> iterationIdList= new ArrayList();
			List<Long> teamIdList=new ArrayList();
			int projectSize = projectList.size();
			for (int i=0;i<projectSize;i++){
				Project project=projectList.get(i);
				productIdList.add(project.getProductId());
				iterationIdList.add(project.getIterationId());
				teamIdList.add(project.getTid());
			}
			//获取产品列表
			List<Product> productList= producService.getObjectsByIds(productIdList);
			model.addAttribute("productList", productList);

			//获取迭代列表
			List<Iteration> iterationList=iterationService.getObjectsByIds(iterationIdList);
			model.addAttribute("iterationList",iterationList);

			//获取小组列表
			List<Team> teamList = teamService.getObjectsByIds(teamIdList);
			model.addAttribute("teams",teamList);



		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get project list error");
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/project/json/projectListJson";
	}
	
	
	
}

