package com.ptteng.common.skill.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.StringUtil;
import com.ptteng.common.skill.model.*;
import com.ptteng.common.skill.service.*;
import com.ptteng.common.skill.util.DynamicUtil;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @Description 评论controller，之前的日报评论，写在了日报接口里，25期把评论单独拆出来了，为了不影响app的使用，
 * 之前的日报评论不做修改，后期如果要改的话，就在这个controller里做扩展
 * @Author ruanshaonan
 * @Date 2018/7/6 15:19
 **/

@Controller
public class CommentController {
    private static final Log log = LogFactory.getLog(CommentController.class);

    @Autowired
    CommentService commentService;

    @Autowired
    UserService userService;

    @Autowired
    ClassTimetableService classTimetableService;

    @Autowired
    MessageService messageService;

    @Autowired
    ArticleService articleService;


    /**
     * 获取小课堂的评论列表
     *
     * @Author ruanshaonan
     * @Date 16:06 2018/7/6
     * @Param smallClassId：小课堂id
     * @Param type：评论对象的类型  daily：日报或晨报  classes：小课堂
     * @Param page
     * @Param size
     */
    @RequestMapping(value = "/a/u/comment/list/{type}", method = RequestMethod.GET)
    private String getSmallClassComments(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                         Long targetId, Integer page, Integer size, @PathVariable("type") String type) {

        log.info("getSmallClassComments==targetId==" + targetId + "==page==" + page + "==size==" + size
                + "==type==" + type);

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        int targetType = 0;
        try {
            if (DataUtils.isNullOrEmpty(targetId)) {
                model.addAttribute("code", -1001);
                return "/common/success";
            }
            switch (type) {
                case Comment.COMMENT_TARGET_DAILY:
                    targetType = Comment.TYPE_DAILY;
                    Article article = articleService.getObjectById(targetId);
                    if (DataUtils.isNullOrEmpty(article)) {
                        model.addAttribute("code", -5000);
                        return "/common/success";
                    }
                    break;
                case Comment.COMMENT_TARGET_SMALL_CLASS:
                    targetType = Comment.TYPE_CLASS;
                    ClassTimetable classTimetable = classTimetableService.getObjectById(targetId);
                    if (DataUtils.isNullOrEmpty(classTimetable)) {
                        model.addAttribute("code", -60005);
                        return "/common/success";
                    }
                    break;
                default:
                    break;
            }
            Map<String, Object> totalCommentSql = DynamicUtil.getComments(targetId, targetType, true);
            Map<String, Object> commentIdsSql = DynamicUtil.getComments(targetId, targetType, false);
            List<Long> commentIds = commentService.getIdsByDynamicCondition(Comment.class, commentIdsSql, start, size);
            Object total = commentService.getObjectByDynamicCondition(Comment.class, totalCommentSql, 0, Integer.MAX_VALUE);
            log.info("commentIds==" + commentIds.size());
            log.info("total==" + total);

            if (CollectionUtils.isEmpty(commentIds)) {
                model.addAttribute("code", -60007);
                return "/common/success";
            }
            List<Comment> comments = commentService.getObjectsByIds(commentIds);
            log.info("get comment success==" + comments.size());

            List<Long> uids = new ArrayList<>();
            for (Comment comment : comments) {
                uids.add(comment.getUid());
            }
            log.info("uids==" + uids.size());
            if (CollectionUtils.isNotEmpty(uids)) {
                List<User> users = userService.getObjectsByIds(uids);
                model.addAttribute("users", users);
            }
            model.addAttribute("code", 0);
            model.addAttribute("comments", comments);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "/common-skill-service/comment/json/commentListJson";
    }


//    /**
//     * 新增评论
//     *
//     * @return
//     * @Author ruanshaonan
//     * @Description 包括评论和回复评论
//     * @Date 23:15 2018/7/12
//     * @Param type：评论对象类型  daily：日报或晨报  class：小课堂
//     * @Param targetId：评论对象id
//     * @Param commenterId：评论者id
//     * @Param comment：评论内容
//     * @Param atUid：回复对象id
//     */
//    @RequestMapping(value = "/a/u/comment/{type}/{targetId}", method = RequestMethod.POST)
//    private String addComment(HttpServletRequest request, HttpServletResponse response, ModelMap model,
//                              @PathVariable("type") String type, Long commenterId, String content,
//                              Long atUid, @PathVariable("targetId") Long targetId) {
//        log.info("addComment==type==" + type + "==targetId==" + targetId + "==commenterId==" + commenterId
//                + "==content==" + content + "==atUid==" + atUid);
//
//        int templateType = 0;
//        int commentType = 0;
//        switch (type) {
//            case Comment.COMMENT_TARGET_DAILY:
//                commentType = Comment.TYPE_DAILY;
//                templateType = Message.SMALL_CLASS_TEMPLATE_256;
//                break;
//            case Comment.COMMENT_TARGET_SMALL_CLASS:
//                commentType = Comment.TYPE_CLASS;
//                templateType = Message.SMALL_CLASS_TEMPLATE_257;
//                break;
//            default:
//                break;
//        }
//        Comment comment = new Comment();
//        comment.setType(commentType);
//        if (DataUtils.isNotNullOrEmpty(atUid)) {
//            comment.setAtUid(atUid);
//        }
//        comment.setComment(content);
//        comment.setDid(targetId);
//        comment.setUid(commenterId);
//        try {
//            Long commentId = commentService.insert(comment);
//            log.info("add comment success==" + commentId);
//            model.addAttribute("code", 0);
//            model.addAttribute("data", commentId);
//
//            //评论成功后，给对应的人发消息
//            //要判断是否是评论自己
//            //是否是回复评论
//            //是否是回复的自己的评论
//            Article article = articleService.getObjectById(targetId);
//            log.info("get target entity success==" + article.getId() + "==type is==" + article.getType());
//            //评论
//            if (DataUtils.isNullOrEmpty(atUid)) {
//                //评论自己，不发消息
//                if (commenterId == article.getUid()) {
//                    log.info("the commenter is author, no need to send msg==");
//                    return "/common/success";
//                }
//                //评论他人，给作者发消息
//                else {
//                    Message message = new Message();
//                    Comment newComment = commentService.getObjectById(commenterId);
//                    message.setReceiveId(newComment.getUid());
//                    message.setUnread(Message.Status_Unread);
//                    message.setType(Message.DAILY_TYPE);
//                    message.setTemplate(templateType);
//                    Long newMsgId = messageService.insert(message);
//                    log.info("send message success==" + newMsgId);
//
//                    //更新用户未读消息数量和最新未读消息的类型
//                    User author = userService.getObjectById(newComment.getId());
//                    author.setIsLook(author.getIsLook() + 1);
//                    author.setLatestMsg(Message.DAILY_TYPE);
//                    userService.update(author);
//                }
//            }
//            //回复评论
//            else {
//                //回复自己，不发消息
//                if (commenterId == atUid) {
//                    log.info("reply oneself, no need to send msg==");
//                    return "/common/success";
//                }
//                //回复他人，给被回复人发消息
//                else {
//                    Message message = new Message();
//                    message.setReceiveId(atUid);
//                    message.setUnread(Message.Status_Unread);
//                    message.setType(Message.DAILY_TYPE);
//                    message.setTemplate(templateType);
//                    Long newMsgId = messageService.insert(message);
//                    log.info("send at message success==" + newMsgId);
//
//                    //更新用户未读消息数量和最新未读消息的类型
//                    User atUser = userService.getObjectById(atUid);
//                    atUser.setIsLook(atUser.getIsLook() + 1);
//                    atUser.setLatestMsg(Message.DAILY_TYPE);
//                    userService.update(atUser);
//                }
//            }
//        } catch (Exception e) {
//            e.printStackTrace();
//            model.addAttribute("code", -1);
//        }
//        return "/common/success";
//    }

//    /**
//     * 新增评论
//     *
//     * @param did：日报/晨报id  或小课堂id
//     * @param comment：评论内容
//     * @param atUid：@用户id
//     * @param type：0       代表日报、晨报  10代表小课堂
//     * @return
//     */
//    @RequestMapping(value = "/a/u/comment/{did}", method = RequestMethod.POST)
//    public String addComment(HttpServletRequest request,
//                             HttpServletResponse response, ModelMap model,
//                             @PathVariable Long did, String comment, Long atUid, Integer type)
//            throws Exception {
//
//        log.info("update daily : did is " + did + " comment is " + comment + "==atUid==" + atUid + "==type==" + type);
//
//        if (StringUtil.isEmpty(comment)) {
//            model.addAttribute("code", -17009);
//            log.info("param is null");
//            return "/common/success";
//        }
//        if (DataUtils.isNotNullOrEmpty(atUid)) {
//            User atUser = userService.getObjectById(atUid);
//            if (DataUtils.isNullOrEmpty(atUser)) {
//                model.addAttribute("code", -15001);
//                log.info("at user is null");
//                return "/common/success";
//            }
//        }
//
//        try {
//            User commenter = (User) request.getAttribute("user");
//            //区分是评论日报，还是评论小课堂
//            if (DataUtils.isNullOrEmpty(type)) {
//                type = Comment.TYPE_DAILY;
//            }
//            int template = 0;
//            int commentType = type;
//            //区分是评论还是回复评论
//            //评论
//            if (DataUtils.isNullOrEmpty(atUid)) {
//                //评论日报
//                if (type == Comment.TYPE_DAILY) {
//                    template = Message.TEMPLATE_112;
//                    //判断日报是否存在
//                    Article daily = articleService.getObjectById(did);
//                    if (DataUtils.isNullOrEmpty(daily)) {
//                        model.addAttribute("code", -5000);
//                        log.info("no this daily");
//                        return "/common/success";
//                    }
//                    Long commentId = addNewComment(commentType, comment, did, commenter.getId(), -1L);
//                    log.info("add comment success==" + commentId);
//                    model.addAttribute("code", 0);
//                    model.addAttribute("data", commentId);
//
//                    //评论成功后，评论数+1
//                    daily.setReply(daily.getReply() + 1);
//                    articleService.update(daily);
//
//                    //评论自己不用发消息
//                    if (commenter.getId() == daily.getUid()) {
//                        log.info("user comment oneself===" + commenter.getId());
//                    }
//                    //评论他人的日报，给作者发消息
//                    else {
//                        SimpleDateFormat timeType = new SimpleDateFormat("yyyy-MM-dd ");
//                        String time = timeType.format(new Date(daily.getDailyTime()));
//                        Long newMsgId = sendNewMessage(daily.getUid(), Message.DAILY_TYPE, template, time, daily.getUid());
//                        log.info("send message success==" + newMsgId);
//
//                        //更新用户未读消息数量和最新未读消息的类型
//                        User author = userService.getObjectById(daily.getUid());
//                        author.setIsLook(author.getIsLook() + 1);
//                        author.setLatestMsg(Message.DAILY_TYPE);
//                        userService.update(author);
//                    }
//
//                    model.addAttribute("code", 0);
//                    model.addAttribute("commentId", commentId);
//                }
//                //评论小课堂
//                if (type == Comment.TYPE_CLASS) {
//                    template = Message.SMALL_CLASS_TEMPLATE_257;
//                    ClassTimetable classTimetable = classTimetableService.getObjectById(did);
//                    if (DataUtils.isNullOrEmpty(classTimetable)) {
//                        log.info("small class don't exist");
//                        model.addAttribute("code", -29009);
//                        return "/common/success";
//                    }
//                    Long commentId = addNewComment(commentType, comment, did, commenter.getId(), -1L);
//                    log.info("add comment success==" + commentId);
//                    model.addAttribute("code", 0);
//                    model.addAttribute("data", commentId);
//
//                    //评论成功后，评论数+1
//                    classTimetable.setCommentCount(classTimetable.getCommentCount() + 1);
//                    classTimetableService.update(classTimetable);
//
//                    //评论自己不用发消息
//                    if (commenter.getId() == classTimetable.getTeachUid()) {
//                        log.info("user comment oneself===" + commenter.getId());
//                    }
//                    //评论他人的小课堂，给主讲人发消息
//                    else {
//                        SimpleDateFormat timeType = new SimpleDateFormat("yyyy-MM-dd ");
//                        String time = timeType.format(new Date(classTimetable.getArrangeDate()));
//                        Long newMsgId = sendNewMessage(classTimetable.getTeachUid(), Message.DAILY_TYPE, template, time, classTimetable.getTeachUid());
//                        log.info("send message success==" + newMsgId);
//
//                        //更新用户未读消息数量和最新未读消息的类型
//                        User author = userService.getObjectById(classTimetable.getTeachUid());
//                        author.setIsLook(author.getIsLook() + 1);
//                        author.setLatestMsg(Message.CLASSES_TYPE);
//                        userService.update(author);
//                    }
//
//                    model.addAttribute("code", 0);
//                    model.addAttribute("commentId", commentId);
//                }
//            }
//            //回复评论
//            else {
//                //回复日报评论
//                if (type == Comment.TYPE_DAILY) {
//                    commentType = Comment.TYPE_DAILY;
//
//                    template = Message.TEMPLATE_113;
//                    //新增评论
//                    Long commentId = addNewComment(commentType, comment, did, commenter.getId(), atUid);
//                    log.info("add reply comment success==" + commentId);
//                    //更新评论数
//                    Article daily = articleService.getObjectById(did);
//                    daily.setReply(daily.getReply() + 1);
//                    articleService.update(daily);
//                    //发消息
//                    if (commenter.getId() == daily.getUid()) {
//                        log.info("comment oneself's daily==");
//                    } else {
//                        SimpleDateFormat timeType = new SimpleDateFormat("yyyy-MM-dd ");
//                        String time = timeType.format(new Date(daily.getDailyTime()));
//                        Long newMsgId = sendNewMessage(atUid, Message.DAILY_TYPE, template, time, daily.getUid());
//                        log.info("send msg to other success==" + newMsgId);
//                    }
//                    //更新未读消息
//                    User author = userService.getObjectById(daily.getUid());
//                    author.setIsLook(author.getIsLook() + 1);
//                    author.setLatestMsg(Message.DAILY_TYPE);
//                }
//                //回复小课堂评论
//                if (type == Comment.TYPE_CLASS) {
//                    commentType = Comment.TYPE_CLASS;
//
//                    template = Message.SMALL_CLASS_TEMPLATE_257;
//                    //新增评论
//                    Long commentId = addNewComment(commentType, comment, did, commenter.getId(), atUid);
//                    log.info("add reply comment success==" + commentId);
//                    //更新评论数
//                    ClassTimetable classTimetable = classTimetableService.getObjectById(did);
//                    classTimetable.setCommentCount(classTimetable.getCommentCount() + 1);
//                    classTimetableService.update(classTimetable);
//                    //发消息
//                    if (commenter.getId() == classTimetable.getTeachUid()) {
//                        log.info("comment oneself's small class==");
//                    } else {
//                        SimpleDateFormat timeType = new SimpleDateFormat("yyyy-MM-dd ");
//                        String time = timeType.format(new Date(classTimetable.getArrangeDate()));
//                        Long newMsgId = sendNewMessage(atUid, Message.DAILY_TYPE, template, time, classTimetable.getTeachUid());
//                        log.info("send msg to other success==" + newMsgId);
//                    }
//                    //更新未读消息
//                    User author = userService.getObjectById(classTimetable.getTeachUid());
//                    author.setIsLook(author.getIsLook() + 1);
//                    author.setLatestMsg(Message.CLASSES_TYPE);
//                }
//            }
//        } catch (Throwable t) {
//            log.error(t.getMessage());
//            log.error("add comment error,did is " + did + " comment is " + comment);
//            model.addAttribute("code", -1);
//        }
//        return "/common-skill-service/comment/json/addComment";
//    }

//    private Long sendNewMessage(Long receiverUid, String messageType, int templateType, String time, Long authorUid)
//            throws ServiceException, ServiceDaoException, IOException {
//        Message message = new Message();
//        message.setReceiveId(receiverUid);
//        message.setUnread(Message.Status_Unread);
//        message.setType(messageType);
//        message.setTemplate(templateType);
//        Map<String, Object> map = new HashMap<>();
//        map.put(Message.KEY_TIME, time);
//        map.put(Message.KEY_AUTHOR_UID, authorUid);
//        ObjectMapper json = new ObjectMapper();
//        String content = json.writeValueAsString(map);
//        message.setContent(content);
//
//        Long newMsgId = messageService.insert(message);
//        log.info("send message success==" + newMsgId);
//        return newMsgId;
//    }
//
//    private Long addNewComment(int commentType, String comment, Long did, Long commenterId, Long atUid) throws ServiceException, ServiceDaoException {
//        Comment commentObj = new Comment();
//        commentObj.setType(commentType);
//        commentObj.setComment(comment);
//        commentObj.setDid(did);
//        commentObj.setUid(commenterId);
//        commentObj.setAtUid(atUid);
//        Long commentId = commentService.insert(commentObj);
//        return commentId;
//    }

    /**
     * 修改评论
     *
     * @param commentId：评论id
     * @param comment：评论内容
     * @return
     */
    @RequestMapping(value = "/a/u/comment/{commentId}", method = RequestMethod.PUT)
    public String updateComment(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model,
                                @PathVariable Long commentId, String comment) throws Exception {

        log.info("update comment : commentId is " + commentId + " comment is " + comment);

        if (StringUtil.isEmpty(comment)) {
            model.addAttribute("code", -1000);
            log.info("param is null");
            return "/common/success";
        }
        try {
            Comment comment1 = commentService.getObjectById(commentId);
            if (comment1 == null) {
                model.addAttribute("code", -5002);
                log.info("no this comment");
                return "/common/success";
            }
            User user = (User) request.getAttribute("user");
            Long uid = user.getId();
            if (!(uid.equals(comment1.getUid()))) {
                model.addAttribute("code", -5003);
                log.info("this is not your comment");
                return "/common/success";
            }
            comment1.setComment(comment);
            commentService.update(comment1);
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("update comment error,commentId is " + commentId
                    + " comment is " + comment);
            model.addAttribute("code", -100000);
        }
        return "/common/success";
    }


    /**
     * 删除评论
     *
     * @param commentId：评论id
     */
    @RequestMapping(value = "/a/u/comment/{commentId}", method = RequestMethod.DELETE)
    public String deleteComment(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                @PathVariable Long commentId) throws Exception {

        log.info("delete comment : commentId is " + commentId);

        try {
            Comment comment1 = commentService.getObjectById(commentId);
            if (comment1 == null) {
                model.addAttribute("code", -5002);
                log.info("no this comment");
                return "/common/success";
            }
            User user = (User) request.getAttribute("user");
            Long uid = user.getId();
            Long did = comment1.getDid();
            Long commentUser = comment1.getUid();
            int type = comment1.getType();
            //日报相关数据更新
            if (type == Comment.TYPE_DAILY) {
                Article daily = articleService.getObjectById(did);
                Long dailyUser = daily.getUid();
                if (!(uid.equals(commentUser) || uid.equals(dailyUser))) {
                    model.addAttribute("code", -5004);
                    log.info("you have no authority to delete the comment");
                    return "/common/success";
                }
                commentService.delete(commentId);
                log.info("deleteComment: [before:" + daily.getReply() + ",now:"
                        + (daily.getReply() - 1) + "]");
                daily.setReply(daily.getReply() - 1);
                articleService.update(daily);
            }
            //小课堂相关数据更新
            else if (type == Comment.TYPE_CLASS) {
                ClassTimetable classTimetable = classTimetableService.getObjectById(did);
                Long speakerId = classTimetable.getTeachUid();
                if (!(uid.equals(commentUser) || uid.equals(speakerId))) {
                    model.addAttribute("code", -5004);
                    log.info("you have no authority to delete the comment");
                    return "/common/success";
                }
                commentService.delete(commentId);
                log.info("deleteComment: [before:" + classTimetable.getReply() + ",now:"
                        + (classTimetable.getReply() - 1) + "]");
                classTimetable.setCommentCount((int) (classTimetable.getReply() - 1));
                classTimetableService.update(classTimetable);
            } else {
                model.addAttribute("code", -60008);
                log.info("type error");
                return "/common/success";
            }
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("delete comment error,commentId is " + commentId);
            model.addAttribute("code", -100000);
        }
        model.addAttribute("code", 0);
        return "/common/success";
    }


    /**
     * 查找评论
     *
     * @param did：目标id（日报/晨报id或小课堂id
     * @param type：目标类型不传时，默认为搜索日报或晨报，DynamicUtil里做了处理
     * @param startAt：
     * @param endAt
     * @param page
     * @param size
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/comment/search/query", method = RequestMethod.GET)
    public String search(HttpServletRequest request,
                         HttpServletResponse response, ModelMap model, Long did, Integer type, Long startAt, Long endAt, Integer page,
                         Integer size) throws Exception {

        log.info("============================================");
        log.info("get comment info of daily:  did==" + did + " type: " + type + " startAt: " + startAt
                + " endAt: " + endAt + " page: " + page + " size: " + size);

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        int end = start + size + 1;
        Set<Long> uids = new HashSet();

        Integer total = 0;
        boolean next = false;
        try {
            List<Comment> comments = new ArrayList();
            Map<String, Object> param = DynamicUtil.getCommentListParam(did, type, startAt, endAt, false);
            List<Long> commentIDS = this.commentService.getIdsByDynamicCondition(Comment.class, param, start, end);

            Map<String, Object> countParam = DynamicUtil.getCommentListParam(did, type, startAt, endAt, true);
            List<Long> totals = this.commentService.getIdsByDynamicCondition(Comment.class, countParam, 0, Integer.MAX_VALUE);
            total = totals.get(0).intValue();
            log.info(" did: " + did + " get comment is " + commentIDS);
            if (CollectionUtils.isEmpty(commentIDS)) {
                log.info("comment is null===");
            } else {
                comments = this.commentService.getObjectsByIds(commentIDS);
                if (comments.size() > size) {
                    comments = comments.subList(0, size);
                    next = true;
                } else {
                    log.info("there is no next==");
                }
                for (Comment comment : comments) {
                    uids.add(comment.getUid());
                }
                log.info(" did: " + did + " get uids is " + uids);
            }

            List<User> users = new ArrayList();
            if (CollectionUtils.isEmpty(uids)) {
                log.info("uids is null");
            } else {
                users = this.userService.getObjectsByIds(new ArrayList(uids));
                DynamicUtil.checkUserGraduateStatus(users);
                log.info(" get user is " + uids);
            }

            model.addAttribute("code", 0);
            model.addAttribute("comments", comments);
            model.addAttribute("users", users);

            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("next", next);
            model.addAttribute("total", total);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t);
            log.error(t.getMessage());
            log.error("get comment error,did is " + did);
            model.addAttribute("code", -100000);
        }

        return "/common-skill-service/comment/json/commentListJson";
    }
}
