package com.ptteng.common.skill.controller;

import com.ptteng.common.skill.model.DeepThink;
import com.ptteng.common.skill.model.Occupation;
import com.ptteng.common.skill.model.Task;
import com.ptteng.common.skill.service.ClassTeamService;
import com.ptteng.common.skill.service.DeepThinkService;
import com.ptteng.common.skill.service.OccupationService;
import com.ptteng.common.skill.service.TaskService;
import com.ptteng.common.skill.util.DynamicUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * DeepThink  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class DeepThinkController {
    private static final Log log = LogFactory.getLog(DeepThinkController.class);

    @Autowired
    private DeepThinkService deepThinkService;

    @Autowired
    private ClassTeamService classTeamService;

    @Autowired
    private OccupationService occupationService;

    @Autowired
    private TaskService taskService;


    /**
     * 获取深度思考列表
     *
     * @Author ruanshaonan
     * @Description
     * @Date 0:23 2018/6/28
     * @Param oid：职业id
     * @Param tid：任务id
     * @Param subjectName：课题名称
     * @Param createrName：创建人姓名
     * @Param speakerId：主讲人id
     * @Param page
     * @Param size
     */
    @RequestMapping(value = "/a/think/list", method = RequestMethod.GET)
    public String getThinkList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                               Long oid, Long tid, String thinkName, String creatorName, Long speakerId,
                               Integer page, Integer size) throws Exception {

        log.info("getThinkList=oid=" + oid + "=tid=" + tid + "=subjectName=" + thinkName
                + "=creatorName=" + creatorName + "=speakerId=" + speakerId + "=page=" + page + "=size=" + size);

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        Object total = 0;

        //TODO 按主讲人姓名搜索，还要再自测、优化
        try {
            Map<String, Object> creatorSql = DynamicUtil.getGroupCreatorId();
            List<Long> creatorIds = classTeamService.getIdsByDynamicCondition(DeepThink.class, creatorSql,
                    0, Integer.MAX_VALUE);
            log.info("creatorIds=" + creatorIds.size());
            Map<String, Object> thinkMap = DynamicUtil.getDeepThinkParam(oid, tid, thinkName, speakerId, creatorName,
                    creatorIds, false);
            log.info("thinkMap=" + thinkMap);
            List<Long> ids = deepThinkService.getIdsByDynamicCondition(DeepThink.class, thinkMap, start, size);
            log.info("ids=" + ids.size());
            if (CollectionUtils.isEmpty(ids)) {
                model.addAttribute("code", -60001);
                return "/common/success";
            }
            List<DeepThink> deepThinkList = deepThinkService.getObjectsByIds(ids);
            if (CollectionUtils.isNotEmpty(deepThinkList)) {
                List<Long> oids = new ArrayList<>();
                List<Long> tids = new ArrayList<>();
                for (DeepThink deepThink : deepThinkList) {
                    oids.add(deepThink.getOid());
                    tids.add(deepThink.getTid());
                }
                List<Occupation> occupationList = occupationService.getObjectsByIds(oids);
                model.addAttribute("occupationList", occupationList);

                List<Task> taskList = taskService.getObjectsByIds(tids);
                model.addAttribute("taskList", taskList);
            }

            Map<String, Object> totalMap = DynamicUtil.getDeepThinkParam(oid, tid, thinkName, speakerId, creatorName,
                    creatorIds, true);
            total = deepThinkService.getObjectByDynamicCondition(DeepThink.class, totalMap, 0, Integer.MAX_VALUE);
            log.info("total==" + total);
            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
            model.addAttribute("deepThinkList", deepThinkList);
            return "/common-skill-service/deepThink/json/deepThinkListJson";

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage(), t);
            model.addAttribute("code", -10000);
            return "common/success";
        }
    }

}

