package com.ptteng.common.skill.controller;

import com.ptteng.common.skill.model.ClassTimetable;
import com.ptteng.common.skill.model.StageReplay;
import com.ptteng.common.skill.model.Symptom;
import com.ptteng.common.skill.model.UserSymptomRelation;
import com.ptteng.common.skill.service.SymptomService;
import com.ptteng.common.skill.service.UserSymptomRelationService;
import com.ptteng.common.skill.util.SymptomUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * Symptom  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class SymptomController {
	private static final Log log = LogFactory.getLog(SymptomController.class);

	@Autowired
	private SymptomService symptomService;

	@Autowired
	private UserSymptomRelationService userSymptonRelationServie;






	
	    		
			
    /**
	 * 
	 * @param 
	 * @return
	 * @throws Exception
	 */
	
		@RequestMapping(value = "/a/symptom/search/query", method = RequestMethod.GET)
	public String getSymptomIdsByTidJsonList(HttpServletRequest request,
                                             HttpServletResponse response, ModelMap model, Integer page,
                                             Integer size, Long uid) throws Exception {


		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
			int total = 0;
		log.info("pageList : page= " + start + " , size=" + size);

		try {

			Map<String, Object> paramList = SymptomUtil.getDynamicParam(uid,null,null,null,null,null,
					null,null,null,null,false);
			log.info("classTimetableListParam=" + paramList);
			List<Long> symptomIDS = symptomService.getIdsByDynamicCondition(ClassTimetable.class, paramList, 0, Integer.MAX_VALUE);
			log.info("symptomIDS= " + symptomIDS.size());

			//获取total
			Map<String,Object> paramCount = SymptomUtil.getDynamicParam(uid,null,null,null,null,null,
					null,null,null,null,true);
			List<Long> totalIds = symptomService.getIdsByDynamicCondition(ClassTimetable.class, paramCount, 0, Integer.MAX_VALUE);
			log.info(" symptom totalIds=" + totalIds.size());
			total = totalIds.size();

			List<Symptom> symptomList = symptomService.getObjectsByIds(symptomIDS);
			log.info("get symptom data is " + symptomList.size());



			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			
			model.addAttribute("total", total);

			model.addAttribute("symptomList", symptomList);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get symptom list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/symptom/json/symptomListJson";
	}

	
	
		



	
	
	
}

