package com.ptteng.common.skill.controller;

import com.gemantic.common.util.MyListUtil;
import com.gemantic.common.util.StringUtil;
import com.ptteng.common.skill.model.*;
import com.ptteng.common.skill.service.*;
import com.ptteng.common.skill.util.DynamicUtil;
import com.ptteng.common.skill.util.GetUserFromCookieUtil;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.dom4j.Branch;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 前台小课堂相关接口
 *
 * @Author ruanshaonan
 * @Description
 * @Date 9:53 2018/6/28
 */
@Controller
public class ClassTimetableController {
    private static final Log log = LogFactory.getLog(ClassTimetableController.class);

    @Autowired
    private ClassTimetableService classTimetableService;

    @Autowired
    private UserService userService;

    @Autowired
    private DeepThinkService deepThinkService;

    @Autowired
    private ClassTeamService classTeamService;

    @Autowired
    private GetUserFromCookieUtil getUserFromCookieUtil;

    @Autowired
    private UserArticleRelationService userArticleRelationService;

    @Autowired
    private UserScoreService userScoreService;

    @Autowired
    private BranchInstituteService branchInstituteService;

    @Autowired
    private MessageService messageService;

    @Autowired
    private OccupationService occupationService;

    @Autowired
    private CommentService commentService;

    @Autowired
    private TaskService taskService;

    /**
     * 获取课堂列表（不需要用户登录的）
     * 小课堂入口
     *
     * @Author ruanshaonan
     * @Description
     * @Date 9:55 2018/6/28
     * @Param orderBy：缺省按用户点赞/收藏/时间排序 排序规则：1点赞数 2收藏数 3时间 4评论数 5查看数
     * @Param sort:排序类型 缺省按用户点赞/收藏/时间逆序排 0-逆序 1-正序
     * @Param speakStatus:小课堂状态 1：预告 2：未审核 3：未评级 4：已评级
     * @Param uid:用户id 如果是查找师弟课堂，则要把师弟的用户id，用逗号隔开，组成一个字符串传到后端
     * @Param status:是否上下架 0：未上架 1：上架
     * @Param oid:职业id
     * @Param tid:任务id
     * @Param level:小课堂等级
     * @Param thinkName:深度思考名称
     * @Param speakerId:主讲人id
     * @Param groupId:小组id
     * @Param page
     * @Param size
     */
    @RequestMapping(value = "/lesson", method = RequestMethod.GET)
    public String ketangIndex(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                              Integer orderBy, Integer sort, Integer speakStatus, String uid,
                              Integer status, Integer oid, Integer tid, Integer level, String thinkName,
                              Integer speakerId, Integer groupId, Long startTime, Long endTime, Integer page, Integer size)
            throws Exception {


        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 4;//默认前台展示4条
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        Long userId = getUserFromCookieUtil.getUserFromCookie(request);
        log.info("userId is " + userId);

        try {
            //预告
            speakStatus = ClassTimetable.APPOINT_PUBLISHED;
            //返回近期预告小课堂列表
            //需要把7天以外的排课过滤掉
            //当前日期0点的时间戳
            long currentTimeZero = System.currentTimeMillis() / (1000 * 3600 * 24) * (1000 * 3600 * 24) - TimeZone.getDefault().getRawOffset();
            //当前日期0点的时间戳+7天
            long currentTimeZeroAdd7Day = currentTimeZero + 24 * 60 * 60 * 1000 * 7 - 1;
            //只搜索7天以内的课堂
            endTime = currentTimeZeroAdd7Day;

            Map<String, Object> classTimetableListParam1 = DynamicUtil.getClassIndexParam(orderBy, sort, speakStatus,
                    uid, status, oid, tid, level, thinkName, speakerId, groupId, startTime, endTime, false);
            log.info("classTimetableListParam=" + classTimetableListParam1);
            List<Long> ids1 = classTimetableService.getIdsByDynamicCondition(ClassTimetable.class,
                    classTimetableListParam1, start, size);
            log.info("ids1=" + ids1.size());
            List<ClassTimetable> preClassArrangeList = classTimetableService.getObjectsByIds(ids1);
            log.info("getpreClassArrangeList success=" + preClassArrangeList.size());

            //返回主讲人姓名
            List<Long> speakerIds1 = new ArrayList<>();
            //返回课题名称
            List<Long> thinkIds1 = new ArrayList<>();

            for (ClassTimetable classTimetable1 : preClassArrangeList) {
                speakerIds1.add(classTimetable1.getTeachUid());
                thinkIds1.add(classTimetable1.getThinkId());
            }
            List<User> preSpeakers = userService.getObjectsByIds(speakerIds1);

            //分院id
            Map<Long, Integer> uid_branchId = MyListUtil.convert2Map(User.class.getDeclaredField("id"), User.class.getDeclaredField("branch"), preSpeakers);
            //剔除重复和null
            Set<Long> branchIds = new HashSet<>();
            for (Integer branchId : uid_branchId.values()) {
                if (DataUtils.isNullOrEmpty(branchId)) {
                    log.info("branchId is null");
                } else {
                    Long id = Long.valueOf(branchId);
                    log.info("id is :" + id);
                    branchIds.add(id);
                }
            }
            //转为list
            List<Long> asListBranchIds = new ArrayList<>(branchIds);
            List branchIdsList = branchInstituteService.getObjectsByIds(asListBranchIds);
            Map<Long, BranchInstitute> id_branch = MyListUtil.convert2Map(BranchInstitute.class.getDeclaredField("id"), branchIdsList);


            //遍历preSpeakers添加分院名和职业名
            for (User user : preSpeakers) {
                //获得分院相关
                BranchInstitute branchModel = id_branch.get(Long.valueOf(uid_branchId.get(user.getId())));
                String branchName = branchModel.getName();
                user.setBranchName(branchName);
            }

            List<DeepThink> preDeepThinkList = deepThinkService.getObjectsByIds(thinkIds1);
            log.info("get preDeepThinkList1 success=" + preDeepThinkList.size());


            //oid
            Map<Long, Long> did_oid = MyListUtil.convert2Map(DeepThink.class.getDeclaredField("id"), DeepThink.class.getDeclaredField("oid"), preDeepThinkList);
            //剔除重复和null
            Set<Long> oids = new HashSet<>();
            for (Long oidItem : did_oid.values()) {
                if (DataUtils.isNullOrEmpty(oidItem)) {
                    log.info("oid is null");
                } else {
                    Long id = oidItem;
                    log.info("id is :" + id);
                    oids.add(id);
                }
            }
            //转为list
            List<Long> asListoids = new ArrayList<>(oids);
            List oidsList = occupationService.getObjectsByIds(asListoids);
            Map<Long, Occupation> id_occupation = MyListUtil.convert2Map(Occupation.class.getDeclaredField("id"), oidsList);

            for (DeepThink deepThink : preDeepThinkList) {
                Occupation occupationModel = id_occupation.get(did_oid.get(deepThink.getId()));
                String oidName = occupationModel.getName();
                deepThink.setOidName(oidName);
            }

            //拼接list
            //防止空指针
            NewClassTimeTable newClassTimeTable = null;
            List<NewClassTimeTable> preClassTimeTable = new ArrayList<>();
            if (preClassArrangeList != null && preClassArrangeList.size() >= 1) {
                for (int j = 0; j < preClassArrangeList.size(); j++) {
                    newClassTimeTable = new NewClassTimeTable(preClassArrangeList.get(j), preSpeakers.get(j), preDeepThinkList.get(j));
                    preClassTimeTable.add(newClassTimeTable);
                }
            }

            //精选(展示后台点击上架精选)
            status = ClassTimetable.ON_SHELF;
            speakStatus = null;
            endTime = null;

            Map<String, Object> classTimetableListParam = DynamicUtil.getClassIndexParam(orderBy, sort, speakStatus,
                    uid, status, oid, tid, level, thinkName, speakerId, groupId, startTime, endTime, false);
            log.info("classTimetableListParam=" + classTimetableListParam);
            List<Long> ids = classTimetableService.getIdsByDynamicCondition(ClassTimetable.class,
                    classTimetableListParam, start, size);
            List<ClassTimetable> classArrangeList = classTimetableService.getObjectsByIds(ids);
            log.info("classArrangeList success=" + classArrangeList.size());

            //返回主讲人姓名
            List<Long> speakerIds = new ArrayList<>();
            //返回课题名称
            List<Long> thinkIds = new ArrayList<>();

            for (ClassTimetable classTimetable1 : classArrangeList) {
                speakerIds.add(classTimetable1.getTeachUid());
                thinkIds.add(classTimetable1.getThinkId());
            }
            List<User> speakers = userService.getObjectsByIds(speakerIds);
            log.info("get speakers success=" + speakers.size());


            //分院id
            Map<Long, Integer> uid_branchId1 = MyListUtil.convert2Map(User.class.getDeclaredField("id"), User.class.getDeclaredField("branch"), speakers);
            //剔除重复和null
            Set<Long> branchIds1 = new HashSet<>();
            for (Integer branchId : uid_branchId1.values()) {
                if (DataUtils.isNullOrEmpty(branchId)) {
                    log.info("branchId is null");
                } else {
                    Long id = Long.valueOf(branchId);
                    branchIds1.add(id);
                }
            }
            //转为list
            List<Long> asListBranchIds1 = new ArrayList<>(branchIds1);
            List branchIdsList1 = branchInstituteService.getObjectsByIds(asListBranchIds1);
            Map<Long, BranchInstitute> id_branch1 = MyListUtil.convert2Map(BranchInstitute.class.getDeclaredField("id"), branchIdsList1);


            //遍历preSpeakers添加分院名和职业名
            for (User user : speakers) {
                //获得分院相关
                BranchInstitute branchModel = id_branch1.get(Long.valueOf(uid_branchId1.get(user.getId())));
                String branchName = branchModel.getName();
                user.setBranchName(branchName);
            }

            List<DeepThink> deepThinkList = deepThinkService.getObjectsByIds(thinkIds);

            Map<Long, Long> did_oid1 = MyListUtil.convert2Map(DeepThink.class.getDeclaredField("id"), DeepThink.class.getDeclaredField("oid"), deepThinkList);
            //剔除重复和null
            Set<Long> oids1 = new HashSet<>();
            for (Long oidItem : did_oid1.values()) {
                if (DataUtils.isNullOrEmpty(oidItem)) {
                    log.info("oid is null");
                } else {
                    Long id = oidItem;
                    log.info("id is :" + id);
                    oids1.add(id);
                }
            }
            //转为list
            List<Long> asListoids1 = new ArrayList<>(oids1);
            List oidsList1 = occupationService.getObjectsByIds(asListoids1);
            Map<Long, Occupation> id_occupation1 = MyListUtil.convert2Map(Occupation.class.getDeclaredField("id"), oidsList1);

            for (DeepThink deepThink : deepThinkList) {
                Occupation occupationModel = id_occupation1.get(did_oid1.get(deepThink.getId()));
                String oidName = occupationModel.getName();
                deepThink.setOidName(oidName);
            }

            //拼接list
            //防止空指针
            NewClassTimeTable newClassTimeTable1 = null;
            List<NewClassTimeTable> newClassTimeTableList = new ArrayList<>();
            if (classArrangeList != null && classArrangeList.size() >= 1) {
                for (int j = 0; j < classArrangeList.size(); j++) {
                    newClassTimeTable1 = new NewClassTimeTable(classArrangeList.get(j), speakers.get(j), deepThinkList.get(j));
                    newClassTimeTableList.add(newClassTimeTable1);
                }
            }
            Long loginUserId = getUserFromCookieUtil.getUserFromCookie(request);
            model.addAttribute("code", 0);
            model.addAttribute("ClassTimeTableList", newClassTimeTableList);//精选课题名列表l
            model.addAttribute("preClassTimeTable", preClassTimeTable);//预告课题名列表
            model.addAttribute("loginUid", loginUserId);


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage(), t);
            log.error("get classTimetableCount statistics error");
            model.addAttribute("code", -1);
            return "/web-xiaoketang/index";
        }
        //获得小课堂总数
        try {
            Map<String, Object> sqlMap = DynamicUtil.countClassTimetable();
            Object classCount = classTimetableService.getObjectByDynamicCondition(ClassTimetable.class, sqlMap, 0, Integer.MAX_VALUE);
            log.info("classTimetableCount===" + classCount);
            model.addAttribute("classTotal", classCount);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage(), t);
            log.error("get classTimetableCount statistics error");
            model.addAttribute("code", -1);
        }
        return "/web-xiaoketang/index";
    }


    /**
     * 我的课堂——获取课堂列表（需要用户登录的）
     *
     * @Author ruanshaonan
     * @Description
     * @Date 9:55 2018/6/28
     * @Param orderBy：缺省按用户点赞/收藏/时间排序 排序规则：1点赞数 2收藏数 3时间 4评论数 5查看数
     * @Param sort:排序类型 缺省按用户点赞/收藏/时间逆序排 0-正序 1-逆序
     * @Param speakStatus:小课堂状态 1：预告 2：未审核 3：未评级未审核 4.未评级已审核 5：已评级
     * @Param uid:用户id 如果是查找师弟课堂，则要把师弟的用户id，用逗号隔开，组成一个字符串传到后端
     * @Param status:是否上下架 0：未上架 1：上架
     * @Param oid:职业id
     * @Param tid:任务id
     * @Param level:小课堂等级
     * @Param thinkName:深度思考名称
     * @Param speakerId:主讲人id
     * @Param groupId:小组id
     * @Param
     * @Param type:     0：我的课堂  1：师弟课堂   2：我的收藏   3.他人课堂  4他的收藏
     * @Param page
     * * @Param size
     */
    @RequestMapping(value = "l/class/arrange/list/{type}", method = RequestMethod.GET)
    public String getclassTimetableList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                        Integer orderBy, Integer sort, Integer speakStatus, Long uid,
                                        Integer status, Long oid, Integer tid, Integer level, String thinkName,
                                        Integer speakerId, Integer groupId, @PathVariable("type") Integer type,
                                        Long startTime, Long endTime, Integer page, Integer size)
            throws Exception {

        log.info("get classTimetable List=orderBy=" + orderBy + "=sort=" + sort + "=speakStatus=" + speakStatus
                + "=uid=" + uid + "=type=" + type + "=status=" + status + "=oid=" + oid + "=tid=" + tid
                + "=level=" + level + "=thinkName=" + thinkName + "=speakerId=" + speakerId
                + "==groupId==" + groupId + "==startTime==" + startTime + "==endTime==" + endTime
                + "==page==" + page + "==size==" + size);

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        try {
            Long loginUserId = getUserFromCookieUtil.getUserFromCookie(request);
//        Long loginUserId = Long.valueOf(27451);
            //他人相关小课堂
            if (type == ClassTimetable.OTHER_CLASS || type == ClassTimetable.OTHER_COLLECT) {
                Object total;
                List<Long> ids;
                if (type == ClassTimetable.OTHER_CLASS) {
                    List<Long> studentUids = null;//师弟课堂需要
                    Map<String, Object> classTimetableListParam = DynamicUtil.getClassTimetableParam5(studentUids, orderBy, sort, speakStatus,
                            status, oid, tid, level, thinkName, uid, groupId, startTime, endTime, false);
                    log.info("classTimetableListParam=" + classTimetableListParam);
                    ids = classTimetableService.getIdsByDynamicCondition(ClassTimetable.class,
                            classTimetableListParam, start, size);
                    log.info("ids=" + ids.size());
                    Map<String, Object> totalParam = DynamicUtil.getClassTimetableParam5(studentUids, orderBy, sort, speakStatus,
                            status, oid, tid, level, thinkName, uid, groupId, startTime, endTime, true);
                    total = classTimetableService.getObjectByDynamicCondition(ClassTimetable.class, totalParam,
                            0, Integer.MAX_VALUE);

                    log.info("ids is ===" + ids);
                    List<ClassTimetable> classArrangeList = classTimetableService.getObjectsByIds(ids);
                    log.info("getClassTimetableList success=" + classArrangeList.size());

                    //返回课题名称
                    List<Long> thinkIds = new ArrayList<>();
                    for (ClassTimetable classTimetable : classArrangeList) {
                        thinkIds.add(classTimetable.getThinkId());
                    }
                    log.info("thinkIds==" + thinkIds.size());
                    List<DeepThink> deepThinkList = deepThinkService.getObjectsByIds(thinkIds);
                    log.info("get deep think success=" + deepThinkList.size());

                    log.info(" login user Id = " + loginUserId);
                    if (DataUtils.isNotNullOrEmpty(loginUserId)) {
                        //拼接list
                        //防止空指针
                        NewClassTimeTable newClassTimeTable1 = null;
                        List<NewClassTimeTable> newClassTimeTableList = new ArrayList<>();

                        if (classArrangeList != null && classArrangeList.size() >= 1) {

                            Map<Long, Long> classId_uid = MyListUtil.convert2Map(ClassTimetable.class.getDeclaredField("id"), ClassTimetable.class.getDeclaredField("teachUid"), classArrangeList);
                            Set<Long> uids = new HashSet<>();
                            for (Long uidItem : classId_uid.values()) {
                                if (DataUtils.isNullOrEmpty(uidItem)) {
                                    log.info("oid is null");
                                } else {
                                    Long id = uidItem;
                                    uids.add(id);
                                }
                            }
                            List<Long> asListuids = new ArrayList<>(uids);
                            List uidsList = userService.getObjectsByIds(asListuids);
                            Map<Long, User> id_user = MyListUtil.convert2Map(User.class.getDeclaredField("id"), uidsList);

                            List<Long> userLoveRelationIds = userArticleRelationService.getUserArticleRelationIdsByUidAndTypeAndWhether(loginUserId, UserArticleRelation.STATUS_LOVE, UserArticleRelation.WHETHER_VALID, 0, Integer.MAX_VALUE);
                            List<UserArticleRelation> userLoveRelationList = userArticleRelationService.getObjectsByIds(userLoveRelationIds);
                            Map<Long, Long> aid_relation = MyListUtil.convert2Map(UserArticleRelation.class.getDeclaredField("aid"), userLoveRelationList);

                            List<Long> userColRelationIds = userArticleRelationService.getUserArticleRelationIdsByUidAndTypeAndWhether(loginUserId, UserArticleRelation.STATUS_COLLECTION, UserArticleRelation.WHETHER_VALID, 0, Integer.MAX_VALUE);
                            List<UserArticleRelation> userColRelationList = userArticleRelationService.getObjectsByIds(userColRelationIds);
                            Map<Long, Long> aid_relationCol = MyListUtil.convert2Map(UserArticleRelation.class.getDeclaredField("aid"), userColRelationList);

                            for (int j = 0; j < classArrangeList.size(); j++) {
                                if (DataUtils.isNotNullOrEmpty(aid_relation.get(classArrangeList.get(j).getId()))) {
                                    classArrangeList.get(j).setIfLike(true);
                                }

                                if (DataUtils.isNotNullOrEmpty(aid_relationCol.get(classArrangeList.get(j).getId()))) {
                                    classArrangeList.get(j).setIfCollection(true);
                                }

                                classArrangeList.get(j).setSpeakerTitle(setUserShowName(classArrangeList.get(j).getTeachUid()));
                                User teachUser = id_user.get(classArrangeList.get(j).getTeachUid());
                                newClassTimeTable1 = new NewClassTimeTable(classArrangeList.get(j), teachUser, deepThinkList.get(j));
                                newClassTimeTableList.add(newClassTimeTable1);
                            }

                            Map<Long, Long> id_taskId = MyListUtil.convert2Map(NewClassTimeTable.class.getDeclaredField("id"), NewClassTimeTable.class.getDeclaredField("tid"), newClassTimeTableList);

                            Set<Long> taskIds = new HashSet<>();
                            for (Long taskId : id_taskId.values()) {
                                if (DataUtils.isNullOrEmpty(taskId)) {
                                    log.info("teamId is null");
                                } else {
                                    Long id = taskId;
                                    log.info("id is :" + id);
                                    taskIds.add(id);
                                }
                            }

                            List<Long> asListTaskIds = new ArrayList<>(taskIds);
                            List taskIdsList = taskService.getObjectsByIds(asListTaskIds);
                            Map<Long, Long> taskId_num = MyListUtil.convert2Map(Task.class.getDeclaredField("id"), Task.class.getDeclaredField("num"), taskIdsList);

                            for (NewClassTimeTable newClassTimeTable : newClassTimeTableList) {
                                Long taskNum = taskId_num.get(newClassTimeTable.getTid());
                                newClassTimeTable.setTidName(taskNum);
                            }

                        }

                        Integer totalPage = 1;
                        Integer li = new Integer(String.valueOf(total));
                        if (li > 0) {
                            totalPage = (li - 1) / size + 1;
                        }
                        model.addAttribute("newClassTimeTableList", newClassTimeTableList);
                        model.addAttribute("code", 0);
                        model.addAttribute("page", page);
                        model.addAttribute("pSize", size);
                        model.addAttribute("total", total);
                        model.addAttribute("size", newClassTimeTableList.size());
                        model.addAttribute("totalPage", totalPage);
                        model.addAttribute("loginUid", loginUserId);
                    } else {
                        //拼接list
                        //防止空指针
                        NewClassTimeTable newClassTimeTable1 = null;
                        List<NewClassTimeTable> newClassTimeTableList = new ArrayList<>();
                        if (classArrangeList != null && classArrangeList.size() >= 1) {

                            Map<Long, Long> classId_uid = MyListUtil.convert2Map(ClassTimetable.class.getDeclaredField("id"), ClassTimetable.class.getDeclaredField("teachUid"), classArrangeList);
                            Set<Long> uids = new HashSet<>();
                            for (Long uidItem : classId_uid.values()) {
                                if (DataUtils.isNullOrEmpty(uidItem)) {
                                    log.info("oid is null");
                                } else {
                                    Long id = uidItem;
                                    uids.add(id);
                                }
                            }
                            List<Long> asListuids = new ArrayList<>(uids);
                            List uidsList = userService.getObjectsByIds(asListuids);
                            Map<Long, User> id_user = MyListUtil.convert2Map(User.class.getDeclaredField("id"), uidsList);

                            for (int j = 0; j < classArrangeList.size(); j++) {
                                classArrangeList.get(j).setSpeakerTitle(setUserShowName(classArrangeList.get(j).getTeachUid()));
                                User teachUser = id_user.get(classArrangeList.get(j).getTeachUid());
                                newClassTimeTable1 = new NewClassTimeTable(classArrangeList.get(j), teachUser, deepThinkList.get(j));
                                newClassTimeTableList.add(newClassTimeTable1);
                            }


                            Map<Long, Long> id_taskId = MyListUtil.convert2Map(NewClassTimeTable.class.getDeclaredField("id"), NewClassTimeTable.class.getDeclaredField("tid"), newClassTimeTableList);

                            Set<Long> taskIds = new HashSet<>();
                            for (Long taskId : id_taskId.values()) {
                                if (DataUtils.isNullOrEmpty(taskId)) {
                                    log.info("teamId is null");
                                } else {
                                    Long id = taskId;
                                    log.info("id is :" + id);
                                    taskIds.add(id);
                                }
                            }

                            List<Long> asListTaskIds = new ArrayList<>(taskIds);
                            List taskIdsList = taskService.getObjectsByIds(asListTaskIds);
                            Map<Long, Long> taskId_num = MyListUtil.convert2Map(Task.class.getDeclaredField("id"), Task.class.getDeclaredField("num"), taskIdsList);

                            for (NewClassTimeTable newClassTimeTable : newClassTimeTableList) {
                                Long taskNum = taskId_num.get(newClassTimeTable.getTid());
                                newClassTimeTable.setTidName(taskNum);
                            }


                        }

                        Integer totalPage = 1;
                        Integer li = new Integer(String.valueOf(total));
                        if (li > 0) {
                            totalPage = (li - 1) / size + 1;
                        }
                        model.addAttribute("newClassTimeTableList", newClassTimeTableList);
                        model.addAttribute("code", 0);
                        model.addAttribute("page", page);
                        model.addAttribute("pSize", size);
                        model.addAttribute("total", total);
                        model.addAttribute("size", newClassTimeTableList.size());
                        model.addAttribute("totalPage", totalPage);
                        model.addAttribute("loginUid", loginUserId);
                    }
                } else {

                    if (DataUtils.isNullOrEmpty(orderBy)) {
                        orderBy = UserArticleRelation.COLLECTION;
                    }
                    if (DataUtils.isNullOrEmpty(sort)) {
                        sort = UserArticleRelation.DESC;
                    }
                    Map<String, Object> totalSqlMap = DynamicUtil.getUserLoveClassTimetableList(UserArticleRelation.STATUS_COLLECTION,
                            orderBy, sort, uid, true);
                    total = userArticleRelationService.getObjectByDynamicCondition(UserArticleRelation.class, totalSqlMap, 0, Integer.MAX_VALUE);
                    log.info("total==" + total);

                    Map<String, Object> pageSqlMap = DynamicUtil.getUserLoveClassTimetableList(UserArticleRelation.STATUS_COLLECTION,
                            orderBy, sort, uid, false);
                    List<Long> classTimetableIds = userArticleRelationService.getIdsByDynamicCondition(UserArticleRelation.class, pageSqlMap, start, size);
                    log.info("classTimetableIds==" + classTimetableIds.size());
                    List<ClassTimetable> classTimetables = classTimetableService.getObjectsByIds(classTimetableIds);
                    log.info("get class timetable success==" + classTimetables.size());

                    log.info("  user Id = " + uid);

                    List<Long> thinkIds = new ArrayList<>();
                    for (ClassTimetable classTimetable : classTimetables) {
                        thinkIds.add(classTimetable.getThinkId());
                    }
                    log.info("thinkIds==" + thinkIds.size());
                    List<DeepThink> deepThinkList = deepThinkService.getObjectsByIds(thinkIds);
                    log.info("get deep think success==" + deepThinkList.size());

                    if (DataUtils.isNotNullOrEmpty(loginUserId)) {
                        //拼接list
                        //防止空指针
                        NewClassTimeTable newClassTimeTable1 = null;
                        List<NewClassTimeTable> newClassTimeTableList = new ArrayList<>();
                        if (classTimetables != null && classTimetables.size() >= 1) {

                            Map<Long, Long> classId_uid = MyListUtil.convert2Map(ClassTimetable.class.getDeclaredField("id"), ClassTimetable.class.getDeclaredField("teachUid"), classTimetables);
                            Set<Long> uids = new HashSet<>();
                            for (Long uidItem : classId_uid.values()) {
                                if (DataUtils.isNullOrEmpty(uidItem)) {
                                    log.info("oid is null");
                                } else {
                                    Long id = uidItem;
                                    uids.add(id);
                                }
                            }
                            List<Long> asListuids = new ArrayList<>(uids);
                            List uidsList = userService.getObjectsByIds(asListuids);
                            Map<Long, User> id_user = MyListUtil.convert2Map(User.class.getDeclaredField("id"), uidsList);


                            List<Long> userLoveRelationIds = userArticleRelationService.getUserArticleRelationIdsByUidAndTypeAndWhether(loginUserId, UserArticleRelation.STATUS_LOVE, UserArticleRelation.WHETHER_VALID, 0, Integer.MAX_VALUE);
                            List<UserArticleRelation> userLoveRelationList = userArticleRelationService.getObjectsByIds(userLoveRelationIds);
                            Map<Long, Long> aid_relation = MyListUtil.convert2Map(UserArticleRelation.class.getDeclaredField("aid"), userLoveRelationList);

                            List<Long> userColRelationIds = userArticleRelationService.getUserArticleRelationIdsByUidAndTypeAndWhether(loginUserId, UserArticleRelation.STATUS_COLLECTION, UserArticleRelation.WHETHER_VALID, 0, Integer.MAX_VALUE);
                            List<UserArticleRelation> userColRelationList = userArticleRelationService.getObjectsByIds(userColRelationIds);
                            Map<Long, Long> aid_relationCol = MyListUtil.convert2Map(UserArticleRelation.class.getDeclaredField("aid"), userColRelationList);


                            for (int j = 0; j < classTimetables.size(); j++) {
                                User user = id_user.get(classTimetables.get(j).getTeachUid());
                                if (DataUtils.isNotNullOrEmpty(aid_relation.get(classTimetables.get(j).getId()))) {
                                    classTimetables.get(j).setIfLike(true);
                                }
                                if (DataUtils.isNotNullOrEmpty(aid_relationCol.get(classTimetables.get(j).getId()))) {
                                    classTimetables.get(j).setIfCollection(true);
                                }
                                newClassTimeTable1 = new NewClassTimeTable(classTimetables.get(j), user, deepThinkList.get(j));
                                newClassTimeTableList.add(newClassTimeTable1);
                            }

                            Map<Long, Long> id_taskId = MyListUtil.convert2Map(NewClassTimeTable.class.getDeclaredField("id"), NewClassTimeTable.class.getDeclaredField("tid"), newClassTimeTableList);

                            Set<Long> taskIds = new HashSet<>();
                            for (Long taskId : id_taskId.values()) {
                                if (DataUtils.isNullOrEmpty(taskId)) {
                                    log.info("teamId is null");
                                } else {
                                    Long id = taskId;
                                    log.info("id is :" + id);
                                    taskIds.add(id);
                                }
                            }

                            List<Long> asListTaskIds = new ArrayList<>(taskIds);
                            List taskIdsList = taskService.getObjectsByIds(asListTaskIds);
                            Map<Long, Long> taskId_num = MyListUtil.convert2Map(Task.class.getDeclaredField("id"), Task.class.getDeclaredField("num"), taskIdsList);

                            for (NewClassTimeTable newClassTimeTable : newClassTimeTableList) {
                                Long taskNum = taskId_num.get(newClassTimeTable.getTid());
                                newClassTimeTable.setTidName(taskNum);
                            }

                        }
                        Integer totalPage = 1;
                        Integer li = new Integer(String.valueOf(total));
                        if (li > 0) {
                            totalPage = (li - 1) / size + 1;
                        }

                        model.addAttribute("code", 0);
                        model.addAttribute("page", page);
                        model.addAttribute("pSize", size);
                        model.addAttribute("total", total);
                        model.addAttribute("totalPage", totalPage);
                        model.addAttribute("size", newClassTimeTableList.size());
                        model.addAttribute("newClassTimeTableList", newClassTimeTableList);
                        model.addAttribute("loginUid", loginUserId);
                    } else {
                        //拼接list
                        //防止空指针
                        NewClassTimeTable newClassTimeTable1 = null;
                        List<NewClassTimeTable> newClassTimeTableList = new ArrayList<>();
                        if (classTimetables != null && classTimetables.size() >= 1) {
                            for (int j = 0; j < classTimetables.size(); j++) {
                                User user = userService.getObjectById(classTimetables.get(j).getTeachUid());
                                newClassTimeTable1 = new NewClassTimeTable(classTimetables.get(j), user, deepThinkList.get(j));
                                newClassTimeTableList.add(newClassTimeTable1);
                            }

                            Map<Long, Long> id_taskId = MyListUtil.convert2Map(NewClassTimeTable.class.getDeclaredField("id"), NewClassTimeTable.class.getDeclaredField("tid"), newClassTimeTableList);

                            Set<Long> taskIds = new HashSet<>();
                            for (Long taskId : id_taskId.values()) {
                                if (DataUtils.isNullOrEmpty(taskId)) {
                                    log.info("teamId is null");
                                } else {
                                    Long id = taskId;
                                    log.info("id is :" + id);
                                    taskIds.add(id);
                                }
                            }

                            List<Long> asListTaskIds = new ArrayList<>(taskIds);
                            List taskIdsList = taskService.getObjectsByIds(asListTaskIds);
                            Map<Long, Long> taskId_num = MyListUtil.convert2Map(Task.class.getDeclaredField("id"), Task.class.getDeclaredField("num"), taskIdsList);

                            for (NewClassTimeTable newClassTimeTable : newClassTimeTableList) {
                                Long taskNum = taskId_num.get(newClassTimeTable.getTid());
                                newClassTimeTable.setTidName(taskNum);
                            }

                        }
                        Integer totalPage = 1;
                        Integer li = new Integer(String.valueOf(total));
                        if (li > 0) {
                            totalPage = (li - 1) / size + 1;
                        }

                        model.addAttribute("code", 0);
                        model.addAttribute("page", page);
                        model.addAttribute("pSize", size);
                        model.addAttribute("total", total);
                        model.addAttribute("totalPage", totalPage);
                        model.addAttribute("size", newClassTimeTableList.size());
                        model.addAttribute("newClassTimeTableList", newClassTimeTableList);
                        model.addAttribute("loginUid", loginUserId);
                    }


                }

            }
            //我的相关课堂
            else {
                //未登录返回-2，前端模态框提示用户重新登录
//            loginUserId = getUserFromCookieUtil.getUserFromCookie(request);
                //Long loginUserId = Long.valueOf(27444);
                log.info("userId is " + loginUserId);
                if (DataUtils.isNullOrEmpty(loginUserId)) {
                    log.info("user no login");
                    model.addAttribute("code", -2);
                    return "/web-xiaoketang/myClass/myClassList";
                }


                List<Long> studentUids = null;//师弟课堂需要

                switch (type) {
                    //0：我的课堂  1：师弟课堂   2：我的收藏
                    case ClassTimetable.MINE_CLASS:
                        uid = loginUserId;


                        break;
                    case ClassTimetable.STUDENT_CLASS:

                        uid = loginUserId;

                        String type1 = User.TYPE_OFFLINE;
                        /* 获取该师兄下师弟信息 */
                        Map<String, Object> paramList = DynamicUtil.getHisStudentRelationListParam(uid, type1, false);
                        log.info("get param:" + paramList);
                        studentUids = userService.getIdsByDynamicCondition(User.class, paramList, 0, Integer.MAX_VALUE);
                        log.info("get studentUids:" + studentUids);


                        break;
                    case ClassTimetable.MINE_COLLECT:
                        uid = loginUserId;

                        break;

                }
                try {

                    if (type == ClassTimetable.MINE_CLASS || type == ClassTimetable.STUDENT_CLASS) {
                        Object total;
                        List<Long> ids;
                        if (type == ClassTimetable.STUDENT_CLASS) {
                            if (studentUids != null && studentUids.size() >= 1) {
                                Map<String, Object> classTimetableListParam = DynamicUtil.getClassTimetableParam(studentUids, orderBy, sort, speakStatus,
                                        status, oid, tid, level, thinkName, uid, groupId, startTime, endTime, false);
                                log.info("classTimetableListParam=" + classTimetableListParam);
                                ids = classTimetableService.getIdsByDynamicCondition(ClassTimetable.class,
                                        classTimetableListParam, start, size);
                                log.info("ids=" + ids.size());
                                Map<String, Object> totalParam = DynamicUtil.getClassTimetableParam(studentUids, orderBy, sort, speakStatus,
                                        status, oid, tid, level, thinkName, uid, groupId, startTime, endTime, true);
                                total = classTimetableService.getObjectByDynamicCondition(ClassTimetable.class, totalParam,
                                        0, Integer.MAX_VALUE);
                            }
                            //没有师弟
                            else {
                                model.addAttribute("code", -1);
                                log.info("the user no students");
                                model.addAttribute("total", 0);
                                return "/web-xiaoketang/myClass/myClassList";
                            }

                        } else {
                            Map<String, Object> classTimetableListParam = DynamicUtil.getClassTimetableParam4(studentUids, orderBy, sort, speakStatus,
                                    status, oid, tid, level, thinkName, uid, groupId, startTime, endTime, false);
                            log.info("classTimetableListParam=" + classTimetableListParam);
                            ids = classTimetableService.getIdsByDynamicCondition(ClassTimetable.class,
                                    classTimetableListParam, start, size);
                            log.info("ids=" + ids.size());
                            Map<String, Object> totalParam = DynamicUtil.getClassTimetableParam4(studentUids, orderBy, sort, speakStatus,
                                    status, oid, tid, level, thinkName, uid, groupId, startTime, endTime, true);
                            total = classTimetableService.getObjectByDynamicCondition(ClassTimetable.class, totalParam,
                                    0, Integer.MAX_VALUE);
                            //我的课堂——判断是否显示“编辑小课堂按钮”（七天内要讲小课堂）
                            /* 获取当前时间点 */
                            boolean recentPlan;
                            Long currentTime = System.currentTimeMillis();
                            log.info(" currentTime =============" + currentTime);
                            Long deadLine = currentTime + 7 * 24 * 60 * 60 * 1000;
                            Map<String, Object> classButtonParam = DynamicUtil.findClassTimetableRecentParam(uid, currentTime, deadLine);
                            log.info("classButtonParam=" + classButtonParam);
                            List<Long> recentClass = classTimetableService.getIdsByDynamicCondition(ClassTimetable.class,
                                    classButtonParam, 0, Integer.MAX_VALUE);
                            log.info("recentClass is ====" + recentClass);

                            if (recentClass != null && recentClass.size() >= 1) {
                                List<Long> recentClassId = classTimetableService.getIdsByDynamicCondition(ClassTimetable.class,
                                        classButtonParam, 0, 1);
                                recentPlan = true;
                                model.addAttribute("recentClassId", recentClassId.get(0));
                                log.info(recentClassId.get(0));
                            } else {
                                recentPlan = false;
                                model.addAttribute("recentClassId", "");
                            }
                        }

                        log.info("ids is ===" + ids);
                        List<ClassTimetable> classArrangeList = classTimetableService.getObjectsByIds(ids);
                        log.info("getClassTimetableList success=" + classArrangeList.size());

                        //返回课题名称
                        List<Long> thinkIds = new ArrayList<>();
                        for (ClassTimetable classTimetable : classArrangeList) {
                            thinkIds.add(classTimetable.getThinkId());
                        }
                        log.info("thinkIds==" + thinkIds.size());
                        List<DeepThink> deepThinkList = deepThinkService.getObjectsByIds(thinkIds);
                        log.info("get deep think success=" + deepThinkList.size());

                        log.info(" login user Id = " + loginUserId);
                        if (DataUtils.isNotNullOrEmpty(loginUserId)) {
                            //拼接list
                            //防止空指针
                            NewClassTimeTable newClassTimeTable1 = null;
                            List<NewClassTimeTable> newClassTimeTableList = new ArrayList<>();
                            if (classArrangeList != null && classArrangeList.size() >= 1) {


                                List<Long> userLoveRelationIds = userArticleRelationService.getUserArticleRelationIdsByUidAndTypeAndWhether(loginUserId, UserArticleRelation.STATUS_LOVE, UserArticleRelation.WHETHER_VALID, 0, Integer.MAX_VALUE);
                                List<UserArticleRelation> userLoveRelationList = userArticleRelationService.getObjectsByIds(userLoveRelationIds);
                                Map<Long, Long> aid_relation = MyListUtil.convert2Map(UserArticleRelation.class.getDeclaredField("aid"), userLoveRelationList);

                                List<Long> userColRelationIds = userArticleRelationService.getUserArticleRelationIdsByUidAndTypeAndWhether(loginUserId, UserArticleRelation.STATUS_COLLECTION, UserArticleRelation.WHETHER_VALID, 0, Integer.MAX_VALUE);
                                List<UserArticleRelation> userColRelationList = userArticleRelationService.getObjectsByIds(userColRelationIds);
                                Map<Long, Long> aid_relationCol = MyListUtil.convert2Map(UserArticleRelation.class.getDeclaredField("aid"), userColRelationList);

                                Map<Long, Long> uid_teacherId = MyListUtil.convert2Map(ClassTimetable.class.getDeclaredField("id"), ClassTimetable.class.getDeclaredField("teachUid"), classArrangeList);
                                Set<Long> teachIds = new HashSet<>();
                                for (Long teachId : uid_teacherId.values()) {
                                    if (DataUtils.isNullOrEmpty(teachId)) {
                                        log.info("oid is null");
                                    } else {
                                        Long id = teachId;
                                        log.info("id is :" + id);
                                        teachIds.add(id);
                                    }
                                }
                                List<Long> asListteachIds = new ArrayList<>(teachIds);
                                List teachIdsList = userService.getObjectsByIds(asListteachIds);
                                Map<Long, User> id_user = MyListUtil.convert2Map(User.class.getDeclaredField("id"), teachIdsList);


                                for (int j = 0; j < classArrangeList.size(); j++) {

                                    if (DataUtils.isNotNullOrEmpty(aid_relation.get(classArrangeList.get(j).getId()))) {
                                        classArrangeList.get(j).setIfLike(true);
                                    }

                                    if (DataUtils.isNotNullOrEmpty(aid_relationCol.get(classArrangeList.get(j).getId()))) {
                                        classArrangeList.get(j).setIfCollection(true);
                                    }

                                    classArrangeList.get(j).setSpeakerTitle(setUserShowName(classArrangeList.get(j).getTeachUid()));
                                    User teachUser = id_user.get(classArrangeList.get(j).getTeachUid());
                                    newClassTimeTable1 = new NewClassTimeTable(classArrangeList.get(j), teachUser, deepThinkList.get(j));
                                    newClassTimeTableList.add(newClassTimeTable1);
                                }

                                Map<Long, Long> id_taskId = MyListUtil.convert2Map(NewClassTimeTable.class.getDeclaredField("id"), NewClassTimeTable.class.getDeclaredField("tid"), newClassTimeTableList);

                                Set<Long> taskIds = new HashSet<>();
                                for (Long taskId : id_taskId.values()) {
                                    if (DataUtils.isNullOrEmpty(taskId)) {
                                        log.info("teamId is null");
                                    } else {
                                        Long id = taskId;
                                        log.info("id is :" + id);
                                        taskIds.add(id);
                                    }
                                }

                                List<Long> asListTaskIds = new ArrayList<>(taskIds);
                                List taskIdsList = taskService.getObjectsByIds(asListTaskIds);
                                Map<Long, Long> taskId_num = MyListUtil.convert2Map(Task.class.getDeclaredField("id"), Task.class.getDeclaredField("num"), taskIdsList);

                                for (NewClassTimeTable newClassTimeTable : newClassTimeTableList) {
                                    Long taskNum = taskId_num.get(newClassTimeTable.getTid());
                                    newClassTimeTable.setTidName(taskNum);
                                }

                            }

                            Integer totalPage = 1;
                            Integer li = new Integer(String.valueOf(total));
                            if (li > 0) {
                                totalPage = (li - 1) / size + 1;
                            }
                            model.addAttribute("newClassTimeTableList", newClassTimeTableList);
                            model.addAttribute("code", 0);
                            model.addAttribute("page", page);
                            model.addAttribute("pSize", size);
                            model.addAttribute("total", total);
                            model.addAttribute("size", newClassTimeTableList.size());
                            model.addAttribute("totalPage", totalPage);
                            model.addAttribute("loginUid", loginUserId);
                        }
                    }
                    //我的收藏
                    else {
                        if (DataUtils.isNullOrEmpty(orderBy)) {
                            orderBy = UserArticleRelation.COLLECTION;
                        }
                        if (DataUtils.isNullOrEmpty(sort)) {
                            sort = UserArticleRelation.DESC;
                        }
                        Map<String, Object> totalSqlMap = DynamicUtil.getUserLoveClassTimetableList(UserArticleRelation.STATUS_COLLECTION,
                                orderBy, sort, uid, true);
                        Object total = userArticleRelationService.getObjectByDynamicCondition(UserArticleRelation.class, totalSqlMap, 0, Integer.MAX_VALUE);
                        log.info("total==" + total);

                        Map<String, Object> pageSqlMap = DynamicUtil.getUserLoveClassTimetableList(UserArticleRelation.STATUS_COLLECTION,
                                orderBy, sort, uid, false);
                        List<Long> classTimetableIds = userArticleRelationService.getIdsByDynamicCondition(UserArticleRelation.class, pageSqlMap, start, size);
                        log.info("classTimetableIds==" + classTimetableIds.size());
                        List<ClassTimetable> classTimetables = classTimetableService.getObjectsByIds(classTimetableIds);
                        log.info("get class timetable success==" + classTimetables.size());

                        log.info("  user Id = " + uid);

                        List<Long> thinkIds = new ArrayList<>();
                        for (ClassTimetable classTimetable : classTimetables) {
                            thinkIds.add(classTimetable.getThinkId());
                        }
                        log.info("thinkIds==" + thinkIds.size());
                        List<DeepThink> deepThinkList = deepThinkService.getObjectsByIds(thinkIds);
                        log.info("get deep think success==" + deepThinkList.size());

                        //拼接list
                        //防止空指针
                        NewClassTimeTable newClassTimeTable1 = null;
                        List<NewClassTimeTable> newClassTimeTableList = new ArrayList<>();
                        if (classTimetables != null && classTimetables.size() >= 1) {


                            List<Long> userLoveRelationIds = userArticleRelationService.getUserArticleRelationIdsByUidAndTypeAndWhether(loginUserId, UserArticleRelation.STATUS_LOVE, UserArticleRelation.WHETHER_VALID, 0, Integer.MAX_VALUE);
                            List<UserArticleRelation> userLoveRelationList = userArticleRelationService.getObjectsByIds(userLoveRelationIds);
                            Map<Long, Long> aid_relation = MyListUtil.convert2Map(UserArticleRelation.class.getDeclaredField("aid"), userLoveRelationList);

                            List<Long> userColRelationIds = userArticleRelationService.getUserArticleRelationIdsByUidAndTypeAndWhether(loginUserId, UserArticleRelation.STATUS_COLLECTION, UserArticleRelation.WHETHER_VALID, 0, Integer.MAX_VALUE);
                            List<UserArticleRelation> userColRelationList = userArticleRelationService.getObjectsByIds(userColRelationIds);
                            Map<Long, Long> aid_relationCol = MyListUtil.convert2Map(UserArticleRelation.class.getDeclaredField("aid"), userColRelationList);


                            Map<Long, Long> uid_teacherId = MyListUtil.convert2Map(ClassTimetable.class.getDeclaredField("id"), ClassTimetable.class.getDeclaredField("teachUid"), classTimetables);
                            Set<Long> teachIds = new HashSet<>();
                            for (Long teachId : uid_teacherId.values()) {
                                if (DataUtils.isNullOrEmpty(teachId)) {
                                } else {
                                    Long id = teachId;
                                    log.info("id is :" + id);
                                    teachIds.add(id);
                                }
                            }
                            List<Long> asListteachIds = new ArrayList<>(teachIds);
                            List teachIdsList = userService.getObjectsByIds(asListteachIds);
                            Map<Long, User> id_user = MyListUtil.convert2Map(User.class.getDeclaredField("id"), teachIdsList);


                            for (int j = 0; j < classTimetables.size(); j++) {
                                User user = id_user.get(classTimetables.get(j).getTeachUid());
                                classTimetables.get(j).setSpeakerTitle(setUserShowName(classTimetables.get(j).getTeachUid()));
                                newClassTimeTable1 = new NewClassTimeTable(classTimetables.get(j), user, deepThinkList.get(j));

                                if ((aid_relation.get(classTimetables.get(j).getId())) != null) {
                                    newClassTimeTable1.setIfLike(true);

                                }

                                if ((aid_relationCol.get(classTimetables.get(j).getId())) != null) {
                                    newClassTimeTable1.setIfCollection(true);
                                }

                                newClassTimeTableList.add(newClassTimeTable1);
                            }

                            Map<Long, Long> id_taskId = MyListUtil.convert2Map(NewClassTimeTable.class.getDeclaredField("id"), NewClassTimeTable.class.getDeclaredField("tid"), newClassTimeTableList);

                            Set<Long> taskIds = new HashSet<>();
                            for (Long taskId : id_taskId.values()) {
                                if (DataUtils.isNullOrEmpty(taskId)) {
                                    log.info("teamId is null");
                                } else {
                                    Long id = taskId;
                                    log.info("id is :" + id);
                                    taskIds.add(id);
                                }
                            }

                            List<Long> asListTaskIds = new ArrayList<>(taskIds);
                            List taskIdsList = taskService.getObjectsByIds(asListTaskIds);
                            Map<Long, Long> taskId_num = MyListUtil.convert2Map(Task.class.getDeclaredField("id"), Task.class.getDeclaredField("num"), taskIdsList);

                            for (NewClassTimeTable newClassTimeTable : newClassTimeTableList) {
                                Long taskNum = taskId_num.get(newClassTimeTable.getTid());
                                newClassTimeTable.setTidName(taskNum);
                            }

                        }

                        Integer totalPage = 1;
                        Integer li = new Integer(String.valueOf(total));
                        if (li > 0) {
                            totalPage = (li - 1) / size + 1;
                        }
                        model.addAttribute("code", 0);
                        model.addAttribute("page", page);
                        model.addAttribute("pSize", size);
                        model.addAttribute("total", total);
                        model.addAttribute("totalPage", totalPage);
                        model.addAttribute("size", newClassTimeTableList.size());
                        model.addAttribute("newClassTimeTableList", newClassTimeTableList);
                        log.info(newClassTimeTableList);
                        model.addAttribute("loginUid", loginUserId);
                    }
                } catch (Throwable throwable) {
                    log.info("getclassTimetableList error=" + throwable.getMessage());
                    model.addAttribute("code", -1);
                    return "/web-xiaoketang/myClass/myClassList";
                }


            }
            Map<Integer, String> levelNameList = new LinkedHashMap<Integer, String>();
            levelNameList.put(1, "下品");
            levelNameList.put(2, "中品");
            levelNameList.put(3, "上品");

            model.addAttribute("taskNameList", setTaskName());
            log.info(setTaskName());
            model.addAttribute("loginUid", loginUserId);
            model.addAttribute("orderBy", orderBy);
            model.addAttribute("sort", sort);


            return "/web-xiaoketang/myClass/myClassList";
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage(), t);
            model.addAttribute("code", -1);
        }
        return "/web-xiaoketang/myClass/myClassList";
    }


    /**
     * 课堂课题
     *
     * @Description
     * @Param type:要获取那种类型的数据：0：获取课表   1：获取课题
     * <p>
     * 课表搜索条件
     * @Param oid:职业id
     * @Param thinkName:课题名称
     * @Param tid:任务id
     * @Param groupId:小组名
     * @Param speakerName：主讲人姓名
     *
     * <p>
     * 课题搜索条件
     * @Param creatorName:创建人
     * @Param oid:职业id
     * @Param tid:任务id
     * @Param groupId:小组id
     * @Param thinkName:课题名称
     * @Param page
     * @Param size
     */
    @RequestMapping(value = "/l/subject/list/{type}", method = RequestMethod.GET)
    public String getclassTimetables(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                     Long oid, String creatNick, Long tid, String thinkName, String creatorName,
                                     Integer speakerId, String groupid, Long classTeamId, Integer level, Long startTime,
                                     Long endTime, @PathVariable("type") Integer type, String speakerName, Integer page, Integer size)
            throws Exception {


        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        //用于判定返回哪一个页面
        String returnPage = null;
        try {
            //课表
            if (type == 0) {

                log.info("getClassTimetableList params === oid=" + oid + " tid=" + tid + " thinkName=" + thinkName +
                        " groupid=" + groupid + " type=" + type + " page=" + page + " size=" + size + "speakerName=" + speakerName);

                List<Long> classArrangeIds = new ArrayList<>();
                List<ClassTimetable> classArrangeList = new ArrayList<>();
                Object total;

                try {
                    Map<String, Object> classTimetableListParam = DynamicUtil.getClassTimetableParam1(oid, tid, level, classTeamId,
                            startTime, endTime, speakerName, thinkName, groupid, false);
                    log.info("classTimetableListParam=" + classTimetableListParam);
                    classArrangeIds = classTimetableService.getIdsByDynamicCondition(ClassTimetable.class, classTimetableListParam, start, size);
                    log.info("classArrangeIds==" + classArrangeIds.size());

                    Map<String, Object> totalSql = DynamicUtil.getClassTimetableParam1(oid, tid, level, classTeamId,
                            startTime, endTime, speakerName, thinkName, groupid, true);
                    log.info("totalSql=" + totalSql);
                    total = classTimetableService.getObjectByDynamicCondition(ClassTimetable.class, totalSql, 0, Integer.MAX_VALUE);
                    log.info("total==" + total);


                    List<Occupation> occupationList = new ArrayList<>();
                    List<Long> oidList = occupationService.getOccupationIds(0, Integer.MAX_VALUE);
                    if (CollectionUtils.isEmpty(oidList)) {
                        log.info(" oidList is null ");
                    } else {
                        log.info(" oidList size =  " + oidList.size());
                        occupationList = occupationService.getObjectsByIds(oidList);
                    }


                    if (CollectionUtils.isEmpty(classArrangeIds)) {

                    }
                    classArrangeList = classTimetableService.getObjectsByIds(classArrangeIds);
                    log.info("getClassTimetableList success=" + classArrangeList.size());

                    //主讲人信息
                    List<Long> speakerIds = new ArrayList<>();
                    List<User> speakerList = new ArrayList<>();
                    //课题信息
                    List<Long> thinkIds = new ArrayList<>();
                    List<DeepThink> deepThinkList = new ArrayList<>();
                    if (CollectionUtils.isNotEmpty(classArrangeList)) {
                        for (ClassTimetable classTimetable : classArrangeList) {
                            speakerIds.add(classTimetable.getTeachUid());
                            thinkIds.add(classTimetable.getThinkId());
                        }
                    }
                    log.info("speakerIds=" + speakerIds.size());
                    log.info("thinkIds=" + thinkIds.size());
                    if (CollectionUtils.isNotEmpty(speakerIds)) {
                        speakerList = userService.getObjectsByIds(speakerIds);

                        Map<Long, Long> uid_oid = MyListUtil.convert2Map(User.class.getDeclaredField("id"), User.class.getDeclaredField("oid"), speakerList);
                        Set<Long> oids = new HashSet<>();
                        for (Long oidItem : uid_oid.values()) {
                            if (DataUtils.isNullOrEmpty(oidItem)) {
                                log.info("oid is null");
                            } else {
                                Long id = oidItem;
                                log.info("id is :" + id);
                                oids.add(id);
                            }
                        }
                        List<Long> asListoids = new ArrayList<>(oids);
                        List oidsList = occupationService.getObjectsByIds(asListoids);
                        Map<Long, Occupation> id_occupation = MyListUtil.convert2Map(Occupation.class.getDeclaredField("id"), oidsList);
                        for (User user : speakerList) {
                            Long preOid = user.getOid();
                            Occupation occupation = id_occupation.get(preOid);
                            String oidName = occupation.getName();
                            user.setOidName(oidName);
                        }
                    }
                    if (CollectionUtils.isNotEmpty(thinkIds)) {
                        deepThinkList = deepThinkService.getObjectsByIds(thinkIds);

                        Map<Long, Long> deepid_oid = MyListUtil.convert2Map(DeepThink.class.getDeclaredField("id"), DeepThink.class.getDeclaredField("oid"), deepThinkList);
                        Set<Long> oids = new HashSet<>();
                        for (Long oidItem : deepid_oid.values()) {
                            if (DataUtils.isNullOrEmpty(oidItem)) {
                            } else {
                                Long id = oidItem;
                                oids.add(id);
                            }
                        }
                        List<Long> asListoids = new ArrayList<>(oids);
                        List oidsList = occupationService.getObjectsByIds(asListoids);
                        Map<Long, Occupation> id_occupation = MyListUtil.convert2Map(Occupation.class.getDeclaredField("id"), oidsList);


                        for (DeepThink deepThink : deepThinkList) {
                            Long deepOid = deepThink.getOid();
                            Occupation occupation = id_occupation.get(deepOid);
                            String oidName = occupation.getName();
                            deepThink.setOidName(oidName);
                        }
                    }
                    log.info("speakerList=" + speakerList.size());
                    log.info("deepThinkList=" + deepThinkList.size());

                    List<NewClassTimeTable> newClassTimeTablesList = new ArrayList<>();
                    NewClassTimeTable newClassTimeTable = null;
                    Long loginUserId = getUserFromCookieUtil.getUserFromCookie(request);
                    int userIdentity = 0;
                    if (DataUtils.isNotNullOrEmpty(loginUserId)) {
                        userIdentity = userService.getObjectById(loginUserId).getIdentity();
                    }
                    boolean showLiveNum = false;
                    if (DataUtils.isNotNullOrEmpty(loginUserId) && userIdentity != User.IDENTIFY_10 && userIdentity != User.IDENTIFY_20 && userIdentity != 0) {
                        showLiveNum = true;
                    }
                    if (classArrangeList != null && classArrangeList.size() >= 1) {

                        Map<Long, Long> id_teamId = MyListUtil.convert2Map(ClassTimetable.class.getDeclaredField("id"), ClassTimetable.class.getDeclaredField("classTeamId"), classArrangeList);
                        Set<Long> teamIds = new HashSet<>();
                        for (Long teamId : id_teamId.values()) {
                            if (DataUtils.isNullOrEmpty(teamId)) {
                                log.info("teamId is null");
                            } else {
                                Long id = teamId;
                                log.info("id is :" + id);
                                teamIds.add(id);
                            }
                        }
                        List<Long> asListTeamIds = new ArrayList<>(teamIds);
                        List teamIdsList = classTeamService.getObjectsByIds(asListTeamIds);
                        Map<Long, ClassTeam> id_classTeam = MyListUtil.convert2Map(ClassTeam.class.getDeclaredField("id"), teamIdsList);


                        for (int j = 0; j < classArrangeList.size(); j++) {
                            newClassTimeTable = new NewClassTimeTable(classArrangeList.get(j), speakerList.get(j), deepThinkList.get(j));
                            String groupName = id_classTeam.get(newClassTimeTable.getGroupId()).getGroupName();

                            newClassTimeTable.setGroupName(groupName);
                            //散修和未登录不可见
                            if (showLiveNum) {
                                //添加直播群号
                                String liveNum = id_classTeam.get(newClassTimeTable.getGroupId()).getLiveNumber();
                                newClassTimeTable.setLiveNumber(liveNum);
                            } else {
                                newClassTimeTable.setLiveNumber("");
                            }
                            //增加组名
                            newClassTimeTablesList.add(newClassTimeTable);
                        }


                        Map<Long, Long> id_taskId = MyListUtil.convert2Map(NewClassTimeTable.class.getDeclaredField("id"), NewClassTimeTable.class.getDeclaredField("tid"), newClassTimeTablesList);

                        Set<Long> taskIds = new HashSet<>();
                        for (Long taskId : id_taskId.values()) {
                            if (DataUtils.isNullOrEmpty(taskId)) {
                                log.info("teamId is null");
                            } else {
                                Long id = taskId;
                                log.info("id is :" + id);
                                taskIds.add(id);
                            }
                        }
                        List<Long> asListTaskIds = new ArrayList<>(taskIds);
                        List taskIdsList = taskService.getObjectsByIds(asListTaskIds);
                        Map<Long, Long> taskId_num = MyListUtil.convert2Map(Task.class.getDeclaredField("id"), Task.class.getDeclaredField("num"), taskIdsList);

                        for (NewClassTimeTable newClassTimeTable1 : newClassTimeTablesList) {
                            Long taskNum = taskId_num.get(newClassTimeTable1.getTid());
                            newClassTimeTable1.setTidName(taskNum);
                        }


                    }

                    Integer totalPage = 1;
                    Integer li = new Integer(String.valueOf(total));
                    if (li > 0) {
                        totalPage = (li - 1) / size + 1;
                    }
                    model.addAttribute("taskNameList", setTaskName());

                    Map<String, String> groupNameMap = new LinkedHashMap<String, String>();
                    groupNameMap.put("01", "A组");
                    groupNameMap.put("02", "B组");
                    groupNameMap.put("03", "C组");
                    groupNameMap.put("04", "D组");
                    groupNameMap.put("05", "E组");
                    groupNameMap.put("06", "F组");
                    groupNameMap.put("07", "G组");
                    groupNameMap.put("08", "H组");
                    groupNameMap.put("09", "I组");
                    groupNameMap.put("10", "J组");

                    //进后台的听课记录列表时，要先访问数据统计接口，那里返回了total，所以这里不用再重复调用service返回了
                    model.addAttribute("code", 0);
                    model.addAttribute("page", page);
                    model.addAttribute("pSize", size);
                    model.addAttribute("size", newClassTimeTablesList.size());
                    model.addAttribute("total", total);
                    model.addAttribute("totalPage", totalPage);
                    model.addAttribute("classArrangeList", newClassTimeTablesList);
                    model.addAttribute("occupationList", occupationList);
                    model.addAttribute("groupNameMap", groupNameMap);
                    model.addAttribute("loginUid", loginUserId);
                } catch (Throwable t) {
                    t.printStackTrace();
                    log.error(t.getMessage());
                    log.info("getClassTimetableList error=" + t.getMessage());
                    model.addAttribute("code", -100000);
                    return "/web-xiaoketang/classTask/classTaskList";
                }

                returnPage = "/web-xiaoketang/classTask/classTaskList";
            }
            //课题
            else if (type == 1) {

                log.info("getThinkList params=oid= " + oid + "=tid=" + tid + "=thinkName=" + thinkName
                        + "=page=" + page + "=size=" + size + "=creatorName" + creatorName + "=type" + type);

                Map<String, Object> deepThinkParam = DynamicUtil.getDeepThinkParam(oid, tid, thinkName, null, creatorName, null, false);
                log.info("deepThinkParam=" + deepThinkParam);
                List<Long> ids = deepThinkService.getIdsByDynamicCondition(DeepThink.class, deepThinkParam, start, size);
                log.info("ids=" + ids);
                if (CollectionUtils.isEmpty(ids)) {

                }
                List<DeepThink> thinkList = deepThinkService.getObjectsByIds(ids);
                if (CollectionUtils.isNotEmpty(thinkList)) {

                    Map<Long, Long> tid_oid = MyListUtil.convert2Map(DeepThink.class.getDeclaredField("id"), DeepThink.class.getDeclaredField("oid"), thinkList);
                    Set<Long> oids = new HashSet<>();
                    for (Long oidItem : tid_oid.values()) {
                        if (DataUtils.isNullOrEmpty(oidItem)) {
                        } else {
                            Long id = oidItem;
                            oids.add(id);
                        }
                    }
                    List<Long> asListoids = new ArrayList<>(oids);
                    List oidsList = occupationService.getObjectsByIds(asListoids);
                    Map<Long, Occupation> id_occupation = MyListUtil.convert2Map(Occupation.class.getDeclaredField("id"), oidsList);


                    Map<Long, Long> tid_tid = MyListUtil.convert2Map(DeepThink.class.getDeclaredField("id"), DeepThink.class.getDeclaredField("tid"), thinkList);
                    Set<Long> tids = new HashSet<>();
                    for (Long tidItem : tid_tid.values()) {
                        if (DataUtils.isNullOrEmpty(tidItem)) {
                        } else {
                            Long id = tidItem;
                            tids.add(id);
                        }
                    }
                    List<Long> asListTids = new ArrayList<>(tids);
                    List tidsLists = taskService.getObjectsByIds(asListTids);
                    Map<Long, Task> id_task = MyListUtil.convert2Map(Task.class.getDeclaredField("id"), tidsLists);

                    Map<Long, Long> tid_creatUid = MyListUtil.convert2Map(DeepThink.class.getDeclaredField("id"), DeepThink.class.getDeclaredField("createBy"), thinkList);
                    Set<Long> uids = new HashSet<>();
                    for (Long uidItem : tid_creatUid.values()) {
                        if (DataUtils.isNullOrEmpty(uidItem)) {
                        } else {
                            Long id = uidItem;
                            log.info("id is :" + id);
                            uids.add(id);
                        }
                    }
                    List<Long> asListUids = new ArrayList<>(uids);
                    List uidsList = userService.getObjectsByIds(asListUids);
                    Map<Long, User> id_user = MyListUtil.convert2Map(User.class.getDeclaredField("id"), uidsList);

                    for (DeepThink deepThink : thinkList) {
                        String oidName = id_occupation.get(deepThink.getOid()).getName();
                        deepThink.setOidName(oidName);
                        Long tidNum = id_task.get(deepThink.getTid()).getNum();
                        deepThink.setTidNum(tidNum);
                        if (deepThink.getCreateBy() != null) {
                            User creator = id_user.get(deepThink.getCreateBy());
                            String nick = creator.getNick();
                            deepThink.setCreator(nick);
                        } else {
                            deepThink.setCreator("");
                        }
                    }
                }

                Map<String, Object> totalParam = DynamicUtil.getDeepThinkParam(oid, tid, thinkName, null, creatorName, null, true);
                Object total = deepThinkService.getObjectByDynamicCondition(DeepThink.class, totalParam, 0, Integer.MAX_VALUE);
                log.info("total==" + total);

                //获取职业列表
                List<Occupation> occupationList = new ArrayList<>();
                List<Long> oidList = occupationService.getOccupationIds(0, Integer.MAX_VALUE);
                if (CollectionUtils.isEmpty(oidList)) {
                    log.info(" oidList is null ");
                } else {
                    log.info(" oidList size =  " + oidList.size());
                    occupationList = occupationService.getObjectsByIds(oidList);
                }

                Integer totalPage = 1;
                Integer li = new Integer(String.valueOf(total));
                if (li > 0) {
                    totalPage = (li - 1) / size + 1;
                }
                Long loginUserId = getUserFromCookieUtil.getUserFromCookie(request);
                model.addAttribute("code", 0);
                model.addAttribute("page", page);
                model.addAttribute("Psize", size);
                model.addAttribute("size", thinkList.size());
                model.addAttribute("totalPage", totalPage);
                model.addAttribute("total", total);
                model.addAttribute("thinkList", thinkList);
                model.addAttribute("taskNameList", setTaskName());
                model.addAttribute("occupationList", occupationList);
                model.addAttribute("loginUid", loginUserId);

                returnPage = "/web-xiaoketang/classTask/classTaskList";
            }
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.info("getclassTimetableList error=" + t.getMessage());
            model.addAttribute("code", -1);
            return "/web-xiaoketang/classTask/classTaskList";
        }
        return returnPage;
    }


    /**
     * 获取课堂列表（不需要用户登录的——如：课堂资料）
     *
     * @Author ruanshaonan
     * @Description
     * @Date 9:55 2018/6/28
     * @Param orderBy：缺省按用户点赞/收藏/时间排序 排序规则：1点赞数 2收藏数 3时间 4评论数 5查看数
     * @Param sort:排序类型 缺省按用户点赞/收藏/时间逆序排 0-逆序 1-正序
     * @Param speakStatus:小课堂状态 1：预告 2：未审核 3：未评级 4：已评级
     * @Param uid:用户id 如果是查找师弟课堂，则要把师弟的用户id，用逗号隔开，组成一个字符串传到后端
     * @Param status:是否上下架 0：未上架 1：上架
     * @Param oid:职业id
     * @Param tid:任务id
     * @Param level:小课堂等级
     * @Param thinkName:深度思考名称
     * @Param speakerId:主讲人id
     * @Param groupId:小组id
     * @Param type:要获取那种类型的数据："timetable"：获取课表   "classes"：获取小课堂
     * @Param page
     * @Param size
     */
    @RequestMapping(value = "/l/class/arrange/data/{type}", method = RequestMethod.GET)
    public String getclassTimetables(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                     Integer orderBy, Integer sort, Integer speakStatus, Long uid,
                                     Integer status, Long oid, Integer tid, Integer level, String thinkName,
                                     Integer speakerId, Integer groupId, @PathVariable("type") String type,
                                     Long startTime, Long endTime, Integer page, Integer size)
            throws Exception {

        log.info("get classTimetable List=orderBy=" + orderBy + "=sort=" + sort + "=speakStatus=" + speakStatus
                + "=uid=" + uid + "=type=" + type + "=status=" + status + "=oid=" + oid + "=tid=" + tid
                + "=level=" + level + "=thinkName=" + thinkName + "=speakerId=" + speakerId
                + "==groupId==" + groupId + "==startTime==" + startTime + "==endTime==" + endTime
                + "==page==" + page + "==size==" + size);

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        try {
            Map<String, Object> classTimetableListParam = DynamicUtil.getClassTimetableParam2(orderBy, sort, speakStatus,
                    uid, status, oid, tid, level, thinkName, speakerId, groupId, type, startTime, endTime, false);
            log.info("classTimetableListParam=" + classTimetableListParam);
            Map<String, Object> totalParam = DynamicUtil.getClassTimetableParam2(orderBy, sort, speakStatus,
                    uid, status, oid, tid, level, thinkName, speakerId, groupId, type, startTime, endTime, true);
            Object total = classTimetableService.getObjectByDynamicCondition(ClassTimetable.class, totalParam,
                    0, Integer.MAX_VALUE);

            List<Long> ids = classTimetableService.getIdsByDynamicCondition(ClassTimetable.class,
                    classTimetableListParam, start, size);
            log.info("ids=" + ids.size());
            List<ClassTimetable> classArrangeList = classTimetableService.getObjectsByIds(ids);
            log.info("getClassTimetableList success=" + classArrangeList.size());
            //返回主讲人姓名
            List<Long> speakerIds = new ArrayList<>();
            //返回课题名称
            List<Long> thinkIds = new ArrayList<>();
            //返回小组名称
            List<Long> groupIds = new ArrayList<>();
            for (ClassTimetable classTimetable : classArrangeList) {
                speakerIds.add(classTimetable.getTeachUid());
                thinkIds.add(classTimetable.getThinkId());
                groupIds.add(classTimetable.getClassTeamId());
            }
            log.info("speakerIds==" + speakerIds.size());
            log.info("thinkIds==" + thinkIds.size());
            log.info("groupIds==" + groupIds.size());
            List<User> speakers = userService.getObjectsByIds(speakerIds);
            log.info("get speakers success=" + speakers.size());
            List<DeepThink> deepThinkList = deepThinkService.getObjectsByIds(thinkIds);
            log.info("get deep think success=" + deepThinkList.size());

            //获取所有职业和任务
            List<Occupation> occupationList = new ArrayList<>();

            List<Long> oidList = occupationService.getOccupationIds(0, Integer.MAX_VALUE);

            if (CollectionUtils.isEmpty(oidList)) {
                log.info(" oidList is null ");
            } else {
                log.info(" oidList size =  " + oidList.size());
                occupationList = occupationService.getObjectsByIds(oidList);
            }

            List<NewClassTimeTable> newClassTimeTablesList = new ArrayList<>();
            NewClassTimeTable newClassTimeTable = null;
            if (classArrangeList != null && classArrangeList.size() >= 1) {
                for (int j = 0; j < classArrangeList.size(); j++) {
                    classArrangeList.get(j).setSpeakerTitle(setUserShowName(classArrangeList.get(j).getTeachUid()));
                    newClassTimeTable = new NewClassTimeTable(classArrangeList.get(j), speakers.get(j), deepThinkList.get(j));
                    newClassTimeTablesList.add(newClassTimeTable);
                }
            }
            Long loginUserId = getUserFromCookieUtil.getUserFromCookie(request);
            log.info("get loginUserId=====" + loginUserId);
            if (newClassTimeTablesList != null && newClassTimeTablesList.size() >= 1) {
                Map<Long, Long> classId_oid = MyListUtil.convert2Map(NewClassTimeTable.class.getDeclaredField("id"), NewClassTimeTable.class.getDeclaredField("oid"), newClassTimeTablesList);
                Set<Long> oids = new HashSet<>();
                for (Long oidItem : classId_oid.values()) {
                    if (DataUtils.isNullOrEmpty(oidItem)) {
                        log.info("oid is null");
                    } else {
                        Long id = oidItem;
                        log.info("id is :" + id);
                        oids.add(id);
                    }
                }
                List<Long> asListoids = new ArrayList<>(oids);
                List oidsList = occupationService.getObjectsByIds(asListoids);
                Map<Long, Occupation> id_occupation = MyListUtil.convert2Map(Occupation.class.getDeclaredField("id"), oidsList);


                Map<Long, Long> aid_relation = null;
                Map<Long, Long> aid_relationCol = null;

                if (DataUtils.isNotNullOrEmpty(loginUserId)) {
                    List<Long> userLoveRelationIds = userArticleRelationService.getUserArticleRelationIdsByUidAndTypeAndWhether(loginUserId, UserArticleRelation.STATUS_LOVE, UserArticleRelation.WHETHER_VALID, 0, Integer.MAX_VALUE);
                    List<UserArticleRelation> userLoveRelationList = userArticleRelationService.getObjectsByIds(userLoveRelationIds);
                    aid_relation = MyListUtil.convert2Map(UserArticleRelation.class.getDeclaredField("aid"), userLoveRelationList);

                    List<Long> userColRelationIds = userArticleRelationService.getUserArticleRelationIdsByUidAndTypeAndWhether(loginUserId, UserArticleRelation.STATUS_COLLECTION, UserArticleRelation.WHETHER_VALID, 0, Integer.MAX_VALUE);
                    List<UserArticleRelation> userColRelationList = userArticleRelationService.getObjectsByIds(userColRelationIds);
                    aid_relationCol = MyListUtil.convert2Map(UserArticleRelation.class.getDeclaredField("aid"), userColRelationList);
                }


                Map<Long, Long> id_taskId = MyListUtil.convert2Map(NewClassTimeTable.class.getDeclaredField("id"), NewClassTimeTable.class.getDeclaredField("tid"), newClassTimeTablesList);
                Set<Long> taskIds = new HashSet<>();
                for (Long taskId : id_taskId.values()) {
                    if (DataUtils.isNullOrEmpty(taskId)) {
                        log.info("teamId is null");
                    } else {
                        Long id = taskId;
                        log.info("id is :" + id);
                        taskIds.add(id);
                    }
                }
                List<Long> asListTaskIds = new ArrayList<>(taskIds);
                List taskIdsList = taskService.getObjectsByIds(asListTaskIds);
                Map<Long, Long> taskId_num = MyListUtil.convert2Map(Task.class.getDeclaredField("id"), Task.class.getDeclaredField("num"), taskIdsList);


                for (NewClassTimeTable newClassTimeTable1 : newClassTimeTablesList) {
                    (newClassTimeTable1).setOidName(id_occupation.get(newClassTimeTable1.getOid()).getName());

                    Long taskNum = taskId_num.get(newClassTimeTable1.getTid());
                    newClassTimeTable1.setTidName(taskNum);

                    if (newClassTimeTable1.getReply() == null) {
                        newClassTimeTable1.setReply((long) 0);
                    }
                    if (DataUtils.isNotNullOrEmpty(loginUserId)) {
                        if (DataUtils.isNotNullOrEmpty(aid_relation.get(newClassTimeTable1.getId()))) {
                            newClassTimeTable1.setIfLike(true);
                        }
                        if (DataUtils.isNotNullOrEmpty(aid_relationCol.get(newClassTimeTable1.getId()))) {
                            newClassTimeTable1.setIfCollection(true);
                        }
                    }
                }


            }

            Map<Integer, String> levelNameList = new LinkedHashMap<Integer, String>();
            levelNameList.put(1, "下品");
            levelNameList.put(2, "中品");
            levelNameList.put(3, "上品");

            model.addAttribute("taskNameList", setTaskName());

            Integer totalPage = 1;
            Integer li = new Integer(String.valueOf(total));
            if (li > 0) {
                totalPage = (li - 1) / size + 1;
            }

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("pSize", size);
            model.addAttribute("size", newClassTimeTablesList.size());
            model.addAttribute("total", total);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("classArrangeList", newClassTimeTablesList);
            log.info(newClassTimeTablesList);
            model.addAttribute("orderBy", orderBy);
            model.addAttribute("sort", sort);
            model.addAttribute("levelNameList", levelNameList);
            model.addAttribute("occupationList", occupationList);
            model.addAttribute("loginUid", loginUserId);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.info("getclassTimetableList error=" + t.getMessage());
            model.addAttribute("code", -1);
            return "/web-xiaoketang/classroomDatum/classroomDatum";
        }
        return "/web-xiaoketang/classroomDatum/classroomDatum";
    }

    /**
     * 小课堂评级
     *
     * @Author 丶
     * @Description
     * @Param id:课堂id
     * @Param level：评级： 1：下品 2：中品 3：上品
     * @Param comment：评语
     */
    @RequestMapping(value = "/a/u/class/evaluation/{id}", method = RequestMethod.PUT)
    public String updateClass(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                              @PathVariable Long id, String comment, Integer level)
            throws Exception {

        log.info("params====id==" + id + "comment==" + comment + "level==" + level);

        try {
            if (DataUtils.isNullOrEmpty(level)) {
                model.addAttribute("code", -17001);
                return "/common/success";
            }

            if (StringUtil.isEmpty(comment)) {
                model.addAttribute("code", -17009);
                return "/common/success";
            }
            ClassTimetable classTimetable = classTimetableService.getObjectById(id);
            log.info("get classTimetable success==" + classTimetable.getId());
            if (DataUtils.isNullOrEmpty(classTimetable)) {
                model.addAttribute("code", -1111);
                return "/common/success";
            }
            User speaker = userService.getObjectById(classTimetable.getTeachUid());
            User LoginUser = (User) request.getAttribute("user");

            //若小课堂已被评级，则直接返回“该小课堂已被评级”
            if (classTimetable.getSpeakStatus() == ClassTimetable.HAS_LEVEL) {
                log.info("The class has been rated, which classId = " + id);
                model.addAttribute("code", -5005);
                return "/common/failure";
            }

            if (DataUtils.isNotNullOrEmpty(speaker)) {
                if (LoginUser.getId().equals(speaker.getTeacherId())) {

                    //新增评论
                    ClassTimetable smallClass = classTimetableService.getObjectById(id);
                    if (DataUtils.isNullOrEmpty(smallClass)) {
                        model.addAttribute("code", -5000);
                        log.info("no this smallClass");
                        return "/common/success";
                    }
                    User user = (User) request.getAttribute("user");

                    Long commentId = commentClass(smallClass, user, comment, null);
                    model.addAttribute("code", 0);
                    model.addAttribute("commentId", commentId);


                    if (classTimetable.getSpeakStatus() == ClassTimetable.NO_LEVEL_UNSEND) {
                        //师兄给师弟评级，师兄可以获得2学分，加分后，给师兄发送增加学分的消息，给师弟发送小课堂已被评级的消息
                        // 辅导师兄——新增积分记录
                        UserScore userScore = new UserScore();
                        userScore.setScore(UserScore.SCORE_MAKE_CLASS_LEVEL);
                        userScore.setUid(speaker.getTeacherId());
                        log.info("student id = " + classTimetable.getTeachUid());
                        log.info("teacher id = " + speaker.getTeacherId());
                        userScore.setScoreType(UserScore.SCORE_TYPE_ADD);
                        userScore.setComment(UserScore.MAKE_CLASS_LEVEL);
                        Long scoreRecordId = userScoreService.insert(userScore);
                        log.info("add teacher score record success==" + scoreRecordId);

                        // 给辅导师兄发送学分变动的消息
                        User teacher = userService.getObjectById(speaker.getTeacherId());
                        Message message = new Message();
                        message.setStatus(Message.STATUS_UNDELETE);
                        message.setReceiveName(teacher.getNick());
                        message.setSendName("admin");
                        message.setTemplate(Message.TEMPLATE_5);
                        message.setSendId(0L);
                        message.setReceiveId(speaker.getTeacherId());
                        message.setUnread(Message.Status_Unread);
                        message.setType(Message.SCORE_TYPE);
                        message.setCreateAt(System.currentTimeMillis());
                        message.setUpdateAt(System.currentTimeMillis());

                        Occupation occupation = occupationService.getObjectById(speaker.getOid());
                        String oname = occupation.getName();//获取职业名
                        List<Map> list = new ArrayList<>();
                        String content1 = "你审核了《XXX | XXX的XXX》，获得2积分，点击XXX";
                        Map<String, Object> map = new HashMap<>();
                        map.put("content", content1);
                        Map<String, Object> map1 = new HashMap<>();
                        map1.put("childContent", oname + "-" + speaker.getNick());
                        map1.put("skip", true);
                        map1.put("uid", speaker.getId());
                        Map<String, Object> map2 = new HashMap<>();
                        map2.put("childContent", classTimetable.getArrangeDate());
                        map2.put("skip", false);
                        Map<String, Object> map3 = new HashMap<>();
                        map3.put("childContent", "小课堂");
                        map3.put("skip", true);
                        map3.put("lessonId", classTimetable.getId());
                        Map<String, Object> map4 = new HashMap<>();
                        map4.put("childContent", "查看");
                        map4.put("skip", true);
                        map4.put("scoreId", speaker.getTeacherId());

                        list.add(map);
                        list.add(map1);
                        list.add(map2);
                        list.add(map3);
                        list.add(map4);
                        //把list转成json格式的String字符串
                        ObjectMapper json = new ObjectMapper();
                        String contentStr = json.writeValueAsString(list);
                        message.setContent(contentStr);
                        messageService.insert(message);
                        log.info("insert success==" + message);
                        //更新评级师兄的未读消息数量和最后一条消息类型
                        //辅导师兄加学分
                        teacher.setScore(Integer.parseInt(teacher.getScore() + UserScore.SCORE_MAKE_CLASS_LEVEL + ""));
                        teacher.setIsLook(teacher.getIsLook() + 1);
                        teacher.setLatestMsg(Message.SCORE_TYPE);
                        log.info("update teacher score success==");

                        // 师兄评级之后，师弟学分变动
                        // 添加一条变动记录
                        // 发送学分变动的消息
                        int scoreType = UserScore.SCORE_TYPE_ADD;
                        long score = 0;
                        String comments = null;
                        if (level == ClassTimetable.LOW_LEVEL) {
                            score = ClassTimetable.LOW_LEVEL_SCORE;
                            comments = ClassTimetable.SMALL_CLASS_LOW_LEVEL_COMMENT;
                            scoreType = UserScore.SCORE_TYPE_REDUCE;
                        }
                        if (level == ClassTimetable.MIDDLE_LEVEL) {
                            score = ClassTimetable.MIDDLE_LEVEL_SCORE;
                            comments = ClassTimetable.SMALL_CLASS_MIDDLE_LEVEL_COMMENT;
                        }
                        if (level == ClassTimetable.HIGH_LEVEL) {
                            score = ClassTimetable.HIGH_LEVEL_SCORE;
                            comments = ClassTimetable.SMALL_CLASS_HIGH_LEVEL_COMMENT;
                        }

                        // 主讲人添加一条变动记录
                        UserScore speakerScore = new UserScore();
                        speakerScore.setScore(score);
                        speakerScore.setUid(classTimetable.getTeachUid());
                        speakerScore.setScoreType(scoreType);
                        speakerScore.setComment(comments);
                        Long speakerScoreRecordId = userScoreService.insert(speakerScore);
                        log.info("add speaker score record success==" + speakerScoreRecordId);

                        // 发送学分变动的消息
                        Message speakerScoremessage = new Message();
                        speakerScoremessage.setStatus(Message.STATUS_UNDELETE);
                        speakerScoremessage.setReceiveName(speaker.getNick());
                        speakerScoremessage.setSendName("admin");
                        speakerScoremessage.setTemplate(Message.TEMPLATE_5);
                        speakerScoremessage.setSendId(0L);
                        speakerScoremessage.setReceiveId(speaker.getId());
                        speakerScoremessage.setUnread(Message.Status_Unread);
                        speakerScoremessage.setType(Message.SCORE_TYPE);
                        speakerScoremessage.setCreateAt(System.currentTimeMillis());
                        speakerScoremessage.setUpdateAt(System.currentTimeMillis());
                        String contentStudent;
                        if (scoreType == UserScore.SCORE_TYPE_REDUCE) {
                            contentStudent = "你的《XXX的XXX》被评为XXX，扣除" + score + "积分，点击XXX";
                        } else {
                            contentStudent = "你的《XXX的XXX》被评为XXX，获得" + score + "积分，点击XXX";
                        }
                        List<Map> listStudent = new ArrayList<>();
                        Map<String, Object> mapStudent = new HashMap<>();
                        mapStudent.put("content", contentStudent);
                        Map<String, Object> mapStudent1 = new HashMap<>();
                        mapStudent1.put("childContent", classTimetable.getArrangeDate());
                        mapStudent1.put("skip", false);
                        Map<String, Object> mapStudent2 = new HashMap<>();
                        mapStudent2.put("childContent", "小课堂");
                        mapStudent2.put("skip", true);
                        mapStudent2.put("lessonId", classTimetable.getId());
                        Map<String, Object> mapStudent3 = new HashMap<>();
                        mapStudent3.put("childContent", level);
                        mapStudent3.put("skip", false);
                        Map<String, Object> mapStudent4 = new HashMap<>();
                        mapStudent4.put("childContent", "查看");
                        mapStudent4.put("skip", true);
                        mapStudent4.put("scoreId", speaker.getId());

                        listStudent.add(mapStudent);
                        listStudent.add(mapStudent1);
                        listStudent.add(mapStudent2);
                        listStudent.add(mapStudent3);
                        listStudent.add(mapStudent4);
                        //把list转成json格式的String字符串
                        ObjectMapper jsonStudent = new ObjectMapper();
                        String contentStrStudent = jsonStudent.writeValueAsString(listStudent);
                        speakerScoremessage.setContent(contentStrStudent);

                        Long speakerScoreChangeMsgId = messageService.insert(speakerScoremessage);
                        log.info("send speaker score change msg success==" + speakerScoreChangeMsgId);

                        //变动用户学分
                        speaker.setScore(Integer.parseInt(speaker.getScore() + score + ""));
                        speaker.setIsLook(speaker.getIsLook() + 1);
                        speaker.setLatestMsg(Message.SCORE_TYPE);
                        userService.update(speaker);
                        log.info("update user score success==");
                    }

                }
                classTimetable.setLevel(level);
                classTimetable.setSpeakStatus(ClassTimetable.HAS_LEVEL);
                classTimetable.setUpdateBy(getUserFromCookieUtil.getUserFromCookie(request));
                log.info("update date===" + classTimetable);
                classTimetableService.update(classTimetable);
            }

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -1);
        }
        model.addAttribute("code", 0);
        return "/common/success";
    }

    /**
     * 修改课堂
     *
     * @Author ruanshaonan
     * @Description
     * @Date 10:00 2018/6/28
     * @Param previewImg：预告图片
     * @Param targetPerson:目标人群
     * @Param classAbstract:课堂简介
     * @Param speakStatus：小课堂状态 1：预告 2：未审核 3：未评级未审核 4.未评级已审核 5：已评级
     * @Param status：上下架状态： 0：下架 1：上架
     * @Param pptUrl：ppt链接
     * @Param videoUrl：视频链接
     * @Param content：讲课内容
     * @Param expect：课堂期望
     */
    @RequestMapping(value = "/a/u/class/arrange/{id}", method = RequestMethod.PUT)
    public String updateClassTimetable(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                       String previewImg, String targetPerson, String expect, String classAbstract, Integer speakStatus,
                                       Integer status, String pptUrl, String videoUrl, String content,
                                       @PathVariable("id") Long id) throws Exception {

        log.info("update classTimetable :id==" + id + "== previewImg= " + previewImg
                + "=targetPerson=" + targetPerson + "=expect=" + expect + "=classAbstract=" + classAbstract
                + "=speakStatus=" + speakStatus + "=status=" + status
                + "=pptUrl=" + pptUrl + "=videoUrl=" + videoUrl + "=content=" + content);

        try {
            ClassTimetable classTimetable = classTimetableService.getObjectById(id);
            log.info("get classTimetable success==" + classTimetable.getId());
            if (DataUtils.isNullOrEmpty(classTimetable)) {
                model.addAttribute("code", -60005);
                return "/web-kenghu/common/404";
            }

            if (DataUtils.isNotNullOrEmpty(previewImg)) {
                classTimetable.setPreviewImg(previewImg);
            }
            if (DataUtils.isNotNullOrEmpty(targetPerson)) {
                classTimetable.setTargetPeople(targetPerson);
            }
            if (DataUtils.isNotNullOrEmpty(expect)) {
                classTimetable.setExpect(expect);
            }
            if (DataUtils.isNotNullOrEmpty(classAbstract)) {
                classTimetable.setClassAbstract(classAbstract);
            }
            if (DataUtils.isNotNullOrEmpty(speakStatus)) {
                classTimetable.setSpeakStatus(speakStatus);
            }
            if (DataUtils.isNotNullOrEmpty(status)) {
                classTimetable.setStatus(status);
            }
            if (DataUtils.isNotNullOrEmpty(pptUrl)) {
                classTimetable.setPptUrl(pptUrl);
            }
            if (DataUtils.isNotNullOrEmpty(videoUrl)) {
                classTimetable.setVideoUrl(videoUrl);
            }
            if (DataUtils.isNotNullOrEmpty(content)) {
                classTimetable.setContent(content);
            }

            classTimetable.setUpdateBy(getUserFromCookieUtil.getUserFromCookie(request));
            log.info("update date===" + classTimetable);
            classTimetableService.update(classTimetable);

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update classTimetable error,id is  " + id);
            model.addAttribute("code", -1);
        }
        return "/common/success";
    }

    /**
     * 预告相关
     *
     * @Author 丶
     * @Description
     */
    @RequestMapping(value = "/l/trailerEditor/{classId}", method = RequestMethod.GET)
    public String classPreContent(HttpServletRequest request,
                                  HttpServletResponse response, ModelMap model, @PathVariable("classId") Long id) throws Exception {
        try {

            ClassTimetable classTimetable = classTimetableService.getObjectById(id);
            if (DataUtils.isNullOrEmpty(classTimetable)) {
                model.addAttribute("code", -1001);
                return "/web-xiaoketang/myClass/trailerEditor";
            }
            //小课堂提交评级之后，即：speakStatus>=3，查看时对应的查看数+1
            log.info("speak status==" + classTimetable.getSpeakStatus());
            if (classTimetable.getSpeakStatus() >= ClassTimetable.NO_LEVEL) {
                int oldReadCount = classTimetable.getReadCount();
                classTimetable.setReadCount(oldReadCount + 1);
                log.info("old read count==" + oldReadCount);
                classTimetableService.update(classTimetable);
            }
            log.info("getClassTimetableDetail success" + classTimetable.getId());
            //主讲人
            User speaker = userService.getObjectById(classTimetable.getTeachUid());
            log.info("speaker==" + speaker.getId());
            //深度思考
            DeepThink think = deepThinkService.getObjectById(classTimetable.getThinkId());
            log.info("think==" + think.getId());

            NewClassTimeTable newClassTimeTable = new NewClassTimeTable(classTimetable, speaker, think);
            Long taskName = taskService.getObjectById(newClassTimeTable.getTid()).getNum();
            newClassTimeTable.setTidName(taskName);
            Long loginUserId = getUserFromCookieUtil.getUserFromCookie(request);
            model.addAttribute("loginUid", loginUserId);
            model.addAttribute("taskNameList", setTaskName());
            model.addAttribute("code", 0);
            model.addAttribute("classTimetableDetail", newClassTimeTable);
            model.addAttribute("think", think);
            model.addAttribute("teacher", setUserShowName(newClassTimeTable.getTeacherId()));

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -1);
            return "/web-xiaoketang/myClass/trailerEditor";
        }
        return "/web-xiaoketang/myClass/trailerEditor";
    }

    /**
     * 评级相关
     *
     * @Author 丶
     * @Description
     */
    @RequestMapping(value = "/l/subjectRating/{classId}", method = RequestMethod.GET)
    public String classComment(HttpServletRequest request,
                               HttpServletResponse response, ModelMap model, @PathVariable("classId") Long id, Integer page, Integer size, Long startAt, Long endAt) throws Exception {
        try {

            ClassTimetable classTimetable = classTimetableService.getObjectById(id);
            if (DataUtils.isNullOrEmpty(classTimetable)) {
                model.addAttribute("code", -1001);
                return "/web-kenghu/common/404";
            }
            //小课堂提交评级之后，即：speakStatus>=3，查看时对应的查看数+1
            log.info("speak status==" + classTimetable.getSpeakStatus());
            if (classTimetable.getSpeakStatus() >= ClassTimetable.NO_LEVEL) {
                int oldReadCount = classTimetable.getReadCount();
                classTimetable.setReadCount(oldReadCount + 1);
                log.info("old read count==" + oldReadCount);
                classTimetableService.update(classTimetable);
            }
            log.info("getClassTimetableDetail success" + classTimetable.getId());
            //主讲人
            User speaker = userService.getObjectById(classTimetable.getTeachUid());
            log.info("speaker==" + speaker.getId());
            //深度思考
            DeepThink think = deepThinkService.getObjectById(classTimetable.getThinkId());
            log.info("think==" + think.getId());

            NewClassTimeTable newClassTimeTable = new NewClassTimeTable(classTimetable, speaker, think);
            Long taskName = taskService.getObjectById(newClassTimeTable.getTid()).getNum();
            newClassTimeTable.setTidName(taskName);
            Long loginUserId = getUserFromCookieUtil.getUserFromCookie(request);
            model.addAttribute("loginUid", loginUserId);

            model.addAttribute("taskNameList", setTaskName());
            model.addAttribute("code", 0);
            model.addAttribute("classTimetableDetail", newClassTimeTable);
            model.addAttribute("speaker", setUserShowName(speaker.getId()));
            model.addAttribute("think", think);
            model.addAttribute("teacher", setUserShowName(newClassTimeTable.getTeacherId()));


            //查看相关评论
            log.info("get comment Start");


            if (page == null) {
                page = 1;
            }
            if (size == null) {
                size = 10;
            }
            int start = (page - 1) * size;
            if (start < 0) {
                start = 0;
            }
            int end = start + size + 1;
            Set<Long> uids = new HashSet();

            Integer total = 0;

            Long did = id;
            String type = String.valueOf(10);
            List<Comment> comments = new ArrayList();
            Map<String, Object> param = DynamicUtil.getCommentListParam(did, type, startAt, endAt, false);
            List<Long> commentIDS = this.commentService.getIdsByDynamicCondition(Comment.class, param, start, end);

            Map<String, Object> countParam = DynamicUtil.getCommentListParam(did, type, startAt, endAt, true);
            List<Long> totals = this.commentService.getIdsByDynamicCondition(Comment.class, countParam, 0, Integer.MAX_VALUE);
            total = totals.get(0).intValue();
            log.info(" did: " + did + " get comment is " + commentIDS);
            if (CollectionUtils.isEmpty(commentIDS)) {
                log.info("comment is null===");
            } else {
                comments = this.commentService.getObjectsByIds(commentIDS);
                if (comments.size() > size) {
                    comments = comments.subList(0, size);
//                    next = true;
                } else {
                    log.info("there is no next==");
                }

                List<Long> userIds = new ArrayList();
                for (Comment comment : comments) {
                    uids.add(comment.getUid());
                    comment.setUserNick(setUserShowName(comment.getUid()));
                    userIds.add(comment.getUid());
                }
                log.info(" did: " + did + " get uids is " + uids);

                List<User> users = userService.getObjectsByIds(userIds);
                model.addAttribute("users", users);
            }



            Integer totalPage = 1;
            Integer li = new Integer(String.valueOf(total));
            if (li > 0) {
                totalPage = (li - 1) / size + 1;
            }
            model.addAttribute("code", 0);
            model.addAttribute("comments", comments);
            model.addAttribute("page", page);
            model.addAttribute("Psize", size);
            model.addAttribute("total", total);
            model.addAttribute("size", comments.size());
            model.addAttribute("totalPage", totalPage);


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -1);
            return "/web-xiaoketang/myClass/subjectRating";
        }
        return "/web-xiaoketang/myClass/subjectRating";
    }


    /**
     * 内容相关
     *
     * @Author 丶
     * @Description
     */
    @RequestMapping(value = "/l/subjectContent/{classId}", method = RequestMethod.GET)
    public String classContent(HttpServletRequest request,
                               HttpServletResponse response, ModelMap model, @PathVariable("classId") Long id, Integer page, Integer size, Long startAt, Long endAt) throws Exception {
        try {


            ClassTimetable classTimetable = classTimetableService.getObjectById(id);
            if (DataUtils.isNullOrEmpty(classTimetable)) {
                model.addAttribute("code", -1001);
                return "/web-kenghu/common/404";
            }
            //小课堂提交评级之后，即：speakStatus>=4，查看时对应的查看数+1
            log.info("speak status==" + classTimetable.getSpeakStatus());
            if (classTimetable.getSpeakStatus() >= ClassTimetable.NO_LEVEL_UNSEND) {
                int oldReadCount = classTimetable.getReadCount();
                classTimetable.setReadCount(oldReadCount + 1);
                log.info("old read count==" + oldReadCount);
                classTimetableService.update(classTimetable);
            }
            log.info("getClassTimetableDetail success" + classTimetable.getId());
            //主讲人
            User speaker = userService.getObjectById(classTimetable.getTeachUid());
            log.info("speaker==" + speaker.getId());
            //深度思考
            DeepThink think = deepThinkService.getObjectById(classTimetable.getThinkId());
            log.info("think==" + think.getId());
            NewClassTimeTable newClassTimeTable = new NewClassTimeTable(classTimetable, speaker, think);

            Long taskName = taskService.getObjectById(newClassTimeTable.getTid()).getNum();
            newClassTimeTable.setTidName(taskName);

            Long loginUserId = getUserFromCookieUtil.getUserFromCookie(request);
            model.addAttribute("loginUid", loginUserId);
            //登陆者点赞收藏情况
            if (DataUtils.isNotNullOrEmpty(loginUserId)) {
                Long collectionId = userArticleRelationService.getUserArticleRelationIdByUidAndAidAndTypeAndWeather(loginUserId, id, UserArticleRelation.STATUS_COLLECTION, UserArticleRelation.WHETHER_VALID);
                Long loveId = userArticleRelationService.getUserArticleRelationIdByUidAndAidAndTypeAndWeather(loginUserId, id, UserArticleRelation.STATUS_LOVE, UserArticleRelation.WHETHER_VALID);
                if (DataUtils.isNotNullOrEmpty(collectionId)) {
                    newClassTimeTable.setIfCollection(true);
                }
                if (DataUtils.isNotNullOrEmpty(loveId)) {
                    newClassTimeTable.setIfLike(true);
                }
            }

            model.addAttribute("taskNameList", setTaskName());
            model.addAttribute("code", 0);
            model.addAttribute("classTimetableDetail", newClassTimeTable);
            model.addAttribute("teacher", setUserShowName(newClassTimeTable.getTeacherId()));
            model.addAttribute("speakerId", speaker.getId());
            model.addAttribute("think", think);


            //查看相关评论
            log.info("get comment Start");
            if (page == null) {
                page = 1;
            }
            if (size == null) {
                size = 10;
            }
            int start = (page - 1) * size;
            if (start < 0) {
                start = 0;
            }
            int end = start + size + 1;
            Set<Long> uids = new HashSet();
            Integer total = 0;
            Long did = id;
            String type = String.valueOf(10);
            List<Comment> comments = new ArrayList();
            Map<String, Object> param = DynamicUtil.getCommentListParam(did, type, startAt, endAt, false);
            List<Long> commentIDS = this.commentService.getIdsByDynamicCondition(Comment.class, param, start, end);

            Map<String, Object> countParam = DynamicUtil.getCommentListParam(did, type, startAt, endAt, true);
            List<Long> totals = this.commentService.getIdsByDynamicCondition(Comment.class, countParam, 0, Integer.MAX_VALUE);
            total = totals.get(0).intValue();
            log.info(" did: " + did + " get comment is " + commentIDS);
            if (CollectionUtils.isEmpty(commentIDS)) {
                log.info("comment is null===");
            } else {
                comments = this.commentService.getObjectsByIds(commentIDS);
                if (comments.size() > size) {
                    comments = comments.subList(0, size);
                } else {
                    log.info("there is no next==");
                }
                List<Long> userIds = new ArrayList();
                for (Comment comment : comments) {
                    uids.add(comment.getUid());
                    comment.setUserNick(setUserShowName(comment.getUid()));
                    userIds.add(comment.getUid());
                }
                log.info(" did: " + did + " get uids is " + uids);

                List<User> users = userService.getObjectsByIds(userIds);
                model.addAttribute("users", users);
            }


            Integer totalPage = 1;
            Integer li = new Integer(String.valueOf(total));
            if (li > 0) {
                totalPage = (li - 1) / size + 1;
            }
            model.addAttribute("code", 0);
            model.addAttribute("comments", comments);
            model.addAttribute("page", page);
            model.addAttribute("Psize", size);
            model.addAttribute("total", total);
            model.addAttribute("size", comments.size());
            model.addAttribute("totalPage", totalPage);


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -1);
            return "/web-xiaoketang/myClass/subjectContent";
        }
        return "/web-xiaoketang/myClass/subjectContent";
    }


    /**
     * 小课堂评论——新增评论
     *
     * @Author 丶
     * @Description
     * @Param did：小课堂ID
     * @Param comment:评论内容
     * @Param atUid: @用户id
     * @Param type: 10 小课堂
     */
    @RequestMapping(value = "/a/u/classComment/{did}", method = RequestMethod.POST)
    public String addComment(HttpServletRequest request,
                             HttpServletResponse response, ModelMap model,
                             @PathVariable Long did, String comment, Long atUid, Integer type)
            throws Exception {

        log.info("update smallClass : did is " + did + " comment is " + comment + "==atUid==" + atUid + "==type==" + type);

        if (StringUtil.isEmpty(comment)) {
            model.addAttribute("code", -17009);
            log.info("param is null");
            return "/common/success";
        }
        //判斷type是否合法
        if (type != 10) {
            model.addAttribute("code", -60008);
            log.info("param type is error===" + type);
            return "/common/success";
        }

        try {
            ClassTimetable smallClass = classTimetableService.getObjectById(did);
            if (DataUtils.isNullOrEmpty(smallClass)) {
                model.addAttribute("code", -5000);
                log.info("no this smallClass");
                return "/common/success";
            }
            User user = (User) request.getAttribute("user");
            Long commentId = commentClass(smallClass, user, comment, atUid);
            model.addAttribute("code", 0);
            model.addAttribute("commentId", commentId);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add comment error,did is " + did + " comment is " + comment);
            model.addAttribute("code", -1);
        }
        return "/common-skill-service/comment/json/addComment";
    }

    //小課堂評論方法
    private Long commentClass(ClassTimetable smallClass, User user, String comment, Long atUid) throws Exception {
        Long uid = user.getId();
        Long did = smallClass.getId();

        Comment comment1 = new Comment();
        comment1.setUid(uid);
        //默認為-1 表示未回復他人
        if (atUid != null) {
            comment1.setAtUid(atUid);
        } else {
            comment1.setAtUid(-1L);
        }

        comment1.setComment(comment);
        comment1.setDid(did);
        //type為10表示小課堂
        comment1.setType(10);
        Long commentId = commentService.insert(comment1);
        //小課堂評論數+1
        Long now = System.currentTimeMillis();
        Long reply = smallClass.getReply();
        reply = reply + 1;
        smallClass.setReply(reply);
        smallClass.setLastReply(now);
        classTimetableService.update(smallClass);
        ClassTimetable newClass = classTimetableService.getObjectById(smallClass.getId());
        log.info("old comments is===" + smallClass.getReply() + ",now is===" + newClass.getReply());

        // 他相当于日报的主人
        User receiver = userService.getObjectById(smallClass.getTeachUid());

        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String time = df.format(new Date(smallClass.getArrangeDate()));

        log.info("compare id====== teachId is ==" + smallClass.getTeachUid() + "----   comment people uid is==" + uid);

        String userNick = setUserShowName(user.getId());
        log.info(" userNick:" + userNick);

        // 根据小課堂id查出小课堂的作者
        if (smallClass.getTeachUid() - uid == 0) {//自己評論自己
            log.info("sent to self=======");
            if (null != atUid) {
                if (uid - atUid == 0) {//評論者評論自己，沒有消息
                    log.info("update self");
                } else {//評論他人，那麼@他
                    //@回復人
                    if (atUid != null) {
                        User atUser = userService.getObjectById(atUid);
                        if (atUser == null) {
                            log.info("atUser is null");
                        } else {
                            //發送消息
                            String format = new SimpleDateFormat("yyyy年MM月dd号").format(smallClass.getArrangeDate());
                            Message message = new Message();
                            message.setReceiveId(atUid);
                            message.setType(Message.CLASS_TYPE);
                            message.setUnread(Message.Status_Unread);
                            message.setStatus(Message.STATUS_UNDELETE);
                            message.setTemplate(Message.TEMPLATE_5);
                            message.setCreateAt(System.currentTimeMillis());
                            message.setUpdateAt(System.currentTimeMillis());
                            message.setSendId(uid);
                            message.setRelationId(did);

                            String content = "XXX 回复了你对 《修真弟子 【 XXX 】| XXX 的 XXX 》的评论";
                            List<Map> list = new ArrayList<>();
                            Map<String, Object> map = new HashMap<>();
                            map.put("content", content);
                            Map<String, Object> map1 = new HashMap<>();
                            map1.put("childContent", setUserShowName(user.getId()));
                            map1.put("skip", true);
                            map1.put("uid", user.getId());
                            Map<String, Object> map2 = new HashMap<>();
                            map2.put("childContent", user.getNick());
                            map2.put("skip", true);
                            map2.put("uid", uid);
                            Map<String, Object> map3 = new HashMap<>();
                            map3.put("childContent", format);
                            map3.put("skip", false);
                            Map<String, Object> map4 = new HashMap<>();
                            map4.put("childContent", "小课堂");
                            map4.put("skip", true);
                            map4.put("lessonId", smallClass.getId());

                            list.add(map);
                            list.add(map1);
                            list.add(map2);
                            list.add(map3);
                            list.add(map4);
                            //把list转成json格式的String字符串
                            ObjectMapper json = new ObjectMapper();
                            String contentStr = json.writeValueAsString(list);
                            message.setContent(contentStr);
                            messageService.insert(message);
                            log.info("insert success==" + message);
                            //更新用户的未读消息数量和最后一条消息类型
                            atUser.setIsLook(user.getIsLook() + 1);
                            atUser.setLatestMsg(Message.DAILY_TYPE);//评论回复
                            userService.update(atUser);
                            log.info("receiver uid===" + atUid);
                        }
                    }
                }
            }
        } else {//在别人小课堂下
            log.info("send to other=========");
            if (null != atUid) {//回复评论
                if (uid - atUid == 0) {//如果是自己回复自己，不做处理
                } else {//回复别人的回复
                    //如果是回复小课堂主人，那么不处理
                    if (receiver.getId() - atUid == 0) {
                    } else {//如果不是小课堂主人，那么额外给小课堂主人一个通知
                        //发送系统消息
                        Message message = new Message();
                        message.setStatus(Message.STATUS_UNDELETE);
                        message.setReceiveName(receiver.getNick());
                        message.setSendName("admin");
                        message.setSendId(0L);
                        message.setReceiveId(receiver.getId());
                        message.setUnread(Message.Status_Unread);
                        message.setType(Message.DAILY_TYPE);
                        message.setTemplate(Message.TEMPLATE_5);
                        message.setRelationId(did);
                        String format = new SimpleDateFormat("yyyy年MM月dd号").format(smallClass.getArrangeDate());
                        String content = "您 XXX 的 XXX 已被 XXX 评论";
                        List<Map> list = new ArrayList<>();
                        Map<String, Object> map = new HashMap<>();
                        map.put("content", content);
                        Map<String, Object> map1 = new HashMap<>();
                        map1.put("childContent", format);
                        map1.put("skip", false);
                        Map<String, Object> map2 = new HashMap<>();
                        map2.put("childContent", "小课堂");
                        map2.put("skip", true);
                        map2.put("lessonId", smallClass.getId());
                        Map<String, Object> map3 = new HashMap<>();
                        map3.put("childContent", setUserShowName(user.getId()));
                        map3.put("skip", true);
                        map3.put("uid", user.getId());

                        list.add(map);
                        list.add(map1);
                        list.add(map2);
                        list.add(map3);

                        //把list转成json格式的String字符串
                        ObjectMapper json = new ObjectMapper();
                        String contentStr = json.writeValueAsString(list);
                        message.setContent(contentStr);
                        messageService.insert(message);
                        log.info("insert success==" + message);
                        //更新用户的未读消息数量和最后一条消息类型
                        receiver.setIsLook(user.getIsLook() + 1);
                        receiver.setLatestMsg(Message.DAILY_TYPE);//评论回复
                        userService.update(receiver);
                        log.info("receiver uid===" + atUid);
                    }
                    User atUser = userService.getObjectById(atUid);
                    if (atUser == null) {
                        log.info("atUser is null");
                    } else {
                        //發送消息
                        String format = new SimpleDateFormat("yyyy年MM月dd号").format(smallClass.getArrangeDate());
                        Message message = new Message();
                        message.setReceiveId(atUid);
                        message.setType(Message.CLASS_TYPE);
                        message.setUnread(Message.Status_Unread);
                        message.setStatus(Message.STATUS_UNDELETE);
                        message.setTemplate(Message.TEMPLATE_5);
                        message.setCreateAt(System.currentTimeMillis());
                        message.setUpdateAt(System.currentTimeMillis());
                        message.setSendId(uid);
                        message.setRelationId(did);
                        String content = "XXX回复了你对 《修真弟子 【 XXX 】| XXX的XXX》的评论";
                        List<Map> list = new ArrayList<>();
                        Map<String, Object> map = new HashMap<>();
                        map.put("content", content);
                        Map<String, Object> map1 = new HashMap<>();
                        map1.put("childContent", setUserShowName(user.getId()));
                        map1.put("skip", true);
                        map1.put("uid", user.getId());
                        Map<String, Object> map2 = new HashMap<>();
                        map2.put("childContent", user.getNick());
                        map2.put("skip", true);
                        map2.put("uid", uid);
                        Map<String, Object> map3 = new HashMap<>();
                        map3.put("childContent", format);
                        map3.put("skip", false);
                        Map<String, Object> map4 = new HashMap<>();
                        map4.put("childContent", "小课堂");
                        map4.put("skip", true);
                        map4.put("lessonId", smallClass.getId());

                        list.add(map);
                        list.add(map1);
                        list.add(map2);
                        list.add(map3);
                        list.add(map4);

                        //把list转成json格式的String字符串
                        ObjectMapper json = new ObjectMapper();
                        String contentStr = json.writeValueAsString(list);
                        message.setContent(contentStr);
                        messageService.insert(message);
                        log.info("insert success==" + message);
                        //更新用户的未读消息数量和最后一条消息类型
                        atUser.setIsLook(user.getIsLook() + 1);
                        atUser.setLatestMsg(Message.DAILY_TYPE);//评论回复
                        userService.update(atUser);
                    }
                }
            } else {
                //发送系统消息
                Message message = new Message();
                message.setStatus(Message.STATUS_UNDELETE);
                message.setReceiveName(receiver.getNick());
                message.setSendName("admin");
                message.setSendId(0L);
                message.setReceiveId(receiver.getId());
                message.setUnread(Message.Status_Unread);
                message.setType(Message.DAILY_TYPE);
                message.setTemplate(Message.TEMPLATE_5);
                message.setRelationId(did);
                String format = new SimpleDateFormat("yyyy年MM月dd号").format(smallClass.getArrangeDate());
                String content = "您XXX的XXX已被XXX评论";
                List<Map> list = new ArrayList<>();
                Map<String, Object> map = new HashMap<>();
                map.put("content", content);
                Map<String, Object> map1 = new HashMap<>();
                map1.put("childContent", format);
                map1.put("skip", false);
                Map<String, Object> map2 = new HashMap<>();
                map2.put("childContent", "小课堂");
                map2.put("skip", true);
                map2.put("lessonId", smallClass.getId());
                Map<String, Object> map3 = new HashMap<>();
                map3.put("childContent", setUserShowName(user.getId()));
                map3.put("skip", true);
                map3.put("uid", user.getId());

                list.add(map);
                list.add(map1);
                list.add(map2);
                list.add(map3);

                //把list转成json格式的String字符串
                ObjectMapper json = new ObjectMapper();
                String contentStr = json.writeValueAsString(list);
                message.setContent(contentStr);
                messageService.insert(message);
                log.info("insert success==" + message);
                //更新用户的未读消息数量和最后一条消息类型
                receiver.setIsLook(user.getIsLook() + 1);
                receiver.setLatestMsg(Message.DAILY_TYPE);//评论回复
                userService.update(receiver);
                log.info("receiver uid===" + atUid);
            }
        }
        return commentId;
    }

    //学院称谓
    public String setUserShowName(Long uid) {
        String userNick = null;
        try {

            //无名、散修和外门展示学号，只有内门及内门以上的用户展示昵称
            //有分院展示分院，有职业展示职业
            String branch = null;
            User user = userService.getObjectById(uid);
            if (DataUtils.isNotNullOrEmpty(user.getBranch())) {
                Long userBranch = user.getBranch().longValue();
                BranchInstitute branchDetail = branchInstituteService.getObjectById(userBranch);
                branch = branchDetail.getName() + "分院|";
            }
            log.info("user branch is:" + branch);
            String userOccupationName = null;
            long userNumber = user.getStudyNumber();
            int identity = user.getIdentity();
            log.info("identity is :" + identity);
            if (!user.getOid().equals(User.Occupation_None)) {
                Long userOid = user.getOid();
                Occupation userOccupation = occupationService.getObjectById(userOid);
                userOccupationName = userOccupation.getName().toUpperCase();
            }

            //10、无名弟子 20、散修弟子 30、外门弟子 40、内门弟子  50、首席弟子  55 荣耀师兄 60、真传弟子  70、修真长老

            if (identity == User.IDENTIFY_10) {
                userNick = "[" + User.IDENTIFY_10_str + "] " + user.getNick();
            } else if (identity == User.IDENTIFY_20) {
                userNick = "[" + User.IDENTIFY_20_str + "] " + (userOccupationName != null ? userOccupationName : "") + "-" + String.valueOf(userNumber);
            } else if (identity == User.IDENTIFY_30) {
                userNick = "[" + User.IDENTIFY_30_str + "] " + (userOccupationName != null ? userOccupationName : "") + "-" + String.valueOf(userNumber);
            } else if (identity == User.IDENTIFY_40) {
                userNick = "[" + (branch != null ? branch : "") + User.IDENTIFY_40_str + "] " + (userOccupationName != null ? userOccupationName : "") + "-" + user.getNick();
            } else if (identity == User.IDENTIFY_50) {
                userNick = "[" + (branch != null ? branch : "") + User.IDENTIFY_50_str + "] " + (userOccupationName != null ? userOccupationName : "") + "-" + user.getNick();
            } else if (identity == User.IDENTIFY_55) {
                userNick = "[" + (branch != null ? branch : "") + User.IDENTIFY_55_str + "] " + (userOccupationName != null ? userOccupationName : "") + "-" + user.getNick();
            } else if (identity == User.IDENTIFY_60) {
                userNick = "[" + (branch != null ? branch : "") + User.IDENTIFY_60_str + "] " + (userOccupationName != null ? userOccupationName : "") + "-" + user.getNick();
            } else if (identity == User.IDENTIFY_70) {
                userNick = "[" + (branch != null ? branch : "") + User.IDENTIFY_70_str + "] " + (userOccupationName != null ? userOccupationName : "") + "-" + user.getNick();
            }
        } catch (Throwable t) {
            log.error("error is ", t);
        }
        log.info("userNick  is:" + userNick);
        return userNick;
    }

    //任务转换
    //1转化为任务一、2转化为任务二
    public Map<Long, String> setTaskName() {
        Map<Long, String> taskNameList = new LinkedHashMap<Long, String>();
        try {
            List totalTaskList = taskService.getTaskIds(0, Integer.MAX_VALUE);
            log.info("totalTask=====" + totalTaskList);
            List<Task> taskList = taskService.getObjectsByIds(totalTaskList);
            for (Task task : taskList) {
                String taskName = task.getNum().toString();
                String[] s1 = {"零", "一", "二", "三", "四", "五", "六", "七", "八", "九"};
                String[] s2 = {"十", "百", "千", "万", "十", "百", "千", "亿", "十", "百", "千"};
                String result = "任务";
                int n = taskName.length();
                for (int i = 0; i < n; i++) {
                    int num = taskName.charAt(i) - '0';
                    if (i != n - 1 && num != 0) {
                        if (num == 1) {
                            result += s2[n - 2 - i];
                        } else {
                            result += s1[num] + s2[n - 2 - i];
                        }
                    } else {
                        if (num == 0) {
                        } else {
                            result += s1[num];
                        }
                    }
                }
                taskNameList.put(task.getNum(), result);
            }


        } catch (Throwable t) {
            log.error("error is ", t);
        }
        return taskNameList;
    }

    /**
     * 小课堂相关消息通知——jsp页面
     *
     * @param request
     * @param response
     * @param model
     * @param page
     * @param size
     * @param status
     * @param type
     * @param pid
     */
    @RequestMapping(value = "/l/receive/message/search", method = RequestMethod.GET)
    public String getReceiveMessageByType(HttpServletRequest request,
                                          HttpServletResponse response, ModelMap model, Integer page,
                                          Integer size, Integer status, String type, Long pid) throws Exception {

        //未登录返回-2，前端模态框提示用户重新登录
        Long uid = getUserFromCookieUtil.getUserFromCookie(request);
        log.info("userId is " + uid);
        if (DataUtils.isNullOrEmpty(uid)) {
            log.info("user no login");
            model.addAttribute("code", -2);
            return "/web-xiaoketang/message/messageList";
        }

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        try {
            status = 1;
            Map<String, Object> params = DynamicUtil.getMessageListParam1(status, uid, null, false);
            log.info(params + "===================================");
            List<Long> ids = messageService.getIdsByDynamicCondition(Message.class, params, start, size);
            List<Message> messages = messageService.getObjectsByIds(ids);
            log.info("messages====" + messages);

            Map<String, Object> totalParams = DynamicUtil.getMessageListParam1(status, uid, null, true);
            Object total = messageService.getObjectByDynamicCondition(Message.class, totalParams, 0, Integer.MAX_VALUE);
            log.info("total===" + total);

            //未读消息
            Map<String, Object> totalParamsUnread = DynamicUtil.getMessageListParam1(status, uid, 1, true);
            Object totalUnread = messageService.getObjectByDynamicCondition(Message.class, totalParamsUnread, 0, Integer.MAX_VALUE);
            log.info("totalUnread===" + totalUnread);

            if (null == ids) {
                return "/web-xiaoketang/message/messageList";
            }


            Integer totalPage = 1;
            Integer li = new Integer(String.valueOf(total));
            if (li > 0) {
                totalPage = (li - 1) / size + 1;
            }

            Long loginUserId = getUserFromCookieUtil.getUserFromCookie(request);

            model.addAttribute("messages", messages);
            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("pSize", size);
            model.addAttribute("total", total);
            model.addAttribute("totalUnread", totalUnread);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("size", messages.size());
            model.addAttribute("uid", uid);
            model.addAttribute("loginUid", loginUserId);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get occupationTypeRelation list error,page is  " + start + " , size "
                    + size);
            model.addAttribute("code", -1);
            return "/web-xiaoketang/message/messageList";
        }


        return "/web-xiaoketang/message/messageList";
    }


    /**
     * 小课堂相关消息通知
     *
     * @param request
     * @param response
     * @param model
     * @param page
     * @param size
     * @param status
     * @param type
     * @param pid
     */
    @RequestMapping(value = "/l/receive/message/classes", method = RequestMethod.GET)
    public String getClassesMessageByType(HttpServletRequest request,
                                          HttpServletResponse response, ModelMap model, Integer page,
                                          Integer size, Integer status, String type, Long pid) throws Exception {

        //未登录返回-2，前端模态框提示用户重新登录
        Long uid = getUserFromCookieUtil.getUserFromCookie(request);
        log.info("userId is " + uid);
        if (DataUtils.isNullOrEmpty(uid)) {
            log.info("user no login");
            model.addAttribute("code", -2);
            model.addAttribute("uid", uid);
            return "/common-skill-service/message/json/classesMessage";
        }


        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        int end = start + size - 1;

        log.info("receive message :  start = " + start + " , size=" + size + " , status = " + status + ", type = " + type);

        try {
            status = 1;
            Map<String, Object> params = DynamicUtil.getMessageListParam1(status, uid, null, false);
            log.info(params + "===================================");
            List<Long> ids = messageService.getIdsByDynamicCondition(Message.class, params, start, size);
            List<Message> messages = messageService.getObjectsByIds(ids);
            log.info("messages====" + messages);

            Map<String, Object> totalParams = DynamicUtil.getMessageListParam1(status, uid, null, true);
            Object total = messageService.getObjectByDynamicCondition(Message.class, totalParams, 0, Integer.MAX_VALUE);
            log.info("total===" + total);

            if (null == ids) {
                model.addAttribute("code", -7000);
                log.info("the user message is null");
                model.addAttribute("uid", uid);
                return "/common-skill-service/message/json/classesMessage";
            }

            //未读消息
            Map<String, Object> totalParamsUnread = DynamicUtil.getMessageListParam1(status, uid, 1, true);
            Object totalUnread = messageService.getObjectByDynamicCondition(Message.class, totalParamsUnread, 0, Integer.MAX_VALUE);
            log.info("totalUnread===" + totalUnread);

            Integer totalPage = 1;
            Integer li = new Integer(String.valueOf(total));
            if (li > 0) {
                totalPage = (li - 1) / size + 1;
            }

            Long loginUserId = getUserFromCookieUtil.getUserFromCookie(request);

            model.addAttribute("messages", messages);
            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("pSize", size);
            model.addAttribute("total", total);
            model.addAttribute("totalUnread", totalUnread);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("size", messages.size());
            model.addAttribute("uid", uid);
            model.addAttribute("loginUid", loginUserId);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get occupationTypeRelation list error,page is  " + start + " , size "
                    + size);
            model.addAttribute("code", -1);
            return "/common-skill-service/message/json/classesMessage";
        }
        return "/common-skill-service/message/json/classesMessage";
    }


    /**
     * 获取课堂列表（不需要用户登录的——如：课堂资料）主站要用
     *
     * @Author ruanshaonan
     * @Description
     * @Date 9:55 2018/6/28
     * @Param orderBy：缺省按用户点赞/收藏/时间排序 排序规则：1点赞数 2收藏数 3时间 4评论数 5查看数
     * @Param sort:排序类型 缺省按用户点赞/收藏/时间逆序排 0-逆序 1-正序
     * @Param speakStatus:小课堂状态 1：预告 2：未审核 3：未评级 4：已评级
     * @Param uid:用户id 如果是查找师弟课堂，则要把师弟的用户id，用逗号隔开，组成一个字符串传到后端
     * @Param status:是否上下架 0：未上架 1：上架
     * @Param oid:职业id
     * @Param tid:任务id
     * @Param level:小课堂等级
     * @Param thinkName:深度思考名称
     * @Param speakerId:主讲人id
     * @Param groupId:小组id
     * @Param type:要获取那种类型的数据："timetable"：获取课表   "classes"：获取小课堂
     * @Param page
     * @Param size
     */
    @RequestMapping(value = "/a/class/arrange/list/{type}", method = RequestMethod.GET)
    public String getclassTimetablesFront(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                          Integer orderBy, Integer sort, Integer speakStatus, String uid,
                                          Integer status, Integer oid, Integer tid, Integer level, String thinkName,
                                          Integer speakerId, Integer groupId, @PathVariable("type") String type,
                                          Long startTime, Long endTime, Integer page, Integer size)
            throws Exception {

        log.info("get classTimetable List=orderBy=" + orderBy + "=sort=" + sort + "=speakStatus=" + speakStatus
                + "=uid=" + uid + "=type=" + type + "=status=" + status + "=oid=" + oid + "=tid=" + tid
                + "=level=" + level + "=thinkName=" + thinkName + "=speakerId=" + speakerId
                + "==groupId==" + groupId + "==startTime==" + startTime + "==endTime==" + endTime
                + "==page==" + page + "==size==" + size);

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        String returnPage = null;
        try {
            //如果请求的是课堂列表，则需要把7天以外的排课过滤掉，前台课堂列表，
            // 只展示处于预告状态（发完预告消息）和已讲状态的课堂
            if (type.equals(ClassTimetable.TYPE_CLASSES)) {
                //当前日期0点的时间戳
                Long currentTimeZero = System.currentTimeMillis() / (1000 * 3600 * 24) * (1000 * 3600 * 24) - TimeZone.getDefault().getRawOffset();
                //当前日期0点的时间戳+7天
                //只搜索7天以内的课堂
                endTime = currentTimeZero + 24 * 60 * 60 * 1000 * 7 - 1;
            }
            Map<String, Object> classTimetableListParam = DynamicUtil.getClassIndexParam(orderBy, sort, speakStatus,
                    uid, status, oid, tid, level, thinkName, speakerId, groupId, startTime, endTime, false);
            log.info("classTimetableListParam=" + classTimetableListParam);
            Map<String, Object> totalParam = DynamicUtil.getClassIndexParam(orderBy, sort, speakStatus,
                    uid, status, oid, tid, level, thinkName, speakerId, groupId, startTime, endTime, true);
            Object total = classTimetableService.getObjectByDynamicCondition(ClassTimetable.class, totalParam,
                    0, Integer.MAX_VALUE);

            List<Long> ids = classTimetableService.getIdsByDynamicCondition(ClassTimetable.class,
                    classTimetableListParam, start, size);
            log.info("ids=" + ids.size());
            List<ClassTimetable> classArrangeList = classTimetableService.getObjectsByIds(ids);
            log.info("getClassTimetableList success=" + classArrangeList.size());

            //返回主讲人姓名
            List<Long> speakerIds = new ArrayList<>();
            //返回课题名称
            List<Long> thinkIds = new ArrayList<>();
            //返回小组名称
            List<Long> groupIds = new ArrayList<>();
            for (ClassTimetable classTimetable : classArrangeList) {
                speakerIds.add(classTimetable.getTeachUid());
                thinkIds.add(classTimetable.getThinkId());
                groupIds.add(classTimetable.getClassTeamId());
            }
            List<User> speakers = userService.getObjectsByIds(speakerIds);
            log.info("get speakers success=" + speakers.size());
            //分院
            List<Long> branches = new ArrayList<>();
            for (User speaker :  speakers){
                branches.add(Long.valueOf(speaker.getBranch()));
            }
            List<BranchInstitute> branchList = branchInstituteService.getObjectsByIds(branches);

            List<DeepThink> deepThinkList = deepThinkService.getObjectsByIds(thinkIds);
            log.info("get deep think success=" + deepThinkList.size());

            //获取课表列表时，返回小组信息，用户收藏信息，用户点赞信息
            if (type.equals(ClassTimetable.TYPE_TIMETABLE)) {
                List<ClassTeam> groups = classTeamService.getObjectsByIds(groupIds);
                log.info("get groups success=" + groups.size());

                //用户是否点赞过或者收藏过
                Long loginUserId = getUserFromCookieUtil.getUserFromCookie(request);
                Map<Long, Boolean> iflikeMap = new HashedMap(),
                        ifCollectionMap = new HashedMap();
                log.info(" login user Id = " + loginUserId);
                if (DataUtils.isNotNullOrEmpty(loginUserId)) {
                    Map<String, Object> paramRelation = DynamicUtil.getArticleRelationListParam(ids, loginUserId,
                            UserArticleRelation.TARGET_CLASS_TIMETABLE, false);
                    log.info("query relationId sql: " + paramRelation);
                    List<Long> relationIds = userArticleRelationService.getIdsByDynamicCondition(
                            UserArticleRelation.class, paramRelation, 0, Integer.MAX_VALUE);

                    if (CollectionUtils.isNotEmpty(relationIds)) {
                        log.info("relationIds has:" + relationIds);
                        List<UserArticleRelation> relationList = userArticleRelationService.getObjectsByIds(relationIds);

                        int relationSize = relationList.size();
                        for (int i = 0; i < relationSize; i++) {
                            UserArticleRelation relation = relationList.get(i);
                            Integer relationStatus = relation.getType();
                            log.info(" relation id = " + relation.getId() + " aid = " + relation.getAid() + " relationStatus = " + relationStatus);
                            Long aid = relation.getAid();

                            /* 替换掉旧值 */
                            log.info(" iflikeMap = " + iflikeMap + " ifCollectionMap = " + ifCollectionMap);
                            switch (relationStatus) {
                                case UserArticleRelation.STATUS_LOVE:
                                    iflikeMap.put(aid, true);
                                    break;
                                case UserArticleRelation.STATUS_COLLECTION:
                                    ifCollectionMap.put(aid, true);
                                    break;
                                default:
                                    break;
                            }
                            log.info(" iflikeMap = " + iflikeMap + " ifCollectionMap = " + ifCollectionMap);
                        }
                        for (int i = 0; i < classArrangeList.size(); i++) {
                            ClassTimetable classTimetable = classArrangeList.get(i);
                            Long aid = classTimetable.getId();
                            log.info(" aid = " + aid + " iflikeMap = " + iflikeMap + " ifCollectionMap = " + ifCollectionMap);
                            classTimetable.setIfLike(iflikeMap.get(aid) == null ? false : iflikeMap.get(aid));
                            classTimetable.setIfCollection(ifCollectionMap.get(aid) == null ? false : ifCollectionMap.get(aid));
                        }
                    }
                }

                model.addAttribute("groups", groups);
                returnPage = "/common-skill-service/classTimetable/json/classTimetableList";
            }

            if (type.equals(ClassTimetable.TYPE_CLASSES)) {
                returnPage = "/common-skill-service/classTimetable/json/classRecordList";
            }
            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("pSize", size);
            model.addAttribute("total", total);
            model.addAttribute("speakers", speakers);
            model.addAttribute("branchList", branchList);
            model.addAttribute("deepThinkList", deepThinkList);
            model.addAttribute("classArrangeList", classArrangeList);
        } catch (Throwable throwable) {
            throwable.printStackTrace();
            log.error("getclassTimetableList error=" + throwable.getMessage(),throwable);
            model.addAttribute("code", -1);
            return "/common/success";
        }
        return returnPage;
    }
}