package com.ptteng.common.skill.util;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author liutao
 */
public class ToMap {
  
  
  private static final Log log = LogFactory.getLog(ToMap.class);
  
  /**
   * 私有化构造器
   */
  private ToMap() {
  }
  
  /**
   * list转换map
   * 
   * @param list
   *        要转换的list
   * @param keyMethodName
   *        key的get方法
   * @param clazz
   *        list中每个元素的类对象
   * @return
   */
  public static <K, V> Map<K, V> list2Map(List<V> list, String keyMethodName, Class<V> clazz) {
    Map<K, V> map = new HashMap<>();
    if (CollectionUtils.isEmpty(list)) {
      log.info("argument list is empty");
      return map;
    }
    try {
      Method methodGetKey = clazz.getMethod(keyMethodName);
      for (int i = 0; i < list.size(); i++) {
        V value = list.get(i);
        @SuppressWarnings("unchecked")
        K key = (K) methodGetKey.invoke(value);
        map.put(key, value);
      }
    }
    catch (Exception ex) {
      log.error("list2Map error");
      log.error(ex);
    }
    return map;
  }
  
}
