package com.ptteng.common.skill.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.skill.model.Account;
import com.ptteng.common.skill.model.User;
import com.ptteng.common.skill.service.AccountService;
import com.ptteng.common.skill.service.UserService;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Account  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class AccountController {
	private static final Log log = LogFactory.getLog(AccountController.class);

	@Autowired
	private AccountService accountService;

	@Autowired
	private CookieUtil cookieUtil;


	@Autowired
	private UserService userService;

	    		
			
    /**
	 * 4.查看购买到的账号
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	
		@RequestMapping(value = "/a/u/account", method = RequestMethod.GET)
	public String getAccountIdsByAccountJsonList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page,
			Integer size,String account) throws Exception {


		if (page == null) {
			page = 1;

		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {
			User user = (User) request.getAttribute("user");
			Long uid = user.getId();
//			Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request,
//					com.qding.common.util.http.cookie.CookieUtil.USER_ID));
//			String buyer=String.valueOf(cookieUtil.getKeyIdentity(request,
//					CookieUtil.USER_NAME));

		//	User user = userService.getObjectById(uid);

			List<Long> ids = accountService.getAccountByMobile(user.getMobile(), 0, Integer.MAX_VALUE);
			List<Account> accountList = accountService.getObjectsByIds(ids);
			log.info("get account data is " + accountList.size());

			Integer total = accountService. countAccountByUid(uid);
			log.info("get account count is " + total);
            List<Long> unused = accountService.getAccountByStatus(2,0,Integer.MAX_VALUE);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			model.addAttribute("buyer",user.getNick());
			model.addAttribute("total", total);
            model.addAttribute("unused",unused.size());
			model.addAttribute("accountList", accountList);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get account list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -1);
		}

		return "/common-skill-service/account/json/accountListJson";
	}


	/**
	 * 返回账户详细信息
	 * @param id
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/account/{id}", method = RequestMethod.GET)
	public String getAccountJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {

			User user = (User) request.getAttribute("user");
			Long uid = user.getId();

			List<Long> ids = accountService.getAccountByMobile(user.getMobile(),0,Integer.MAX_VALUE);
			if (ids.contains(id)){
				Account account = accountService.getObjectById(id);
				log.info("get account data is " + account);

				model.addAttribute("code", 0);

				model.addAttribute("account", account);

			}else {

				model.addAttribute("code", -8003);
				return "/data/json";
			}

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get account error,id is  " + id);
			model.addAttribute("code", -1);
		}

		return "/common-skill-service/account/json/accountDetailJson";
	}

	@RequestMapping(value = "/web/a/account/{id}", method = RequestMethod.PUT)
	public String updateAccountJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Account account) throws Exception {
		
		log.info("update account : account= " + account);
		
		try {

			accountService.update(account);

			model.addAttribute("code", 0);

			model.addAttribute("account", account);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update account error,id is  " + account.getId());
			model.addAttribute("code", -1);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/web/a/account", method = RequestMethod.POST)
	public String addAccountJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Account account) throws Exception {
		
		log.info("update account : account= " + account);
		
		try { 
			account.setId(null);

			accountService.insert(account);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add account error ");
			model.addAttribute("code", -1);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/web/a/account/{id}", method = RequestMethod.DELETE)
	public String deleteAccountJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete account : id= " + id);
		try {
			accountService.delete(id);

			log.info("add account success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete account error,id is  " + id);
			model.addAttribute("code", -1);

		}

		return "/data/json";
	}
	
	
	@RequestMapping(value = "/web/a/multi/account", method = RequestMethod.GET)
	public String getMultiAccountJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			
		List<Long> idList = new ArrayList();	
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			List<Account> accountList = accountService.getObjectsByIds(idList);
			log.info("get  account data is " + accountList.size());

			model.addAttribute("code", 0);			
			model.addAttribute("total",accountList.size());

			model.addAttribute("accountList", accountList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get account error,id is  " + idList);
			model.addAttribute("code", -100000);
		}




		return "/common-skill-service/account/json/accountListJson";
	}
}