package com.ptteng.common.skill.controller;

import com.ptteng.common.skill.model.Iteration;
import com.ptteng.common.skill.model.Project;
import com.ptteng.common.skill.model.Team;
import com.ptteng.common.skill.service.IterationService;
import com.ptteng.common.skill.service.ProjectService;
import com.ptteng.common.skill.service.TeamService;
import com.ptteng.common.skill.util.DynamicUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Iteration  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class IterationController {
	private static final Log log = LogFactory.getLog(IterationController.class);

	@Autowired
	private IterationService iterationService;

	@Autowired
	private ProjectService projectService;

	@Autowired
	private TeamService teamService;




	
	//迭代列表
	@RequestMapping(value = "/a/iteration/search", method = RequestMethod.GET)
	public String getMultiIterationJson(HttpServletRequest request,
										HttpServletResponse response, ModelMap model, Integer page, Integer size,
										Long productId,String name,Long period,Integer status)
			throws Exception {
		log.info("name"+name+"status"+status+"page"+page+"size"+size+"productId"+productId+"time" +
				period);
		/* 1 默认分页 */
		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		try {
			//初始值
			Long total =0L;
			//动态查询
			Map<String,Object> paramList = DynamicUtil.getIterationListParam(productId,name,period,status,false);
			log.info("paramList size =" + paramList.size());
			//获取迭代Id列表
			List<Long> iterationsIdList = iterationService.getIdsByDynamicCondition(Iteration.class,paramList,start,size);
			//获取total
			Map<String,Object> paramCount = DynamicUtil.getIterationListParam(productId,name,period,status,true);
			List<Long> iterationsIdCount = iterationService.getIdsByDynamicCondition(Iteration.class,paramCount, 0, Integer.MAX_VALUE);
			if (CollectionUtils.isNotEmpty(iterationsIdCount)) {
				total = iterationsIdCount.get(0);
			}

			//获取迭代列表
			List<Iteration> iterationList = iterationService.getObjectsByIds(iterationsIdList);
			log.info("get  iteration data is " + iterationList.size());

			model.addAttribute("code", 0);
			model.addAttribute("total",total);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			model.addAttribute("iterationList", iterationList);

			//获取项目id列表
			List<Long> projectIdList = new ArrayList();
			int iterationIdSize= iterationsIdList.size();
			for (int i=0;i<iterationIdSize;i++){
				List<Long> projectIds=projectService.getProjectIdsByIterationIdOrderByCreateAt(iterationsIdList.get(i),0,Integer.MAX_VALUE);
				int projectIdsSize=projectIds.size();
				for (int j=0;j<projectIdsSize;j++){

					projectIdList.add(projectIds.get(j));
				}

			}
			//获取项目列表
			List<Project> projectList=projectService.getObjectsByIds(projectIdList);

			model.addAttribute("projectList", projectList);

			//获取小组id列表
			List<Long> teamIdList=new ArrayList();
			int projectSize=projectList.size();
			for (int k=0;k<projectSize;k++){
				Project project=projectList.get(k);
				teamIdList.add(project.getTid());
			}
			//获取小组列表
			List<Team> teams=teamService.getObjectsByIds(teamIdList);
			model.addAttribute("teams",teams);
		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get iteration list error");
			model.addAttribute("code", -1);
		}

		return "/common-skill-service/iteration/json/iterationListJson";
	}

	
}

