package com.ptteng.common.skill.util;

import com.qding.common.util.http.cookie.CookieUtil;
import com.qding.common.util.http.cookie.UserCryptUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by liangxj on 2017/1/13.
 */
public class GetUserFromCookieUtil {

    private static final Log log = LogFactory.getLog(GetUserFromCookieUtil.class);

    public static String SPLITTER_REGEX = "\\|";
    public static final String USER_ID = "userId";


    @Autowired
    private CookieUtil cookieUtil;

    public  Long getUserFromCookie(HttpServletRequest request){

        Cookie[] cookies = request.getCookies();
        log.info("get cookies  " + Arrays.asList(cookies));
        Long uid = cookieUtil.getID(request);
        if (uid == null) {
            String token = request.getParameter("token");
            if(null == token){
                token = request.getHeader("token");
            }
            log.info("token : " + token);
            if(StringUtils.isNotEmpty(token) ) {
                Map map = decodeCookie(token);
                if (null != map) {
                    uid = (Long) map.get(USER_ID);
                    if(null == uid ){
                        return null;
                    }else {
                        return uid;
                    }
                }else{
                    return null;
                }

            }else {
                return null;
            }

        }else {
            return uid;
        }
    }

    private static Map decodeCookie(String value) {
        if (StringUtils.isBlank(value))
            return null;
        try {
            String[] p = value.split(SPLITTER_REGEX);
            Long userId = new Long(p[0]);
            String crypt = p[1];
            String plainUserInfo = UserCryptUtil.userDecrypt(crypt);
            String userName = UserCryptUtil.getUserNameFromPlain(plainUserInfo);
            Long uid = UserCryptUtil.getUserIdFromPlain(plainUserInfo);
            if (userId.equals(uid)) {
                return getUserIdentity(userName, userId);
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error("Wrong cookie format: [" + value + "] message is:" + e.getMessage());
            return null;
        }

        return null;
    }


    public static Map getUserIdentity(String userName, Long userId) {
        Map map = new HashMap();
        map.put(CookieUtil.USER_NAME, userName);
        map.put(CookieUtil.USER_ID, userId);
        return map;
    }
}
