package com.ptteng.common.skill.controller;

import com.ptteng.common.skill.model.Constant;
import com.ptteng.common.skill.service.ConstantService;
import com.ptteng.common.skill.util.DynamicUtil;
import com.ptteng.common.skill.util.LogUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * Constant  crud
 * 
 * @author magenm
 * @Date 2214-4-16 13:43
 * 
 */
@Controller
public class ConstantController {
	private static final Log log = LogFactory.getLog(ConstantController.class);

	@Autowired
	private ConstantService constantService;

	@Autowired
	private CookieUtil cookieUtil;
	

	//1 搜索常量列表
	@RequestMapping(value = "/a/u/constant/search", method = RequestMethod.GET)
	public String searchConstantList(
			HttpServletRequest request, HttpServletResponse response, ModelMap model,
			String type,String name,String value, String comments,Long startAt, Long endAt,
			Integer page, Integer size)
			throws Exception {


		//打印入参
		log.info("============================================");
		String paramStr = LogUtil.convertParam("/a/u/constant/search  by==type", type, "name", name, "value", value,
				"comments", comments,  "startAt", startAt, "endAt", endAt, "page", page, "size", size);
		log.info(paramStr);

		//初始化page size start
		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		String pageStr = LogUtil.convertParam("page", page, "start", start, "size", size);
		log.info(pageStr);

		try {
			//初始值
			Long total = 0L;

			//动态查询-获取参数列表
			Map<String, Object> paramList = DynamicUtil.getConstantListParam(type, name, value, comments, startAt, endAt, false);
			log.info(" paramList size =  " + paramList.size());
			//获取list
			List<Long> constantIdList = constantService.getIdsByDynamicCondition(Constant.class, paramList, start, size);
			if (CollectionUtils.isEmpty(constantIdList)) {
				log.info(" constantIdList is null ");
			} else {
				log.info(" constantIdList size =  " + constantIdList.size());
			}
			//获取total
			Map<String, Object> paramCount = DynamicUtil.getConstantListParam(type, name, value, comments, startAt, endAt, true);
			log.info("get param:" + paramCount);
			List<Long> constantIdCount = constantService.getIdsByDynamicCondition(Constant.class, paramCount, 0, Integer.MAX_VALUE);
			log.info("get constantIdCount:" + constantIdCount.size());
			if (CollectionUtils.isNotEmpty(constantIdCount)) {
				total = constantIdCount.get(0);
			}

			//获取constantList
			List<Constant> constantList = constantService.getObjectsByIds(constantIdList);


			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			model.addAttribute("total", total);
			model.addAttribute("constantList", constantList);


		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get constant list error,page is " + page + " , size " + size);
			// for test
			ModelMap code = model.addAttribute("code", -1);
		}

		return "/common-skill-service/constant/json/constantListJson";
	}





}

