/*
package com.ptteng.common.skill.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.skill.model.*;
import com.ptteng.common.skill.service.*;
import com.ptteng.common.skill.util.DataValidatorUtil;
import com.ptteng.common.skill.util.DynamicUtil;
import com.ptteng.common.skill.util.GetUserFromCookieUtil;
import com.qding.common.util.DataUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

*/
/**
 * Record  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 *//*

@Controller
public class RecordController {

    private static final Log log = LogFactory.getLog(RecordController.class);

    @Autowired
    private RecordService recordService;

    @Autowired
    private RecordLogService recordLogService;

    @Autowired
    private UserService userService;

    @Autowired
    private ProvincesService provincesService;

    @Autowired
    private CitiesService citiesService;

    @Autowired
    private CountiesService countiesService;

    @Autowired
    private SchoolService schoolService;

    @Autowired
    private MajorService majorService;

    @Resource
    private GetUserFromCookieUtil getUserFromCookieUtil;

    */
/**
     * @return recordID
     * @Description: 新建档案
     * @param: request 请求对象
     * @param: model 模型对象
     * @param: record 要创建的档案详情
     *//*

    @RequestMapping(value = "/a/u/record", method = RequestMethod.POST)
    public String createNewRecord(HttpServletRequest request, ModelMap model, Record record) {

        log.info("POST /a/u/record: prepare to create new record: " + record);

        if (!DataValidatorUtil.checkRecord(record)) {
            log.info("params error");
            model.addAttribute("code", -1001);
            return "/common/failure";
        }

        try {
            Long uid = record.getUid();
            Long userId = getUserFromCookieUtil.getUserFromCookie(request);
            if (!ObjectUtils.equals(userId, uid)) {
                log.info("no permission: can't create record for other");
                model.addAttribute("code", -38001); //不允许为他人创建档案
                return "/common/failure";
            }

            User u = userService.getObjectById(uid);
            if (DataUtils.isNullOrEmpty(u)) {
                log.info("create record failure, because user in record is not exist, uid = " + record.getUid());
                model.addAttribute("code", -38002); //新建档案失败，该学员不存在
                return "/common/failure";
            }

            if (u.getIdentity() < User.IDENTIFY_40) {
                log.info("current user has no permission to create record: user's identity: " + u.getIdentity());
                model.addAttribute("code", -38020); //个人档案功能只对内门弟子开放
                return "/common/failure";
            }

            Long rid = recordService.getRecordIdByUidOrderByCreateAt(uid);
            if (DataUtils.isNotNullOrEmpty(rid)) {
                log.info("can not create record repeatedly，current user's recordId = " + rid);
                model.addAttribute("code", -38003); //不允许重复创建档案
                return "/common/failure";
            }

            record.setSchoolType(getSchoolType(record.getSchool()));
            record.setStatus(Record.STATUS_APPLYING);
            record.setCreateBy(uid);
            record.setUpdateBy(uid);
            Long recordId = recordService.insert(record);
            log.info("insert new record success, recordId = " + recordId);

            //内门弟子新建档案之后，更新user表的record_status字段
            User user = userService.getObjectById(userId);
            user.setRecordStatus(Record.STATUS_APPLYING);
            boolean update = userService.update(user);
            log.info("update user's filed record_status result: " + update);

            model.addAttribute("code", 0);
            model.addAttribute("id", recordId);

        } catch (Exception e) {
            e.printStackTrace();
            e.getMessage();
            log.info("insert new record failure");
            model.addAttribute("code", -38000); //新建档案失败，请稍后再尝试
        }
        return "/common/insert";
    }

    */
/**
     * @return record和最新的一条审核记录
     * @Description: 查看本人档案
     * @param: request 请求对象
     * @param: model 模型对象
     *//*

    @RequestMapping(value = "/a/u/record", method = RequestMethod.GET)
    public String getMyRecord(HttpServletRequest request, ModelMap model) {

        Long uid = getUserFromCookieUtil.getUserFromCookie(request);
        log.info("GET /a/u/record: user want to get his record, uid = " + uid);


        try {
            User user = userService.getObjectById(uid);
            if (DataUtils.isNullOrEmpty(user)) {
                log.info("the user is not exist whose uid = " + uid);
                model.addAttribute("code", -2000); //无此用户
                return "/common/failure";
            }

            if (user.getIdentity() < User.IDENTIFY_40) {
                log.info("current user has no permission to check record: user's identity: " + user.getIdentity());
                model.addAttribute("code", -38020); //个人档案功能只对内门弟子开放
                return "/common/failure";
            }

            Long rid = recordService.getRecordIdByUidOrderByCreateAt(uid);
            if (DataUtils.isNullOrEmpty(rid)) {
                log.info("current user never commit his record");
                model.addAttribute("code", -38004); //尚未提交档案
                return "/common-skill-service/record/json/recordAndLogJson";
            }

            Record record = recordService.getObjectById(rid);
            log.info("current user's record = " + record);

            List<Long> recordLogIds = recordLogService.getRecordLogIdsByUidOrderByCreateAt(uid, 0, Integer.MAX_VALUE);
            log.info("get current user's record-log success, size = " + recordLogIds.size());
            if (!CollectionUtils.isEmpty(recordLogIds)) {
                log.info("the newest record-log id = " + recordLogIds.get(0));
                RecordLog recordLog = recordLogService.getObjectById(recordLogIds.get(0));
                log.info("get current user's newest record-log success: " + recordLog);
                model.addAttribute("recordLog", recordLog);
            }

            model.addAttribute("code", 0);
            model.addAttribute("record", record);

        } catch (Exception e) {
            e.printStackTrace();
            e.getMessage();
            log.info("get record failure, try again later");
            model.addAttribute("code", -38005);
        }
        return "/common-skill-service/record/json/recordAndLogJson";
    }

    */
/**
     * @param record 档案要修改的信息
     * @return success/failure
     * @Description: 修改档案
     * @param: request 请求对象
     * @param: model 模型对象
     *//*

    @RequestMapping(value = "/a/u/record", method = RequestMethod.PUT)
    public String modifyMyRecord(HttpServletRequest request, ModelMap model, Record record, String a) {

        log.info("PUT /a/u/record: prepare to set record like:" + record);

        if (!DataValidatorUtil.checkRecord(record)) {
            log.info("params error");
            model.addAttribute("code", -1001);
            return "/common/failure";
        }

        try {
            Long userId = getUserFromCookieUtil.getUserFromCookie(request);
            log.info("current userId: " + userId);
            if (DataUtils.isNotNullOrEmpty(userId)) {
                User user = userService.getObjectById(userId);
                if (user.getIdentity() < User.IDENTIFY_40) {
                    log.info("current user has no permission to modify record: user's identity: " + user.getIdentity());
                    model.addAttribute("code", -38020); //个人档案功能只对内门弟子开放
                    return "/common/failure";
                }
            }

            //先判断该档案是否存在
            Long rid = record.getId();
            if (DataUtils.isNullOrEmpty(rid)) {
                log.info("no such record which id = " + rid);
                model.addAttribute("code", -38007);
                return "/common/failure";
            }

            Record realRecord = recordService.getObjectById(rid);
            log.info("record before modify: " + realRecord);
            if (DataUtils.isNullOrEmpty(realRecord)) {
                log.info("no such record which id = " + rid);
                model.addAttribute("code", -38007);
                return "/common/failure";
            }

            //再判断是不是本人的档案 && 不可以修改他人的档案
            if (!ObjectUtils.equals(userId, record.getUid()) || !ObjectUtils.equals(userId, realRecord.getUid())
                    || !ObjectUtils.equals(realRecord.getUid(), record.getUid())) {
                log.info("can not modify other's record: current userId = " + userId + ", uid-in-record = " + record.getUid()
                        + "uid-in-realRecord = " + realRecord.getUid());
                model.addAttribute("code", -38008);
                return "/common/failure";
            }

            //档案的状态为“申请中”或“已存档”时，不可修改。只有状态为“驳回”才可以修改
            if (!realRecord.getStatus().equals(Record.STATUS_REFUSE)) {
                log.info("cant not modify, record status before modify: " + realRecord.getStatus() + " not equals" + Record.STATUS_REFUSE);
                model.addAttribute("code", -38009);
                return "/common/failure";
            }

            // 并且，还要统一设置编辑后的status为“申请中”
            realRecord.setAvatar(record.getAvatar());
            realRecord.setName(record.getName());
            realRecord.setSex(record.getSex());
            realRecord.setIdentityNum(record.getIdentityNum());
            realRecord.setBornAt(record.getBornAt());
            realRecord.setProvince(record.getProvince());
            realRecord.setCity(record.getCity());
            realRecord.setCounty(record.getCounty());
            realRecord.setEducatedStartAt(record.getEducatedStartAt());
            realRecord.setEducatedEndAt(record.getEducatedEndAt());
            realRecord.setGrade(record.getGrade());
            realRecord.setSchool(record.getSchool());
            realRecord.setSchoolType(getSchoolType(record.getSchool()));
            realRecord.setMajor(record.getMajor());
            realRecord.setIsWork(record.getIsWork());
            realRecord.setWorkExp(record.getWorkExp());
            realRecord.setContactName(record.getContactName());
            realRecord.setContactRelation(record.getContactRelation());
            realRecord.setContactMobile(record.getContactMobile());
            realRecord.setCardNum(record.getCardNum());
            realRecord.setBank(record.getBank());
            realRecord.setSource(record.getSource());
            realRecord.setIdentityFrontUrl(record.getIdentityFrontUrl());
            realRecord.setIdentityReverseUrl(record.getIdentityReverseUrl());
            realRecord.setIsLoan(record.getIsLoan());
            realRecord.setHouseholdRegisterUrl(record.getHouseholdRegisterUrl());
            realRecord.setStatus(Record.STATUS_APPLYING);
            realRecord.setUpdateBy(userId);
            recordService.update(realRecord);

            model.addAttribute("code", 0);

        } catch (Exception e) {
            e.printStackTrace();
            e.getMessage();
            log.info("modify record failure");
            model.addAttribute("code", -38006); //修改档案失败，请稍后再尝试
        }
        return "/common/success";
    }

    */
/**
     * @return provincesList、citiesList、countiesList
     * @Description: 获取全国各省市区县数据
     * @param: model
     *//*

    @RequestMapping(value = "/a/u/area/list", method = RequestMethod.GET)
    public String getAreaList(ModelMap model) {

        log.info("GET /a/u/area/list");

        try {
            List<Long> provincesIds = provincesService.getProvincesIds(0, Integer.MAX_VALUE);
            log.info("get provincesIds size = " + provincesIds.size());

            List<Long> citiesIds = citiesService.getCitiesIds(0, Integer.MAX_VALUE);
            log.info("get citiesIds  size = " + citiesIds.size());

            List<Long> countiesIds = countiesService.getCountiesIds(0, Integer.MAX_VALUE);
            log.info("get countiesIds size = " + countiesIds.size());

            if (CollectionUtils.isEmpty(provincesIds) || CollectionUtils.isEmpty(citiesIds) || CollectionUtils.isEmpty(countiesIds)) {
                log.info("get area failure");
                model.addAttribute("code", -38010); //省市县数据不存在
                return "/common/failure";
            }

            List<Provinces> provincesList = provincesService.getObjectsByIds(provincesIds);
            log.info("get provincesList success, size = " + provincesList.size());

            List<Cities> citiesList = citiesService.getObjectsByIds(citiesIds);
            log.info("get citiesList success, size = " + citiesList.size());

            List<Counties> countiesList = countiesService.getObjectsByIds(countiesIds);
            log.info("get countiesList success, size = " + countiesList.size());

            model.addAttribute("code", 0);
            model.addAttribute("provinceList", provincesList);
            model.addAttribute("cityList", citiesList);
            model.addAttribute("countyList", countiesList);

        } catch (Exception e) {
            e.printStackTrace();
            e.getMessage();
            log.info("get areas failure, try again later");
            model.addAttribute("code", -38011);
        }
        return "/common-skill-service/provinces/json/areaListJson";
    }

    */
/**
     * @return 全国所有省份的数据
     * @Description: 获取全国各省数据
     * @param: null
     *//*

    @RequestMapping(value = "/a/u/province/list", method = RequestMethod.GET)
    public String getProvinceList(ModelMap model) {

        log.info("GET /a/u/province");

        try {
            List<Long> provincesIds = provincesService.getProvincesIds(0, Integer.MAX_VALUE);
            log.info("get provincesIds size = " + provincesIds.size());

            if (CollectionUtils.isEmpty(provincesIds)) {
                log.info("get provinceList failure");
                model.addAttribute("code", -38012); //省数据不存在
                return "/common/failure";
            }

            List<Provinces> provincesList = provincesService.getObjectsByIds(provincesIds);
            log.info("get provincesList success, size = " + provincesList.size());

            model.addAttribute("code", 0);
            model.addAttribute("total", provincesList.size());
            model.addAttribute("provincesList", provincesList);

        } catch (Exception e) {
            e.printStackTrace();
            e.getMessage();
            log.info("get provinceList failure, try again later");
            model.addAttribute("code", -38013);
        }
        return "/common-skill-service/provinces/json/provincesListJson";
    }

    */
/**
     * @return 某省的所有市数据
     * @Description: 获取某省的市数据
     * @param: provinceId 某省ID
     *//*

    @RequestMapping(value = "/a/u/city/list", method = RequestMethod.GET)
    public String getCityList(ModelMap model, Long provinceId) {

        log.info("GET /a/u/city/list: which provinceId = " + provinceId);

        try {
            List<Long> citiesIds = citiesService.getCitiesIdsByProvinceIdOrderByCreateAt(provinceId, 0, Integer.MAX_VALUE);
            log.info("get citiesIds  size = " + citiesIds.size());

            if (CollectionUtils.isEmpty(citiesIds)) {
                log.info("get cityList failure");
                model.addAttribute("code", -38014); //市数据不存在
                return "/common/failure";
            }

            List<Cities> citiesList = citiesService.getObjectsByIds(citiesIds);
            log.info("get citiesList success, size = " + citiesList.size());


            model.addAttribute("code", 0);
            model.addAttribute("total", citiesList.size());
            model.addAttribute("citiesList", citiesList);

        } catch (Exception e) {
            e.printStackTrace();
            e.getMessage();
            log.info("get cityList failure, ty again later");
            model.addAttribute("code", -38015);
        }
        return "/common-skill-service/cities/json/citiesListJson";
    }

    */
/**
     * @return 某市的所有区县数据
     * @Description: 获取某市的区县数据
     * @param: cityId 某市ID
     *//*

    @RequestMapping(value = "/a/u/county/list", method = RequestMethod.GET)
    public String getCountyList(ModelMap model, Long cityId) {

        log.info("GET /a/u/county/list: which cityId = " + cityId);

        try {

            List<Long> countiesIds = countiesService.getCountiesIdsByCityIdOrderByCreateAt(cityId, 0, Integer.MAX_VALUE);
            log.info("get countiesIds size = " + countiesIds.size());

            if (CollectionUtils.isEmpty(countiesIds)) {
                log.info("get countyList failure");
                model.addAttribute("code", -38016); //县数据不存在
                return "/common/failure";
            }

            List<Counties> countiesList = countiesService.getObjectsByIds(countiesIds);
            log.info("get countiesList success, size = " + countiesList.size());

            model.addAttribute("code", 0);
            model.addAttribute("total", countiesList.size());
            model.addAttribute("countiesList", countiesList);

        } catch (Exception e) {
            e.printStackTrace();
            e.getMessage();
            log.info("get cityList failure, ty again later");
            model.addAttribute("code", -38017);
        }
        return "/common-skill-service/counties/json/countiesListJson";
    }

    */
/**
     * @return 10条学校名称，按数据表id递增取前10
     * @Description: 按名称查找学校-模糊搜索
     * @param: name 学校名称
     *//*

    @RequestMapping(value = "/a/u/school/search", method = RequestMethod.GET)
    public String getSchoolByName(ModelMap model, String name) {

        log.info("GET /a/u/school/search: prepare to get school list by name: " + name);

        if (StringUtils.isEmpty(name)) {
            log.info("params are null: name = " + name);
            model.addAttribute("code", -1000);
            return "/common/failure";
        }

        try {

            Map<String, Object> params = DynamicUtil.getSchoolByName(name);
            log.info("get params:" + params);

            int size = 10;  //默认size=10
            List<Long> schoolIds = schoolService.getIdsByDynamicCondition(School.class, params, 0, size);
            log.info("get schoolIds size = " + schoolIds.size());
            if (CollectionUtils.isEmpty(schoolIds)) {
                model.addAttribute("code", -38018);
                return "/common/failure";
            }

            List<School> schoolList = schoolService.getObjectsByIds(schoolIds);
            log.info("get schoolList size = " + schoolList.size());

            model.addAttribute("code", 0);
            model.addAttribute("total", schoolList.size());
            model.addAttribute("schoolList", schoolList);

        } catch (Exception e) {
            e.printStackTrace();
            e.getMessage();
            log.info("get school failure, try again later");
            model.addAttribute("code", -38019);
        }
        return "/common-skill-service/school/json/schoolListJson";
    }


    //专业联想
//    @RequestMapping(value = "/a/u/major/search", method = RequestMethod.GET)
//    public String getMajorByName(ModelMap model, String major) {
//
//        log.info("GET /a/u/major: get majorList by params: major = " + major);
//
//        if (StringUtils.isEmpty(major)) {
//            log.info("param is null");
//            model.addAttribute("code", -1000);
//            return "/common/failure";
//        }
//
//        try {
//
//
//
//        } catch (Exception e) {
//            e.printStackTrace();
//            e.getMessage();
//            log.info();
//            model.addAttribute("code", );
//        }
//
//    }


    */
/**
     * @return 学校类型
     * @Description: 根据学校名返回学校的类型
     * @param: schoolName 学校名称
     *//*

    private Integer getSchoolType(String schoolName) throws ServiceException, ServiceDaoException {
        Long schoolId = schoolService.getSchoolIdByName(schoolName);
        if (DataUtils.isNotNullOrEmpty(schoolId)) {
            School school = schoolService.getObjectById(schoolId);
            return school.getSchoolType();
        } else {
            return School.SCHOOL_TYPE_NORMAL;
        }
    }

}

*/
