package com.ptteng.common.skill.controller;

import com.ptteng.common.skill.model.Ctype;
import com.ptteng.common.skill.service.CtypeService;
import org.apache.commons.logging.Log;
import com.ptteng.common.skill.util.DynamicUtil;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * Created by Master on 2017/7/14.
 */
@Controller
public class CtypeController {
    private static final Log log = LogFactory.getLog(CtypeController.class);

    @Autowired
    private CtypeService ctypeService;
    /**
     * @param page;
     * @param size;
     * @param status;
     * @param id;
     * @param title;
     * @param createStartAt;
     * @param createEndAt;
     * @param createBy;
     * @return /common-skill-service/ctype/json/ctypeListJson；
     * @throws Exception；
     */

    //卡券类型列表
    @RequestMapping(value = "/a/u/cardType/search", method = RequestMethod.GET)
    public String getCtypeIdsByStatusOrderByCreateAtJsonList(HttpServletRequest request,
                                                             HttpServletResponse response, ModelMap model, Integer page, Integer size, Integer status,Long id, String title,
                                                             Long createStartAt, Long createEndAt, String createBy
    ) throws Exception {


        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("pageList : page= " + start + " , size=" + size + " , status=" + status + " , id=" + id + " , title=" + title + " , createStartAt=" + createStartAt  + " , createEndAt=" + createEndAt+
                 " , createBy=" + createBy);

        try {
            Map<String, Object> param = DynamicUtil.getCardsTypeQueryListParam(title, id, status, createStartAt, createEndAt, createBy, false);
            log.info("card params is: " + param);

            List<Long> ids= ctypeService.getIdsByDynamicCondition(Ctype.class,param,start,size);
            log.info("get Ctype size is " + ids.size());

            if (ids.isEmpty()){
                model.addAttribute("code", 0);
                model.addAttribute("page", page);
                model.addAttribute("size", size);
                model.addAttribute("total", 0);
                model.addAttribute("ctypeList", ids);

                return "/common-skill-service/ctype/json/ctypeListJson";
            }

            List<Ctype> ctypeList = ctypeService.getObjectsByIds(ids);


            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);

            model.addAttribute("total", ctypeList.size());

            model.addAttribute("ctypeList", ctypeList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get ctype list error,page is  " + start + " , size "
                    + size);
            // for test
            model.addAttribute("code", -100000);
        }

        return "/common-skill-service/ctype/json/ctypeListJson";
    }
}
