package com.ptteng.common.skill.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.StringUtil;
import com.ptteng.common.skill.model.*;
import com.ptteng.common.skill.service.*;
import com.ptteng.common.skill.util.CheckDataUtil;
import com.ptteng.common.skill.util.DynamicUtil;
import com.qding.common.util.HttpClientUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

import static com.ptteng.common.skill.model.Classes.Status_NotFull;

/**
 * Classes crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class ClassesController {
    private static final Log log = LogFactory.getLog(ClassesController.class);

    StringBuilder timeBuf = new StringBuilder();

    @Autowired
    private ClassesService classesService;

    @Autowired
    private MessageService messageService;

    @Autowired
    private UserClassRelationService userClassRelationService;

    @Autowired
    private UserService userService;

    @Autowired
    private OccupationService occupationService;

    @Autowired
    private CookieUtil cookieUtil;

    @Autowired
    private ConstantService constantService;
    @Autowired
    private TeacherService teacherService;
    @Autowired
    private BranchInstituteService branchInstituteService;
    /**
     * @param
     * @return
     */

    // 14.获取班级详情
    @RequestMapping(value = "/a/classes/detail", method = RequestMethod.GET)
    public String classesDetail(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long[] cid) throws Exception {

        log.info("============================================");
        log.info("cid is " + cid);

        List<Long> cidList = new ArrayList();
        List<Classes> classesList = new ArrayList();


        try {
            if (cid == null) {
                log.info("not get any data ");
                model.addAttribute("code", -1000);
                return "/common/success";

            } else {

            }


            cidList = Arrays.asList(cid);
            log.info(cidList + " want get detail info ");
            classesList = classesService.getObjectsByIds(cidList);
            log.info("get classes data is " + classesList.size());

            Set<Long> allUserIDS = new HashSet<Long>();
            Set<Long> allRelationIDS = new HashSet<Long>();
            Set<Long> occupatoins = new HashSet<Long>();

            for (Classes classes : classesList) {
                Long classesID = classes.getId();

                List<Long> relationIDS = this.userClassRelationService.getUserClassRelationIdsByCid(classesID, 0, Integer.MAX_VALUE);
                allRelationIDS.addAll(relationIDS);
                occupatoins.add(classes.getOid());

            }

            log.info(cidList + "  get occupations  " + occupatoins.size());

            List<UserClassRelation> relations = this.userClassRelationService.getObjectsByIds(new ArrayList(allRelationIDS));
            log.info(cidList + "  get relations  " + relations.size());
            Map<Long, List<UserClassRelation>> cid_relations = new HashMap<Long, List<UserClassRelation>>();
            for (UserClassRelation relation : relations) {
                allUserIDS.add(relation.getUid());

                if (cid_relations.containsKey(relation.getCid())) {

                } else {
                    cid_relations.put(relation.getCid(), new ArrayList<UserClassRelation>());
                }
                List<UserClassRelation> userIDS = cid_relations.get(relation.getCid());
                userIDS.add(relation);
            }


            List<User> users = this.userService.getObjectsByIds(new ArrayList<Long>(allUserIDS));
            if(CollectionUtils.isEmpty(users)){

            }else {
                DynamicUtil.checkUserGraduateStatus(users);
            }

            log.info(cidList + "  get users  " + users.size());

            List<Occupation> occupationList = this.occupationService.getObjectsByIds(new ArrayList<Long>(occupatoins));
            log.info(cidList + "  get occupationList  " + occupationList.size());
            model.addAttribute("code", 0);
            model.addAttribute("userList", users);
            model.addAttribute("relationList", relations);
            model.addAttribute("classesList", classesList);
            model.addAttribute("occupationList", occupationList);
            model.addAttribute("cid_relations", cid_relations);


        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get classes error,id is  " + cidList);
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/classes/json/classesDetailJson";
    }

    // 14.获取班级简单详情
    @RequestMapping(value = "/a/class/simpleDetail", method = RequestMethod.GET)
    public String classesSimpleDetail(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long[] cid)
            throws Exception {
        log.info("cid is " + cid);

        try {
            if (cid == null) {
                log.info("not get any data ");
                model.addAttribute("code", -1000);
                return "/common/success";
            }

            List<Long> cidList = Arrays.asList(cid);
            log.info(cidList + " want get detail info ");
            List<Classes> classesList = classesService.getObjectsByIds(cidList);
            log.info("get classes data is " + classesList.size());

            model.addAttribute("code", 0);
            model.addAttribute("classesList", classesList);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get classes error,id is  " + cid);
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/classes/json/classesListJson";
    }

    /**
     * @param
     * @return
     */

    // 15.获取班级列表
    @RequestMapping(value = "/a/classes/search/query", method = RequestMethod.GET)
    public String occupationClassesList(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long oid, Long uid,
                                        String type, Long status, Integer page,Integer branch, Integer size) throws Exception {

        log.info("============================================");
        log.info("oid is " + oid + " uid " + uid + " type " + type + "status " + status + " size " + size + " page " + page);

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }


        List<Classes> classesList = new ArrayList();
        List<Occupation> occupationList = new ArrayList();
        List<UserClassRelation> relationList = new ArrayList();
        List<BranchInstitute> branches = new ArrayList<>();

        boolean next = false;

        try {

            Long totalSize = 0L;

            Map<String, Object> param = DynamicUtil.getClassesListParam(oid, uid, type, status, branch,false);

            List<Long> ids = this.classesService.getIdsByDynamicCondition(Classes.class, param, start, size);
            if (CollectionUtils.isEmpty(ids)) {
                log.info("classes ids is null");
            } else {
                classesList = this.classesService.getObjectsByIds(ids);
                log.info("oid is " + oid + " uid " + uid + " type " + type + "status " + status + " size " + size + " page " + page
                        + "get classes size is  " + classesList.size());

                Map<String, Object> cntParam = DynamicUtil.getClassesListParam(oid, uid, type, status, branch, true);
                totalSize = classesService.getIdsByDynamicCondition(Classes.class, cntParam, 0, Integer.MAX_VALUE).get(0);
                log.info("oid is " + oid + " uid " + uid + " type " + type + "status " + status + " size " + size + " page " + page
                        + "get all size is  " + classesList.size());

                if (totalSize > start + size) {
                    next = true;
                }

                Set<Long> oids = new HashSet();
                List<Long> branchIds = new ArrayList<>();
                for (Classes classes : classesList) {
                    oids.add(classes.getOid());
                    if (classes.getBranch() != null) {
                          branchIds.add(classes.getBranch().longValue());
                    } else {
                        log.info("This classes branch is null , id is " + classes.getId());
                    }
                }

                occupationList = this.occupationService.getObjectsByIds(new ArrayList(oids));
                totalSize = classesService.getIdsByDynamicCondition(Classes.class, cntParam, 0, Integer.MAX_VALUE).get(0);
                log.info("oid is " + oid + " uid " + uid + " type " + type + "status " + status + " size " + size + " page " + page
                        + "get all occupationList size is  " + occupationList.size());
                if (branchIds.size() > 0) {
                    branches = branchInstituteService.getObjectsByIds(branchIds);
                } else {
                    log.info("branches size is 0");
                }

                if (uid != null) {
                    List<Long> relationIDS = this.userClassRelationService.getUserClassRelationIdsByUid(uid, 0, Integer.MAX_VALUE);
                    if (CollectionUtils.isEmpty(relationIDS)) {

                    } else {
                        relationList = this.userClassRelationService.getObjectsByIds(relationIDS);
                    }

                }
                log.info("oid is " + oid + " uid " + uid + " type " + type + "status " + status + " size " + size + " page " + page
                        + "get all relations size is  " + relationList.size());

            }
            model.addAttribute("code", 0);
            model.addAttribute("classesList", classesList);
            model.addAttribute("occupationList", occupationList);
            model.addAttribute("relationList", relationList);
            model.addAttribute("branches", branches);
            model.addAttribute("total", totalSize);
            model.addAttribute("next", next);
            model.addAttribute("page", page);
            model.addAttribute("size", size);

        } catch (Throwable t) {
            log.info("oid is " + oid + " uid " + uid + " type " + type + "status " + status + " size " + size + " page " + page
                    + "get all classes error");
            t.printStackTrace();
            log.error(t.getMessage());
            log.error(t);
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/classes/json/classesListJson";
    }


    /**
     * @param
     * @return
     */

    // 18.加入班级
    @RequestMapping(value = "/a/u/classmate/{cid}", method = RequestMethod.POST)
    public String joinClasses(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long cid, String swear)
            throws Exception {

        log.info("============================================");
        log.info("cid is " + cid + " swear is " + swear);

        List<Long> cidList = new ArrayList();

        try {

            if (StringUtil.isEmpty(swear)) {
                model.addAttribute("code", -10008);
                log.info("swear is null");
                return "/common/success";
            }

            User user = (User) request.getAttribute("user");
            Long uid = user.getId();

            // 1. 班级校验
            Classes classes = classesService.getObjectById(cid);

            if (classes == null) {
                model.addAttribute("code", -4002);
                log.info("classes is null");
                return "/common/success";
            }

            if (classes.getType().equals("offline")) {
                model.addAttribute("code", -4004);
                log.info("the class is offline");
                return "/common/success";
            }

            Long status = classes.getStatus();
            if (status.longValue() == 1) {
                model.addAttribute("code", -4001);
                log.info("classes have 20 students");
                return "/common/success";
            }

            Long relationId = userClassRelationService.getUserClassRelationIdsByUidAndStatus(uid, 1);

            if (!(relationId == null)) {
                model.addAttribute("code", -4000);
                log.info("you already in a classes");
                return "/common/success";
            }

            Long oid = classes.getOid();

            Occupation occupation = occupationService.getObjectById(oid);
            Long num = null;

            //获取用户班级信息
            List<Long> uids = this.userClassRelationService.getUserIdsByCid(cid, 0, Integer.MAX_VALUE);
            // 1 重新加入原来班级
            if (uids.contains(uid)) {
                log.info(uid + " already exist in " + cid);
                Long relationID = this.userClassRelationService.getUserClassRelationIdByCidAndUid(cid, uid);
                UserClassRelation relation = this.userClassRelationService.getObjectById(relationID);
                num = relation.getNum();

                //激活userClassRelation
                relation.setStatus(UserClassRelation.Status_Valid);
                if (this.userClassRelationService.update(relation)) {
                    //更新用户状态
                    user.setCid(cid);
                    user.setUserClassID(relationID);
                    user.setStudyNumber(num.intValue());
                    user.setType(Classes.Type_Online);
                    user.setOid(oid);
                    user.setIdentity(User.IDENTIFY_20);
                    if (!(this.userService.update(user))) {
                        model.addAttribute("code", -5001);
                        log.info("update user error");
                        return "/common/success";
                    }
                } else {
                    model.addAttribute("code", -5000);
                    log.info("update user_class_relation error");
                    return "/common/success";
                }

                model.addAttribute("code", 0);
                model.addAttribute("num", num);
                return "/common-skill-service/classes/json/joinClasses";
            // 2  加入新班级
            } else {
                log.info(uid + " not exist in " + cid);
                // 1 分配学号

                num = occupation.getOnlineUserCount() + 1L;
                log.info(oid + "  current user is " + occupation.getOnlineUserCount());

                UserClassRelation userClassRelation = new UserClassRelation();
                userClassRelation.setCid(cid);
                userClassRelation.setUid(uid);
                userClassRelation.setSwear(swear);
                userClassRelation.setNum(num);
                userClassRelation.setStatus(1);
                userClassRelation.setOid(oid);
                log.info("oid is " + oid);
                Long relationID = userClassRelationService.insert(userClassRelation);

                // 2 增加班级人数，判断班级是不是已经满员
                log.info(uid + " update userClassRelation success ");
                Long classesTotal = classes.getTotal();

                classesTotal = classesTotal + 1;

                String userLimitCountContent = this.constantService.getConstantValueByTypeAndName(Constant.Type_Classes,
                        Constant.Name_UserLimitCount);
                Integer userLimitCount = Integer.valueOf(userLimitCountContent);
                //班级满员则自动开班
                if (classesTotal >= userLimitCount) {
                    log.info(cid + " is full ,so create new classes ");
                    classes.setStatus(Classes.Status_Full);
                    classes.setTotal(classesTotal);
                    if (!(this.classesService.update(classes))) {
                        log.info("update classes info error");
                    }

                    // 自动开班

                    // 1.创建班级
                    Classes newClasses = new Classes();
                    newClasses.setStatus(Status_NotFull);
                    newClasses.setGrade(classes.getGrade());
                    Integer classNum = Integer.valueOf(classes.getName()) + 1;
                    newClasses.setName(classNum.toString());
                    newClasses.setOid(classes.getOid());
                    newClasses.setTotal(0L);
                    newClasses.setQq(classes.getQq());
                    newClasses.setType(classes.getType());
                    Long newCID = classesService.insert(newClasses);

                    // 2.更新总班级数
                    Long constantID = this.constantService.getConstantIdByTypeAndName(Constant.Type_Statistics, Constant.Name_ClassCount);
                    if (constantID == null) {
                        log.error(" not statistics class Count ,check constant " + Constant.Type_Statistics + " name is "
                                + Constant.Name_ClassCount);
                    } else {
                        Constant constant = this.constantService.getObjectById(constantID);
                        log.info(" constant is " + constant);
                        Integer classCount = Integer.valueOf(constant.getValue()) + 1;
                        constant.setValue(classCount.toString());
                        this.constantService.update(constant);
                        log.info(" update class count success ");

                    }
                    // 3.更新职业班级数
                    switch (classes.getType()) {
                        case Classes.Type_Offline:

                            occupation.setOfflineClassCount(occupation.getOfflineClassCount() + 1L);

                        case Classes.Type_Online:
                            occupation.setOnlineClassCount(occupation.getOnlineClassCount() + 1L);

                        default:
                            log.info(newCID + " is not support type ");

                    }

                } else {
                    log.info(cid + " is not full ,continue  ");
                    classes.setTotal(classesTotal);
                }

                //更新加入班级数据
                if (!(this.classesService.update(classes))) {
                    log.info(classes.getId() + "update classes info error");
                }

                // 3 更新职业人数
                log.info(cid + " update count success ");

                occupation.setOnlineUserCount(num);
                occupationService.update(occupation);
                log.info(occupation + " update count success " + occupation.getOnlineUserCount());

                // 4 更新用户数据
                user.setType(Classes.Type_Online);
                user.setCid(cid);
                user.setUserClassID(relationID);
                user.setStudyNumber(num.intValue());
                user.setOid(oid);
                user.setIdentity(User.IDENTIFY_20);
                /**
                 *  更新用户入学时间
                 *  1 线上学员为第一次加入班级时间
                 *  2 线下学员为加入除js（web学员一般是先加css班级）班级时间，并根据班级所属分院，自动设置结业时间
                 *    结业时间为入学时间+分院学时
                 */
                if (!classes.getType().equals(Classes.Type_Offline)&&CheckDataUtil.isNull(user.getStartAt())) {
                    user.setStartAt(System.currentTimeMillis());
                }
                if(classes.getType().equals(Classes.Type_Offline)&&!occupation.getName().equals(Occupation.Occupation_name_js)){
                    user.setStartAt(System.currentTimeMillis());
                    Long startAt = user.getStartAt();
                    Long branchId = Long.valueOf(classes.getBranch());
                    BranchInstitute branchInstitute = branchInstituteService.getObjectById(branchId);
                    Integer period = branchInstitute.getPeriod();
                    log.info("startAt:"+startAt);
                    Long GraduateAt = startAt + period * 86400000L;
                    log.info("GraduateAt:"+GraduateAt);
                    user.setGraduateAt(GraduateAt);
                }

                //下面会给用户发一条消息，为减少持久层IO，在此处更新user数据
                Integer unLook = user.getIsLook() + 1;
                user.setIsLook(unLook);
                user.setLatestMsg(Message.CLASS_TYPE);
                this.userService.update(user);
                log.info(cid + " update use success " + user);

            }

            log.info(uid + " update type success ");

            // 发送信息
            Message message = new Message();
            message.setStatus(1);
            message.setReceiveName(user.getNick());
            message.setSendName("admin");
            message.setSendId(0L);
            message.setContent("");
            message.setReceiveId(uid);
            message.setUnread(1);
            message.setType("classes");
            message.setRelationId(cid);

            Long mid = messageService.insert(message);

            message = this.messageService.getObjectById(mid);

            String content = "<span class=\"font-16px system-alert-outline ng-scope\"><span class=\"font-green\">您</span>已成功加入<a data-mid=\"" + mid + "\" ng-click=\"sendAlertMsg(li.id)\" target=\"_blank\" href=\"/class/" + classes.getId() + "//intro\" class=\"font-orange\">" + classes.getType() + "-" + occupation.getName() + "-" + classes.getName() + "班</a></span>";
            log.info("user : " + user.getMobile() + " send : " + content);
            adminSend(user.getMobile(), content);
            message.setContent(content);
            messageService.update(message);

            model.addAttribute("code", 0);
            model.addAttribute("num", num);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t);
            log.error(t.getMessage());
            log.error("join classes error,cid is  " + cid);
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/classes/json/joinClasses";
    }


    public static String adminSend(String mobile, String content) {
        String param = "{\n" +
                "    \"target_type\" : \"users\", \n" +
                "    \"target\" : [\"" + mobile + "\"],   \n" +
                "                                   \n" +
                "                                   \n" +
                "    \"msg\" : {\n" +
                "        \"type\" : \"txt\",\n" +
                "        \"msg\" : \"" + content + "\" \n" +
                "        },\n" +
                "    \"from\" : \"admin\"\n" +
                "}";
        String result = HttpClientUtil.sendPostRequestByJavaSetHeader("https://a1.easemob.com/jnshu4/jnshu4/messages", param, "application/json", "Bearer YWMtwJlMnN7iEeW93dWWI_R-hgAAAVRiEFRny8NEKnIG6-Gu_yibQ4d46AkTlmM");
        log.info(result);
        return result;
    }






    /**
     * 20.分配班级
     * @param request
     * @param response
     * @param model
     * @param oid
     * @param type
     * @return
     */
    @RequestMapping(value = "/a/u/classes", method = RequestMethod.POST)
    public String appointClasses(HttpServletRequest request, HttpServletResponse response,
                                ModelMap model, Long oid, String type) {


        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        log.info(user + " want to enroll a class ");

        try {

            //判断是否存在一条正常状态的user_class_relation，有则不用给用户加班了，直接返回
            if (this.hasVaildUserClassRelation(uid)) {
                log.info(uid + " is in a class, he can`t enroll any more");
                model.addAttribute("code", -5000);
                model.addAttribute("message", "用户在其他班级中");
                return "/common/failure";
            }

            if (oid == null) {
                log.info("doesn`t choose occupation! ");
                model.addAttribute("code", -5001);
                model.addAttribute("message", "职业信息缺失");
                return "/common/failure";
            }

            if (type == null) {
                log.info("classes is null");
                model.addAttribute("code", -5002);
                model.addAttribute("message", "班级类型信息缺失");
                return "/common/failure";
            }

            //获取用户曾经与班级的关联
            Map<Classes, UserClassRelation> classRelationMap = this.getClassesRelationsMap(uid, oid);

            //如果用户可以直接激活原来的班级关系，则获取那条记录，否则结果为空
            Classes joinClasses = this.needJoinNewClasss(uid, type, classRelationMap.keySet());

            Classes classes = null;
            Long cid = null;
            Long studyNum = null;
            Long relationId = null;

            //更新用户关系信息
            if (joinClasses == null) {
                classes = this.getJoinClasses(oid, type);
                cid = classes.getId();
                studyNum = this.getStudyNum(uid, oid, type, classRelationMap);
                relationId = this.createUserClassRelation(uid, cid, studyNum, oid);

            } else {
                UserClassRelation relation = classRelationMap.get(joinClasses);
                relation.setStatus(UserClassRelation.Status_Valid);
                userClassRelationService.update(relation);

                classes = joinClasses;
                cid = relation.getCid();
                studyNum = relation.getNum();
                relationId = relation.getId();
            }

            //更新用户信息
            user.setIsLook(user.getIsLook() + 1);
            user.setLatestMsg(Message.CLASS_TYPE);
            updateUser(user, oid, type, studyNum, cid, relationId);

            // 发送信息
            Message message = new Message();
            message.setStatus(1);
            message.setReceiveName(user.getNick());
            message.setSendName("admin");
            message.setSendId(0L);
            message.setContent("");
            message.setReceiveId(uid);
            message.setUnread(1);
            message.setType("classes");
            message.setRelationId(cid);

            Long mid = messageService.insert(message);

            message = this.messageService.getObjectById(mid);

            Occupation occupation = this.occupationService.getObjectById(oid);

            String content = "<span class=\"font-16px system-alert-outline ng-scope\"><span class=\"font-green\">您</span>已成功加入<a data-mid=\"" + mid + "\" ng-click=\"sendAlertMsg(li.id)\" target=\"_blank\" href=\"/class/" + classes.getId() + "/intro\" class=\"font-orange\">" + classes.getType() + "-" + occupation.getName() + "-" + classes.getName() + "班</a></span>";
            log.info("user : " + user.getMobile() + " send : " + content);
            adminSend(user.getMobile(), content);
            message.setContent(content);
            messageService.update(message);
            model.addAttribute("code", 0);
            model.addAttribute("cid", cid);
            model.addAttribute("num", studyNum);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t);
            model.addAttribute("code", -2);
            model.addAttribute("message", "send message failed ");
        }

        return "/common-skill-service/classes/json/assignClasses";
    }

    /**
     * 判断用户是否当前有班
     *
     * @param uid
     */
    public boolean hasVaildUserClassRelation(Long uid) throws ServiceException, ServiceDaoException {

        Long relationId = null;

        try {
            relationId = this.userClassRelationService.getUserClassRelationIdsByUidAndStatus(uid, UserClassRelation.Status_Valid);
        } catch (Exception e) {
            e.printStackTrace();
            log.info(uid + "error in get relationId");
        }

        return (relationId == null) ? false : true;
    }

    /**
     * 获取用户曾经的班级关系
     * @param uid
     * @param oid
     */
    public Map<Classes, UserClassRelation> getClassesRelationsMap(Long uid, Long oid) throws ServiceException, ServiceDaoException {
        Map<Classes, UserClassRelation> classRelationMap = new HashMap<>();

        try {
            List<Long> relationIds = this.userClassRelationService.getUserClassRelationIdByOidAndUid(oid, uid, 0, Integer.MAX_VALUE);
            List<UserClassRelation> relationList = this.userClassRelationService.getObjectsByIds(relationIds);

            List<Long> classesIds = new ArrayList<>();
            for (UserClassRelation relation : relationList) {
                Long cid = relation.getCid();
                classesIds.add(cid);
            }

            List<Classes> classesList = this.classesService.getObjectsByIds(classesIds);

            for (Classes classes : classesList) {
                for (UserClassRelation relation : relationList) {
                    if (classes.getId().equals(relation.getCid()))
                        classRelationMap.put(classes, relation);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.info(uid + "error in get classList");
        }

        return classRelationMap;
    }

    /**
     * 用户加入原来哪个班级，为空就新加入其他班级
     *
     * @param uid
     * @param type
     * @param classesList
     */
    public Classes needJoinNewClasss(Long uid, String type, Set<Classes> classesList) {
        Classes classesForjoin = null;

        try {
            if (CollectionUtils.isEmpty(classesList)) {
                log.info(uid + " hasn`t a relation");
                return classesForjoin;
            }

            for (Classes classes : classesList) {
                if (type.equals(classes.getType())) {
                    classesForjoin = classes;
                    //一旦获得就不再循环
                    break;
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.info(uid + " has error in needJoinNewClasss");
        }

        return classesForjoin;
    }

    /**
     * 分配学号
     *
     * @param uid
     */
    public Long getStudyNum(Long uid, Long oid, String type, Map<Classes, UserClassRelation> classRelationMap) {


        Long studyNum = null;

        try {

            Boolean isInputOffline = null,
                    isClassOffline = null;

            Set<Classes> classesList = classRelationMap.keySet();

            //学号分两类,online(散修、外门),offline(内门)
            if ("offline".equals(type)) {
                isInputOffline = true;
            } else {
                isInputOffline = false;
            }

            for (Classes classes : classesList) {
                if ("offline".equals(classes.getType())) {
                    isClassOffline = true;
                } else {
                    isClassOffline = false;
                }

                //存在相同type和oid的relation，意味着延用旧职业学号
                if (isInputOffline.equals(isClassOffline)) {
                    UserClassRelation relation = classRelationMap.get(classes);
                    studyNum = relation.getNum();

                    log.info(uid + " can use his earlier studyNumber");
                    return studyNum;
                }
            }

            //新建一个学号，同时更新Occupation表
            Occupation occupation = this.occupationService.getObjectById(oid);

            if ("offline".equals(type)) {
                Long offlineUserCount = occupation.getOfflineUserCount() + 1;

                studyNum = offlineUserCount;
                occupation.setOfflineUserCount(offlineUserCount);
            } else {
                Long onlineUserCount = occupation.getOnlineUserCount() + 1;

                studyNum = onlineUserCount;
                occupation.setOnlineUserCount(onlineUserCount);
            }

            occupationService.update(occupation);

        } catch (Exception e) {
            e.printStackTrace();
            log.info(uid + " has error in needJoinNewClasss");
        }

        return studyNum;
    }

    /**
     * 给用户分配一个加入的班级
     * @param oid
     * @param type
     */
    public Classes getJoinClasses(Long oid, String type) throws ServiceException, ServiceDaoException {

        Classes lastClasses = null;

        try {
            //得到oid+type的最新班级人数
            List<Long> cids = this.classesService.getClassesIdsByOidAndType(oid, type, 0, Integer.MAX_VALUE);
            Long lastCid = cids.get(0);
            lastClasses = this.classesService.getObjectById(lastCid);
            Long total = lastClasses.getTotal();

            //获取满员人数限制
            String userLimitCountContent = this.constantService.getConstantValueByTypeAndName(Constant.Type_Classes, Constant.Name_UserLimitCount);
            Integer userLimitCount = Integer.valueOf(userLimitCountContent);

            //判断之前该班就大于19人了的时候，加入后会满员则自动新增一个班级
            if (total > userLimitCount - 2) {
                //调用新增班级方法
                Classes newClasses = getNewClasses(lastClasses);

                //意外情况班级人数已经大于等于20人了，lastClasses为新建班级
                if (total > userLimitCount - 1) {
                    lastClasses = newClasses;
                    total = lastClasses.getTotal();
                }

            }

            //更新lastClasses
            total = total + 1;
            lastClasses.setTotal(total);
            classesService.update(lastClasses);

        } catch (Exception e) {
            e.printStackTrace();
            log.info("There is a error in getJoinClasss ");
        }

        return lastClasses;
    }

    /**
     * 新增一个班级
     *
     * @param lastClasses
     */
    public Classes getNewClasses(Classes lastClasses) throws ServiceException, ServiceDaoException {

        Classes newClasses = new Classes();

        try {
            // 1.创建班级
            newClasses.setStatus(0L);
            newClasses.setGrade(lastClasses.getGrade());
            Integer classNum = Integer.valueOf(lastClasses.getName()) + 1;
            newClasses.setName(classNum.toString());
            newClasses.setOid(lastClasses.getOid());
            newClasses.setTotal(0L);
            newClasses.setQq(lastClasses.getQq());
            newClasses.setType(lastClasses.getType());
            Long newCID = classesService.insert(newClasses);

            // 2.更新总班级数
            Long constantID = this.constantService.getConstantIdByTypeAndName(Constant.Type_Statistics, Constant.Name_ClassCount);
            if (constantID == null) {
                log.error(" not statistics class Count ,check constant " + Constant.Type_Statistics + " name is "
                        + Constant.Name_ClassCount);
            } else {
                Constant constant = this.constantService.getObjectById(constantID);
                log.info(" constant is " + constant);
                Integer classCount = Integer.valueOf(constant.getValue()) + 1;
                constant.setValue(classCount.toString());
                this.constantService.update(constant);

                log.info(" update class count success ");
            }

            // 3.更新职业班级数
            Long oid = lastClasses.getOid();
            Occupation occupation = this.occupationService.getObjectById(oid);

            switch (lastClasses.getType()) {
                case Classes.Type_Offline:

                    occupation.setOfflineClassCount(occupation.getOfflineClassCount() + 1L);

                case Classes.Type_Online:
                    occupation.setOnlineClassCount(occupation.getOnlineClassCount() + 1L);

                default:
                    log.info(newCID + " is not support type ");
            }

        } catch (Exception e) {
            e.printStackTrace();
            log.info("There is a error in creating a new classes");
        }

        return newClasses;
    }

    /**
     * 新建一个用户班级关系
     */
    public Long createUserClassRelation(Long uid, Long cid, Long num, Long oid) throws ServiceException, ServiceDaoException {

        Long startAt = System.currentTimeMillis(),
                duration = null,
                lastPart = startAt,
                nowPart = null;

        UserClassRelation userClassRelation = new UserClassRelation();

        try {
            userClassRelation.setCid(cid);
            userClassRelation.setUid(uid);
            userClassRelation.setSwear("");
            userClassRelation.setNum(num);
            userClassRelation.setStatus(1);
            userClassRelation.setOid(oid);
        } catch (Exception e) {
            e.printStackTrace();
            log.info("There is a error in creating a new classes");
        }

        return this.userClassRelationService.insert(userClassRelation);
    }

    /**
     * 更新user相关信息
     *
     * @param oid
     */
    public boolean updateUser(User user, Long oid, String type, Long studyNum, Long cid, Long relationId) throws ServiceException, ServiceDaoException {

        try {
            user.setOid(oid);
            user.setType(type);
            user.setStudyNumber(studyNum.intValue());
            user.setCid(cid);
            user.setUserClassID(relationId);
            user.setIdentity(User.IDENTIFY_20);
        } catch (Exception e) {
            e.printStackTrace();
            log.info("There is a error in creating a new classes");
        }

        return this.userService.update(user);
    }

    public static void main(String[] args) throws ServiceException, ServiceDaoException {
//		Map<String, Object> param = DynamicUtil.getClassesListParam(null, null, "online", 1L, false);
//		   String sql = SQLUtil.convert2Sql(param, 0, 1000);
//		   log.info(sql);


//        StringBuilder timeBuf = new StringBuilder();
//        Long startAt = System.currentTimeMillis(),
//                duration = null,
//                lastPart = null,
//                nowPart = null;
//
//        timeBuf.append("needJoinNewClasss()");
//        timeBuf.append("=== ");
//        nowPart = System.currentTimeMillis();
//        duration = nowPart - lastPart;
//        lastPart = nowPart;
//        timeBuf.append(TimeUnit.MILLISECONDS.toMillis(duration));
//        timeBuf.append(" ms===");
//        log.info(timeBuf.toString());
//        timeBuf.setLength(0);


    }
}
