package com.ptteng.common.skill.interceptor;

import com.ptteng.common.skill.model.User;
import com.ptteng.common.skill.service.UserService;
import com.ptteng.common.skill.util.GetUserFromCookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class VUserInterceptor extends HandlerInterceptorAdapter {

    private static final Log log = LogFactory.getLog(VUserInterceptor.class);

    @Autowired
    private UserService userService;

    @Autowired
    private GetUserFromCookieUtil getUserFromCookieUtil;

    /**
     * In this case intercept the request BEFORE it reaches the controller
     */
    @Override
    public boolean preHandle(HttpServletRequest request,
                             HttpServletResponse response, Object handler) throws Exception {
        log.info("request uri: " + request.getRequestURI());

        Long uid = getUserFromCookieUtil.getUserFromCookie(request);
        if (null == uid) {
            return noLogin(response, request);
        } else {
            User user = this.userService.getObjectById(uid);
            if (null != user) {
                request.setAttribute("user", user);
            } else {
                return noLogin(response, request);
            }
        }

        return true;
    }


    //用户未登录
    private boolean noLogin(HttpServletResponse response, HttpServletRequest request) throws IOException {

        log.info(" user don't login");

        String url = request.getHeader("Host") + "/login/0/";
        log.info(url);
        response.sendRedirect(url);
        return false;

    }


    @Override
    public void postHandle(HttpServletRequest request,
                           HttpServletResponse response, Object handler,
                           ModelAndView modelAndView) throws Exception {

        log.info("p =========================================== ");
    }

    /**
     * 获取跳转链接的地址
     *
     * @param request
     * @return
     */
    public String getInterceptorUrl(HttpServletRequest request) {

        String interceptorUrl = request.getRequestURI()
                + (null == request.getQueryString() ? "" : "?"
                + request.getQueryString()).toString();
        interceptorUrl = interceptorUrl.replace("/app/", "/");

        log.info("get getInterceptorUrl is " + interceptorUrl);

        return interceptorUrl;
    }

    public static void main(String[] args) throws UnsupportedEncodingException {

        String x = URLEncoder.encode("p/hello", "utf-8");
        log.info(x);

    }
}
