package com.ptteng.common.skill.controller;

import com.gemantic.common.util.MyListUtil;
import com.ptteng.common.skill.model.*;
import com.ptteng.common.skill.service.*;
import com.ptteng.common.skill.util.*;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import net.sf.json.JSONArray;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * Question  crud
 *
 * @author guchen
 * @Date 2018-01-19
 */
@Controller
public class QuestionController {
    private static final Log log = LogFactory.getLog(QuestionController.class);

    @Autowired
    private QuestionService questionService;

    @Autowired
    private LabelService labelService;

    @Autowired
    private CookieUtil cookieUtil;

    @Autowired
    private OccupationService occupationService;

    @Autowired
    private TaskService taskService;

    @Autowired
    private QuestionLabelRelationService questionLabelRelationService;

    @Autowired
    private AnswerService answerService;


    @Autowired
    private UserService userService;


    @Autowired
    private GetUserFromCookieUtil getUserFromCookieUtil;

    @Autowired
    private UserArticleRelationService userArticleRelationService;

    @Resource
    private QuestionCtrlUtil questionCtrlUtil;

    @Resource
    private CommonUtil commonUtil;

    /**
     * 1.1 新增问题-json
     *
     * @param request
     * @param response
     * @param model
     * @param question
     * @param labelIds
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/v/question", method = RequestMethod.POST)
    public String addQuestionJson(HttpServletRequest request,
                                  HttpServletResponse response, ModelMap model, Question question,
                                  String labelIds) throws Exception {

        log.info("update question : question= " + question);

        //未登录返回-2，前端模态框提示用户重新登录
        Long userId = getUserFromCookieUtil.getUserFromCookie(request);
        log.info("userId is " + userId);
        if (DataUtils.isNullOrEmpty(userId)) {
            log.info("user no login");
            model.addAttribute("code", -2);
            return "/common/failure";
        }

        if (question.getOid() == null) {
            model.addAttribute("code", -28001);
            log.info("oid is null");
            return "/common/failure";
        }

        if (question.getTid() == null) {
            model.addAttribute("code", -28002);
            log.info("tid is null");
            return "/common/failure";
        }
        if (question.getType() == null) {
            model.addAttribute("code", -28003);
            log.info("type is null");
            return "/common/failure";
        }
        if (question.getTitle() == null) {
            model.addAttribute("code", -28004);
            log.info("title is null");
            return "/common/failure";
        }
        if (question.getDescription() == null) {
            model.addAttribute("code", -28005);
            log.info("description is null");
            return "/common/failure";
        }

        try {
            question.setId(null);
            question.setStatus(Constants.STATUS_SHOW);
            question.setAdopt(Question.ADOPT_OUT);
            question.setAgreeNum(0);
            question.setIsAgree(0);
            question.setAnswerNum(0);
            question.setCreateBy(userId);
            question.setUpdateBy(userId);

            Long id = questionService.insert(question);
            if (DataUtils.isNullOrEmpty(id)) {
                log.info("add question error ");
                model.addAttribute("code", -1);
                return "/common/failure";
            }

            List<Long> labelIdList = new ArrayList<>();
            List<QuestionLabelRelation> questionLabelRelationList = new ArrayList<>();
            List<Label> labelList = new ArrayList<>();

            //建立新的问题-标签关系
            if (StringUtils.isNotBlank(labelIds)) {
                questionCtrlUtil.updateQuestionLabelRelationship(id, userId, labelIds, labelIdList, labelList, questionLabelRelationList);
            }

            //自己创建的问题默认建立踩坑(点赞)关系
            UserArticleRelation userArticleRelation = new UserArticleRelation();
            userArticleRelation.setTargetType(UserArticleRelation.TARGET_QUESTION);
            userArticleRelation.setUid(userId);
            userArticleRelation.setAid(id);
            userArticleRelation.setType(UserArticleRelation.STATUS_LOVE);
            userArticleRelation.setWhether(UserArticleRelation.WHETHER_VALID);
            userArticleRelation.setCreateBy(userId);
            userArticleRelation.setUpdateBy(userId);
            userArticleRelation.setWhether(UserArticleRelation.WHETHER_VALID);
            Long userArticleRelationId = userArticleRelationService.insert(userArticleRelation);
            if (DataUtils.isNullOrEmpty(userArticleRelationId)) {
                log.info("add userArticleRelation error ");
                model.addAttribute("code", -1);
                return "/common/failure";
            }

            //更新问题踩坑数
            Question newQuestion = questionService.getObjectById(id);
            newQuestion.setAgreeNum(newQuestion.getAgreeNum() + 1);
            newQuestion.setUpdateBy(userId);

            boolean isUpdate = questionService.update(newQuestion);
            if (isUpdate) {
                log.info(" update success.");
            } else {
                model.addAttribute("code", -1);
                return "/common/failure";
            }
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add question error ");
            model.addAttribute("code", -1);
        }
        return "/common/success";
    }


    /**
     * 1.2 新增问题-jsp
     *
     * @param request
     * @param response
     * @param model
     * @param question
     * @param labelIds
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/k/question/create", method = RequestMethod.GET)
    public String questionCreate(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, Question question,
                                 String labelIds) throws Exception {
        try {
            //未登录返回-2，前端模态框提示用户重新登录
            Long uid = getUserFromCookieUtil.getUserFromCookie(request);
            log.info("uid is " + uid);
            if (DataUtils.isNullOrEmpty(uid)) {
                log.info("user no login");
                model.addAttribute("code", -2);
                return "/common/failure";
            } else {
                model.addAttribute("uid", uid);
            }
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("create question error");
            model.addAttribute("code", -1);
        }
        return "/web-kenghu/question/questionCreate";
    }


    /**
     * 2.1 获取问题详情/回答列表-jsp
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @param orderBy
     * @param sort
     * @param page
     * @param size
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/k/question/{id}", method = RequestMethod.GET)
    public String getQuestionJson(
            HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id,
            Integer orderBy, Integer sort, Integer page, Integer size)
            throws Exception {

        log.info("get data : id= " + id);
        if (id == null) {
            model.addAttribute("code", -28007);
            log.info("id is null");
            return "/common/failure";
        }
        //初始化page size start
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        try {
            //获取当前问题详情
            Question question = questionService.getObjectById(id);
            log.info("get question data is " + question);

            //当问题不存在或者问题被隐藏时，跳转到404.jsp
            if (DataUtils.isNullOrEmpty(question) || !question.getStatus().equals(1)) {
                log.info("get question error: question == null or this question has been hidden");
                model.addAttribute("code", -28006);
                return "/web-kenghu/common/404";
            }

            List<Long> oidList = new ArrayList<>();
            List<Long> tidList = new ArrayList<>();
            List<Long> uidList = new ArrayList<>();
            List<Long> labelIdList = new ArrayList<>();

            List<Answer> answerList = new ArrayList<>();
            List<Occupation> occupationList = new ArrayList<>();
            List<Task> taskList = new ArrayList<>();
            List<User> userList = new ArrayList<>();
            List<QuestionLabelRelation> questionLabelRelationList = new ArrayList<>();
            List<Label> labelList = new ArrayList<>();
            Map<Long, Label> labelMap = new HashMap();

            //新增userMap、occupationIds、occupationMap、nickMap
            Map<Long, User> userMap = new HashMap<>();
            Map<Long, Occupation> occupationMap = new HashMap<>();
            Map<Long, String> nickMap = new HashMap<>();

            //处理module json字符串
            JSONArray moduleList = new JSONArray();
            if (StringUtils.isNotBlank(question.getModules())) {
                moduleList = JSONArray.fromObject(question.getModules());
            }

            //获取问题标签关系
            Map<String, Object> questionLabelRelationLisParamList = DynamicUtil.getQuestionLabelRelationListParam(null, id.toString());
            log.info(" questionLabelRelationLisParamList size =  " + questionLabelRelationLisParamList.size());

            List<Long> questionLabelRelationIdList = questionLabelRelationService.getIdsByDynamicCondition(QuestionLabelRelation.class, questionLabelRelationLisParamList, 0, Integer.MAX_VALUE);
            if (CollectionUtils.isEmpty(questionLabelRelationIdList)) {
                log.info(" questionLabelRelationIdList is null ");
            } else {
                log.info(" questionLabelRelationIdList size =  " + questionLabelRelationIdList.size());
                questionLabelRelationList = questionLabelRelationService.getObjectsByIds(questionLabelRelationIdList);
            }

            for (QuestionLabelRelation questionLabelRelation : questionLabelRelationList) {
                if (questionLabelRelation.getLabelId() != null) {
                    labelIdList.add(questionLabelRelation.getLabelId());
                }
            }

            if (CollectionUtils.isEmpty(labelIdList)) {
                log.info(" labelIdList is null ");
            } else {
                log.info(" labelIdList size =  " + labelIdList.size());
                labelMap = questionCtrlUtil.getLabelMap(labelIdList);
            }


            //获取回答列表
            Map<String, Object> answerParamList = DynamicUtil.getAnswerListParam(null, null, null, null, null, id.toString(), Constants.STATUS_SHOW, null, null, null, orderBy, sort);
            log.info(" paramList size =  " + answerParamList.size());

            //获取相关list
            List<Long> answerIdList = answerService.getIdsByDynamicCondition(Answer.class, answerParamList, start, size);
            if (CollectionUtils.isEmpty(answerIdList)) {
                log.info(" answerIdList is null ");
                model.addAttribute("size", 0);
                model.addAttribute("total", 0);
            } else {
                answerList = answerService.getObjectsByIds(answerIdList);
                log.info(" answerIdList size =  " + answerIdList.size());
                for (Answer answer : answerList) {
                    if (answer.getCreateBy() != null) {
                        uidList.add(answer.getCreateBy());
                    }
                }
            }

            //获取当前问题的总回答数total
            List<Long> allAnswer = answerService.getIdsByDynamicCondition(Answer.class, answerParamList, 0, Integer.MAX_VALUE);
            log.info("total is:" + allAnswer.size());

            //更新一波answerNum
            question.setAnswerNum(allAnswer.size());
            boolean isUpdate = questionService.update(question);
            if (isUpdate) {
                log.info(" update success.");
            } else {
                model.addAttribute("code", -1);
                return "/common/failure";
            }

            if (CollectionUtils.isEmpty(uidList)) {
                log.info(" uidList is null ");
            } else {
                log.info(" uidList size =  " + uidList.size());
                userList = userService.getObjectsByIds(uidList);
                userMap = MyListUtil.convert2Map(User.class.getDeclaredField("id"), userList);
                for (User user : userList) {
                    if (!user.getOid().equals(User.Occupation_None)) {
                        oidList.add(user.getOid());
                    }
                }
            }

            oidList.add(question.getOid());
            tidList.add(question.getTid());

            if (CollectionUtils.isEmpty(oidList)) {
                log.info(" oidList is null ");
            } else {
                log.info(" oidList size =  " + oidList.size());
                occupationList = occupationService.getObjectsByIds(oidList);
                occupationMap = MyListUtil.convert2Map(Occupation.class.getDeclaredField("id"), occupationList);
                for (User user : userList) {
                    if (!user.getOid().equals(User.Occupation_None)) {
                        nickMap.put(user.getId(), commonUtil.setUserShowName(user, occupationMap.get(user.getOid())));
                    } else {
                        nickMap.put(user.getId(), commonUtil.setUserShowName(user, null));
                    }

                }
            }

            if (CollectionUtils.isEmpty(tidList)) {
                log.info(" tidList is null ");
            } else {
                log.info(" tidList size =  " + tidList.size());
                taskList = taskService.getObjectsByIds(tidList);
            }

            //获取当前登录的用户信息
            Answer userAnswer = null;
            Long userId = getUserFromCookieUtil.getUserFromCookie(request);
            if (DataUtils.isNullOrEmpty(userId)) {
                log.info("user no login");
            } else {
                model = questionCtrlUtil.getCurUser(userId, model);

                //获取当前用户回答(状态为展示中)
                Map<String, Object> userAnswerParamList = DynamicUtil.getAnswerListParam(null, null, null, null, 2, id.toString(), Constants.STATUS_SHOW, userId, null, null, null, null);
                log.info(" userAnswerParamList size =  " + userAnswerParamList.size());

                //获取相关list(后台隐藏的回答视为失效，用户可以继续回答，同一个问题，用户可显示的回答只有一个)
                List<Long> userAnswerIdList = answerService.getIdsByDynamicCondition(Answer.class, userAnswerParamList, 0, Integer.MAX_VALUE);
                if (CollectionUtils.isEmpty(userAnswerIdList)) {
                    log.info(" userAnswerIdList is null ");
                    model.addAttribute("userAnswer", null);
                } else {
                    List<Answer> userAnswerList;
                    userAnswerList = answerService.getObjectsByIds(userAnswerIdList);
                    log.info(" userAnswerList size =  " + userAnswerList.size());
                    userAnswer = userAnswerList.get(0);
                    log.info(" userAnswer is : " + userAnswer);
                }
            }

            List<Long> questionIdList = new ArrayList<>();
            questionIdList.add(question.getId());
            List<Question> questionList = new ArrayList<>();
            questionList.add(question);

            //用户收藏点赞关系
            if (DataUtils.isNotNullOrEmpty(userId)) {
                questionCtrlUtil.checkQuestionAndAnswerLikeOrCollection(userId, questionIdList, questionList, answerIdList, answerList);
            }

            Integer totalPage = 1;
            Integer total = allAnswer.size();
            if (total > 0) {
                totalPage = (total - 1) / size + 1;
            }

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", answerList.size());
            model.addAttribute("pSize", size);
            model.addAttribute("total", total);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("answerList", answerList);
            model.addAttribute("userAnswer", userAnswer);
            model.addAttribute("question", questionList.get(0));
            model.addAttribute("moduleList", moduleList);
            model.addAttribute("occupationList", occupationList);
            model.addAttribute("taskList", taskList);
            model.addAttribute("userList", userList);
            model.addAttribute("labelList", labelList);
            model.addAttribute("userMap", userMap);
            model.addAttribute("occupationMap", occupationMap);
            model.addAttribute("nickMap", nickMap);
            model.addAttribute("labelMap", labelMap);
            model.addAttribute("questionLabelRelationList", questionLabelRelationList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get question error,id is  " + id);
            model.addAttribute("code", -1);
        }
        return "/web-kenghu/question/questionDetail";
    }


    /**
     * 2.2 获取问题详情/回答列表-json
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @param orderBy
     * @param sort
     * @param page
     * @param size
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/question/{id}", method = RequestMethod.GET)
    public String aGetQuestionJson(
            HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id,
            Integer orderBy, Integer sort, Integer page, Integer size)
            throws Exception {

        log.info("get data : id= " + id);
        if (id == null) {
            model.addAttribute("code", -28007);
            log.info("id is null");
            return "/common/failure";
        }
        //初始化page size start
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        try {
            Question question = questionService.getObjectById(id);
            log.info("get question data is " + question);
            if (DataUtils.isNullOrEmpty(question)) {
                log.info("get question error :question == null");
                model.addAttribute("code", -28006);
                return "/common/failure";
            }

            //处理module json字符串
            JSONArray moduleList = new JSONArray();
            if (StringUtils.isNotBlank(question.getModules())) {
                moduleList = JSONArray.fromObject(question.getModules());
            }

            List<Long> oidList = new ArrayList<>();
            List<Long> tidList = new ArrayList<>();
            List<Long> uidList = new ArrayList<>();
            List<Long> labelIdList = new ArrayList<>();

            List<Answer> answerList = new ArrayList<>();
            List<Occupation> occupationList = new ArrayList<>();
            List<Task> taskList = new ArrayList<>();
            List<User> userList = new ArrayList<>();
            List<QuestionLabelRelation> questionLabelRelationList = new ArrayList<>();
            List<Label> labelList = new ArrayList<>();
            Map<Long, Label> labelMap = new HashMap();

            //获取回答列表
            Map<String, Object> answerParamList = DynamicUtil.getAnswerListParam(null, null, null, null, null, id.toString(), Constants.STATUS_SHOW, null, null, null, orderBy, sort);
            log.info(" paramList size =  " + answerParamList.size());

            //获取相关list
            List<Long> answerIdList = answerService.getIdsByDynamicCondition(Answer.class, answerParamList, start, size);
            if (CollectionUtils.isEmpty(answerIdList)) {
                log.info(" answerIdList is empty");
                model.addAttribute("size", 0);
                model.addAttribute("total", 0);
            } else {
                answerList = answerService.getObjectsByIds(answerIdList);
                log.info(" answerIdList size =  " + answerIdList.size());
            }

            //获取total
            List<Long> allAnswer = answerService.getIdsByDynamicCondition(Answer.class, answerParamList, 0, Integer.MAX_VALUE);
            Integer total = allAnswer.size();
            log.info("total is:" + total);

            //获取问题标签关系
            Map<String, Object> questionLabelRelationLisParamList = DynamicUtil.getQuestionLabelRelationListParam(null, id.toString());
            log.info(" questionLabelRelationLisParamList size =  " + questionLabelRelationLisParamList.size());

            List<Long> questionLabelRelationIdList = questionLabelRelationService.getIdsByDynamicCondition(QuestionLabelRelation.class, questionLabelRelationLisParamList, 0, Integer.MAX_VALUE);
            if (CollectionUtils.isEmpty(questionLabelRelationIdList)) {
                log.info(" questionLabelRelationIdList is null ");
            } else {
                log.info(" questionLabelRelationIdList size =  " + questionLabelRelationIdList.size());
                questionLabelRelationList = questionLabelRelationService.getObjectsByIds(questionLabelRelationIdList);
            }

            for (QuestionLabelRelation questionLabelRelation : questionLabelRelationList) {
                if (questionLabelRelation.getLabelId() != null) {
                    labelIdList.add(questionLabelRelation.getLabelId());
                }
            }

            if (CollectionUtils.isEmpty(labelIdList)) {
                log.info(" labelIdList is null ");
            } else {
                log.info(" labelIdList size =  " + labelIdList.size());
                labelMap = questionCtrlUtil.getLabelMap(labelIdList);
            }

            for (Answer answer : answerList) {
                if (answer.getCreateBy() != null) {
                    uidList.add(answer.getCreateBy());
                }
            }

            oidList.add(question.getOid());
            tidList.add(question.getTid());
            if (CollectionUtils.isEmpty(oidList)) {
                log.info(" oidList is null ");
            } else {
                log.info(" oidList size =  " + oidList.size());
                occupationList = occupationService.getObjectsByIds(oidList);
            }

            if (CollectionUtils.isEmpty(tidList)) {
                log.info(" tidList is null ");
            } else {
                log.info(" tidList size =  " + tidList.size());
                taskList = taskService.getObjectsByIds(tidList);
            }

            if (CollectionUtils.isEmpty(uidList)) {
                log.info(" uidList is null ");
            } else {
                log.info(" uidList size =  " + uidList.size());
                userList = userService.getObjectsByIds(uidList);
            }

            Integer totalPage = 1;
            if (total > 0) {
                totalPage = (total - 1) / size + 1;
            }

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", answerList.size());
            model.addAttribute("pSize", size);
            model.addAttribute("total", total);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("answerList", answerList);
            model.addAttribute("question", question);
            model.addAttribute("moduleList", moduleList);
            model.addAttribute("occupationList", occupationList);
            model.addAttribute("taskList", taskList);
            model.addAttribute("userList", userList);
            model.addAttribute("labelList", labelList);
            model.addAttribute("labelMap", labelMap);
            model.addAttribute("questionLabelRelationList", questionLabelRelationList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get question error,id is  " + id);
            model.addAttribute("code", -1);
        }
        return "/common-skill-service/question/json/questionDetailJson";
    }


    /**
     * 3 修改问题
     *
     * @param request
     * @param response
     * @param model
     * @param question
     * @param labelIds
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/v/question/{id}", method = RequestMethod.PUT)
    public String updateQuestionJson(HttpServletRequest request,
                                     HttpServletResponse response, ModelMap model, Question question,
                                     String labelIds, @PathVariable Long id) throws Exception {

        log.info("update question : question= " + question);

        //未登录返回-2，前端模态框提示用户重新登录
        Long userId = getUserFromCookieUtil.getUserFromCookie(request);
        log.info("userId is " + userId);
        if (DataUtils.isNullOrEmpty(userId)) {
            log.info("user no login");
            model.addAttribute("code", -2);
            return "/common/failure";
        }

        if (id == null) {
            model.addAttribute("code", -28007);
            log.info("id is null");
            return "/common/failure";
        }

        if (question.getOid() == null) {
            model.addAttribute("code", -28001);
            log.info("oid is null");
            return "/common/failure";
        }

        if (question.getTid() == null) {
            model.addAttribute("code", -28002);
            log.info("tid is null");
            return "/common/failure";
        }
        if (question.getType() == null) {
            model.addAttribute("code", -28003);
            log.info("type is null");
            return "/common/failure";
        }
        if (question.getTitle() == null) {
            model.addAttribute("code", -28004);
            log.info("title is null");
            return "/common/failure";
        }
        if (question.getDescription() == null) {
            model.addAttribute("code", -28004);
            log.info("description is null");
            return "/common/failure";
        }

        try {
            Question oldQuestion = questionService.getObjectById(id);
            if (DataUtils.isNullOrEmpty(oldQuestion)) {
                log.info("get oldQuestion error: oldQuestion == null");
                model.addAttribute("code", -28006);
                return "/common/failure";
            } else {
                log.info("get oldQuestion data is " + oldQuestion);
            }

            oldQuestion.setOid(question.getOid());
            oldQuestion.setTid(question.getTid());
            oldQuestion.setType(question.getType());
            oldQuestion.setTitle(question.getTitle());
            oldQuestion.setDescription(question.getDescription());
            oldQuestion.setModules(question.getModules());
            oldQuestion.setUpdateBy(userId);

            boolean isUpdate = questionService.update(oldQuestion);
            if (isUpdate) {
                log.info(" update success.");
            } else {
                model.addAttribute("code", -1);
                return "/common/failure";
            }

            List<Long> oldQuestionLabelRelationIdList = new ArrayList<>();
            List<Long> oldLabelIdList = new ArrayList<>();
            List<Long> newLabelIdList = new ArrayList<>();

            List<QuestionLabelRelation> oldQuestionLabelRelationList = new ArrayList<>();
            List<QuestionLabelRelation> newQuestionLabelRelationList = new ArrayList<>();
            List<Label> oldLabelList = new ArrayList<>();
            List<Label> newLabelList = new ArrayList<>();

            //解除旧问题标签关系
            Map<String, Object> paramList = DynamicUtil.getQuestionLabelRelationListParam(null, id.toString());
            log.info(" paramList size =  " + paramList.size());

            oldQuestionLabelRelationIdList = questionLabelRelationService.getIdsByDynamicCondition(QuestionLabelRelation.class, paramList, 0, Integer.MAX_VALUE);
            if (CollectionUtils.isEmpty(oldQuestionLabelRelationIdList)) {
                log.info(" questionLabelRelationIdList is null ");
            } else {
                log.info(" questionLabelRelationIdList size =  " + oldQuestionLabelRelationIdList.size());
                oldQuestionLabelRelationList = questionLabelRelationService.getObjectsByIds(oldQuestionLabelRelationIdList);

                //解除关系时更新标签下的问题数
                for (QuestionLabelRelation questionLabelRelation : oldQuestionLabelRelationList) {
                    oldLabelIdList.add(questionLabelRelation.getLabelId());
                }
                questionLabelRelationService.deleteList(QuestionLabelRelation.class, oldQuestionLabelRelationIdList);
                //通过labelIdList得到一个labelList
                oldLabelList = labelService.getObjectsByIds(oldLabelIdList);
                //更新各个标签对应的问题数
                for (Label label : oldLabelList) {
                    label.setQuestionNum(label.getQuestionNum() - 1);
                }
                boolean isUpdateOldLabel = labelService.updateList(oldLabelList);
                if (isUpdateOldLabel) {
                    log.info(" update label success.");
                } else {
                    model.addAttribute("code", -1);
                    return "/common/failure";
                }

            }

            //建立新问题标签关系
            if (StringUtils.isNotBlank(labelIds)) {
                String[] ids = labelIds.split(",");
                for (String labelId : ids) {
                    newLabelIdList.add(Long.valueOf(labelId));
                    QuestionLabelRelation questionLabelRelation = new QuestionLabelRelation();
                    questionLabelRelation.setQuestionId(id);
                    questionLabelRelation.setLabelId(Long.valueOf(labelId));
                    questionLabelRelation.setUpdateBy(userId);
                    questionLabelRelation.setCreateBy(userId);
                    newQuestionLabelRelationList.add(questionLabelRelation);
                }
                questionLabelRelationService.insertList(newQuestionLabelRelationList);
                log.info("newQuestionLabelRelationList size is " + newQuestionLabelRelationList.size());
                newLabelList = labelService.getObjectsByIds(newLabelIdList);
                for (Label label : newLabelList) {
                    label.setQuestionNum(label.getQuestionNum() + 1);
                }
                boolean isUpdateNewLabel = labelService.updateList(newLabelList);
                if (isUpdateNewLabel) {
                    log.info(" update label success.");
                } else {
                    model.addAttribute("code", -1);
                    return "/common/failure";
                }
            }

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update question error,id is  " + question.getId());
            model.addAttribute("code", -1);
        }
        return "/common/success";
    }


    /**
     * 3.1 编辑问题-jsp
     *
     * @param request
     * @param response
     * @param model
     * @param question
     * @param labelIds
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/k/question/edit", method = RequestMethod.GET)
    public String questionEdit(HttpServletRequest request,
                               HttpServletResponse response, ModelMap model, Question question,
                               String labelIds) throws Exception {

        try {
            //未登录返回-2，前端模态框提示用户重新登录
            Long uid = getUserFromCookieUtil.getUserFromCookie(request);
            log.info("uid is " + uid);
            if (DataUtils.isNullOrEmpty(uid)) {
                log.info("user no login");
                model.addAttribute("code", -2);
                return "/common/failure";
            } else {
                model.addAttribute("uid", uid);
            }
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("edit question error");
            model.addAttribute("code", -1);
        }
        return "/web-kenghu/question/questionEdit";
    }


    /**
     * 4.1 搜索问题列表-官网任务热门问题
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @param oid
     * @param tid
     * @param uid
     * @param type     type 1-用户点赞(配合参数uid) 2-用户创建(配合参数createBy)
     * @param status
     * @param adopt
     * @param createBy
     * @param title
     * @param labelIds
     * @param orderBy
     * @param sort
     * @param page
     * @param size
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/question/search", method = RequestMethod.GET)
    public String aSearchQuestionList(
            HttpServletRequest request, HttpServletResponse response, ModelMap model,
            Long id, Long oid, Long tid, Long uid, Integer type,
            Integer status, Integer adopt, Long createBy, String title, String labelIds,
            Integer orderBy, Integer sort,
            Integer page, Integer size)
            throws Exception {

        //打印入参
        log.info("============================================");
        String paramStr = LogUtil.convertParam("/a/question/search  by==id", id, "oid", oid, "tid", tid, "uid", uid, "type", type,
                "status", status, "adopt", adopt, "createBy", createBy, "title", title, "labelIds", labelIds,
                "orderBy", orderBy, "sort", sort, "page", page, "size", size);
        log.info(paramStr);

        Long userId = getUserFromCookieUtil.getUserFromCookie(request);
        log.info("userId is " + userId);

        //初始化page size start
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        String pageStr = LogUtil.convertParam("page", page, "start", start, "size", size);
        log.info(pageStr);

        try {
            List<Question> questionList;

            //获取问题列表
            Map<String, Object> paramList = DynamicUtil.getQuestionListParam(id, oid, tid, uid, type, Constants.STATUS_SHOW, adopt, createBy, title, labelIds, orderBy, sort);
            log.info(" paramList size =  " + paramList.size());

            //获取list
            List<Long> questionIdList = questionService.getIdsByDynamicCondition(Question.class, paramList, start, size);
            if (CollectionUtils.isEmpty(questionIdList)) {
                log.info(" questionIdList is empty ");
                model.addAttribute("code", 0);
                model.addAttribute("size", 0);
                model.addAttribute("total", 0);
                return "/common-skill-service/question/json/questionListJson";
            } else {
                log.info(" questionIdList size =  " + questionIdList.size());
                questionList = questionService.getObjectsByIds(questionIdList);
            }

            //获取total
            List<Long> allQuestion = questionService.getIdsByDynamicCondition(Question.class, paramList, 0, Integer.MAX_VALUE);
            log.info("total is:" + allQuestion.size());

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", questionList.size());
            model.addAttribute("total", allQuestion.size());
            model.addAttribute("questionList", questionList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get label list error,page is " + page + " , size " + size);
            model.addAttribute("code", -1);
        }
        return "/common-skill-service/question/json/questionListJson";
    }


    /**
     * 4.2 搜索问题列表-我的提问
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @param oid
     * @param tid
     * @param uid
     * @param type     type 1-用户点赞(配合参数uid) 2-用户创建(配合参数createBy)
     * @param status
     * @param adopt
     * @param createBy
     * @param title
     * @param labelIds
     * @param orderBy
     * @param sort
     * @param page
     * @param size
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/k/question/search", method = RequestMethod.GET)
    public String searchQuestionList(
            HttpServletRequest request, HttpServletResponse response, ModelMap model,
            Long id, Long oid, Long tid, Long uid, Integer type,
            Integer status, Integer adopt, Long createBy, String title, String labelIds,
            Integer orderBy, Integer sort,
            Integer page, Integer size)
            throws Exception {

        //打印入参
        log.info("============================================");
        String paramStr = LogUtil.convertParam("/k/question/search  by==id", id, "oid", oid, "tid", tid, "uid", uid, "type", type,
                "status", status, "adopt", adopt, "createBy", createBy, "title", title, "labelIds", labelIds,
                "orderBy", orderBy, "sort", sort, "page", page, "size", size);
        log.info(paramStr);

        //未登录返回-2，前端模态框提示用户重新登录
        Long userId = getUserFromCookieUtil.getUserFromCookie(request);
        log.info("userId is " + userId);
        if (DataUtils.isNullOrEmpty(userId)) {
            log.info("user no login");
            model.addAttribute("code", -2);
            return "/web-kenghu/question/questionList";
        }

        //暂不支持获取他人信息，直接取当前用户id
        if (type == 1) {
            uid = userId;
        } else if (type == 2) {
            createBy = userId;
        }

        //初始化page size start
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        String pageStr = LogUtil.convertParam("page", page, "start", start, "size", size);
        log.info(pageStr);

        try {
            //初始值
            List<Long> oidList = new ArrayList<>();
            List<Long> tidList = new ArrayList<>();
            List<Long> labelIdList = new ArrayList<>();

            List<Occupation> occupationList = new ArrayList<>();
            List<Task> taskList = new ArrayList<>();
            List<Question> questionList;
            List<QuestionLabelRelation> questionLabelRelationList = new ArrayList<>();
            List<Label> labelList = new ArrayList<>();

            //获取问题列表
            Map<String, Object> paramList = DynamicUtil.getQuestionListParam(id, oid, tid, uid, type, Constants.STATUS_SHOW, adopt, createBy, title, labelIds, orderBy, sort);
            log.info(" paramList size =  " + paramList.size());

            //获取list
            List<Long> questionIdList = questionService.getIdsByDynamicCondition(Question.class, paramList, start, size);
            if (CollectionUtils.isEmpty(questionIdList)) {
                log.info(" questionIdList is null ");
                model.addAttribute("code", 0);
                model.addAttribute("size", 0);
                model.addAttribute("total", 0);
                model.addAttribute("uid", userId);
                model.addAttribute("type", type);
                return "/web-kenghu/question/questionList";
            } else {
                log.info(" questionIdList size =  " + questionIdList.size());
            }

            //获取total
            List<Long> allQuestion = questionService.getIdsByDynamicCondition(Question.class, paramList, 0, Integer.MAX_VALUE);
            log.info("total is:" + allQuestion.size());

            //获取labelList、occupationList、taskList
            questionList = questionService.getObjectsByIds(questionIdList);
            for (Question question : questionList) {
                oidList.add(question.getOid());
                tidList.add(question.getTid());
            }

            //获取问题标签关系
            String questionIds = StringUtils.join(questionIdList, ",");
            Map<String, Object> questionLabelRelationLisParamList = DynamicUtil.getQuestionLabelRelationListParam(null, questionIds);
            log.info(" questionLabelRelationLisParamList size =  " + questionLabelRelationLisParamList.size());

            List<Long> questionLabelRelationIdList = questionLabelRelationService.getIdsByDynamicCondition(QuestionLabelRelation.class, questionLabelRelationLisParamList, 0, Integer.MAX_VALUE);
            if (CollectionUtils.isEmpty(questionLabelRelationIdList)) {
                log.info(" questionLabelRelationIdList is null ");
            } else {
                log.info(" questionLabelRelationIdList size =  " + questionLabelRelationIdList.size());
                questionLabelRelationList = questionLabelRelationService.getObjectsByIds(questionLabelRelationIdList);

            }

            //一一映射
            Map<Long, QuestionLabelRelation> questionId_questionLabelRelation = MyListUtil.convert2ListMap(QuestionLabelRelation.class.getDeclaredField("questionId"), questionLabelRelationList);
            log.info(questionId_questionLabelRelation);
            for (QuestionLabelRelation questionLabelRelation : questionLabelRelationList) {
                if (questionLabelRelation.getLabelId() != null) {
                    labelIdList.add(questionLabelRelation.getLabelId());
                }
            }

            if (CollectionUtils.isEmpty(labelIdList)) {
                log.info(" labelIdList is null ");
            } else {
                log.info(" labelIdList size =  " + labelIdList.size());
                labelList = labelService.getObjectsByIds(labelIdList);
            }

            if (CollectionUtils.isEmpty(oidList)) {
                log.info(" oidList is null ");
            } else {
                log.info(" oidList size =  " + oidList.size());
                occupationList = occupationService.getObjectsByIds(oidList);
            }

            if (CollectionUtils.isEmpty(tidList)) {
                log.info(" tidList is null ");
            } else {
                log.info(" tidList size =  " + tidList.size());
                taskList = taskService.getObjectsByIds(tidList);
            }

            //用户是否点赞过或者收藏过
            log.info(" login user Id = " + userId);
            if (DataUtils.isNotNullOrEmpty(userId)) {
                questionCtrlUtil.checkQuestionLikeOrCollection(userId, questionIdList, questionList);
            }

            Integer totalPage = 1;
            Integer total = allQuestion.size();
            if (total > 0) {
                totalPage = (total - 1) / size + 1;
            }

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", questionList.size());
            model.addAttribute("pSize", size);
            model.addAttribute("uid", userId);
            model.addAttribute("type", type);
            model.addAttribute("total", total);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("questionList", questionList);
            model.addAttribute("occupationList", occupationList);
            model.addAttribute("taskList", taskList);
            model.addAttribute("labelList", labelList);
            model.addAttribute("questionLabelRelationList", questionLabelRelationList);
            model.addAttribute("questionId_questionLabelRelation", questionId_questionLabelRelation);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get label list error,page is " + page + " , size " + size);
            model.addAttribute("code", -1);
        }
        return "/web-kenghu/question/questionList";
    }

    /**
     * 4.3 搜索问题列表-坑乎入口
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @param oid
     * @param tid
     * @param uid
     * @param type     type 1-用户点赞(配合参数uid) 2-用户创建(配合参数createBy)
     * @param status
     * @param adopt
     * @param createBy
     * @param title
     * @param labelIds
     * @param page
     * @param size
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/kenghu", method = RequestMethod.GET)
    public String searchQuestionList(
            HttpServletRequest request, HttpServletResponse response, ModelMap model,
            Long id, Long oid, Long tid, Long uid, Integer type,
            Integer status, Integer adopt, Long createBy, String title, String labelIds,
            Integer page, Integer size)
            throws Exception {

        //初始化page size start
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        String pageStr = LogUtil.convertParam("page", page, "start", start, "size", size);
        log.info(pageStr);

        Long userId = getUserFromCookieUtil.getUserFromCookie(request);
        log.info("userId is " + userId);

        try {
            //默认oid为1
            if (DataUtils.isNullOrEmpty(oid)) {
                oid = 1L;
            }

            Integer orderBy = Question.ORDER_BY_AGREE_COUNT;
            Integer sort = Constants.SORT_DESC;

            List<Long> labelIdList = new ArrayList<>();

            List<Occupation> occupationList = new ArrayList<>();
            List<Task> taskList = new ArrayList<>();
            List<Question> questionList = new ArrayList<>();
            List<QuestionLabelRelation> questionLabelRelationList = new ArrayList<>();
            List<Label> labelList = new ArrayList<>();
            Map<Long, QuestionLabelRelation> questionId_questionLabelRelation = new HashMap();


            //获取所有职业和任务
            List<Long> oidList = occupationService.getOccupationIds(0, Integer.MAX_VALUE);
            List<Long> tidList = taskService.getTaskIdsByOid(oid, 0, Integer.MAX_VALUE);

            if (CollectionUtils.isEmpty(oidList)) {
                log.info(" oidList is null ");
            } else {
                log.info(" oidList size =  " + oidList.size());
                occupationList = occupationService.getObjectsByIds(oidList);
            }

            if (CollectionUtils.isEmpty(tidList)) {
                log.info(" tidList is null ");
            } else {
                log.info(" tidList size =  " + tidList.size());
                taskList = taskService.getObjectsByIds(tidList);
            }

            //获取问题列表
            Map<String, Object> paramList = DynamicUtil.getQuestionListParam(id, oid, tid, uid, type, Constants.STATUS_SHOW, adopt, createBy, title, labelIds, orderBy, sort);
            log.info(" paramList size =  " + paramList.size());

            //获取list
            List<Long> questionIdList = questionService.getIdsByDynamicCondition(Question.class, paramList, start, size);
            if (CollectionUtils.isEmpty(questionIdList)) {
                log.info(" questionIdList is null ");
                model.addAttribute("code", 0);
                model.addAttribute("page", page);
                model.addAttribute("size", questionList.size());
                model.addAttribute("pSize", size);
                model.addAttribute("total", 0);
                model.addAttribute("totalPage", 0);
                model.addAttribute("oid", oid);
                model.addAttribute("tid", tid);
                model.addAttribute("uid", userId);
                model.addAttribute("adopt", adopt);
                model.addAttribute("labelIds", labelIds);
                model.addAttribute("occupationList", occupationList);
                model.addAttribute("taskList", taskList);
                return "/web-kenghu/index";
            } else {
                log.info(" questionIdList size =  " + questionIdList.size());
                questionList = questionService.getObjectsByIds(questionIdList);
            }


            //处理module json字符串
            Map<Long, JSONArray> modulesMap = new HashMap();
            for (Question question : questionList) {
                if (StringUtils.isNotBlank(question.getModules())) {
                    JSONArray moduleList = JSONArray.fromObject(question.getModules());
                    modulesMap.put(question.getId(), moduleList);
                }
            }

            //获取total
            List<Long> allQuestion = questionService.getIdsByDynamicCondition(Question.class, paramList, 0, Integer.MAX_VALUE);
            log.info("total is:" + allQuestion.size());

            //获取问题标签关系
            String questionIds = StringUtils.join(questionIdList, ",");
            Map<String, Object> questionLabelRelationLisParamList = DynamicUtil.getQuestionLabelRelationListParam(null, questionIds);
            log.info(" questionLabelRelationLisParamList size =  " + questionLabelRelationLisParamList.size());

            List<Long> questionLabelRelationIdList = questionLabelRelationService.getIdsByDynamicCondition(QuestionLabelRelation.class, questionLabelRelationLisParamList, 0, Integer.MAX_VALUE);
            if (CollectionUtils.isEmpty(questionLabelRelationIdList)) {
                log.info(" questionLabelRelationIdList is null ");
            } else {
                log.info(" questionLabelRelationIdList size =  " + questionLabelRelationIdList.size());
                questionLabelRelationList = questionLabelRelationService.getObjectsByIds(questionLabelRelationIdList);

            }

            //一一映射
            questionId_questionLabelRelation = MyListUtil.convert2ListMap(QuestionLabelRelation.class.getDeclaredField("questionId"), questionLabelRelationList);
            log.info(questionId_questionLabelRelation);
            for (QuestionLabelRelation questionLabelRelation : questionLabelRelationList) {
                if (questionLabelRelation.getLabelId() != null) {
                    labelIdList.add(questionLabelRelation.getLabelId());
                }
            }

            Map<Long, Label> labelMap = new HashMap<>();
            if (CollectionUtils.isEmpty(labelIdList)) {
                log.info(" labelIdList is null ");
            } else {
                log.info(" labelIdList size =  " + labelIdList.size());
                labelList = labelService.getObjectsByIds(labelIdList);
                labelMap = MyListUtil.convert2Map(Label.class.getDeclaredField("id"), labelList);
            }

            //用户是否点赞过或者收藏过
            log.info(" login user Id = " + userId);
            if (DataUtils.isNotNullOrEmpty(userId)) {
                questionCtrlUtil.checkQuestionLikeOrCollection(userId, questionIdList, questionList);
            }

            Integer totalPage = 1;
            Integer total = allQuestion.size();
            if (total > 0) {
                totalPage = (total - 1) / size + 1;
            }

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", questionList.size());
            model.addAttribute("pSize", size);
            model.addAttribute("total", total);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("oid", oid);
            model.addAttribute("tid", tid);
            model.addAttribute("uid", userId);
            model.addAttribute("adopt", adopt);
            model.addAttribute("labelIds", labelIds);
            model.addAttribute("questionList", questionList);
            model.addAttribute("modulesMap", modulesMap);
            model.addAttribute("occupationList", occupationList);
            model.addAttribute("taskList", taskList);
            model.addAttribute("labelMap", labelMap);
            model.addAttribute("questionLabelRelationList", questionLabelRelationList);
            model.addAttribute("questionId_questionLabelRelation", questionId_questionLabelRelation);


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get label list error,page is " + page + " , size " + size);
            model.addAttribute("code", -1);
        }
        return "/web-kenghu/index";
    }
}