package com.ptteng.common.skill.util;

import com.gemantic.common.util.StringUtil;
import com.gemantic.dal.config.helper.GroupHelper;
import com.ptteng.common.dao.util.SQLUtil;
import com.ptteng.common.skill.model.*;
import com.ptteng.skill.service.model.UserTaskRelation;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.simple.ParameterizedBeanPropertyRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

import javax.sql.DataSource;
import java.util.*;

/**
 * Created by liangxj on 2015/9/7.
 */
public class DynamicUtil {
    private static final Log log = LogFactory.getLog(DynamicUtil.class);

    public static List<Document> getSkillMastLoveDocument(Long[] sids, Integer type) {

        StringBuilder sidStr = new StringBuilder("");
        int i = 0;
        for (Long sid : sids) {
            i += 1;
            if (i == sids.length) {
                sidStr.append(sid);
            } else {
                sidStr.append(sid + ",");
            }

        }


        log.info("Test 111 ");
        List<Document> indentParmList = new ArrayList<Document>();
        log.info("Test 222 ");
        try {
            DataSource dataSource = GroupHelper.getDataSource("common_skill");
            log.info("Test 333 ");
            if (DataUtils.isNotNullOrEmpty(dataSource)) {
                log.info("  datasource = " + dataSource);
            } else {

            }
            log.info("Test 44 ");
            SimpleJdbcTemplate simpleJdbcTemplate = new SimpleJdbcTemplate(dataSource);
            StringBuilder sql = new StringBuilder();
            sql.append(" SELECT  GROUP_CONCAT(DISTINCT a.sid) sid  ,b.id id, b.love love ,b.document_name document_name ,b.url url from " +
                    "(select   sid,MAX(love) love  from document where sid in(" + sidStr.toString() + ") and type = " + type + " GROUP BY sid) a," +
                    "document b " +
                    "where a.sid = b.sid and b.love = a.love and b.sid in (" + sidStr.toString() + ")  and b.type = " + type + " GROUP BY a.sid");


            log.info("Sql " + sql.toString());
            indentParmList =
                    simpleJdbcTemplate.query(sql.toString(),
                            ParameterizedBeanPropertyRowMapper.newInstance(Document.class));
        } catch (Exception e) {
            e.printStackTrace(System.out);
            log.info(e.getMessage());
        }

        log.info("  size  = " + indentParmList.size());
        return indentParmList;
    }


    public static List<User> getUserVideo(Integer start, Integer limit) {


        log.info("Test 111 ");
        List<User> indentParmList = new ArrayList<User>();
        log.info("Test 222 ");
        try {
            DataSource dataSource = GroupHelper.getDataSource("common_skill");
            log.info("Test 333 ");
            if (DataUtils.isNotNullOrEmpty(dataSource)) {
                log.info("  datasource = " + dataSource);
            } else {

            }
            log.info("Test 44 ");
            SimpleJdbcTemplate simpleJdbcTemplate = new SimpleJdbcTemplate(dataSource);
            StringBuilder sql = new StringBuilder();
            sql.append("select id from user where  graduated_video is not null and graduated_video !=''");
            sql.append("  order by salary desc ");

            sql.append(" limit  " + start + "," + limit);
            log.info("Sql " + sql.toString());
            indentParmList =
                    simpleJdbcTemplate.query(sql.toString(),
                            ParameterizedBeanPropertyRowMapper.newInstance(User.class));
        } catch (Exception e) {
            e.printStackTrace(System.out);
            log.info(e.getMessage());
        }

        log.info("  size  = " + indentParmList.size());
        return indentParmList;
    }


    public static Map<String, Object> getUserListByParams(Long oid, Long tid, Integer branch, Integer identity, Integer level,
                                                          Long studyStartAt, Long studyEndAt, Long graduatedStartAt, Long graduatedEndAt,
                                                          String nick, String type, Integer studyNumber, Integer status, boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("user");
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("user.status", status);
        }
        if (DataUtils.isNotNullOrEmpty(oid)) {
            params.put("user.oid", oid);
        }
        if (DataUtils.isNotNullOrEmpty(branch)) {
            params.put("user.branch", branch);
        }
        if (DataUtils.isNotNullOrEmpty(identity)) {
            params.put("user.identity", identity);
        }
        if (DataUtils.isNotNullOrEmpty(level)) {
            params.put("user.level", level);
        }
        if (DataUtils.isNotNullOrEmpty(studyStartAt)) {
            params.put("user.start_at & >= ", studyStartAt);
        }
        if (DataUtils.isNotNullOrEmpty(studyEndAt)) {
            params.put("user.start_at & <= ", studyEndAt);
        }
        if (DataUtils.isNotNullOrEmpty(graduatedStartAt)) {
            params.put("user.graduate_at & >= ", graduatedStartAt);
        }
        if (DataUtils.isNotNullOrEmpty(graduatedEndAt)) {
            params.put("user.graduate_at & <= ", graduatedEndAt);

        }
        if (StringUtil.isNotEmpty(nick)) {
            params.put("user.nick & like ", "'%" + nick + "%'");
        }
        if (StringUtil.isNotEmpty(type)) {
            params.put("user.type", "'" + type + "'");
        }
        if (DataUtils.isNotNullOrEmpty(studyNumber)) {
            params.put("user.study_number", studyNumber);
        }

        if (DataUtils.isNotNullOrEmpty(tid)) {
            tables.add("user_task_relation");
            params.put("user.id", "user_task_relation.uid");
            params.put("user_task_relation.tid & <= ", tid);

        }

        if (count) {
            params.put("@query", " count(distinct user.id) ");
        } else {
            params.put("@query", " user.id ");
            params.put("@order", "user.start_at desc");

        }


        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        
        /*打印sql语句
        String convert2Sql = SQLUtil.convert2Sql(params, 0, Integer.MAX_VALUE);
        System.out.println("语句："+convert2Sql);
        */
        return params;
    }


    public static void checkUserGraduateStatus(List<User> users) {
        Long now = System.currentTimeMillis();
        for (User user : users) {
            Long graduateAt = user.getGraduateAt();
            if (DataUtils.isNullOrEmpty(graduateAt)) {
                log.info(" user graduateAt is null ,so he dosen't graduate ");
                user.setGraduated(false);
            } else {
                if (graduateAt <= now) {
                    log.info(" user graduateAt<=now ,so he has graduated ");
                    user.setGraduated(true);
                } else {
                    log.info(" user graduateAt>now , so he dosen't graduate ");
                    user.setGraduated(false);
                }
            }

        }
    }


    public static void checkUserGraduateStatus(User user) {
        Long now = System.currentTimeMillis();
        Long graduateAt = user.getGraduateAt();
        if (DataUtils.isNullOrEmpty(graduateAt)) {
            log.info(" user graduateAt is null ,so he dosen't graduate ");
            user.setGraduated(false);
        } else {
            if (graduateAt <= now) {
                log.info(" user graduateAt<=now ,so he has graduated ");
                user.setGraduated(true);
            } else {
                log.info(" user graduateAt>now , so he dosen't graduate ");
                user.setGraduated(false);
            }
        }


    }

    public static Map<String, Object> getMessageListParam(Integer status, String type, Long uid, Integer unread,
                                                          boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty(uid)) {
            params.put(" receive_id ", uid);
        }
        //1-显示正常状态的消息   0-显示删除状态的消息
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put(" status ", status);
        }
        // 0已读，1未读
        if (DataUtils.isNotNullOrEmpty(unread)) {
            params.put(" unread ", unread);
        }
        if (StringUtils.isNotEmpty(type)) {
            //师兄弟关系teacher的消息，目前前台也展示在学院消息classes中
            if (Message.CLASS_TYPE.equals(type)) {
                params.put(" type & in ", "('" + Message.CLASS_TYPE + "','" + Message.TEACHER_TYPE + "')");
            } else {
                params.put(" type ", "'" + type + "'");
            }
        }

        if (count) {
            params.put("@query", " count(id) ");
        } else {

            params.put("@order", "  create_at desc ");

            params.put("@query", " id ");
        }
        params.put("@table", "message");

        return params;

    }

    public static List<DocumentAndSkill> getDocumentIdByMaxLove(Set<Long> skillIDS) {
        log.info("skillIDS: " + skillIDS);
        List<DocumentAndSkill> documentAndSkills = new ArrayList<>();
        try {
            DataSource dataSource = GroupHelper.getDataSource("common_skill");
            log.info("getBeforeNextArticleId datasource: " + dataSource);

            SimpleJdbcTemplate simpleJdbcTemplate = new SimpleJdbcTemplate(dataSource);

            StringBuilder sql = new StringBuilder("");
            StringBuffer sbuf = new StringBuffer();
            for (Long skillID : skillIDS) {
                sbuf.append(skillID);
                sbuf.append(",");
            }
            if (sbuf.length() > 0) {
                sbuf.deleteCharAt(sbuf.length() - 1);
            }


            sql.append("select MAX(love) as love,sid ,id from document where sid in (" + sbuf + ") GROUP BY sid");
            documentAndSkills = simpleJdbcTemplate.query(sql.toString(),
                    ParameterizedBeanPropertyRowMapper.newInstance(DocumentAndSkill.class));
            log.info("ids: " + documentAndSkills.size());
        } catch (Exception e) {
            log.error("getDocumentIdByMaxLove error ", e);
        }
        return documentAndSkills;
    }


    public static Map<String, Object> getUserLoveArticleList(Integer type, Integer orderBy, Integer sort, Long uid,
                                                             boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("user_article_relation");
        tables.add("article");
        params.put(" user_article_relation.aid ", " article.id ");
        params.put(" user_article_relation.whether  ", UserArticleRelation.WHETHER_VALID);
        params.put("user_article_relation.uid", uid);
        if (UserArticleRelation.STATUS_LOVE == type) {
            //点赞
            params.put(" user_article_relation.type ", UserArticleRelation.STATUS_LOVE);
        } else if (UserArticleRelation.STATUS_COLLECTION == type) {
            //收藏
            params.put(" user_article_relation.type  ", UserArticleRelation.STATUS_COLLECTION);
        }

        if (count) {
            params.put("@query", " count(article.id) ");
        } else {
            StringBuilder a = new StringBuilder("");
            if (UserArticleRelation.LOVE == orderBy) {
                a.append("  article.love ").toString();
            } else if (UserArticleRelation.COLLECTION == orderBy) {
                a.append("  article.collection ").toString();
            } else if (UserArticleRelation.ARTICLE_CREATE_AT == orderBy) {
                a.append("  article.create_at ").toString();
            } else if (UserArticleRelation.COMMENT == orderBy) {
                a.append("  article.reply ").toString();
            } else if (UserArticleRelation.READ == orderBy) {
                a.append("  article.read_count ").toString();
            }

            if (UserArticleRelation.DESC == sort) {
                a.append("desc");
            } else if (UserArticleRelation.ASC == sort) {
                a.append("asc");
            }
            params.put("@order", a.toString());
            params.put("@query", " article.id ");
        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;

    }


    public static Map<String, Object> getUserTaskListByTeacherId(Long teacherId,
                                                                 Integer type,
                                                                 boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("user_task_relation");
        tables.add("user");
        params.put(" user_task_relation.uid ", " user.id ");
        params.put(" user.teacher_id ", teacherId);

        if (UserTaskRelation.UNJUDGE == type) {
            params.put(" user_task_relation.progress ", UserTaskRelation.PROGRESS_SUBMITED);

        } else if (UserTaskRelation.JUDGE_FAILD == type) {
            params.put(" user_task_relation.progress  ", UserTaskRelation.PROGRESS_FAIL);

        } else if (UserTaskRelation.JUDGE_PASS == type) {
            params.put(" user_task_relation.progress  ", UserTaskRelation.PROGRESS_PASSED);

        }

        if (count) {
            params.put("@query", " count(user_task_relation.id) ");
        } else {
            if (UserTaskRelation.UNJUDGE == type) {
                params.put("@order", "  user_task_relation.submit_at desc ");
            } else {
                params.put("@order", "  user_task_relation.judge_at desc ");

            }

            params.put("@query", " user_task_relation.id ");
        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;

    }


    public static Map<String, Object> getDocumentListParam(Set<Long> skillIDS,
                                                           boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("document");

        if (skillIDS.size() > 0) {
            StringBuffer sbuf = new StringBuffer();
            for (Long skillID : skillIDS) {
                sbuf.append(skillID);
                sbuf.append(",");
            }
            if (sbuf.length() > 0) {
                sbuf.deleteCharAt(sbuf.length() - 1);
                params.put("sid & in ", "(" + sbuf + ")");
            }
        }

        if (count) {
            params.put("@query", " count(id) ");
        } else {

            params.put("@order", "  love desc ");

            params.put("@query", " id ");
        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;

    }

    public static Map<String, Object> getUserDocumentRelationListParam(Long uid, List<Long> dids,
                                                                       Integer type, Integer status, Integer whether, boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("user_document_relation");

        if (type != null) {
            params.put("type", type);
        }

        if (status != null) {
            params.put("status", status);
        }

        if (whether != null) {
            params.put("whether", whether);
        }

        if (uid != null) {
            params.put("uid", uid);
        }

        if (dids != null) {
            if (dids.size() > 0) {
                StringBuffer sbuf = new StringBuffer();
                for (Long did : dids) {
                    sbuf.append(did.toString());
                    sbuf.append(",");
                }
                if (sbuf.length() > 0) {
                    sbuf.deleteCharAt(sbuf.length() - 1);
                    params.put("document_id & in ", "(" + sbuf.toString() + ")");
                }
            }
        }

        if (count) {
            params.put("@query", " count(document_id) ");
        } else {
            params.put("@query", " distinct(document_id) ");
        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;
    }

    public static Map<String, Object> getArticleAuthorListParam(Long uid, Long tid, Long cid, Long oid,
                                                                Long createAt, Long endAt, boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("article");


        if (uid != null) {

            params.put("article.uid", uid);

        }


        if (tid != null) {

            params.put("article_task_relation.tid", tid);
            params.put("article.id", "article_task_relation.did");
            tables.add("article_task_relation");

        }

        if (cid != null) {

            params.put("article.cid", cid);

        }


        if (oid != null) {

            params.put("article.oid", oid);

        }


        if (createAt != null) {
            params.put("article.create_at & > ", createAt);

        }


        if (endAt != null) {
            params.put("article.create_at & < ", endAt);

        }

        if (count) {
            params.put("@query", " count(article.uid) ");
        } else {

            params.put("@order", "  article.create_at desc ");

            params.put("@query", " distinct(article.uid) ");
        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;

    }

    public static Map<String, Object> getStudentsArticleParam(List<Long> uidList,String type, Long oid, Integer orderBy, Integer sort,
                                                              Integer stuEvaluation, boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        if (oid != null) {
            params.put("oid", oid);
        }

        if (DataUtils.isNotNullOrEmpty(stuEvaluation)) {
            if (stuEvaluation == 1) {
                params.put("evaluation & is  null ", "");
            } else if (stuEvaluation == 2) {
                params.put("evaluation & is not null ", "");
            } else {
                params.put("evaluation & is  null ", "");
            }
        }

        if (StringUtils.isNotBlank(type)) {
            params.put("type", "'" + type + "'");
        }


        if (CollectionUtils.isNotEmpty(uidList)) {
            StringBuffer sbuf = new StringBuffer();
            for (Long uid : uidList) {
                if (uid != null) {
                    sbuf.append(uid.toString());
                    sbuf.append(",");
                }
            }
            if (sbuf.length() > 0) {
                sbuf.deleteCharAt(sbuf.length() - 1);
                params.put("uid & in ", "(" + sbuf.toString() + ")");
            }
        }

        if (count) {
            params.put("@query", " count(id) ");
        } else {
            StringBuilder a = new StringBuilder("");
            if (UserArticleRelation.LOVE == orderBy) {
                a.append("  article.love ").toString();
            } else if (UserArticleRelation.COLLECTION == orderBy) {
                a.append("  article.collection ").toString();
            } else if (UserArticleRelation.ARTICLE_CREATE_AT == orderBy) {
                a.append("  article.create_at ").toString();
            } else if (UserArticleRelation.COMMENT == orderBy) {
                a.append("  article.reply ").toString();
            } else if (UserArticleRelation.READ == orderBy) {
                a.append("  article.read_count ").toString();
            }

            if (UserArticleRelation.DESC == sort) {
                a.append("desc");
            } else if (UserArticleRelation.ASC == sort) {
                a.append("asc");
            }

            params.put("@order", a.toString());

            params.put("@query", " id ");
        }

        params.put("@table", "article");

        return params;

    }

    public static Map<String, Object> getNearStudentsArticleParam(List<Long> uidList, Long startAt, Long endAt) {

        Map<String, Object> params = new HashMap<String, Object>();

        if (CollectionUtils.isNotEmpty(uidList)) {
            StringBuffer sbuf = new StringBuffer();
            for (Long uid : uidList) {
                if (uid != null) {
                    sbuf.append(uid.toString());
                    sbuf.append(",");
                }
            }
            if (sbuf.length() > 0) {
                sbuf.deleteCharAt(sbuf.length() - 1);
                params.put("uid & in ", "(" + sbuf.toString() + ")");
            }
        }

        if (null != startAt) {

            params.put(" create_at & > ", startAt);

            params.put("@order", " create_at ");
        }

        if (null != endAt) {

            params.put(" create_at & < ", endAt);

            params.put("@order", " create_at DESC ");
        }


        params.put("@query", " id ");

        params.put("@table", "article");

        return params;

    }

    public static Map<String, Object> getArticleListByDirectionParam(Long uid, Long tid, Long cid, Long oid,
                                                                     Long createAt, Long endAt, boolean direction, boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("article");


        if (uid != null) {

            params.put("article.uid", uid);

        }


        if (tid != null) {

            params.put("article_task_relation.tid", tid);
            params.put("article.id", "article_task_relation.did");
            tables.add("article_task_relation");

        }

        if (cid != null) {

            params.put("article.cid", cid);

        }


        if (oid != null) {

            params.put("article.oid", oid);

        }


        if (createAt != null) {
            params.put("article.create_at & > ", createAt);
        }


        if (endAt != null) {
            params.put("article.create_at & < ", endAt);


        }

        if (count) {
            params.put("@query", " count(article.id) ");
        } else {
            params.put("@query", " article.id ");

            if (direction && createAt != null) {
                params.put("@order", "  article.create_at ");
            } else {
                params.put("@order", "  article.create_at desc ");
            }
        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;

    }


    public static Map<String, Object> getArticleListParam(Long uid, Long tid, Long cid, Long oid,
                                                          Long createAt, Long endAt, boolean direction, Integer orderBy, Integer sort, boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("article");


        if (uid != null) {

            params.put("article.uid", uid);

        }


        if (tid != null) {

            params.put("article_task_relation.tid", tid);
            params.put("article.id", "article_task_relation.did");
            tables.add("article_task_relation");

        }

        if (cid != null) {

            params.put("article.cid", cid);

        }


        if (oid != null) {

            params.put("article.oid", oid);

        }


        if (createAt != null) {
            params.put("article.create_at & > ", createAt);
        }


        if (endAt != null) {
            params.put("article.create_at & < ", endAt);


        }

        if (count) {
            params.put("@query", " count(article.id) ");
        } else {
            StringBuilder a = new StringBuilder("");
            if (UserArticleRelation.LOVE == orderBy) {
                a.append("  article.love ").toString();
            } else if (UserArticleRelation.COLLECTION == orderBy) {
                a.append("  article.collection ").toString();
            } else if (UserArticleRelation.ARTICLE_CREATE_AT == orderBy) {
                a.append("  article.create_at ").toString();
            } else if (UserArticleRelation.COMMENT == orderBy) {
                a.append("  article.reply ").toString();
            } else if (UserArticleRelation.READ == orderBy) {
                a.append("  article.read_count ").toString();
            }

            if (UserArticleRelation.DESC == sort) {
                a.append("desc");
            } else if (UserArticleRelation.ASC == sort) {
                a.append("asc");
            }
            params.put("@order", a.toString());
            params.put("@query", " article.id ");
        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;

    }

    public static Map<String, Object> getArticleListByParam(Long uid, Long tid, Long cid, Long oid,
                                                            Long createAt, Long endAt, boolean direction, Integer orderBy, Integer sort,
                                                            Integer evaluation, String userType, Long userOid, Integer studyNumber,
                                                            String type,List<Long> teamIds,Integer status,Long seniorId,boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("article");

        if (type!=null) {
            params.put(" type ", "'" + type + "'");
        }

        if (uid != null) {

            params.put("article.uid", uid);

        }

        if (seniorId != null) {

            params.put("article.senior_id", seniorId);

        }



        if (tid != null) {

            params.put("article_task_relation.tid", tid);
            params.put("article.id", "article_task_relation.did");
            tables.add("article_task_relation");

        }

        if (cid != null) {

            params.put("article.cid", cid);

        }


        if (status != null) {

            params.put("article.status", status);

        }


        if (oid != null) {

            params.put("article.oid", oid);

        }

        StringBuffer tids = new StringBuffer();

        if(CollectionUtils.isNotEmpty(teamIds)){
            for (Long teamId : teamIds){
                if (null!=teamId){
                    tids.append(teamId.toString());
                    tids.append(",");
                }
            }
            if (tids.length()>0) {
                tids.deleteCharAt(tids.length() - 1);
                params.put("team_id & in ", "(" + tids.toString() + ")");
            }
        }


        if (createAt != null) {
            params.put("article.create_at & >= ", createAt);
        }


        if (endAt != null) {
            params.put("article.create_at & <= ", endAt);


        }

        if (DataUtils.isNotNullOrEmpty(evaluation)) {
            params.put(" article.evaluation", "'" + evaluation + "'");
        }
        if (DataUtils.isNotNullOrEmpty(userType)
                || DataUtils.isNotNullOrEmpty(userOid)
                || DataUtils.isNotNullOrEmpty(studyNumber)) {
            tables.add("user");
            params.put("article.uid ", "user.id");
            if (DataUtils.isNotNullOrEmpty(userType)) {
                params.put("user.type ", "'" + userType + "'");
            }
            if (DataUtils.isNotNullOrEmpty(userOid)) {
                params.put(" user.oid ", userOid);
            }
            if (DataUtils.isNotNullOrEmpty(studyNumber)) {
                params.put("user.study_number ", studyNumber);
            }
        }


        if (count) {
            params.put("@query", " count(article.id) ");
        } else {
            StringBuilder a = new StringBuilder("");
            if (UserArticleRelation.LOVE == orderBy) {
                a.append("  article.love ");
            } else if (UserArticleRelation.COLLECTION == orderBy) {
                a.append("  article.collection ");
            } else if (UserArticleRelation.ARTICLE_CREATE_AT == orderBy) {
                a.append("  article.create_at ");
            } else if (UserArticleRelation.COMMENT == orderBy) {
                a.append("  article.reply ");
            } else if (UserArticleRelation.READ == orderBy) {
                a.append("  article.read_count ");
            }

            if (UserArticleRelation.DESC == sort) {
                a.append("desc");
            } else if (UserArticleRelation.ASC == sort) {
                a.append("asc");
            }
            params.put("@order", a.toString());
            params.put("@query", " article.id ");
        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;

    }
    //晨报搜索不带uid
    public static Map<String, Object> getArticleListPaper( Long tid, Long cid, Long oid,
                                                            Long createAt, Long endAt, boolean direction, Integer orderBy, Integer sort,
                                                            Integer evaluation, String userType, Long userOid, Integer studyNumber,
                                                            String type,List<Long> teamIds,Integer status,Long seniorId,boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("article");

        if (type!=null) {
            params.put(" type ", "'" + type + "'");
        }

//        if (uid != null) {
//
//            params.put("article.uid", uid);
//
//        }

        if (seniorId != null) {

            params.put("article.senior_id", seniorId);

        }



        if (tid != null) {

            params.put("article_task_relation.tid", tid);
            params.put("article.id", "article_task_relation.did");
            tables.add("article_task_relation");

        }

        if (cid != null) {

            params.put("article.cid", cid);

        }


        if (status != null) {

            params.put("article.status", status);

        }


        if (oid != null) {

            params.put("article.oid", oid);

        }

        StringBuffer tids = new StringBuffer();

        if(CollectionUtils.isNotEmpty(teamIds)){
            for (Long teamId : teamIds){
                if (null!=teamId){
                    tids.append(teamId.toString());
                    tids.append(",");
                }
            }
            if (tids.length()>0) {
                tids.deleteCharAt(tids.length() - 1);
                params.put("team_id & in ", "(" + tids.toString() + ")");
            }
        }


        if (createAt != null) {
            params.put("article.create_at & >= ", createAt);
        }


        if (endAt != null) {
            params.put("article.create_at & <= ", endAt);


        }

        if (DataUtils.isNotNullOrEmpty(evaluation)) {
            params.put(" article.evaluation", "'" + evaluation + "'");
        }
        if (DataUtils.isNotNullOrEmpty(userType)
                || DataUtils.isNotNullOrEmpty(userOid)
                || DataUtils.isNotNullOrEmpty(studyNumber)) {
            tables.add("user");
            params.put("article.uid ", "user.id");
            if (DataUtils.isNotNullOrEmpty(userType)) {
                params.put("user.type ", "'" + userType + "'");
            }
            if (DataUtils.isNotNullOrEmpty(userOid)) {
                params.put(" user.oid ", userOid);
            }
            if (DataUtils.isNotNullOrEmpty(studyNumber)) {
                params.put("user.study_number ", studyNumber);
            }
        }


        if (count) {
            params.put("@query", " count(article.id) ");
        } else {
            StringBuilder a = new StringBuilder("");
            if (UserArticleRelation.LOVE == orderBy) {
                a.append("  article.love ");
            } else if (UserArticleRelation.COLLECTION == orderBy) {
                a.append("  article.collection ");
            } else if (UserArticleRelation.ARTICLE_CREATE_AT == orderBy) {
                a.append("  article.create_at ");
            } else if (UserArticleRelation.COMMENT == orderBy) {
                a.append("  article.reply ");
            } else if (UserArticleRelation.READ == orderBy) {
                a.append("  article.read_count ");
            }

            if (UserArticleRelation.DESC == sort) {
                a.append("desc");
            } else if (UserArticleRelation.ASC == sort) {
                a.append("asc");
            }
            params.put("@order", a.toString());
            params.put("@query", " article.id ");
        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;

    }


    public static Map<String, Object> getTaskListParam(Long id, Long oid,Long sid,
                                                       boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("task");

        if (id != null) {

            params.put("task.id", id);

        }
        if (id != oid) {

            params.put("task.oid", oid);

        }
        if (null != sid) {

            params.put("task.sid", sid);

        }


        if (count) {
            params.put("@query", " count(task.id) ");
        } else {

            params.put("@order", "  task.num ");

        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;
    }

    public static Map<String, Object> getCommentListParam(Long did,
                                                          Long startAt, Long endAt, boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("comment");

        if (did != null) {

            params.put("comment.did", did);

        }


        if (count) {
            params.put("@query", " count(comment.id) ");
        } else {

            params.put("@order", "  comment.create_at ");

        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;
    }

    //有uid则依据uid、oid、status查询，否则依据oid、type、status查询
    public static Map<String, Object> getClassesListParam(Long oid, Long uid,
                                                          String type, Long status, Integer branch, boolean count) {

        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();


        if (uid != null) {
            if (oid != null) {
                params.put("oid", oid);
            }

            if (status != null) {
                params.put("user_class_relation.status", status);
            }
            //个人班级只传uid，按照更新时间排序
            params.put("user_class_relation.uid", uid);

            if (count) {
                params.put("@query", " count(user_class_relation.cid) ");
            } else {
                params.put("user_class_relation.cid", "classes.id");
                params.put("@query", " distinct(user_class_relation.cid) ");
                params.put("@order", "  user_class_relation.update_at desc ");
            }

            tables.add("user_class_relation");
            tables.add("classes");
        } else {
            if (oid != null) {
                params.put("oid", oid);
            }

            if (status != null) {
                params.put("status", status);
            }
            if (StringUtils.isNotBlank(type)) {
                params.put("type", "'" + type + "'");
            }
            if (DataUtils.isNotNullOrEmpty(branch)) {
                params.put("branch", branch);
            }

            if (count) {
                params.put("@query", " count(id) ");
            } else {
                params.put("@query", " id ");
                params.put("@order", "  name+0 desc ");
            }

            tables.add("classes");
        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;
    }


    public static Map<String, Object> getHisStudentRelationListParam(Long teacherId, String type, boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        if (StringUtils.isNotBlank(type)) {
            params.put("type", "'" + type + "'");
        }

        if (CheckDataUtil.isNotNull(teacherId)) {
            params.put("teacher_id", teacherId);
        }

        if (count) {
            params.put("@query", " count(id) ");
        } else {
            params.put("@order", "  update_at desc ");
            params.put("@query", "  id ");
        }

        params.put("@table", "user");

        return params;
    }


    public static Map<String, Object> getAllUserClassRelationIdsByUids(List<Long> uids, boolean count) {

        Map<String, Object> params = new HashMap<String, Object>();

        if (CollectionUtils.isNotEmpty(uids)) {
            StringBuffer sbuf = new StringBuffer();
            for (Long uid : uids) {
                sbuf.append(uid.toString());
                sbuf.append(",");
            }
            if (sbuf.length() > 0) {
                sbuf.deleteCharAt(sbuf.length() - 1);
                params.put(" uid & in ", "(" + sbuf.toString() + ")");
            }
        }

        if (count) {
            params.put("@query", " count(id) ");
        } else {

            params.put("@query", " id ");

        }

        params.put("@table", " user_class_relation ");

        return params;
    }


    /**
     * 查找师兄，用来分配给师弟师兄
     *
     * @param oid
     * @param identify
     * @param orderBy
     * @param count
     * @return
     */
    public static Map<String, Object> getTeacherInfoListParam(Long oid, Integer identify, String orderBy, boolean count) {

        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();

        tables.add("user");
        tables.add("teacher");
        tables.add("branch_institute");

        if (CheckDataUtil.isNotNull(oid)) {
            if (Occupation.CSS_ID.equals(oid)) {
                params.put("user.oid & in ", "(" + Occupation.CSS_ID + "," + Occupation.JS_ID + ")");

            } else {
                params.put("user.oid", oid);
            }
        }
        //只有为结业的可作为师兄，已结业不可
        params.put("(user.graduate_at & > ", System.currentTimeMillis() + " or user.graduate_at is null )");
        //只有正常状态的用户可以作为师兄，退学用户不可
        params.put("user.status", User.Status_Student);
        if (count) {
            params.put("@query", " count(user.id) ");

        } else {
            params.put("@query", " user.id ");
        }


        params.put("user.id", "teacher.id");
        params.put("user.identity", identify);
        params.put("@order", " teacher." + orderBy);

        //只有所在分院设置为可分配师弟的学员，才可以作为师兄
        params.put("user.branch", "branch_institute.id");
        params.put("branch_institute.teacher", BranchInstitute.Is_teacher);

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;


    }

    public static Map<String, Object> getMyCreateDocumentList(Integer type, Long uid,
                                                              Integer orderBy, Integer sort,
                                                              boolean count) {

        Map<String, Object> params = new HashMap<String, Object>();

        if (DataUtils.isNotNullOrEmpty(uid)) {
            params.put("document.author ", uid);
        }
        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put(" document.type", type);
        }


        if (count) {
            params.put("@query", " count(document.id) ");
        } else {
            StringBuilder a = new StringBuilder("");
            if (UserArticleRelation.LOVE == orderBy) {
                a.append("  document.love ").toString();
            } else if (UserArticleRelation.COLLECTION == orderBy) {
                a.append("  document.collection ").toString();
            } else if (UserArticleRelation.ARTICLE_CREATE_AT == orderBy) {
                a.append("  document.create_at ").toString();
            }

            if (UserArticleRelation.DESC == sort) {
                a.append("desc");
            } else if (UserArticleRelation.ASC == sort) {
                a.append("asc");
            }
            params.put("@order", a.toString());
            params.put("@query", " document.id ");
        }

        params.put("@table", "document");

        return params;
    }

    public static Map<String, Object> getMyCollectionDocumentList(Integer type, Long uid, Integer status, Integer weather,
                                                                  Integer orderBy, Integer sort,
                                                                  boolean count) {

        Map<String, Object> params = new HashMap<String, Object>();
        Set<String> tables = new HashSet();
        tables.add("document");
        tables.add("user_document_relation");
        params.put("document.id", " user_document_relation.document_id");
        if (DataUtils.isNotNullOrEmpty(uid)) {
            params.put("user_document_relation.uid ", uid);
        }
        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put(" document.type", type);
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("user_document_relation.status", status);
        }
        if (DataUtils.isNotNullOrEmpty(weather)) {
            params.put(" user_document_relation.whether", weather);
        }

        if (count) {
            params.put("@query", " count(user_document_relation.id) ");
        } else {
            StringBuilder a = new StringBuilder("");
            if (UserArticleRelation.LOVE == orderBy) {
                a.append("  document.love ").toString();
            } else if (UserArticleRelation.COLLECTION == orderBy) {
                a.append("  document.collection ").toString();
            } else if (UserArticleRelation.ARTICLE_CREATE_AT == orderBy) {
                a.append("  document.create_at ").toString();
            }

            if (UserArticleRelation.DESC == sort) {
                a.append("desc");
            } else if (UserArticleRelation.ASC == sort) {
                a.append("asc");
            }
            params.put("@order", a.toString());
            params.put("@query", " user_document_relation.id ");
        }
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }


    public static Map<String, Object> getDocumentQueryListParam(Integer type, Integer rating, Long oid, Long[] sids,
                                                                String name, Integer orderBy, Integer sort,
                                                                String userType, Integer studyNumber,
                                                                boolean count) {

        Map<String, Object> params = new HashMap<String, Object>();
        Set<String> tables = new HashSet();
        tables.add("document");
        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put("document.type", type);
        }

        StringBuffer sbuf = new StringBuffer();

        if (DataUtils.isNotNullOrEmpty(sids)) {

            if (sids.length > 0) {
                for (Long sid : sids) {
                    if (null != sid) {
                        sbuf.append(sid.toString());
                        sbuf.append(",");
                    }
                }

                if (sbuf.length() > 0) {
                    sbuf.deleteCharAt(sbuf.length() - 1);
                    params.put("document.sid & in ", "(" + sbuf.toString() + ")");
                }

                sbuf.setLength(0);
            }

        } else if (null != oid) {

            params.put("document.oid", oid);

        } else {

        }

        if (StringUtils.isNotBlank(name)) {

            params.put("document.document_name & like ", "'%" + name + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(userType)
                || DataUtils.isNotNullOrEmpty(studyNumber)) {
            tables.add("user");
            params.put("document.author ", "user.id");
            if (DataUtils.isNotNullOrEmpty(userType)) {
                params.put("user.type ", "'" + userType + "'");
            }
            if (DataUtils.isNotNullOrEmpty(studyNumber)) {
                params.put("user.study_number ", studyNumber);
            }
        }


        if (DataUtils.isNotNullOrEmpty(rating)) {
            switch (rating) {
                case Document.LOW:
                    params.put(" document.love & > ", Document.NORMAL_UP_LIMIT);
                    break;
                case Document.NORMAL:
                    params.put(" document.love & BETWEEN " + Document.NORMAL_DOWN_LIMIT + " AND " + Document.NORMAL_UP_LIMIT + " ", "");
                    break;
                case Document.BEST:
                    params.put(" document.love & < ", Document.NORMAL_DOWN_LIMIT);
                    break;
                default:
                    break;
            }
        }

		/* 正序的情况 */
        if (CheckDataUtil.equal(sort, 1)) {
            switch (orderBy) {
                case 1:
                    params.put("@order", " document.love ");
                    break;
                case 2:
                    params.put("@order", " document.collection ");
                    break;
                default:
                    params.put("@order", " document.create_at ");
                    break;
            }

		/* 逆序的情况 */
        } else {
            switch (orderBy) {
                case 1:
                    params.put("@order", " document.love desc ");
                    break;
                case 2:
                    params.put("@order", " document.collection desc ");
                    break;
                default:
                    params.put("@order", " document.create_at desc ");
                    break;
            }
        }

        if (count) {

            params.put("@query", " count(document.id) ");
        } else {


            params.put("@query", " document.id ");
        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;

    }

    public static Map<String, Object> getDocumentParamByType(Integer type, boolean count) {

        Map<String, Object> params = new HashMap<String, Object>();

        if (CheckDataUtil.isNotNull(type)) {
            params.put("type", type);
        }

        if (count) {
            params.put("@query", " count(id) ");
        } else {
            params.put("@order", " love desc ");
            params.put("@query", " id ");
        }

        params.put("@table", "document");

        return params;

    }

    public static Map<String, Object> getDocumentRelationListParam(List<Long> dids, Long uid, boolean count) {

        Map<String, Object> params = new HashMap<String, Object>();

        StringBuffer sbuf = new StringBuffer();

        if (CollectionUtils.isNotEmpty(dids)) {

            for (Long did : dids) {
                if (null != did) {
                    sbuf.append(did.toString());
                    sbuf.append(",");
                }
            }

            if (sbuf.length() > 0) {
                sbuf.deleteCharAt(sbuf.length() - 1);
                params.put("document_id & in ", "(" + sbuf.toString() + ")");
            }

            sbuf.setLength(0);
        }

        if (null != uid) {

            params.put("uid", uid);
        }

        if (count) {

            params.put("@query", " count(id) ");
        } else {

            params.put("@query", " id ");
        }

		/* 只获取有效记录 */
        params.put("whether", UserArticleRelation.WHETHER_VALID);

        params.put("@table", "user_document_relation");

        return params;

    }

    public static Map<String, Object> getArticleRelationListParam(List<Long> aIds, Long uid, boolean count) {

        Map<String, Object> params = new HashMap<String, Object>();

        StringBuffer sbuf = new StringBuffer();

        if (CollectionUtils.isNotEmpty(aIds)) {

            for (Long did : aIds) {
                if (null != did) {
                    sbuf.append(did.toString());
                    sbuf.append(",");
                }
            }

            if (sbuf.length() > 0) {
                sbuf.deleteCharAt(sbuf.length() - 1);
                params.put("aid  & in ", "(" + sbuf.toString() + ")");
            }

            sbuf.setLength(0);
        }

        if (null != uid) {

            params.put("uid", uid);
        }

        if (count) {

            params.put("@query", " count(id) ");
        } else {

            params.put("@query", " id ");
        }


		/* 只获取有效记录 */
        params.put("whether", UserArticleRelation.WHETHER_VALID);

        params.put("@table", "user_article_relation");

        return params;

    }


    /**
     * 第一种方法：根据评级查询该评级下每个任务的日报的id（不使用）
     * 用户任务统计接口调用动态查询
     * 用户每个任务下上、中、下的数量
     */
    public static Map<String, Object> getArticleIdsByUidAndEvaluationAndOid(Long uid, Integer evaluation, Long oid) {

        Map<String, Object> params = new HashMap<String, Object>();

        if (CheckDataUtil.isNotNull(uid)) {
            params.put("uid", uid);
        }
        if (CheckDataUtil.isNotNull(evaluation)) {
            params.put("evaluation", evaluation);
        }
        if (CheckDataUtil.isNotNull(oid)) {
            params.put("oid", oid);
        }
        params.put("@query", " id ");

        params.put("@table", "article");

        log.info("getArticleIdsByUidAndEvaluationAndOid sql is " + SQLUtil.convert2Sql(params, 0, 0));

        return params;

    }


    /**
     * 第二种方法：每个任务下日报的id（使用）
     * 用户任务统计接口调用动态查询
     * 用户每个任务下上、中、下的数量
     */
    public static Map<String, Object> getArticleIdsByUidAndTid(Long uid, Long tid) {

        Map<String, Object> params = new HashMap<String, Object>();
        params.put("@query", " id ");
        params.put("@table", "article");

        if (CheckDataUtil.isNotNull(uid)) {
            params.put("uid", uid);
        }
        if (CheckDataUtil.isNotNull(tid)) {
            params.put("(tids", "'[" + tid + "]'" + " or " + " tids  like " + "'%," + tid + "]%')");
        }

        log.info("getArticleIdsByUidAndEvaluationAndOid sql is " + SQLUtil.convert2Sql(params, 0, 0));
        return params;

    }

    /**
     * 查询用户已完成的任务id
     *
     * @param uid
     * @param oid
     * @return
     */
    public static Map<String, Object> getUserTaskRelationIdsIdsByUidAndOid(Long uid, Long oid) {

        Map<String, Object> params = new HashMap<String, Object>();
        params.put("@query", " id ");
        params.put("@table", "user_task_relation");

        if (CheckDataUtil.isNotNull(uid)) {
            params.put("uid", uid);
        }
        if (CheckDataUtil.isNotNull(oid)) {
            params.put("oid", oid);
        }
        params.put("progress", UserTaskRelation.PROGRESS_PASSED);

        log.info("getArticleIdsByUidAndEvaluationAndOid sql is " + SQLUtil.convert2Sql(params, 0, 0));
        return params;

    }

    //获取日报下篇 id
    public static Map<String, Object> getDownArticleByDidAndOid(Long did, Long oid) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("@query", " id ");
        params.put("@table", "article");
        if (CheckDataUtil.isNotNull(did)) {
            params.put("id  &<", did);
        }
        if (CheckDataUtil.isNotNull(oid)) {
            params.put("oid", oid);
        }
        params.put("@order", "id desc");
        log.info("sql is ： " + SQLUtil.convert2Sql(params, 0, 1));
        return params;
    }

    //获取日报上篇 id
    public static Map<String, Object> getUpArticleByDidAndOid(Long did, Long oid) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("@query", " id ");
        params.put("@table", "article");
        if (CheckDataUtil.isNotNull(did)) {
            params.put("id  &>", did);
        }
        if (CheckDataUtil.isNotNull(oid)) {
            params.put("oid", oid);
        }
        log.info("sql is ： " + SQLUtil.convert2Sql(params, 0, 1));
        return params;
    }


    public static Map<String, Object> getContentsQueryListParam(Integer[] type,
                                                                Integer status,
                                                                String title,
                                                                Long createBy,
                                                                Long createStartAt,
                                                                Long createEndAt,
                                                                Long publishStartAt,
                                                                Long publishEndAt, boolean isCount) {

        Map<String, Object> params = new HashMap<String, Object>();


        if (DataUtils.isNotNullOrEmpty(type)) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            if (type != null) {
                for (Integer t : type) {
                    if (t != null) {
                        sb.append(t.toString());
                        sb.append(",");
                        i++;
                    }
                }
            }
            sb.deleteCharAt(sb.length() - 1);
            params.put("type & in ", "(" + sb.toString() + ")");
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", status);
        }
        if (DataUtils.isNotNullOrEmpty(title)) {
            params.put("title", "'" + title + "'");
        }
        if (DataUtils.isNotNullOrEmpty(createBy)) {
            params.put("create_by", createBy);
        }
        if (DataUtils.isNotNullOrEmpty(createStartAt)) {
            params.put("create_at & >=", createStartAt);
        }
        if (DataUtils.isNotNullOrEmpty(createEndAt)) {
            params.put("create_at & <=", createEndAt);
        }
        if (DataUtils.isNotNullOrEmpty(publishStartAt)) {
            params.put("publish_at & >=", publishStartAt);
        }
        if (DataUtils.isNotNullOrEmpty(publishEndAt)) {
            params.put("publish_at & <=", publishEndAt);
        }


        if (isCount) {
            params.put("@query", "count(id) ");
        } else {
            params.put("@order", "update_at desc ");
            params.put("@query", "id ");
        }
        params.put("@table", "contents ");

        return params;
    }


    public static Map<String, Object> getQueryBranchList(String name, Long uid,
                                                         String qq, Integer period, String phone, String url, String address, Integer status) {


        Map<String, Object> params = new HashMap<String, Object>();
//        Set<String> tables = new HashSet();
//        tables.add("branch_institute b");
        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put("name & like", "'%" + name + "%'");
        }

        if (uid != null) {

            params.put("uid", uid);

        }


        if (DataUtils.isNotNullOrEmpty(qq)) {
            params.put("qq", qq);

        }
        if (DataUtils.isNotNullOrEmpty(period)) {
            params.put("period", period);
        }


        if (DataUtils.isNotNullOrEmpty(phone)) {
            params.put("phone", status);
        }

        if (DataUtils.isNotNullOrEmpty(url)) {
            params.put("url", url);
        }

        if (DataUtils.isNotNullOrEmpty(address)) {
            params.put("address", address);
        }

        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", status);
        }


        return params;
    }

    public static Map<String, Object> getUserListParam2(String nick) {
        Map<String, Object> params = new HashMap<String, Object>();

        if (DataUtils.isNotNullOrEmpty(nick)) {
            params.put("nick & like", "'%" + nick + "%'");
        }


        return params;
    }

    //获取请假记录
    public static Map<String, Object> getLeavesListParam(Long uid, String nick, Long oid, Integer identity, String type,
                                                         Long startAt, Long endAt, boolean count) {


        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();

        tables.add("user user");
        tables.add("leaves leaves");
        params.put("leaves.uid", "user.id");

        if (DataUtils.isNotNullOrEmpty(uid)) {
            params.put("user.id", uid);
        }

        if (StringUtils.isNotBlank(nick)) {
            params.put(" user.nick & like ", "'%" + nick + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(oid)) {
            params.put("user.oid", oid);
        }
        if (DataUtils.isNotNullOrEmpty(identity)) {
            params.put("user.identity", identity);
        }
        if (StringUtils.isNotBlank(type)) {
            params.put("user.type", "'" + type + "'");
        }
        if (DataUtils.isNotNullOrEmpty(startAt)) {
            params.put("leaves.start_at & >= ", startAt);
        }
        if (DataUtils.isNotNullOrEmpty(endAt)) {
            params.put("leaves.start_at &  <= ", endAt);
        }

        if (count) {
            params.put("@query", " count(leaves.id) ");
        } else {
            params.put("@order", " leaves.start_at desc ");
            params.put("@query", " leaves.id ");
        }
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }

    //查询常量列表
    public static Map<String, Object> getConstantListParam(String type, String name, String value, String comments, Long startAt, Long endAt, boolean count) {


        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        log.info("start select from constant");
        tables.add("constant");

        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put(" type & like ", "'%" + type + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put(" name & like ", "'%" + name + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(value)) {
            params.put(" value & like ", "'%" + value + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(comments)) {
            params.put(" comments & like ", "'%" + comments + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(startAt)) {
            params.put("leaves.create_at & >= ", startAt);
        }
        if (DataUtils.isNotNullOrEmpty(endAt)) {
            params.put("leaves.create_at &  <= ", endAt);
        }
        if (count) {
            params.put("@query", " count(id) ");
        } else {
            params.put("@order", " create_at desc ");
            params.put("@query", " id ");
        }
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }


    public static void main(String[] args) {
        //getArticleIdsByUidAndTid(6030l,5l);
        //getUserTaskRelationIdsIdsByUidAndOid(6030l,5l);
//        getDownArticleByDidAndOid(17259L,5L);
//        getClogsQueryListParam("0217070516000926", null, null, null, null, null,null, false);
    }

    public static Map<String, Object> getScoresListParam(Long uid, Integer scoreType, boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();
        Set<String> tables = new HashSet();
        log.info("start select from  user_score ");

        tables.add("user_score scores");
        if (DataUtils.isNotNullOrEmpty(uid)) {
            params.put("scores.uid", uid);
        }
        if (DataUtils.isNotNullOrEmpty(scoreType)) {
            params.put("scores.scoreType", scoreType);
        }
        if (count) {
            params.put("@query", " count(scores.id) ");
        } else {
            params.put("@order", " scores.create_at desc ");
            params.put("@query", " scores.id ");
        }
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }

    public static Map<String, Object> getCardsQueryListParam(String code,
                                                             Long tid,
                                                             Long ownerId,
                                                             Integer status,
                                                             Integer cardValid,
                                                             Integer typeValid,
                                                             Integer sort,
                                                              boolean isCount) {

        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        log.info("start select from card");
        tables.add("card");

        if (DataUtils.isNotNullOrEmpty(code)) {
            params.put(" code & like ", "'%" + code + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(tid)) {
            params.put(" tid ", tid);
        }

        if (DataUtils.isNotNullOrEmpty(ownerId)){
            params.put(" owner_id ", ownerId );
        }

        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put(" status ", status);
        }
        if (DataUtils.isNotNullOrEmpty(cardValid)) {
            params.put(" card_valid ", cardValid);
        }
        if (DataUtils.isNotNullOrEmpty(typeValid)) {
            params.put(" ctype_valid ", typeValid);
        }

        if (isCount) {
            params.put("@query", "count(id) ");
        } else {
            if (DataUtils.isNotNullOrEmpty(sort)) {
                switch (sort) {
                    case 1:
                        params.put("@order", "expire_at asc");
                        break;
                    case 2:
                        params.put("@order", "expire_at desc ");
                        break;
                    case 3:
                        params.put("@order", "assign_at desc ");
                        break;
                    case 4:
                        params.put("@order", "assign_at asc ");
                        break;
                }
            }else {
                params.put("@order", "update_at desc ");
            }
            params.put("@query", "id ");
        }

        params.put("@table", "card ");

        return params;
    }

    public static Map<String, Object> getCardsQueryListByCardValidAndTypeValidParam(String code,
                                                             Long tid,
                                                             Long ownerId,
                                                             Integer status,
                                                             Integer cardValid,
                                                             Integer typeValid,
                                                             Integer sort,
                                                             boolean isCount) {

        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        log.info("start select from card");
        tables.add("card");

        if (DataUtils.isNotNullOrEmpty(code)) {
            params.put(" code & like ", "'%" + code + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(tid)) {
            params.put(" tid ", tid);
        }

        if (DataUtils.isNotNullOrEmpty(ownerId)){
            params.put(" owner_id ", ownerId );
        }

        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put(" status ", status);
        }
        if (DataUtils.isNotNullOrEmpty(cardValid) && DataUtils.isNotNullOrEmpty(typeValid)) {
            params.put("( card_valid & = "+ cardValid+" or " + "ctype_valid " ,"="+typeValid + ")");
        }
//        if (DataUtils.isNotNullOrEmpty(typeValid)) {
//            params.put("ctype_valid ", typeValid);
//        }


        if (isCount) {
            params.put("@query", "count(id) ");
        } else {
            if (DataUtils.isNotNullOrEmpty(sort)) {
                switch (sort) {
                    case 1:
                        params.put("@order", "expire_at asc");
                        break;
                    case 2:
                        params.put("@order", "expire_at desc ");
                        break;
                    case 3:
                        params.put("@order", "assign_at desc ");
                        break;
                    case 4:
                        params.put("@order", "assign_at asc ");
                        break;
                }
            }else {
                params.put("@order", "update_at desc ");
            }
            params.put("@query", "id ");
        }

        params.put("@table", "card ");

        return params;
    }



    public static Map<String, Object> getClogsQueryListParam(String code, Long tid,
                                                             Long createId, Long issueId, Long ownerId, Long cessionId, Long verificationId,
                                                             Integer[] type,
                                                             Long createStartAt, Long createEndAt,
                                                             Long assignStartAt, Long assignEndAt,
                                                             Long applyStartAt, Long applyEndAt,
                                                             Long cessionStartAt, Long cessionEndAt,
                                                             Long verificationStartAt, Long verificationEndAt, boolean isCount) {

        Map<String, Object> params = new HashMap<String, Object>();
        log.info("start select from clog");

        if (DataUtils.isNotNullOrEmpty(code)) {
            params.put(" cid & in ", "(select id from card where code like '%" + code + "%')");
        }
        if (DataUtils.isNotNullOrEmpty(tid)) {
            params.put(" tid ", tid);
        }
        if (DataUtils.isNotNullOrEmpty(issueId) || DataUtils.isNotNullOrEmpty(verificationId)) {
            params.put(" admin_id & in ", "(" + issueId + "," + verificationId + ")");
            params.put("type & in", "(4,5)");
        }
        if (DataUtils.isNotNullOrEmpty(createId)) {
            params.put(" create_by ", createId);
        }

        if (DataUtils.isNotNullOrEmpty(ownerId) && DataUtils.isNotNullOrEmpty(cessionId)) {

            params.put("( use_id ", ownerId + " or receive_id = " + cessionId+" )");
        }else if (DataUtils.isNotNullOrEmpty(ownerId)) {
            params.put("use_id ", ownerId);
        }

        if (DataUtils.isNotNullOrEmpty(type)) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            if (type != null) {
                for (Integer t : type) {
                    if (t != null) {
                        sb.append(t.toString());
                        sb.append(",");
                        i++;
                    }
                }
            }
            sb.deleteCharAt(sb.length() - 1);
            params.put("type & in ", "(" + sb.toString() + ")");
        }
        if (DataUtils.isNotNullOrEmpty(createStartAt)) {
            params.put("create_at & >=", createStartAt);
        }
        if (DataUtils.isNotNullOrEmpty(createEndAt)) {
            params.put("create_at & <=", createEndAt);
        }

        if (DataUtils.isNotNullOrEmpty(assignStartAt)) {
            params.put("create_at & >=", assignStartAt);
            params.put("type", 2);
        }
        if (DataUtils.isNotNullOrEmpty(assignEndAt)) {
            params.put("create_at & <=", assignEndAt);
            params.put("type", 2);
        }
        if (DataUtils.isNotNullOrEmpty(applyStartAt)) {
            params.put("create_at & >=", applyStartAt);
            params.put("type", 3);
        }
        if (DataUtils.isNotNullOrEmpty(applyEndAt)) {
            params.put("create_at & <=", applyEndAt);
            params.put("type", 3);
        }
        if (DataUtils.isNotNullOrEmpty(cessionStartAt)) {
            params.put("create_at & >=", cessionStartAt);
            params.put("type", 6);
        }
        if (DataUtils.isNotNullOrEmpty(cessionEndAt)) {
            params.put("create_at & <=", cessionEndAt);
            params.put("type", 6);
        }
        if (DataUtils.isNotNullOrEmpty(verificationStartAt)) {
            params.put("create_at & >=", verificationStartAt);
            params.put("type & in", "(4,5)");
        }
        if (DataUtils.isNotNullOrEmpty(verificationEndAt)) {
            params.put("create_at & <=", verificationEndAt);
            params.put("type & in", "(4,5)");
        }

        if (isCount) {
            params.put("@query", "count(id) ");
        } else {
            params.put("@order", "create_at desc ");
            params.put("@query", "id ");
        }
        params.put("@table", "clog");

        return params;
    }

    public  static Map<String, Object> getCardsTypeQueryListParam(String title,
                                                                  Long id,
                                                                  Integer status,
                                                                  Long createStarAt,
                                                                  Long createEndAt,
                                                                  String  createBy,
                                                                  boolean count){
        Map<String, Object> params = new HashMap<String, Object>();
        log.info("start select from ctype");
        if (DataUtils.isNotNullOrEmpty(title)) {
            params.put(" title & like","'%" + title + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(id)) {
            params.put(" id ", id);
        }

        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put(" status ", status);
        }

        if (DataUtils.isNotNullOrEmpty(createStarAt)) {
            params.put(" create_at & >= ", createStarAt);
        }

        if (DataUtils.isNotNullOrEmpty(createEndAt)) {
            params.put(" create_at & <= ", createStarAt);
        }

        if (DataUtils.isNotNullOrEmpty(createBy)) {
            params.put(" create_by ", createBy );
        }

        if (count){
            params.put("@query", "count(id) ");
        }else {
            params.put("@order", "create_at desc ");
            params.put("@query", "id ");
        }
        params.put("@table", "ctype");

        return params;
    }


    public static Map<String, Object> getCardsQueryListOrderByParam(Integer sort,String ids) {

        Map<String, Object> params = new HashMap<String, Object>();

//        Set<String> tables = new HashSet();
//        log.info("start select from card");
//        tables.add("card");


        if (DataUtils.isNotNullOrEmpty(ids)) {
            params.put(" id & in ", "("+ids+")");
        }


        if (DataUtils.isNotNullOrEmpty(sort)) {
            switch (sort) {
                case 1:
                    params.put("@order", "expire_at asc");
                    break;
                case 2:
                    params.put("@order", "expire_at desc ");
                    break;
                case 3:
                    params.put("@order", "assign_at desc ");
                    break;
                case 4:
                    params.put("@order", "assign_at asc ");
                    break;
            }
        }else {
            params.put("@order", "update_at desc ");
        }
        params.put("@query", "id ");

        params.put("@table", "card ");

        return params;
    }


    public static Map<String, Object> getCardsQueryListInTidByParam(String code, String tid,
                                                                    Long ownerId,
                                                                    Long assignId,
                                                                    Long verificationId,
                                                                    Long createId,
                                                                    Integer status, Integer cardValid,
                                                                    Long assignStartAt, Long assignEndAt,
                                                                    Long applyStartAt, Long applyEndAt,
                                                                    Integer sort,
                                                                    Long verificationStartAt, Long verificationEndAt, boolean isCount) {

        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        log.info("start select from card");
        tables.add("card");

        if (DataUtils.isNotNullOrEmpty(code)) {
            params.put(" code & like ", "'%" + code + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(tid)) {
            params.put(" tid & in ", "(" + tid + ")");
        }
        if (DataUtils.isNotNullOrEmpty(ownerId)) {
            params.put(" owner_id ", ownerId);
        }
        if (DataUtils.isNotNullOrEmpty(assignId)) {
            params.put(" assign_id ", assignId);
        }
        if (DataUtils.isNotNullOrEmpty(verificationId)) {
            params.put(" verification_id ", verificationId);
        }
        if (DataUtils.isNotNullOrEmpty(createId)) {
            params.put(" create_by ", createId);
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put(" status ", status);
        }
        if (DataUtils.isNotNullOrEmpty(cardValid)) {
            params.put(" card_valid ", cardValid);
        }
        if (DataUtils.isNotNullOrEmpty(assignStartAt)) {
            params.put("assign_at & >=", assignStartAt);
        }
        if (DataUtils.isNotNullOrEmpty(assignEndAt)) {
            params.put("assign_at & <=", assignEndAt);
        }
        if (DataUtils.isNotNullOrEmpty(applyStartAt)) {
            params.put("apply_at & >=", applyStartAt);
        }
        if (DataUtils.isNotNullOrEmpty(applyEndAt)) {
            params.put("apply_at & <=", applyEndAt);
        }
        if (DataUtils.isNotNullOrEmpty(verificationStartAt)) {
            params.put("verification_at & >=", verificationStartAt);
        }
        if (DataUtils.isNotNullOrEmpty(verificationEndAt)) {
            params.put("verification_at & <=", verificationEndAt);
        }


        if (isCount) {
            params.put("@query", "count(id) ");
        } else {
            if (DataUtils.isNotNullOrEmpty(sort)) {
                switch (sort) {
                    case 1:
                        params.put("@order", "expire_at asc");
                        break;
                    case 2:
                        params.put("@order", "expire_at desc ");
                        break;
                    case 3:
                        params.put("@order", "assign_at desc ");
                        break;
                    case 4:
                        params.put("@order", "assign_at asc ");
                        break;
                }
            }else {
                params.put("@order", "update_at desc ");
            }
            params.put("@query", "id ");
        }

        params.put("@table", "card ");

        return params;
    }

    //获取产品列表
    public static Map<String, Object> getProductListParam(String name,String industry,Integer status,String client,
                                                          boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("product p");


        if (StringUtils.isNotBlank(name)) {
            params.put(" p.name & like ", "'%" + name + "%'");
        }
        if (StringUtils.isNotBlank(industry)) {
            params.put(" p.industry & like ", "'%" + industry + "%'");
        }
        if (null != status) {
            params.put("p.status", status);
        }
        if (StringUtils.isNotBlank(client)) {
            params.put(" p.client & like ", "'%" + client + "%'");
        }

        if (count) {
            params.put("@query", " count(p.id) ");
        } else {
            params.put("@order", "  p.level desc ");
        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;
    }
    //获取迭代列表
    public static Map<String, Object> getIterationListParam(Long productId,String name,Long period,Integer status,
                                                            boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("iteration i");


        if (StringUtils.isNotBlank(name)) {
            params.put(" i.name & like ", "'%" + name + "%'");
        }

        if (null != status) {
            params.put("i.status", status);
        }
        if (null != productId) {
            params.put("i.product_id", productId);
        }
        if (null != period) {
            params.put("i.period", period);
        }


        if (count) {
            params.put("@query", " count(i.id) ");
        } else {
            params.put("@order", "  i.sort desc ");
        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;
    }

    //获取项目记录
    public static Map<String, Object> getProjectsListParam(Long tid ,String name,Long productId,Long iterationId,
                                                           Long startAt,Long endAt,Long finishStartAt,Long finishEndAt,
                                                           Long createBy,Long sid,Long status,Long createStartAt,Long createEndAt, boolean count) {


        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();

        tables.add("project p");


        if (DataUtils.isNotNullOrEmpty(tid)) {
            params.put("p.tid", tid);
        }
        if (StringUtils.isNotBlank(name)) {
            params.put(" p.name & like ", "'%" + name + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(productId)) {
            params.put("p.product_id", productId);
        }
        if (DataUtils.isNotNullOrEmpty(iterationId)) {
            params.put("p.iteration_id", iterationId);
        }
        if (DataUtils.isNotNullOrEmpty(sid)) {
            params.put("p.sid", sid);
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("p.status", status);
        }
        //搜索项目开始时间
        if (DataUtils.isNotNullOrEmpty(startAt)) {
            params.put("p.start_at & >= ", startAt);
        }
        if (DataUtils.isNotNullOrEmpty(endAt)) {
            params.put("p.start_at & <= ", endAt);
        }
        //搜索项目结束时间
        if (DataUtils.isNotNullOrEmpty(finishStartAt)) {
            params.put("p.end_at & >= ", finishStartAt);
        }
        if (DataUtils.isNotNullOrEmpty(finishEndAt)) {
            params.put("p.end_at & <= ", finishEndAt);
        }
        //搜索项目创建开始时间
        if (DataUtils.isNotNullOrEmpty(createStartAt)) {
            params.put("p.create_at & >= ", createStartAt);
        }
        if (DataUtils.isNotNullOrEmpty(createEndAt)) {
            params.put("p.create_at & <= ", createEndAt);
        }

        if (count) {
            params.put("@query", " count(p.id) ");
        } else {
            params.put("@order", " p.create_at desc ");
            params.put("@query", " p.id ");
        }
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }

    //获取组员记录
    public static Map<String, Object> getMembersListParam(Long uid,String nick, Long oid, boolean count) {


        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        log.info("start select from user and user_team_relation ");
        tables.add("user u");
        tables.add("user_team_relation m");
        params.put("u.id", "m.uid");

        if (DataUtils.isNotNullOrEmpty(uid)) {
            params.put("m.uid", uid);
        }
        if (StringUtils.isNotBlank(nick)) {
            params.put(" u.nick & like ", "'%" + nick + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(oid)) {
            params.put("u.oid", oid);
        }


        if (count) {
            params.put("@query", " count(m.id) ");
        } else {
            params.put("@order", " m.create_at desc ");
            params.put("@query", " m.id ");
        }
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }
}