package com.ptteng.common.skill.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.PasswordUtils;
import com.gemantic.common.util.http.cookie.MD5Util;
import com.ptteng.common.skill.constant.InterfaceCodeConstant;
import com.ptteng.common.skill.interceptor.CookieConstant;
import com.ptteng.common.skill.model.*;
import com.ptteng.common.skill.service.*;
import com.ptteng.common.skill.util.CheckDataUtil;
import com.ptteng.common.skill.util.ComputeUtil;
import com.ptteng.common.skill.util.DynamicUtil;
import com.ptteng.common.skill.util.LogUtil;
import com.ptteng.common.storage.util.CaptchaUtil;
import com.qding.common.util.DataUtils;
import com.qding.common.util.HttpClientUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import com.qding.common.util.http.cookie.IdentityUtil;
import com.qding.common.util.http.cookie.RequestUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.annotation.Resource;
import javax.imageio.ImageIO;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.awt.image.BufferedImage;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * User  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class UserController {
    private static final Log log = LogFactory.getLog(UserController.class);

    StringBuffer sbuf = new StringBuffer();

    @Autowired
    private UserService userService;

    @Autowired
    private ClassesService classesService;

    @Autowired
    private UserClassRelationService userClassRelationService;

    @Autowired
    private TaskSkillRelationService taskSkillRelationService;

    @Autowired
    private OccupationService occupationService;

    @Autowired
    private SmsService smsService;

    @Autowired
    private MessageService messageService;

    @Autowired
    private TaskService taskService;

    @Autowired
    private SkillService skillService;

    @Autowired
    private CookieUtil cookieUtil;

    @Autowired
    private ConstantService constantService;


    @Autowired
    private AccountService accountService;


    @Autowired
    private TeacherService teacherService;


    @Autowired
    private CommentService commentService;


    @Resource(name = "accountConfig")
    private Map<String, String> accountConfig;


    @Autowired
    private ArticleService articleService;

    @Autowired
    private UserStatisticsService userStatisticsService;

    private boolean isCaptcha = false;


    @RequestMapping(value = "/index", method = RequestMethod.GET)
    public String index(HttpServletRequest request,
                        HttpServletResponse response, ModelMap model) throws Exception {

        log.info(" index ,this is demo link ");

        return "/demo/test";

    }


    @RequestMapping(value = "/a/wrong", method = RequestMethod.GET)
    public String wrong(HttpServletRequest request,
                        HttpServletResponse response, ModelMap model) throws Exception {

        log.info(" index ,this is demo link ");

        model.addAttribute("code", -2);

        return "/common/success";

    }


    // 9、查看用户邀请名单
    @RequestMapping(value = "/a/user/{uid}/invite/search", method = RequestMethod.GET)
    public String getInviteUsers(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, Integer page, Integer size,
                                 @PathVariable Long uid)
            throws Exception {
        log.info(" /a/user/{uid}/invite/search uid=" + uid + "  ===================================================== ");
        List<Long> idList = new ArrayList();
        List<User> userList = new ArrayList();
        if (DataUtils.isNullOrEmpty(uid)) {
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        if (null == page) {
            page = 1;
        }
        if (null == size) {
            size = 20;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        try {
            idList = userService.getUIdsByRecommendId(uid, start, size);
            if (CollectionUtils.isEmpty(idList)) {
                log.info(" idList is null ");
            } else {
                log.info(" idList size =  " + idList.size());
                userList = userService.getObjectsByIds(idList);
            }
            idList = userService.getUIdsByRecommendId(uid, 0, Integer.MAX_VALUE);
            model.addAttribute("code", 0);
            model.addAttribute("total", idList.size());
            model.addAttribute("userList", userList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get user error,id is  " + idList);
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/user/json/userListJson";
    }

    //1、校验手机号是否注册
    @RequestMapping(value = "/a/mobile", method = RequestMethod.GET)
    public String verifyNick(HttpServletRequest request,
                             HttpServletResponse response, ModelMap model, String mobile) throws Exception {

        log.info("verify the mobile: " + mobile);

        if (StringUtils.isBlank(mobile)) {
            model.addAttribute("code", -1000);
            log.info("params is null");
            return "/common/success";
        }
        try {
            Long uid = userService.getUserIdByMobile(mobile);

            if (uid != null) {
                model.addAttribute("code", -2007);
                log.info("mobile exist");
                return "/common/success";
            }
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add user error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";

    }


    //2、整体信息
    @RequestMapping(value = "/a/info", method = RequestMethod.GET)
    public String info(HttpServletRequest request,
                       HttpServletResponse response, ModelMap model) throws Exception {

        log.info("get info");

        try {

            Integer classCount = 0;
            Integer userCount = 0;
            List<Long> ids = this.constantService.getConstantIdsByType(Constant.Type_Statistics, 0, Integer.MAX_VALUE);
            List<Constant> constants = this.constantService.getObjectsByIds(ids);
            for (Constant constant : constants) {
                if (Constant.Name_ClassCount.equals(constant.getName())) {
                    classCount = Integer.valueOf(constant.getValue());
                }
                if (Constant.Name_UserCount.equals(constant.getName())) {
                    userCount = Integer.valueOf(constant.getValue());
                }
            }

            model.addAttribute("code", 0);
            model.addAttribute("classCount", classCount);
            model.addAttribute("userCount", userCount);
            log.info(" classCount : " + classCount + " userCount " + userCount);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get info error ");
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/user/json/info";
    }


    // 3、用户注册
    @RequestMapping(value = "/a/user", method = RequestMethod.POST)
    public String register(HttpServletRequest request,
                           HttpServletResponse response, ModelMap model, String mobile,
                           String verify, String password, String nick, String invitationCode) throws Exception {


        String type = "register";

        log.info(mobile + " is mobile " + verify + " is verify " + password
                + " is password " + nick + " is nick " + " invitationCode = " + invitationCode);
        if (mobile == null || StringUtils.isBlank(verify) || StringUtils.isBlank(password)) {
            model.addAttribute("code", -1000);
            log.info("params is null");
            return "/common/success";
        }

        try {
            // 是否已注册
            Long uid = userService.getUserIdByMobile(mobile);

            if (uid != null) {
                log.info(mobile + " is already exist  " + uid);
                model.addAttribute("code", -2007);

                return "/common/success";

            } else {
                log.info(mobile + " not exist ,so can register ");
            }

            boolean verifyResult = false;


            if (verifyModel()) {
                log.info("is test model ");
                //线上去掉万能验证码
                Boolean isOnline = CheckDataUtil.isOnline(request);
                if ("555555".equals(verify) && !isOnline) {
                    log.info("test ,so not verify mobile ");
                    verifyResult = true;
                } else {
                    log.info("log1: mobile is " + mobile + ",type = " + type + ",verify" + verify);
                    verifyResult = verifyMobileCode(model, mobile, type, verify);
                }
            } else {
                log.info("log1: mobile is " + mobile + ",type = " + type + ",verify" + verify);
                verifyResult = verifyMobileCode(model, mobile, type, verify);
            }

            // 校验验证码
            Long now = System.currentTimeMillis();
            SimpleDateFormat myFmt2 = new SimpleDateFormat("yyyyMMdd");
            String date = myFmt2.format(now);
            //校验邀请码
            if (verifyResult) {
                //是否有邀请人
                Long recommendId = null;
                if (StringUtils.isNotEmpty(invitationCode)) {
                    log.info(" user " + mobile + " invitationCode is " + invitationCode);
                    recommendId = userService.getUserIdByInviteCode(invitationCode);
                    log.info(" recommendId = " + recommendId);
                    if (DataUtils.isNullOrEmpty(recommendId)) {
                        log.info(" get recommendUser by invitationCode ,result is null ");
                        recommendId = userService.getUserIdByMobile(invitationCode);
                        log.info(" recommendId = " + recommendId);
                        if (DataUtils.isNullOrEmpty(recommendId)) {
                            log.info(" get recommendUser by mobile ,result is null ");
                            model.addAttribute("code", -18001);
                            return "/common/success";
                        }
                    }
                }


                User user = new User();
                user.setMobile(mobile);
                mobile.split(mobile);
                //生成带星号码
                if (null == nick) {

                    user.setNick(mobile);
                } else {
                    user.setNick(nick);
                }
                user.setThumb("");

                String encodePass = PasswordUtils.encode(password);
                user.setPwd(encodePass);

                user.setIsLook(0); // 默认消息数为0
                user.setValue(new BigDecimal("0"));
                user.setIdentity(User.IDENTIFY_10);//注册时身份为无名弟子

                if (StringUtils.isNotEmpty(invitationCode)) {
                    user.setRecommendId(recommendId);
                }
                Long userID = userService.insert(user);
                //给邀请人+1
                if (StringUtils.isNotEmpty(invitationCode)) {
                    User recommend = userService.getObjectById(recommendId);
                    //如果推荐人数为空，则设为 0
                    if (null == recommend.getRecommendCount()) {
                        recommend.setRecommendCount(0);
                    }
                    log.info("recommendCount is " + recommend.getRecommendCount());
                    recommend.setRecommendCount(recommend.getRecommendCount() + 1);
                    log.info("recommendCount is " + recommend.getRecommendCount());
                    userService.update(recommend);
                }

                //生成用户的邀请码
                int idLength = (userID + "").length();
                String userInvitationCode = RandomStringUtils.randomNumeric(8 - idLength);
                log.info(" user " + userID + " invitationCode is " + userInvitationCode);
                user = userService.getObjectById(userID);
                user.setInvitationCode(userID + userInvitationCode);

                Long constantID = this.constantService.getConstantIdByTypeAndName(Constant.Type_Statistics, Constant.Name_UserCount);
                if (constantID == null) {
                    log.error(" not statistics user Count ,check constant " + Constant.Type_Statistics + " name is " + Constant.Name_UserCount);
                } else {
                    Constant constant = this.constantService.getObjectById(constantID);
                    log.info(" constant is " + constant);
                    Integer userCount = Integer.valueOf(constant.getValue()) + 1;
                    constant.setValue(userCount.toString());
                    this.constantService.update(constant);
                    log.info(" update use count success ");

                }

                //加入用户卡券统计
                UserStatistics userStatistics = new UserStatistics();
                userStatistics.setId(userID);
                userStatistics.setCardUnused(UserStatistics.Statistics_InitialValue);
                userStatistics.setCardUsed(UserStatistics.Statistics_InitialValue);
                userStatistics.setCardVerifying(UserStatistics.Statistics_InitialValue);
                userStatistics.setCardVerified(UserStatistics.Statistics_InitialValue);
                userStatistics.setCardCession(UserStatistics.Statistics_InitialValue);
                userStatistics.setCardExpired(UserStatistics.Statistics_InitialValue);
                userStatistics.setCardNotice(UserStatistics.Statistics_InitialValue);
                Long userStatisticsId = userStatisticsService.insert(userStatistics);
                log.info("create userStatistics success,user id is" + userID + ", userStatistics id is " + userStatisticsId);

                String token = IdentityUtil.encodeCookie("phone", userID);
                model.put("token", token);

                log.info(mobile + " register success,userID is " + userID);

                Map<String, String> maps = new HashMap();
                maps.put(CookieUtil.USER_ID, userID + "");
                maps.put(CookieConstant.Cookie_WEB_mobile, mobile);
                cookieUtil.setIdentity(request, response, maps, userID);

                model.put("uid", userID);

                //新注册用户发欢迎词
                String content = "";
                Message message = new Message();
                message.setStatus(Message.STATUS_UNDELETE);
                message.setReceiveName(nick);
                message.setSendName("admin");
                message.setSendId(0L);
                message.setContent(mobile);
                message.setReceiveId(userID);
                message.setUnread(Message.Status_Unread);
                message.setType(Message.CLASS_TYPE);
                message.setRelationId(uid);
                Long mid = messageService.insert(message);
                message = messageService.getObjectById(mid);

                content = LogUtil.convertString("<span  class=\\\"font-16px system-alert-outline \\\">欢迎来到IT修真院，IT新人请去<a data-mid=", mid,
                        " ng-click=\\\"sendAlertMsg(li.id)\\\" target=\"_blank\"  href=\\\"/hall/recommend\\\"><span class=\\\"font-green\\\">",
                        "职业殿堂 </span> </a>了解互联网职业，若想深入了解每个职业学习难度、发展趋势，可参与<a  ng-click=\\\"sendAlertMsg(li.id)\\\" target=\"_blank\" " +
                                "href=\\\"https://www.zhihu.com/lives/869215863344107520\\\"><span class=\\\"font-green\\\">互联网职业介绍</span> </a>。" +
                                "赶紧选择职业，领取任务，踏上IT修真之旅吧！</span>");

                adminSend(mobile, content);
                message.setContent(content);
                messageService.update(message);

                user.setIsLook(1);
                user.setLatestMsg(Message.CLASS_TYPE);
                userService.update(user);


                model.addAttribute("code", 0);

            } else {
                log.error("wrong verifycode");
                model.addAttribute("code", -2005);

                return "/common/success";
            }


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add user error ");
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/user/json/register";
    }

    private boolean verifyModel() {
        return "test".equals(this.accountConfig.get("testModel"));
    }

    // 验证码校验
    private boolean verifyMobileCode(ModelMap model, String mobile, String type,
                                     String verify) throws ServiceException, ServiceDaoException {
        log.info("log2: mobile is " + mobile + ",type = " + type + ",verify" + verify);
        // 是否有发送验证码
        Long sid = smsService.getSmsIdByMobileAndType(mobile, type);
        log.info("sid is " + sid);

        if (sid == null) {
            return false;
        }
        // 获取验证码信息
        Sms sms = smsService.getObjectById(sid);
        log.info("sms is " + sms);
        // 获取验证码
        String message = sms.getMessage();
        log.info("message is " + message);

        //发送是否超时
        Long delay = System.currentTimeMillis() - sms.getSendAt();

        if (delay > 600000) {
            log.info("require verify too long");
            return false;
        }

        if (message.equals(verify)) {
            return true;
        } else {
            return false;
        }

    }

    //4、用户登陆
    @RequestMapping(value = "/a/login", method = RequestMethod.POST)
    public String aLogin(HttpServletRequest request,
                         HttpServletResponse response, ModelMap model, String mobile, String pwd)
            throws Exception {
        log.info("mobile is " + mobile + "pwd is " + pwd);

        if (mobile == null) {
            model.addAttribute("code", -1000);

            return "/common/success";
        }

        Long uid = userService.getUserIdByMobile(mobile);
        String token = IdentityUtil.encodeCookie("phone", uid);

        if (uid == null) {
            model.addAttribute("code", -2000);
            return "/common/success";
        }
        log.info(" uid is " + uid);
        User user = this.userService.getObjectById(uid);
        String pass = PasswordUtils.encode(pwd);
        Boolean verify = user.getPwd().equals(pass);
        if (verify) {
            log.info(uid + " login ");
            Map<String, String> maps = new HashMap();


            maps.put(CookieUtil.USER_ID, uid + "");
            maps.put(CookieConstant.Cookie_WEB_mobile, mobile);
            cookieUtil.setIdentity(request, response, maps, uid);

            model.addAttribute("code", 0);
            model.addAttribute("uid", uid);

            model.put("token", token);

        } else {
            log.info(mobile + " wrong pwd " + pwd);

            model.put("code", -2006);

            return "/common/success";

        }

        return "/common-skill-service/user/json/register";
    }


    // 5、验证码发送
    @RequestMapping(value = "/a/code/send", method = RequestMethod.POST)
    public String sendVerify(HttpServletRequest request,
                             HttpServletResponse response, ModelMap model, String mobile,
                             String type) throws ServiceException, ServiceDaoException {
        log.info(mobile + " want send sms of type " + type);

        if (!isCaptcha) {
            model.addAttribute("code", -2005);
            return "/common/success";
        }

        if (StringUtils.isBlank(mobile)) {
            log.info(mobile + " want send sms of type " + type + " null mobile ");
            model.addAttribute("code", InterfaceCodeConstant.Mobile_Null);
            return "/common/success";
        }

        if (StringUtils.isBlank(type)) {
            type = "password";
        }

        if ("register".equals(type)) {
            Long uid = this.userService.getUserIdByMobile(mobile);
            if (uid != null) {

                log.info(type + " is already exist  " + mobile);

                model.addAttribute("code", InterfaceCodeConstant.Mobile_AlreadyExist);
                return "/common/success";
            }

        } else {
            Long uid = this.userService.getUserIdByMobile(mobile);
            if (uid == null) {

                log.info(type + " is not already exist  " + mobile);

                model.addAttribute("code", InterfaceCodeConstant.User_NotExist);
                return "/common/success";
            }
        }

        int code = InterfaceCodeConstant.System_Success;

        try {
            String result = this.smsService.sendMsg(mobile, type);
//            smsService.getSmsIdByMobileAndType(mobile,type);

            switch (result) {
                case SmsService.ErrorCode_SMS_InvalidType:
                    code = InterfaceCodeConstant.VerifyCode_Type_NotSupport;
                    break;
                case SmsService.ErrorCode_SMS_smsMoreThan5:
                    code = InterfaceCodeConstant.VerifyCode_MoreThan5;
                    break;
                default:

            }

            model.addAttribute("code", code);

        } catch (Exception t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error(mobile + " send message error of type " + type);
            model.addAttribute("code", InterfaceCodeConstant.System_Exception);

        }
        return "/common/success";

    }


    // 语音验证码
    @RequestMapping(value = "/a/code/voice", method = RequestMethod.POST)
    public String sendVoice(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                            String mobile, String type) throws ServiceException, ServiceDaoException {
        log.info(mobile + " want send voice of type " + type);

        if (StringUtils.isBlank(mobile)) {
            log.info(mobile + " want send sms of type " + type + " null mobile ");
            model.addAttribute("code", InterfaceCodeConstant.Mobile_Null);
            return "/common/success";
        }
        if (StringUtils.isBlank(type)) {
            type = "password";
        }

        if ("register".equals(type)) {
            Long uid = this.userService.getUserIdByMobile(mobile);
            if (uid != null) {
                log.info(type + " is already exist  " + mobile);
                model.addAttribute("code", InterfaceCodeConstant.Mobile_AlreadyExist);
                return "/common/success";
            }
        } else {
            Long uid = this.userService.getUserIdByMobile(mobile);
            if (uid == null) {
                log.info(type + " is not already exist  " + mobile);
                model.addAttribute("code", InterfaceCodeConstant.User_NotExist);
                return "/common/success";
            }
        }

        int code = InterfaceCodeConstant.System_Success;

        try {
            String result = this.smsService.sendVoice(mobile, type);
            switch (result) {
                case SmsService.ErrorCode_SMS_InvalidType:
                    code = InterfaceCodeConstant.VerifyCode_Type_NotSupport;
                    break;
                case SmsService.ErrorCode_SMS_smsMoreThan5:
                    code = InterfaceCodeConstant.VerifyCode_MoreThan5;
                    break;
                case SmsService.ErrorCode_sendError:
                    code = InterfaceCodeConstant.VerifyCode_sendError;
                    break;
                default:

            }

            model.addAttribute("code", code);
        } catch (Exception t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error(mobile + " send voice error of type " + type);
            model.addAttribute("code", InterfaceCodeConstant.System_Exception);
        }

        return "/common/success";
    }


    // 6、忘记密码
    @RequestMapping(value = "/a/password/forget", method = RequestMethod.PUT)
    public String rewritepwd(HttpServletRequest request,
                             HttpServletResponse response, ModelMap model, String mobile,
                             String verify, String newpwd) throws Exception {
        try {

            // 是否已注册
            Long uid = userService.getUserIdByMobile(mobile);

            // 用户不存在
            if (uid == null) {
                log.info(mobile + " not exist ");
                model.addAttribute("code", -2000);

                return "/common/success";

            } else {
                log.info(mobile + " exist and uid is " + uid);
            }

            boolean verifyResult = false;

            String type = "password";

            // 测试模式
            if (verifyModel()) {
                //线上去掉万能验证码
                Boolean isOnline = CheckDataUtil.isOnline(request);
                if ("555555".equals(verify) && !isOnline) {
                    log.info("test ,so not verify mobile ");
                    verifyResult = true;
                } else {
                    verifyResult = verifyMobileCode(model, mobile, type, verify);
                }
            } else {
                verifyResult = verifyMobileCode(model, mobile, type, verify);
            }

            if (verifyResult) {
                User user = userService.getObjectById(uid);

                String encodePass = PasswordUtils.encode(newpwd);
                user.setPwd(encodePass);
                boolean result = userService.update(user);

                log.info(mobile + " change password," + newpwd + "result is " + result);
                log.error("rewrite password success! ");

                model.addAttribute("code", 0);
            } else {
                log.error("rewritepwd verifycode");
                model.addAttribute("code", -2005);

                return "/common/success";
            }

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add user error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";

    }

    //7、退出登录
    @RequestMapping(value = "/a/u/logout", method = RequestMethod.POST)
    public String logout(HttpServletRequest request,
                         HttpServletResponse response, ModelMap model) {
        log.info(" welcome to manager logout ");

        try {
            cookieUtil.clearCookie(response);

            model.addAttribute("code", 0);

            return "/common/success";
        } catch (Throwable t) {
            log.error("user logout error  ");
            t.printStackTrace();

            return "/common/success";

        }


    }


    // 8、本人信息读取
    @RequestMapping(value = "/a/u/user/self", method = RequestMethod.GET)
    public String getUserJson(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model)
            throws Exception {

        log.info(" ===================================================== ");

        try {
            User user = (User) request.getAttribute("user");
            Long uid = user.getId();
            log.info("/a/u/user/self id " + uid);

//获取用户班级信息
            Set<Long> cids = new HashSet();
            Set<Long> ucids = new HashSet();
            Set<Long> oids = new HashSet();
            if (user.getCid() > 0) {
                cids.add(user.getCid());
            }
            if (user.getUserClassID() > 0) {
                ucids.add(user.getUserClassID());
            }


            log.info(" get class ids is " + ucids);
            List<Classes> classes = this.classesService.getObjectsByIds(new ArrayList(cids));
            log.info(" get class  is " + classes.size());
            List<UserClassRelation> relations = this.userClassRelationService.getObjectsByIds(new ArrayList(ucids));
            log.info(" get class  is " + relations.size());

            for (UserClassRelation relation : relations) {
                if (null != relation) {
                    oids.add(relation.getOid());
                }
            }

            log.info(" get occupation ids is " + oids);
            List<Occupation> occupations = this.occupationService.getObjectsByIds(new ArrayList<Long>(oids));
            log.info(" get occupations is " + occupations.size());

            model.addAttribute("classes", classes);
            model.addAttribute("relations", relations);
            model.addAttribute("occupations", occupations);
            model.addAttribute("total", 1);
            List<User> userList = new ArrayList<>();
            userList.add(user);
            model.addAttribute("userList", userList);
            model.addAttribute("code", 0);


        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get user error");
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/user/json/userListJson";
    }


    // 9、个人信息读取
    @RequestMapping(value = "/a/user/detail/{type}", method = RequestMethod.GET)
    public String getMultiUserJson(HttpServletRequest request,
                                   HttpServletResponse response, ModelMap model, @PathVariable String type, Long[] uids)
            throws Exception {

        log.info(" ===================================================== ");
        List<Long> idList = new ArrayList();
        List<User> userList = new ArrayList();

        try {

            if (uids == null) {
                log.info("not get any data ");
                model.addAttribute("code", -1000);
                return "/common/success";
            } else {
                idList = Arrays.asList(uids);
                log.info(idList + " want get detail info ");
                userList = userService.getObjectsByIds(idList);
                log.info("get  user data is " + userList.size());
                DynamicUtil.checkUserGraduateStatus(userList);
                log.info(" get user is " + uids);
            }


            model.addAttribute("code", 0);
            model.addAttribute("total", userList.size());
            model.addAttribute("userList", userList);


            if ("full".equals(type)) {
                //获取用户班级信息
                Set<Long> cids = new HashSet();
                Set<Long> ucids = new HashSet();
                Set<Long> oids = new HashSet();
                Set<Long> inviteIDS = new HashSet();
                for (User user : userList) {
                    if (user.getCid() > 0) {
                        cids.add(user.getCid());
                    }
                    if (user.getUserClassID() > 0) {
                        ucids.add(user.getUserClassID());
                    }
                    ucids.add(user.getRecommendId());
                    inviteIDS.add(user.getRecommendId());

                }
                List<Long> inviterUserIDS = new ArrayList(inviteIDS);
                log.info("get inviterUserIDS is " + inviterUserIDS);
                List<User> inviterUsers = userService.getObjectsByIds(inviterUserIDS);
                log.info(" get class ids is " + ucids);
                List<Classes> classes = this.classesService.getObjectsByIds(new ArrayList(cids));
                log.info(" get class  is " + classes.size());
                List<UserClassRelation> relations = this.userClassRelationService.getObjectsByIds(new ArrayList(ucids));
                log.info(" get class  is " + relations.size());

                for (UserClassRelation relation : relations) {
                    if (null != relation) {
                        oids.add(relation.getOid());
                    }
                }

                log.info(" get occupation ids is " + oids);
                List<Occupation> occupations = this.occupationService.getObjectsByIds(new ArrayList<Long>(oids));
                log.info(" get occupations is " + occupations.size());

                model.addAttribute("classes", classes);
                model.addAttribute("relations", relations);
                model.addAttribute("occupations", occupations);
                model.addAttribute("inviterUsers", inviterUsers);

            }


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get user error,id is  " + idList);
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/user/json/userListJson";
    }

    // 10、修改密码
    @RequestMapping(value = "/a/u/password", method = RequestMethod.PUT)
    public String editPassword(HttpServletRequest request,
                               HttpServletResponse response, ModelMap model, String pwd, String newPwd)
            throws Exception {

        try {

            if (newPwd.equals(null)) {
                log.info("newPassword is null");
                model.addAttribute("code", -1000);
                return "/common/success";
            }

            log.info(" ===================================================== ");

            String encodePwd = PasswordUtils.encode(pwd);
            String encodeNewPwd = PasswordUtils.encode(newPwd);

            User user = (User) request.getAttribute("user");
            Long uid = user.getId();
            String oldPwd = user.getPwd();

            if (encodePwd.equals(oldPwd)) {
                user.setPwd(encodeNewPwd);
                userService.update(user);
                model.addAttribute("code", 0);
                log.info("update password success, new password is " + newPwd);
            } else {
                model.addAttribute("code", -2006);
                log.info("wrong password");
                return "/common/success";
            }

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("update password error,pwd is  " + pwd);
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    // 10、重置未读消息数为0
    @RequestMapping(value = "/a/u/user/look", method = RequestMethod.GET)
    public String changeLookStatus(HttpServletRequest request,
                                   HttpServletResponse response, ModelMap model)
            throws Exception {

        try {
            User user = (User) request.getAttribute("user");
            Long uid = user.getId();

            log.info("the uid and user is -------" + uid + user);
            user.setIsLook(0);


            userService.update(user);
            model.addAttribute("code", 0);


        } catch (Throwable t) {
            log.error(t.getMessage());
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    //11、修改个人信息
    @RequestMapping(value = "/a/u/user", method = RequestMethod.PUT)
    public String updateUser(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                             String nick, Long sex, String sign, String thumb, String qq, Long birthday, String school, String province, String city) throws Exception {

        try {


            log.info("get nick : " + nick + " , sign : " + sign + " get thumb : " + thumb + " get qq " + qq);

            if (StringUtils.isBlank(nick)) {
                log.info("params is null");
                model.addAttribute("code", -1000);
                return "/common/success";
            }

            User user = (User) request.getAttribute("user");
            Long uid = user.getId();

            log.info(" ====update self userInfo==== " + uid);
            if (Classes.Type_Offline.equals(user.getType())) {
                log.info(" user is offline ,so can't update nick and  img ");
            } else {
                log.info(" user is not offline ,so can update nick and img ");
                user.setNick(nick);
                user.setThumb(thumb);
            }
            user.setSex(sex);
            user.setSign(sign);
            user.setQq(qq);
            user.setBirthday(birthday);
            user.setSchool(school);
            user.setProvince(province);
            user.setCity(city);
            userService.update(user);
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("update user error,nick is " + nick + " sign is " + sign + "get thumb : " + thumb + " get qq " + qq);
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    // 生成图形验证码
    @RequestMapping(value = "/a/captcha/generate", method = RequestMethod.GET)
    public void captchaGenerate(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {
        log.info("To captchaGenerate ------------------");
        try {
            // 设置页面不缓存
            response.reset();
            response.setHeader("Pragma", "No-cache");
            response.setHeader("Cache-Control", "no-cache");
            response.setDateHeader("Expires", 0);
            response.setContentType("image/gif");

            // 生成随机字符
            String randomStr = RandomStringUtils.randomAlphabetic(4).toUpperCase();
            log.info("randomStr: " + randomStr);
            // 存入cookie
            response.addCookie(new Cookie("captcha", MD5Util.getMd5Sum(randomStr)));

            // 生成图片流
            BufferedImage bi = new CaptchaUtil().generate(165, 40, randomStr).getImage();
            // 创建输出流
            OutputStream out = response.getOutputStream();
            // 将图片写入到输出流中去
            ImageIO.write(bi, "JPG", out);
            // 强制刷新
            out.flush();
            // 关闭输出流
            out.close();
        } catch (Exception e) {
            log.error("get captchaGenerate error", e);
            model.addAttribute("code", -1);
        }

    }

    // 验证图形验证码
    @RequestMapping(value = "/a/captcha/verify", method = RequestMethod.GET)
    public String captchaVerify(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                String inputValue) throws Exception {
        log.info("To captchaVerify ------------------");

        log.info("inputValue: " + inputValue);

        try {
            String cookieValue = "";
            try {
                cookieValue = RequestUtil.getCookie(request, "captcha").getValue();
            } catch (Exception e) {
                log.error("got error when getCookie");
            }
            log.info("cookieValue: " + cookieValue);

            if (StringUtils.isBlank(inputValue) || StringUtils.isBlank(cookieValue)) {
                model.addAttribute("code", -2005);
                return "/common/success";
            }

            String md5Value = "";
            try {
                md5Value = MD5Util.getMd5Sum(inputValue.toUpperCase());
            } catch (NoSuchAlgorithmException e) {
                log.error("got error when getMD5");
            }

            log.info("md5Value: " + md5Value);

            if (md5Value.equals(cookieValue)) {
                isCaptcha = true;
                model.addAttribute("code", 0);
            } else {
                isCaptcha = false;
                model.addAttribute("code", -2005);
            }
        } catch (Exception e) {
            log.error("get captchaVerify error", e);
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    /**
     * 版本更新
     *
     * @param request
     * @param response
     * @param model
     * @param versionName
     * @param versionCode
     * @return
     */
    @RequestMapping(value = "/a/version", method = RequestMethod.GET)
    public String version(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                          String versionName, Long versionCode) {

        try {
            String newName = "";
            Long newCode = 0L;
            String url = "";

            List<Long> versionIds = constantService.getConstantIdsByType("version", 0, Integer.MAX_VALUE);
            List<Constant> versionList = constantService.getObjectsByIds(versionIds);
            for (Constant constant : versionList) {
                if (constant.getName().equals("code"))
                    newCode = Long.valueOf(constant.getValue());
                if (constant.getName().equals("url"))
                    url = constant.getValue();
            }

            model.addAttribute("code", 0);
            model.addAttribute("url", url);
            model.addAttribute("versionName", newName);
            model.addAttribute("versionCode", newCode);
        } catch (Exception e) {
            log.error("get version error", e);
            model.addAttribute("code", -1);
        }
        return "/common-skill-service/user/json/version";
    }


    // 5、验证码发送
    @RequestMapping(value = "/a/app/code/send", method = RequestMethod.POST)
    public String sendVerifyApp(HttpServletRequest request, HttpServletResponse response, ModelMap model, String mobile,
                                String type) throws ServiceException, ServiceDaoException {
        log.info(mobile + " want send sms of type " + type);

        if (StringUtils.isBlank(mobile)) {
            log.info(mobile + " want send sms of type " + type + " null mobile ");
            model.addAttribute("code", InterfaceCodeConstant.Mobile_Null);
            return "/common/success";
        }

        if (StringUtils.isBlank(type)) {
            type = "password";
        }

        if ("register".equals(type)) {
            Long uid = this.userService.getUserIdByMobile(mobile);
            if (uid != null) {

                log.info(type + " is already exist  " + mobile);

                model.addAttribute("code", InterfaceCodeConstant.Mobile_AlreadyExist);
                return "/common/success";
            }

        } else {
            Long uid = this.userService.getUserIdByMobile(mobile);
            if (uid == null) {

                log.info(type + " is not already exist  " + mobile);

                model.addAttribute("code", InterfaceCodeConstant.User_NotExist);
                return "/common/success";
            }
        }

        int code = InterfaceCodeConstant.System_Success;

        try {
            String result = this.smsService.sendMsg(mobile, type);
//            smsService.getSmsIdByMobileAndType(mobile,type);

            switch (result) {
                case SmsService.ErrorCode_SMS_InvalidType:
                    code = InterfaceCodeConstant.VerifyCode_Type_NotSupport;
                    break;
                case SmsService.ErrorCode_SMS_smsMoreThan5:
                    code = InterfaceCodeConstant.VerifyCode_MoreThan5;
                    break;
                default:

            }

            model.addAttribute("code", code);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error(mobile + " send message error of type " + type);
            model.addAttribute("code", InterfaceCodeConstant.System_Exception);

        }
        return "/common/success";

    }


    /**
     * 14.获取用户的师兄信息
     *
     * @param request
     * @param response
     * @param model
     * @return
     */
    @RequestMapping(value = "/a/user/{uid}/teacher", method = RequestMethod.GET)
    public String getHisTeacher(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                @PathVariable Long uid) {

        log.info(uid + "  want to getHisTeacherInfo");
        if (CheckDataUtil.isNull(uid)) {
            log.info(" uid is null ");
            model.addAttribute("code", -15002);
            return "/common/success";
        }

        try {
            /* 1 获取自己的用户基础信息 */
            User student = userService.getObjectById(uid);
            if (CheckDataUtil.isNull(student)) {
                log.info(" user is null ");
                model.addAttribute("code", -15000);
                return "/common/success";
            }
            Long teacherId = student.getTeacherId();

            /* 2 获取自己师兄的用户基础、拓展信息，职业信息 */
            User teacherInfo1 = null;
            Teacher teacherInfo2 = null;
            Occupation occupation = null;

            /* 3 仅在师兄不为空的情况下，进行查询逻辑，否则空值返回 */
            if (CheckDataUtil.notEqual(teacherId, User.TeacherID_None)) {
                teacherInfo1 = userService.getObjectById(teacherId);
                teacherInfo2 = teacherService.getObjectById(teacherId);
                occupation = occupationService.getObjectById(teacherInfo1.getOid());

                /* 4 计算师兄写日报率 */
                String replyRate = "1.0000";
                Long studentDaily = teacherInfo2.getStudentDaily();
                Long teacherComment = teacherInfo2.getTeacherComment();
                if (CheckDataUtil.notEqual(studentDaily, Teacher.Daily_None)) {
                    replyRate = ComputeUtil.myDivideiCeil(teacherComment, studentDaily);
                }
                log.info("replyRate: " + replyRate);
                teacherInfo2.setReplyRate(replyRate);
            }

            model.addAttribute("userInfo", teacherInfo1);
            model.addAttribute("teacher", teacherInfo2);
            model.addAttribute("occupation", occupation);
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t);
            log.error(t.getMessage());
            log.error(uid + " failed in getting his teacher ");
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/user/json/hisTeacherInfo";
    }


    /**
     * 15.获取用户的师弟信息
     *
     * @param request
     * @param response
     * @param model
     * @param type
     * @param page
     * @param size
     * @return
     */
    @RequestMapping(value = "/a/user/{uid}/student", method = RequestMethod.GET)
    public String getHisStudent(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                @PathVariable Long uid, String type, Integer page, Integer size) {

        log.info(uid + "  want to getHisTeacherInfo");
        if (CheckDataUtil.isNull(uid)) {
            log.info(" uid is null ");
            model.addAttribute("code", -15002);
            return "/common/success";
        }

        if (null == type) {
            type = "online";
        }
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 24;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        try {
            /* 1 获取自己的用户基础信息 */
            User teacher = userService.getObjectById(uid);
            if (CheckDataUtil.isNull(teacher)) {
                log.info(" user is null ");
                model.addAttribute("code", -15000);
                return "/common/success";
            }

            /* 2 获取师弟们的用户基础信息 */
            Long total = 0L,
                    totalPage = 1L;
            Set<Long> cids = new HashSet<>(),
                    oids = new HashSet<>();

            /* 获取该师兄单页要显示的师弟信息 */
            Map<String, Object> paramList = DynamicUtil.getHisStudentRelationListParam(uid, type, false);
            log.info("get param:" + paramList);
            List<Long> studentUids = userService.getIdsByDynamicCondition(User.class, paramList, start, size);
            log.info("get studentUids:" + studentUids);
            List<User> studentList = userService.getObjectsByIds(studentUids);

            /* 获取该类别下师弟总数、总页数 */
            Map<String, Object> paramCount = DynamicUtil.getHisStudentRelationListParam(uid, type, true);
            List<Long> studentCount = userService.getIdsByDynamicCondition(UserDocumentRelation.class, paramCount, 0, Integer.MAX_VALUE);
            if (CollectionUtils.isNotEmpty(studentCount)) {
                total = studentCount.get(0);
                totalPage = ComputeUtil.myDivideiCeil(total, size);
            }

            /* 计算写日报率 */
            int studentSize = studentList.size();
            for (int i = 0; i < studentSize; i++) {
                User student = studentList.get(i);
                student = ComputeUtil.computeDailyRate(student);

                oids.add(student.getOid());
                cids.add(student.getCid());
            }
            log.info("their cids: " + cids);
            log.info("their oids: " + oids);

            /* 3 获取师弟们的职业信息 */
            List<Occupation> occupationList = occupationService.getObjectsByIds(new ArrayList<Long>(oids));

            /* 4 获取师弟们的班级信息 */
            List<Classes> classesList = this.classesService.getObjectsByIds(new ArrayList<Long>(cids));

            log.info("studentListde size :" + studentList.size());

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("studentList", studentList);
            model.addAttribute("occupationList", occupationList);
            model.addAttribute("classesList", classesList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t);
            log.error(t.getMessage());
            log.error(uid + " failed in getting his students ");
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/user/json/hisStudentsInfo";
    }


    /**
     * 16.查询用户
     *
     * @param request
     * @param response
     * @param model
     * @param type
     * @param oid
     * @param studyNumber
     * @param mobile
     * @return
     */
    @RequestMapping(value = "/a/user/search", method = RequestMethod.GET)
    public String getUid(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                         String type, Long oid, Integer studyNumber, String mobile) {

        String paramStr = LogUtil.convertParam("getUid by==type", type, "oid", oid, "studyNumber", studyNumber, "mobile", mobile);
        log.info(paramStr);

        try {

            Long uid = null;
            if (StringUtils.isNotBlank(mobile)) {
                uid = this.userService.getUserIdByMobile(mobile);

            } else if (StringUtils.isNotBlank(type) && null != oid && null != studyNumber) {
                uid = this.userService.getUserIdByTypeAndOidAndNum(type, oid, studyNumber);

            } else {
                model.addAttribute("code", -15002);
                return "/common/success";
            }

            model.addAttribute("code", 0);
            model.addAttribute("id", uid);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t);
            log.error(t.getMessage());
            log.error(" failed in getting uid ");
            model.addAttribute("code", -1);
        }

        return "/common/insert";
    }


    /**
     * 寻找师兄
     *
     * @param request
     * @param response
     * @param model
     * @param oid
     * @param tid
     * @param branch
     * @param identity
     * @param level
     * @param studyStartAt
     * @param studyEndAt
     * @param graduatedStartAt
     * @param graduatedEndAt
     * @param nick
     * @param type
     * @param studyNumber
     * @param page
     * @param size
     * @return
     */
    @RequestMapping(value = "/a/user/list", method = RequestMethod.GET)
    public String searchTeacher(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                Long oid, Long tid, Integer branch, Integer identity, Integer level,
                                Long studyStartAt, Long studyEndAt, Long graduatedStartAt, Long graduatedEndAt,
                                String nick, String type, Integer studyNumber, Integer page, Integer size, Integer status) {
        log.info(" /a/user/list start ... ");

        String paramStr = LogUtil.convertParam("getUid by==oid", oid, "tid", tid, "branch", branch, "identity", identity,
                "level", level, "studyStartAt", studyStartAt, "studyEndAt", studyEndAt, "graduatedStartAt", graduatedStartAt,
                "graduatedEndAt", graduatedEndAt, "nick", nick, "type", type, "studyNumber", studyNumber);
        log.info(paramStr);

        if (DataUtils.isNullOrEmpty(size)) {
            size = 10;
        }
        if (DataUtils.isNullOrEmpty(page)) {
            page = 1;
        }

        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        Integer total = 0;

        try {

            Map<String, Object> userParam = DynamicUtil.getUserListByParams(oid, tid, branch, identity, level,
                    studyStartAt, studyEndAt, graduatedStartAt, graduatedEndAt, nick, type, studyNumber, status, false);
            List<Long> uids = userService.getIdsByDynamicCondition(User.class, userParam, start, size);
            Set<Long> uidSet = new HashSet<>();


            log.info(" get uids is = " + uids);
            List<User> users = new ArrayList<>();
            Set<Long> cids = new HashSet();
            Set<Long> oids = new HashSet();
            Set<Long> ucids = new HashSet();
            List<Classes> classesList = new ArrayList();
            List<Occupation> occupations = new ArrayList<>();
            List<UserClassRelation> relations = new ArrayList<>();
            if (CollectionUtils.isEmpty(uids)) {
                log.info(" uids is empty ");
            } else {
                for (Long uid : uids) {
                    uidSet.add(uid);
                }

                users = userService.getObjectsByIds(new ArrayList<Long>(uidSet));
                DynamicUtil.checkUserGraduateStatus(users);
                for (User user : users) {
                    cids.add(user.getCid());
                    log.info(" get cids is = " + cids);
                    oids.add(user.getOid());
                    log.info(" get oids is = " + oids);
                    if (user.getUserClassID() > 0) {
                        ucids.add(user.getUserClassID());
                    }
                }
                classesList = classesService.getObjectsByIds(new ArrayList<Long>(cids));
                occupations = occupationService.getObjectsByIds(new ArrayList<Long>(oids));
                relations = userClassRelationService.getObjectsByIds(new ArrayList<Long>(ucids));

            }


            userParam = DynamicUtil.getUserListByParams(oid, tid, branch, identity, level,
                    studyStartAt, studyEndAt, graduatedStartAt, graduatedEndAt, nick, type, studyNumber, status, true);
            uids = userService.getIdsByDynamicCondition(User.class, userParam, 0, Integer.MAX_VALUE);
            if (CollectionUtils.isNotEmpty(uids)) {
                total = uids.get(0).intValue();
            }
            log.info(" total = " + total);

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
            model.addAttribute("userList", users);
            model.addAttribute("classes", classesList);
            model.addAttribute("occupations", occupations);
            model.addAttribute("relations", relations);
            log.info(" /a/user/list end  ... ");
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t);
            log.error(t.getMessage());
            log.error("  searchTeacher error ", t);
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/user/json/userListJson";
    }


    /**
     * 学员自拍视频列表
     *
     * @param request
     * @param response
     * @param model
     * @param page
     * @param size
     * @return
     */
    @RequestMapping(value = "/a/user/video/list", method = RequestMethod.GET)
    public String getUserVideos(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                Integer page, Integer size) {
        log.info(" /a/user/video/list start ... ");

        String paramStr = LogUtil.convertParam("page", page, "size", size);
        log.info(paramStr);

        if (DataUtils.isNullOrEmpty(size)) {
            size = 10;
        }
        if (DataUtils.isNullOrEmpty(page)) {
            page = 1;
        }

        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        Integer total = 0;

        try {
            List<User> users = new ArrayList<>();
            List<User> userIds = DynamicUtil.getUserVideo(start, size);
            List<Long> uids = new ArrayList<>();

            if (CollectionUtils.isEmpty(userIds)) {
                log.info(" uids is null ");
            } else {
                for (User user : userIds) {
                    uids.add(user.getId());
                }

                users = userService.getObjectsByIds(uids);
            }
            userIds = DynamicUtil.getUserVideo(0, Integer.MAX_VALUE);
            if (CollectionUtils.isNotEmpty(userIds)) {
                total = userIds.size();
            }
            log.info(" total = " + total);

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
            model.addAttribute("userList", users);
            log.info(" /a/user/video/list end  ... ");
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t);
            log.error(t.getMessage());
            log.error("  get user video  error ", t);
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/user/json/userListJson";
    }

    public static String adminSend(String mobile, String content) {
        String param = "{\n" +
                "    \"target_type\" : \"users\", \n" +
                "    \"target\" : [\"" + mobile + "\"],   \n" +
                "                                   \n" +
                "                                   \n" +
                "    \"msg\" : {\n" +
                "        \"type\" : \"txt\",\n" +
                "        \"msg\" : \"" + content + "\" \n" +
                "        },\n" +
                "    \"from\" : \"admin\"\n" +
                "}";
        String result = HttpClientUtil.sendPostRequestByJavaSetHeader("https://a1.easemob.com/jnshu4/jnshu4/messages", param, "application/json", "Bearer YWMtwJlMnN7iEeW93dWWI_R-hgAAAVRiEFRny8NEKnIG6-Gu_yibQ4d46AkTlmM");
        log.info(result);
        return result;
    }
}