package com.ptteng.common.skill.util;

import com.ptteng.common.skill.model.User;
import org.apache.commons.lang3.StringUtils;

import javax.servlet.http.HttpServletRequest;

/**
 * Created by ouyang on 2016/12/16.
 */
public class CheckDataUtil {

    /**
     * 校验字符串为合法手机号码
     * 1-字符串不为空
     * 2-第一位为“1”
     * 3-纯数字
     * 4-11位字符串
     * @param mobile
     * @return true-正常手机号 false-非法手机号
     */
    public static boolean checkMobile(String mobile) {

        if (StringUtils.isBlank(mobile)) {
            return false;
        }

        if ("1".equals(mobile.charAt(0))) {
            return false;
        }

        int size = mobile.length();
        for (int i = 1; i < size; i++) {
            if (CheckDataUtil.isNotDigit(mobile.charAt(i))) {
                return false;
            }
        }

        return mobile.length() == 11 ? true : false;
    }

    /***
     * 校验是否需要增加用户拓展信息
     * @param oldStatus
     * @param newStatus
     * @return true-需要 false-不需要
     */
    public static boolean needAddTeacher(Integer oldStatus, Integer newStatus) {
        if (isNull(oldStatus)||isNull(newStatus)) {
            return false;
        }
        return (isStudent(oldStatus) && isTeacher(newStatus))?true:false;
    }


    public static boolean isNotDigit(char c) {
        return !(Character.isDigit(c));
    }

    public static boolean isNotNull(Object object) {
        return !(isNull(object));
    }

    public static boolean isNull(Object object) {
        return null == object?true:false;
    }

    public static boolean notEqual(Long num1, Long num2) {
        if (isNull(num1) || isNull(num2)) {
            return false;
        }
        return !(num1.equals(num2));
    }

    public static boolean notEqual(Integer num1, Integer num2) {
        if (isNull(num1) || isNull(num2)) {
            return false;
        }
        return !(num1.equals(num2));
    }

    public static boolean equal(Long num1, Long num2) {
        if (isNull(num1) || isNull(num2)) {
            return false;
        }
        return num1.equals(num2);
    }

    public static boolean equal(Integer num1, Integer num2) {
        if (isNull(num1) || isNull(num2)) {
            return false;
        }
        return num1.equals(num2);
    }

    public static boolean isTeacher(Integer status) {
        if (isNull(status)){
            return false;
        }
        return status.equals(User.Status_Teacher)?true:false;
    }

    public static boolean isStudent(Integer status) {
        if (isNull(status)) {
            return false;
        }
        return status.equals(User.Status_Student)?true:false;
    }
    //校验是否线上环境
    public static boolean isOnline(HttpServletRequest request) {
        if (isNull(request)) {
            return false;
        }
        return  request.getHeader("Referer").contains("jnshu.com")?true:false;
    }

}
