package com.ptteng.common.skill.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.MyTimeUtil;
import com.gemantic.common.util.StringUtil;
import com.gemantic.common.util.json.GsonUtil;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.ptteng.common.skill.model.*;
import com.ptteng.common.skill.service.*;
import com.ptteng.common.skill.util.*;
import com.ptteng.skill.service.model.UserTaskRelation;
import com.ptteng.skill.service.service.UserTaskRelationService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.HttpClientUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.*;


/**
 * Article crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class ArticleController {
    private static final Log log = LogFactory.getLog(ArticleController.class);

    @Autowired
    private ArticleService articleService;

    @Autowired
    private MessageService messageService;

    @Autowired
    private UserService userService;

    @Autowired
    private UserScoreService userScoreService;

    @Autowired
    private TaskService taskService;

    @Autowired
    private OccupationService occupationService;

    @Autowired
    private CommentService commentService;

    @Autowired
    private ArticleTaskRelationService articleTaskRelationService;

    @Autowired
    private UserClassRelationService userClassRelationService;

    @Autowired
    private ClassesService classesService;
    @Autowired
    private TaskSkillRelationService taskSkillRelationService;
    @Autowired
    private SkillService skillService;

    @Autowired
    private CookieUtil cookieUtil;

    @Autowired
    private ConstantService constantService;
    @Autowired
    private UserArticleRelationService userArticleRelationService;
    @Autowired
    private GetUserFromCookieUtil getUserFromCookieUtil;
    private String easemob_token;
    @Autowired
    private UserTaskRelationService userTaskRelationService;

    /**
     * 日报详情
     *
     * @param request
     * @param response
     * @param model
     * @param did      日报ID
     * @return
     */
    @RequestMapping(value = "/daily/detail/{did}", method = RequestMethod.GET)
    public String webDailyDetial(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model,
                                 @PathVariable Long did) {
        log.info("get dailyInfo " + did);

        try {
            //1.获取日报，更新日报的阅读数
            Article daily = articleService.getObjectById(did);
            if (daily == null) {
                model.addAttribute("code", -5000);
                log.info("no this article");
                return "/common/success";
            }
            daily.setReadCount(daily.getReadCount() + 1);
            articleService.update(daily);

            //2.获取任务
            List<Task> taskList = new ArrayList();
            Gson gson = new Gson();
            List<Long> taskIDS = gson.fromJson(daily.getTids(), new TypeToken<List<Long>>() {
            }.getType());

            if (CollectionUtils.isEmpty(taskIDS)) {
            } else {
                taskList = taskService.getObjectsByIds(taskIDS);
            }
            log.info(did + "get task size is " + taskList.size());

            List<Skill> skills = new ArrayList();
            if (CollectionUtils.isEmpty(taskIDS)) {

            } else {
                List<Long> skillIDS = this.taskSkillRelationService.getSkillIdsByTid(taskIDS.get(0), 0, Integer.MAX_VALUE);
                skills = this.skillService.getObjectsByIds(skillIDS);
            }
            //3.获取用户
            User user = this.userService.getObjectById(daily.getUid());

            //4.职业列表
            List<Occupation> occupations = new ArrayList<>();
            List<Long> occupationIds = occupationService.getOccupationIds(0, Integer.MAX_VALUE);
            if (CollectionUtils.isEmpty(occupationIds)) {

            } else {
                occupations = occupationService.getObjectsByIds(occupationIds);
            }
            //5.评论列表
            int page = 1;
            int size = 10;
            int start = (page - 1) * size;
            if (start < 0) {
                start = 0;
            }
            int end = start + size + 1;
            Set<Long> uids = new HashSet();
            Integer total = 0;
            boolean next = false;

            List<Comment> comments = new ArrayList();
            Map<String, Object> param = DynamicUtil.getCommentListParam(
                    did, null, null, false);
            List<Long> commentIDS = this.commentService
                    .getIdsByDynamicCondition(Comment.class, param,
                            start, end);

            Map<String, Object> countParam = DynamicUtil.getCommentListParam(
                    did, null, null, true);
            List<Long> totals = this.commentService
                    .getIdsByDynamicCondition(Comment.class, countParam,
                            0, Integer.MAX_VALUE);
            total = totals.get(0).intValue();
            log.info(" did: " + did + " get comment is " + commentIDS);
            if (CollectionUtils.isEmpty(commentIDS)) {

            } else {
                comments = this.commentService.getObjectsByIds(commentIDS);
                if (comments.size() > size) {
                    comments = comments.subList(0, size);
                    next = true;

                } else {

                }
                for (Comment comment : comments) {
                    uids.add(comment.getUid());
                }

                log.info(" did: " + did + " get uids is " + uids);
            }
            List<User> users = new ArrayList();
            Map<Long, User> userMap = new HashMap<>();
            if (CollectionUtils.isEmpty(uids)) {
            } else {
                users = this.userService.getObjectsByIds(new ArrayList(uids));
                log.info(" get user is " + uids);
                for (Comment comment : comments) {
                    for (User user1 : users) {
                        if (user1.getId().equals(comment.getUid())) {
                            userMap.put(comment.getId(), user1);
                        }
                    }
                }


            }
            log.info(" user = " + user);

            Long oid = daily.getOid();
            //4.获取上下篇的日报id
            //下篇
            Map<String, Object> downParam = DynamicUtil.getDownArticleByDidAndOid(did, oid);
            List<Long> nextList = articleService.getIdsByDynamicCondition(Article.class, downParam, 0, 1);
            Long nextArticleId = null;
            if (CollectionUtils.isEmpty(nextList)) {
            } else {
                nextArticleId = nextList.get(0);
            }
            //上篇
            Map<String, Object> upParam = DynamicUtil.getUpArticleByDidAndOid(did, oid);
            List<Long> preList = articleService.getIdsByDynamicCondition(Article.class, upParam, 0, 1);
            Long preArticleId = null;
            if (CollectionUtils.isEmpty(preList)) {
            } else {
                preArticleId = preList.get(0);
            }

            Occupation occupation = occupationService.getObjectById(daily.getOid());
            Classes classes = classesService.getObjectById(daily.getCid());

            model.addAttribute("code", 0);
            model.addAttribute("article", daily);
            model.addAttribute("tasks", taskList);
            model.addAttribute("user", user);
            model.addAttribute("classes", classes);
            model.addAttribute("skills", skills);
            model.addAttribute("occupations", occupations);
            model.addAttribute("occupation", occupation);
            model.addAttribute("comments", comments);
            model.addAttribute("userMap", userMap);
            model.addAttribute("commentPage", page);
            model.addAttribute("commentSize", size);
            model.addAttribute("commentNext", next);
            model.addAttribute("commentTotal", total);
            model.addAttribute("oid", daily.getOid());
            model.addAttribute("preArticleId", preArticleId);
            model.addAttribute("nextArticleId", nextArticleId);


        } catch (Throwable t) {
            log.error("get dailyInfo error,did is " + did, t);
            model.addAttribute("code", -100000);
        }

        return "/web-dailys/dailyDetailJsp";
    }

    /**
     * 小网站入口
     *
     * @param request
     * @param response
     * @param model
     * @return
     */
    @RequestMapping(value = "/dailys", method = RequestMethod.GET)
    public String webDailys(HttpServletRequest request,
                            HttpServletResponse response, ModelMap model, Long oid, Integer page) {

		/* 1 初始化参数 */


        Integer size = 10;
        if (DataUtils.isNullOrEmpty(page)) {
            page = 1;
        }

        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        int limit = size + 1;
        Integer total = 0;
        boolean next = false;

        try {
            if (DataUtils.isNullOrEmpty(oid)) {
                oid = 1L;
            }
            int orderBy = UserArticleRelation.ARTICLE_CREATE_AT;
            int sort = UserArticleRelation.DESC;

            List<Long> articleIDS = new ArrayList();
            List<Long> articleCount = new ArrayList();
            /* 2-1 普通日报搜索 */
            Map<String, Object> articleParam = DynamicUtil.getArticleListByParam(
                    null, null, null, oid, null, null, false, orderBy, sort, null, null, null, null, false);
            articleIDS = this.articleService.getIdsByDynamicCondition(Document.class, articleParam, start, limit);

            Map<String, Object> countArticleParam = DynamicUtil.getArticleListByParam(
                    null, null, null, oid, null, null, false, orderBy, sort, null, null, null, null, true);
            articleCount = this.articleService.getIdsByDynamicCondition(Document.class, countArticleParam, 0, Integer.MAX_VALUE);

            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(articleCount)) {
                total = articleCount.get(0).intValue();
            }

            String str2 = LogUtil.convertParam(" get total of daily is ", "total", total, "date", articleIDS);
            log.info(str2);

            List<Article> articles = new ArrayList();
            List<User> users = new ArrayList();
            List<Task> tasks = new ArrayList();
            List<Classes> classes = new ArrayList();

            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(articleIDS)) {
                articles = this.articleService.getObjectsByIds(articleIDS);
                if (articles.size() >= size) {
                    articles = articles.subList(0, size);
                    next = true;
                }
            }
            Gson gson = new Gson();
            Type typeToken = new TypeToken<List<Long>>() {
            }.getType();
            Map<Long, List<Long>> tidMap = new HashMap<>();
            Set<Long> uids = new HashSet();
            Set<Long> tids = new HashSet();
            Set<Long> cids = new HashSet();
            for (Article article : articles) {
                uids.add(article.getUid());
                cids.add(article.getCid());
                List<Long> taskIDS = gson.fromJson(article.getTids(), typeToken);
                if (taskIDS != null) {
                    tids.addAll(taskIDS);
                }
                tidMap.put(article.getId(), taskIDS);
            }

            if (CollectionUtils.isEmpty(tids)) {

            } else {
                tasks = this.taskService.getObjectsByIds(new ArrayList(tids));
                log.info(" get tasks is " + tids);
            }

            if (CollectionUtils.isEmpty(uids)) {

            } else {
                users = this.userService.getObjectsByIds(new ArrayList(uids));
                log.info(" get user is " + uids);
                classes = this.classesService.getObjectsByIds(new ArrayList(cids));
            }
            List<Occupation> occupations = new ArrayList<>();
            List<Long> occupationIds = occupationService.getOccupationIds(0, Integer.MAX_VALUE);
            if (CollectionUtils.isEmpty(occupationIds)) {

            } else {
                occupations = occupationService.getObjectsByIds(occupationIds);
            }
            Map<Long, Occupation> occupationMap = ToMap.list2Map(occupations, "getId", Occupation.class);

            Map<Long, User> userMap = ToMap.list2Map(users, "getId", User.class);
            Map<Long, Task> taskMap = ToMap.list2Map(tasks, "getId", Task.class);
            Map<Long, Classes> classesMap = ToMap.list2Map(classes, "getId", Classes.class);
            model.addAttribute("code", 0);
            log.info(" ==============articles size = " + articles.size());
            int totalPage = 1;
            if (total > 0) {
                totalPage = (total - 1) / size + 1;
            }
            model.addAttribute("aricles", articles);
            model.addAttribute("userMap", userMap);
            model.addAttribute("taskMap", taskMap);
            model.addAttribute("tidMap", tidMap);
            model.addAttribute("classesMap", classesMap);
            model.addAttribute("occupations", occupations);
            model.addAttribute("occupationMap", occupationMap);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("next", next);
            model.addAttribute("total", total);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("oid", oid);
            long a = System.currentTimeMillis();
            long aa = a + 60 * DateUtils.MILLIS_PER_DAY;
            model.addAttribute("graduateAt", aa);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t);
            log.error(t.getMessage());
            log.error("get classesDailyList error,oid is " + 1);
            model.addAttribute("code", -100000);
        }

        return "/web-dailys/dailysJsp";
    }


    /**
     * 日报详情
     *
     * @param request
     * @param response
     * @param model
     * @param did      日报ID
     * @return
     */
    @RequestMapping(value = "/a/daily/{did}", method = RequestMethod.GET)
    public String dailyInfo(HttpServletRequest request,
                            HttpServletResponse response, ModelMap model,
                            @PathVariable Long did) {
        Long loginUserId = getUserFromCookieUtil.getUserFromCookie(request);
        log.info(" loginUserId = " + loginUserId);
        log.info("get dailyInfo " + did);

        try {
            //1.获取日报，更新日报的阅读数
            Article daily = articleService.getObjectById(did);
            if (daily == null) {
                model.addAttribute("code", -5000);
                log.info("no this article");
                return "/common/success";
            }
            daily.setReadCount(daily.getReadCount() + 1);
            articleService.update(daily);
            if (DataUtils.isNotNullOrEmpty(loginUserId)) {
                Long loveId = userArticleRelationService.getUserArticleRelationIdByUidAndAidAndTypeAndWeather(loginUserId, did, UserArticleRelation.STATUS_LOVE, UserArticleRelation.WHETHER_VALID);
                log.info(" loveId = " + loveId);
                Long collectionId =
                        userArticleRelationService.getUserArticleRelationIdByUidAndAidAndTypeAndWeather(loginUserId, did, UserArticleRelation.STATUS_COLLECTION, UserArticleRelation.WHETHER_VALID);
                log.info(" collectionId = " + collectionId);
                if (DataUtils.isNotNullOrEmpty(loveId)) {
                    daily.setIfLike(true);
                }
                if (DataUtils.isNotNullOrEmpty(collectionId)) {
                    daily.setIfCollection(true);
                }
            }
            //2.获取任务
            List<Task> taskList = new ArrayList();
            Gson gson = new Gson();
            List<Long> taskIDS = gson.fromJson(daily.getTids(), new TypeToken<List<Long>>() {
            }.getType());

            if (CollectionUtils.isEmpty(taskIDS)) {
            } else {
                taskList = taskService.getObjectsByIds(taskIDS);
            }
            log.info(did + "get task size is " + taskList.size());
            //3.获取用户
            User user = this.userService.getObjectById(daily.getUid());
            Long teacherId = user.getTeacherId();
            User teacher = new User();
            if (DataUtils.isNotNullOrEmpty(teacherId)) {
                teacher = userService.getObjectById(teacherId);
            }
            DynamicUtil.checkUserGraduateStatus(user);
            model.addAttribute("code", 0);
            model.addAttribute("daily", daily);
            model.addAttribute("tasks", taskList);
            model.addAttribute("user", user);
            model.addAttribute("teacher", teacher);

        } catch (Throwable t) {
            log.error("get dailyInfo error,did is " + did, t);
            model.addAttribute("code", -100000);
        }

        return "/common-skill-service/article/json/articleDetailJson";
    }


    /**
     * 日报搜索
     *
     * @param request
     * @param response
     * @param model
     * @param uid      user's id
     * @param tid
     * @param cid
     * @param oid
     * @param startAt
     * @param endAt
     * @param page
     * @param size
     * @return
     */
    @RequestMapping(value = "/a/daily/search/query", method = RequestMethod.GET)
    public String searchDaily(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model, Long teacherUid, Long uid, Long tid,
                              Long cid, Long oid, Long startAt, Long endAt, Integer page, Integer size, Integer orderBy, Integer sort,
                              Integer evaluation, String userType, Long userOid, Integer studyNumber, Integer stuEvaluation) {

        String paramStr = LogUtil.convertParam("searchDaily by==teacherUid", teacherUid, "uid", uid, "cid", cid, "oid",
                oid, "startAt", startAt, "endAt", endAt, "page", page, "size", size + " orderby " + orderBy + "sort = " + sort);
        log.info(paramStr);
        Long loginUserId = getUserFromCookieUtil.getUserFromCookie(request);

		/* 1 初始化参数 */
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        int limit = size + 1;
        Integer total = 0;
        boolean next = false;

        try {

            List<Long> articleIDS = new ArrayList();
            List<Long> articleCount = new ArrayList();
            if (DataUtils.isNullOrEmpty(orderBy)) {
                orderBy = UserArticleRelation.ARTICLE_CREATE_AT;
            }
            if (DataUtils.isNullOrEmpty(sort)) {
                sort = UserArticleRelation.DESC;
            }
            /* 2-1 普通日报搜索 */
            if (CheckDataUtil.isNull(teacherUid)) {

                Map<String, Object> articleParam = DynamicUtil.getArticleListByParam(
                        uid, tid, cid, oid, startAt, endAt, false, orderBy, sort, evaluation, userType, userOid, studyNumber, false);
                articleIDS = this.articleService.getIdsByDynamicCondition(Document.class, articleParam, start, limit);

                Map<String, Object> countArticleParam = DynamicUtil.getArticleListByParam(
                        uid, tid, cid, oid, startAt, endAt, false, orderBy, sort, evaluation, userType, userOid, studyNumber, true);
                articleCount = this.articleService.getIdsByDynamicCondition(Document.class, countArticleParam, 0, Integer.MAX_VALUE);

            /* 2-2 师弟日报搜索 */
            } else {

                //按teacherUid获取所有的师弟信息
                Map<String, Object> paramList = DynamicUtil.getHisStudentRelationListParam(teacherUid, null, false);
                log.info("get param:" + paramList);
                List<Long> studentIds = userService.getIdsByDynamicCondition(User.class, paramList, 0, Integer.MAX_VALUE);
                log.info("get studentIds:" + studentIds);
                if (CollectionUtils.isEmpty(studentIds)) {
                    model.addAttribute("code", -15003);
                    log.info("user hasn`t a student");
                    return "/common/success";
                }

				/* 获取师弟日报，不不不限定所获取日报必须跟师兄同职业 */
                Map<String, Object> articleParam = DynamicUtil.getStudentsArticleParam(studentIds, null, orderBy, sort, stuEvaluation, false);
                log.info("get articleParam:" + articleParam);
                articleIDS = this.articleService.getIdsByDynamicCondition(Article.class, articleParam, start, limit);
                log.info("get articleIDS:" + articleIDS);

				/* 获取师弟日报 */
                Map<String, Object> articleCountParam = DynamicUtil.getStudentsArticleParam(studentIds, null, orderBy, sort, stuEvaluation, true);
                articleCount = this.articleService.getIdsByDynamicCondition(Article.class, articleCountParam, 0, Integer.MAX_VALUE);

            }

            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(articleCount)) {
                total = articleCount.get(0).intValue();
            }

            String str2 = LogUtil.convertParam(" get total of daily is ", "total", total, "date", articleIDS);
            log.info(str2);

            List<Article> articles = new ArrayList();
            List<User> users = new ArrayList();
            List<Task> tasks = new ArrayList();
            List<Classes> classes = new ArrayList();

            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(articleIDS)) {
                articles = this.articleService.getObjectsByIds(articleIDS);
                if (articles.size() >= size) {
                    articles = articles.subList(0, size);
                    next = true;
                }
            }

            Gson gson = new Gson();
            Type typeToken = new TypeToken<List<Long>>() {
            }.getType();
            Set<Long> uids = new HashSet();
            Set<Long> tids = new HashSet();
            Set<Long> cids = new HashSet();
            for (Article article : articles) {
                uids.add(article.getUid());
                cids.add(article.getCid());
                List<Long> taskIDS = gson.fromJson(article.getTids(), typeToken);
                if (taskIDS != null) {
                    tids.addAll(taskIDS);
                }


            }

            if (CollectionUtils.isEmpty(tids)) {

            } else {
                tasks = this.taskService.getObjectsByIds(new ArrayList(tids));
                log.info(" get tasks is " + tids);
            }


            if (CollectionUtils.isEmpty(uids)) {

            } else {
                users = this.userService.getObjectsByIds(new ArrayList(uids));
                DynamicUtil.checkUserGraduateStatus(users);
                log.info(" get user is " + uids);
                classes = this.classesService.getObjectsByIds(new ArrayList(cids));
            }


            //用户是否点赞过或者收藏过
            Map<Long, Boolean> iflikeMap = new HashedMap(),
                    ifCollectionMap = new HashedMap();
            log.info(" login user Id = " + loginUserId);
            if (DataUtils.isNotNullOrEmpty(loginUserId)) {
                Map<String, Object> paramRelation = DynamicUtil.getArticleRelationListParam(articleIDS, loginUserId, false);
                log.info("query relationId sql: " + paramRelation);
                List<Long> relationIds = userArticleRelationService.getIdsByDynamicCondition(UserArticleRelation.class, paramRelation, 0, Integer.MAX_VALUE);


                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(relationIds)) {
                    log.info("relationIds has:" + relationIds);
                    List<UserArticleRelation> relationList = userArticleRelationService.getObjectsByIds(relationIds);

                    int relationSize = relationList.size();
                    for (int i = 0; i < relationSize; i++) {
                        UserArticleRelation relation = relationList.get(i);
                        Integer relationStatus = relation.getType();
                        log.info(" relation id = " + relation.getId() + " aid = " + relation.getAid() + " relationStatus = " + relationStatus);
                        Long aid = relation.getAid();

                /* 替换掉旧值 */
                        log.info(" iflikeMap = " + iflikeMap + " ifCollectionMap = " + ifCollectionMap);
                        switch (relationStatus) {
                            case UserArticleRelation.STATUS_LOVE:
                                iflikeMap.put(aid, true);
                                break;
                            case UserArticleRelation.STATUS_COLLECTION:
                                ifCollectionMap.put(aid, true);
                                break;
                            default:
                                break;
                        }
                        log.info(" iflikeMap = " + iflikeMap + " ifCollectionMap = " + ifCollectionMap);

                    }
                    for (int i = 0; i < articles.size(); i++) {
                        Article article = articles.get(i);
                        Long aid = article.getId();
                        log.info(" aid = " + aid + " iflikeMap = " + iflikeMap + " ifCollectionMap = " + ifCollectionMap);
                        article.setIfLike(iflikeMap.get(aid) == null ? false : iflikeMap.get(aid));
                        article.setIfCollection(ifCollectionMap.get(aid) == null ? false : ifCollectionMap.get(aid));
                    }
                }


            }


            model.addAttribute("code", 0);
            model.addAttribute("aricles", articles);
            model.addAttribute("users", users);
            model.addAttribute("tasks", tasks);
            model.addAttribute("classesList", classes);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("next", next);
            model.addAttribute("total", total);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t);
            log.error(t.getMessage());
            log.error("get classesDailyList error,oid is " + oid);
            model.addAttribute("code", -100000);
        }

        return "/common-skill-service/article/json/articleListJson";
    }


    /**
     * 19.日报信息读取
     *
     * @param request
     * @param response
     * @param model
     * @param did
     * @return
     */
    @RequestMapping(value = "/a/daily/{did}/{direction}/detail", method = RequestMethod.GET)
    public String getNeighbourDaily(HttpServletRequest request,
                                    HttpServletResponse response, ModelMap model,
                                    @PathVariable Long did, @PathVariable String direction, Long uid,
                                    Long tid, Long cid, Long oid, Long teacherUid) {

        log.info("getNeighbourDaily by " + did);
        Long neighbourID = -1L;
        int code = 0;

        try {

            Article article = this.articleService.getObjectById(did);
            if (article == null) {
                model.addAttribute("code", -15004);
                log.info("no this daily");
                return "/common/success";
            }
            Long startAt = null;
            Long endAt = null;
            if ("next".equals(direction)) {
                endAt = article.getCreateAt();
            } else {
                startAt = article.getCreateAt();
            }

            Map<String, Object> articleParam = new HashedMap();
            List<Long> articleIDS = new ArrayList<>();

			/* 普通日报列表 */
            if (null == teacherUid) {

                articleParam = DynamicUtil.getArticleListByDirectionParam(uid, tid, cid, oid, startAt, endAt, true, false);
                log.info("get articleParam:" + articleParam);
                articleIDS = this.articleService.getIdsByDynamicCondition(Article.class, articleParam, 0, 1);
                log.info(" get daily is " + articleIDS);

			/* 师弟日报列表 */
            } else {

                //按teacherUid获取师弟们的信息
                Map<String, Object> paramList = DynamicUtil.getHisStudentRelationListParam(teacherUid, null, false);
                log.info("get param:" + paramList);
                List<Long> studentIds = userService.getIdsByDynamicCondition(User.class, paramList, 0, Integer.MAX_VALUE);
                log.info("get studentIds:" + studentIds);

                if (CollectionUtils.isEmpty(studentIds)) {
                    model.addAttribute("code", -15003);
                    log.info("user hasn`t a student");
                    return "/common/success";
                }

                articleParam = DynamicUtil.getNearStudentsArticleParam(studentIds, startAt, endAt);
                log.info("get articleParam:" + articleParam);
                articleIDS = this.articleService.getIdsByDynamicCondition(Article.class, articleParam, 0, 1);
                log.info(" get daily is " + articleIDS);

            }

            if (CollectionUtils.isEmpty(articleIDS) || articleIDS.size() < 1) {

                code = -1111;
                String message = "温馨提醒：已是最后一篇了";
                model.addAttribute("message", message);

            } else {

                code = 0;
                neighbourID = articleIDS.get(0);
            }

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get dailyInfo error,did is " + did);
            model.addAttribute("code", -100000);
        }


        model.addAttribute("code", code);
        model.addAttribute("id", neighbourID);
        return "/common/insert";
    }


    /**
     * @param
     * @return
     */

    // 23.新建日报
    @RequestMapping(value = "/a/u/daily/{cid}", method = RequestMethod.POST)
    public String addDaily(HttpServletRequest request,
                           HttpServletResponse response, ModelMap model,
                           @PathVariable Long cid, Long dailyTime, Long[] task,
                           String content, String resultsUrl, String codeUrl) throws Exception {

        log.info("============================================");

        log.info("add daily : cid is " + cid + " dailyTime is " + dailyTime
                + " task is " + task + " content is " + content);

        if (cid == null || dailyTime == null || StringUtil.isEmpty(content) || task == null) {
            model.addAttribute("code", -1000);
            log.info("param is null");
            return "/common/success";
        }
        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        try {


            List<Long> lastDailyIds = articleService.getArticleIdsByUidAndType(uid, Article.TYPE_DAILT, 0, 1);
            log.info(" ======== lastDailyIds = " + lastDailyIds);
            Long lastDailyId = null;
            Article oldArticle = null;
            if (CollectionUtils.isEmpty(lastDailyIds)) {
                log.info(" lastDailyIds is empty ");
            } else {
                log.info(" lastDailyIds is empty " + lastDailyIds.get(0));
                lastDailyId = lastDailyIds.get(0);
                log.info("lastDailyId =  " + lastDailyId);
                oldArticle = articleService.getObjectById(lastDailyId);
                log.info("oldArticle =  " + oldArticle);
            }

            /**
             * 校验今日是否已写过日报
             */
            if (DataUtils.isNullOrEmpty(lastDailyId)) {

            } else {
                Long startAt = MyTimeUtil.getTodayZeroTimeMillions();
                Long endAt = startAt + 24 * 60 * 60 * 1000;
                if (oldArticle.getDailyTime() >= startAt && oldArticle.getDailyTime() <= endAt) {
                    log.info(" user has written today's daily ");
                    model.addAttribute("code", -17010);
                    return "/common/success";
                }

            }


            Classes classes = classesService.getObjectById(cid);
            Long oid = classes.getOid();
            List<Long> taskList = new ArrayList();
            taskList = Arrays.asList(task);
            if (classes.equals(null)) {
                model.addAttribute("code", -4002);
                log.info("no this classes");
                return "/common/success";
            }
            Article daily = new Article();
            daily.setUid(uid);
            daily.setCid(cid);
            daily.setOid(oid);
            String taskContent = GsonUtil.toJson(taskList);
            daily.setTids(taskContent);

            daily.setContent(content);
            daily.setResultsUrl(resultsUrl);
            daily.setCodeUrl(codeUrl);
            daily.setReadCount(0L);
            daily.setReply(0L);
            //日报时间从服务器端获取，不用前端传参
            daily.setDailyTime(System.currentTimeMillis());
            daily.setType("daily");
            Long did = articleService.insert(daily);

            List<ArticleTaskRelation> relations = new ArrayList();

            for (Long taskId : taskList) {
                ArticleTaskRelation articleTaskRelation = new ArticleTaskRelation();
                articleTaskRelation.setDid(did);
                articleTaskRelation.setTid(taskId);
                relations.add(articleTaskRelation);

            }
            articleTaskRelationService.insertList(relations);
            log.info(did + " insert list success ");
            user.setDailyCount(user.getDailyCount() + 1);
            this.userService.update(user);
            log.info(uid + " update daily count " + user.getDailyCount());

            classes.setDailyCount(classes.getDailyCount() + 1);
            this.classesService.update(classes);
            log.info(classes.getId() + " update classese  count " + classes.getDailyCount());


            Long relationID = userClassRelationService
                    .getUserClassRelationIdByCidAndUidAndStatus(cid, uid, 1);
            log.info(" relationID = " + relationID);
            if (DataUtils.isNullOrEmpty(relationID)) {
                model.addAttribute("code", -4003);
                log.info("user is not in the classes");
                return "/common/success";
            }
            UserClassRelation relation = userClassRelationService
                    .getObjectById(relationID);
            if (lastDailyId == null) {
                relation.setLastDaily(did);
                userClassRelationService.update(relation);
            } else {

                if (oldArticle == null) {
                    relation.setLastDaily(did);
                    userClassRelationService.update(relation);
                } else {
                    Long oldDailyTime = oldArticle.getDailyTime();
                    if (oldDailyTime <= dailyTime) {
                        relation.setLastDaily(did);
                        userClassRelationService.update(relation);
                    }
                }
            }

            model.addAttribute("code", 0);
            model.addAttribute("did", did);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("add daily error,cid is " + cid + " dailyTime is "
                    + dailyTime + " task is " + task + " content is " + content);
            t.printStackTrace();
            model.addAttribute("code", -100000);
        }

        return "/common-skill-service/article/json/addDaily";
    }

    /**
     * @param
     * @return
     */

    // 24.修改日报
    @RequestMapping(value = "/a/u/daily/{did}", method = RequestMethod.PUT)
    public String updateDaily(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model,
                              @PathVariable Long did, Long dailyTime, Long[] task,
                              String content, String resultsUrl, String codeUrl) throws Exception {

        log.info("============================================");
        log.info("add daily : did is " + did + " dailyTime is " + dailyTime
                + " task is " + task + " content is " + content);

        if (did.equals(null) || dailyTime.equals(null)
                || StringUtil.isEmpty(content)) {
            model.addAttribute("code", -1000);
            log.info("param is null");
            return "/common/success";
        }

        try {
            Article article = articleService.getObjectById(did);

            if (article.equals(null)) {
                model.addAttribute("code", -5000);
                log.info("no this article");
                return "/common/success";
            }

            User user = (User) request.getAttribute("user");
            Long uid = user.getId();
            log.info("uid is :" + uid + "article is :" + article);

            if (!uid.equals(article.getUid())) {
                model.addAttribute("code", -5001);
                log.info("user is not write the classes");
                return "/common/success";
            }

            List<Long> taskList = new ArrayList();
            taskList = Arrays.asList(task);

            Long relationID = userClassRelationService
                    .getUserClassRelationIdByCidAndUid(article.getCid(), uid);
            UserClassRelation relation = userClassRelationService
                    .getObjectById(relationID);
            Long lastDailyId = relation.getLastDaily();
            if (lastDailyId == null) {
                relation.setLastDaily(did);
                userClassRelationService.update(relation);
            } else {
                Article oldArticle = articleService.getObjectById(lastDailyId);
                Long oldDailyTime = oldArticle.getDailyTime();
                if (oldDailyTime <= dailyTime) {
                    relation.setLastDaily(did);
                    userClassRelationService.update(relation);
                }
            }

             Long now = System.currentTimeMillis();
            //日报时间不可修改
            //article.setDailyTime(dailyTime);
            article.setUpdateTime(now);
            article.setContent(content);
            String taskContent = GsonUtil.toJson(taskList);
            article.setTids(taskContent);
            article.setResultsUrl(resultsUrl);
            article.setCodeUrl(codeUrl);
            articleService.update(article);

            List<Long> oldTaskList = articleTaskRelationService
                    .getArticleTaskRelationIdsByDid(did, 0, Integer.MAX_VALUE);
            articleTaskRelationService.deleteList(ArticleTaskRelation.class,
                    oldTaskList);

            for (Long taskId : taskList) {
                ArticleTaskRelation articleTaskRelation = new ArticleTaskRelation();
                articleTaskRelation.setDid(did);
                articleTaskRelation.setTid(taskId);
                articleTaskRelationService.insert(articleTaskRelation);
            }

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("add daily error,did is " + did + " dailyTime is "
                    + dailyTime + " task is " + task + " content is " + content);
            model.addAttribute("code", -100000);
        }

        return "/common/success";
    }


    /**
     * 日报评级
     *
     * @param request
     * @param response
     * @param model
     * @param did
     * @param result   1-下品 2-中品 3-上品
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/daily/evaluation/{did}", method = RequestMethod.PUT)
    public String updateDaily(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model,
                              @PathVariable Long did, Integer result, String comment, Long atUid) throws Exception {
        log.info(" evaluation daily ,id = " + did);
        if (DataUtils.isNullOrEmpty(result)) {
            model.addAttribute("code", -17001);
            return "/common/success";

        }
        if (StringUtil.isEmpty(comment)) {
            model.addAttribute("code", -17009);
            return "/common/success";
        }
        User user = (User) request.getAttribute("user");
        int userIdentity = user.getIdentity();
        Long uid = user.getId();
        int teacherScore = user.getScore();
        log.info("  teacher id = " + uid);
        log.info("  teacher teacherScore = " + teacherScore);
        Article article = articleService.getObjectById(did);
        if (DataUtils.isNotNullOrEmpty(article)) {
            Long studentId = article.getUid();
            User student = userService.getObjectById(studentId);
            int studentIdentity = student.getIdentity();
            int studentScore = student.getScore();
            log.info(" student's teacher id  = " + student.getTeacherId());
            log.info("  student studentScore = " + studentScore);
            if (DataUtils.isNotNullOrEmpty(student)) {
                if (uid.equals(student.getTeacherId())) {
                    article.setEvaluation(result);
                    //评级后师兄获得相应学分
                    if (userIdentity == User.IDENTIFY_40 || userIdentity == User.IDENTIFY_50) {
                        String dailyEvaluate = constantService.getConstantValueByTypeAndName(Constant.Type_score, Constant.Name_dailyEvaluate);
                        teacherScore = teacherScore + Integer.parseInt(dailyEvaluate);
                        Long score = Long.parseLong(dailyEvaluate);
                        log.info("  teacher teacherScore = " + teacherScore);
                        log.info("score" + score);
                        user.setScore(teacherScore);
                        userService.update(user);
                        //新增积分记录
                        UserScore userScore = new UserScore();
                        String comments = "日报评级奖励";
                        userScore.setUid(uid);
                        userScore.setComment(comments);
                        userScore.setScoreType(0);
                        userScore.setScore(score);
                        userScoreService.insert(userScore);
                        //===================================
                        //发送消息
                        user.setIsLook(user.getIsLook() + 1);
                        user.setLatestMsg(Message.SCORE_TYPE);
                        userService.update(user);

                        Message message = new Message();
                        message.setStatus(1);
                        message.setReceiveName(user.getNick());
                        message.setSendName("admin");
                        message.setSendId(0L);
                        message.setContent("");
                        message.setReceiveId(uid);
                        message.setUnread(1);
                        message.setType("score");


                        Long mid = messageService.insert(message);

                        message = this.messageService.getObjectById(mid);
                        String content;
                        content = "<span  class=\"font-16px system-alert-outline \">您得到了积分奖励，" +
                                "<a   data-mid=22362 ng-click=\"sendAlertMsg(li.id)\" class=\"font-orange\" target=\"_blank\" href=\"" +
                                "/school/" + uid + "/score///0\" target=\"_blank\">点击查看</a></span>";
                        adminSend(user.getMobile(), content);
                        message.setContent(content);
                        messageService.update(message);
                    }

                    //评级后师弟获得相应学分
                    if (studentIdentity == User.IDENTIFY_40 || studentIdentity == User.IDENTIFY_50) {
                        String dailyGood = constantService.getConstantValueByTypeAndName(Constant.Type_score, Constant.Name_dailyGood);
                        Long score = Long.parseLong(dailyGood);
                        log.info(" dailyGood  = " + teacherScore);

                        switch (result) {
                            case 1:
                                break;
                            case 2:
                                break;
                            case 3:
                                UserScore userScore = new UserScore();
                                String comments = "日报被评为上品，奖励积分";
                                userScore.setUid(studentId);
                                userScore.setComment(comments);
                                userScore.setScoreType(0);
                                userScore.setScore(score);
                                userScoreService.insert(userScore);
                                studentScore = studentScore + Integer.parseInt(dailyGood);

                                user.setIsLook(student.getIsLook() + 1);
                                user.setLatestMsg(Message.SCORE_TYPE);
                                userService.update(student);

                                Message message = new Message();
                                message.setStatus(1);
                                message.setReceiveName(student.getNick());
                                message.setSendName("admin");
                                message.setSendId(0L);
                                message.setContent("");
                                message.setReceiveId(studentId);
                                message.setUnread(1);
                                message.setType("score");


                                Long mid = messageService.insert(message);

                                message = this.messageService.getObjectById(mid);
                                String content;
                                content = "<span  class=\"font-16px system-alert-outline \">您得到了积分奖励，" +
                                        "<a   data-mid=22362 ng-click=\"sendAlertMsg(li.id)\" class=\"font-orange\" target=\"_blank\" href=\"" +
                                        "/school/" + studentId + "/score///0\" target=\"_blank\">点击查看</a></span>";
                                adminSend(user.getMobile(), content);
                                message.setContent(content);
                                messageService.update(message);
                                break;
                        }
                        log.info("  student studentScore = " + studentScore);
                        student.setScore(studentScore);
                        userService.update(student);
                    }

                    article.setEvaluationUid(uid);
                    article.setEvaluationAt(System.currentTimeMillis());
                    articleService.update(article);
                } else {
                    model.addAttribute("code", -17000);
                    return "/common/success";

                }
            } else {
                model.addAttribute("code", -1111);
                return "/common/success";
            }

            //保存评论
            if (StringUtil.isNotEmpty(comment)) {
                Long commentId = commentDaily(article, user, comment, atUid);
                log.info(" comment id = " + commentId);
            }

        } else {
            model.addAttribute("code", -1111);
            return "/common/success";
        }
        model.addAttribute("code", 0);
        return "/common/success";
    }


    /**
     * @param
     * @return
     */

    // 25.删除日报
    @RequestMapping(value = "/a/u/daily/{did}", method = RequestMethod.DELETE)
    public String deleteDaily(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model, @PathVariable Long did)
            throws Exception {

        log.info("============================================");
        log.info("delete daily : did is " + did);

        try {
            Article article = articleService.getObjectById(did);
            if (article == null) {
                model.addAttribute("code", -5000);
                log.info("no this article");
                return "/common/success";
            }

            User user = (User) request.getAttribute("user");
            Long uid = user.getId();
            log.info("uid is :" + uid + "article is :" + article);

            if (!uid.equals(article.getUid())) {
                model.addAttribute("code", -5001);
                log.info("user is not write the classes");
                return "/common/success";
            }

            articleService.delete(did);

            // 更新最后最后日报
            Long lastDid = null;
            List<Long> articleIds = articleService.getArticleIdByUidAndCid(uid,
                    article.getCid(), 0, 1);
            if (articleIds != null && articleIds.size() > 0) {
                lastDid = articleService.getArticleIdByUidAndCid(uid,
                        article.getCid(), 0, 1).get(0);
            }
            Long relationID = userClassRelationService
                    .getUserClassRelationIdByCidAndUid(article.getCid(), uid);
            UserClassRelation relation = userClassRelationService
                    .getObjectById(relationID);
            relation.setLastDaily(lastDid);
            userClassRelationService.update(relation);

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("delete daily error,did is " + did);
            model.addAttribute("code", -100000);
        }

        return "/common/success";
    }


    /**
     * 查找评论
     *
     * @param request
     * @param response
     * @param model
     * @param did
     * @param startAt
     * @param endAt
     * @param page
     * @param size
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/comment/search/query", method = RequestMethod.GET)
    public String search(HttpServletRequest request,
                         HttpServletResponse response, ModelMap model, Long did, Long startAt, Long endAt, Integer page,
                         Integer size) throws Exception {

        log.info("============================================");
        log.info("get comment info of daily:  " + did + " startAt: " + startAt + " endAt: " + endAt + " page: " + page + " size: " + size);

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        int end = start + size + 1;
        Set<Long> uids = new HashSet();

        Integer total = 0;
        boolean next = false;
        try {
            List<Comment> comments = new ArrayList();
            Map<String, Object> param = DynamicUtil.getCommentListParam(
                    did, startAt, endAt, false);
            List<Long> commentIDS = this.commentService
                    .getIdsByDynamicCondition(Comment.class, param,
                            start, end);

            Map<String, Object> countParam = DynamicUtil.getCommentListParam(
                    did, startAt, endAt, true);
            List<Long> totals = this.commentService
                    .getIdsByDynamicCondition(Comment.class, countParam,
                            0, Integer.MAX_VALUE);
            total = totals.get(0).intValue();
            log.info(" did: " + did + " get comment is " + commentIDS);
            if (CollectionUtils.isEmpty(commentIDS)) {

            } else {
                comments = this.commentService.getObjectsByIds(commentIDS);
                if (comments.size() > size) {
                    comments = comments.subList(0, size);
                    next = true;

                } else {

                }
                for (Comment comment : comments) {
                    uids.add(comment.getUid());
                }

                log.info(" did: " + did + " get uids is " + uids);
            }


            List<User> users = new ArrayList();
            if (CollectionUtils.isEmpty(uids)) {

            } else {
                users = this.userService.getObjectsByIds(new ArrayList(uids));
                DynamicUtil.checkUserGraduateStatus(users);
                log.info(" get user is " + uids);
            }

            model.addAttribute("code", 0);
            model.addAttribute("comments", comments);
            model.addAttribute("users", users);

            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("next", next);
            model.addAttribute("total", total);


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t);
            log.error(t.getMessage());
            log.error("get comment error,did is " + did);
            model.addAttribute("code", -100000);
        }

        return "/common-skill-service/comment/json/commentListJson";
    }


    /**
     * @param
     * @return
     */

    // 26.评论日报
    @RequestMapping(value = "/a/u/comment/{did}", method = RequestMethod.POST)
    public String addComment(HttpServletRequest request,
                             HttpServletResponse response, ModelMap model,
                             @PathVariable Long did, String comment, Long atUid)
            throws Exception {

        log.info("============================================");
        log.info("update daily : did is " + did + " comment is " + comment);

        if (StringUtil.isEmpty(comment)) {
            model.addAttribute("code", -17009);
            log.info("param is null");
            return "/common/success";
        }


        try {
            Article daily = articleService.getObjectById(did);

            Long cid = daily.getCid();
            Classes classes = classesService.getObjectById(cid);
            Occupation occupation = occupationService.getObjectById(classes
                    .getOid());

            if (daily == null) {
                model.addAttribute("code", -5000);
                log.info("no this daily");
                return "/common/success";
            }
            String type = daily.getType();

            if (type.equals("daily")) {
            } else {
                model.addAttribute("code", -5000);
                log.info("no this daily");
                return "/common/success";
            }

            User user = (User) request.getAttribute("user");
            Long commentId = commentDaily(daily, user, comment, atUid);

            model.addAttribute("code", 0);
            model.addAttribute("commentId", commentId);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("add comment error,did is " + did + " comment is "
                    + comment);
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/comment/json/addComment";
    }


    //日报评论方法
    private Long commentDaily(Article daily, User user, String comment, Long atUid) throws Exception {
        Long cid = daily.getCid();
        Long uid = user.getId();
        Long did = daily.getId();
        Classes classes = classesService.getObjectById(cid);
        Occupation occupation = occupationService.getObjectById(classes
                .getOid());

        String type = daily.getType();

        Comment comment1 = new Comment();
        comment1.setUid(uid);
        comment1.setComment(comment);
        comment1.setDid(did);
        Long commentId = commentService.insert(comment1);


        Long now = System.currentTimeMillis();
        Long reply = daily.getReply();
        reply = reply + 1;
        log.info("addComment: [before:" + daily.getReply() + ",now:"
                + reply + "]");
        daily.setReply(reply);
        daily.setLastReply(now);
        articleService.update(daily);
        Article hh = articleService.getObjectById(daily.getId());
        log.info(" hh = " + hh.getReply());


        log.info(daily.getId() + " comment + 1 ,now is "
                + daily.getReply());

        // 他相当于日报的主人
        User receiver = userService.getObjectById(daily.getUid());

        Long relationId = userClassRelationService
                .getUserClassRelationIdByCidAndUid(cid, daily.getUid());
        UserClassRelation relation = userClassRelationService
                .getObjectById(relationId);

        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String time = df.format(new Date(daily.getDailyTime()));

        log.info("compare id" + daily.getUid() + "----" + uid);

        //判断内门及以上的用户所在分院
        String branch = null;
        //log.info("userBranch is"  + userBranch);
        if (DataUtils.isNotNullOrEmpty(user.getBranch())) {
            int userBranch = user.getBranch();
            if (userBranch == 10) {
                branch = "[北京分院|";
            } else if (userBranch == 20) {
                branch = "[武汉分院|";
            } else if (userBranch == 30) {
                branch = "[成都分院|";
            } else if (userBranch == 40) {
                branch = "[郑州分院|";
            } else if (userBranch == 50) {
                branch = "[深圳分院|";
            }
        }
        log.info("user branch is:" + branch);
        //无名、散修和外门展示学号，只有内门及内门以上的用户展示昵称
        String userNick = null;
        String userOccupationName = null;
        long userNumber = user.getStudyNumber();
        //职业名称
        //用户身份,如果是无名，没有职业
        int identity = user.getIdentity();
        log.info("identity is :" + identity);
        if (identity != User.IDENTIFY_10) {
            Long userOid = user.getOid();
            Occupation userOccupation = occupationService.getObjectById(userOid);
            userOccupationName = userOccupation.getName();
        }

        if (identity == User.IDENTIFY_10) {
            userNick = "[无名弟子] " + user.getNick();
        } else if (identity == User.IDENTIFY_20) {
            userNick = "[散修弟子] " + userOccupationName + "-" + String.valueOf(userNumber);
        } else if (identity == User.IDENTIFY_30) {
            userNick = "[外门弟子] " + userOccupationName + "-" + String.valueOf(userNumber);
        } else if (identity == User.IDENTIFY_40) {
            userNick = branch + "内门弟子] " + userOccupationName + "-" + user.getNick();
        } else if (identity == User.IDENTIFY_50) {
            userNick = branch + "首席弟子] " + userOccupationName + "-" + user.getNick();
        } else if (identity == User.IDENTIFY_60) {
            userNick = branch + "真传弟子] " + userOccupationName + "-" + user.getNick();
        } else if (identity == User.IDENTIFY_70) {
            userNick = branch + "修真长老] " + userOccupationName + "-" + user.getNick();
        }

        log.info("userNick is:" + userNick);
        // 根据日报id查出日报的作者

        if (daily.getUid() - uid == 0) { // 在自己日报下评论

            log.info("send to self==========");

            if (null != atUid) {

                if (uid - atUid == 0) { // 评论者评论自己,没有消息

                    log.info("update  self");

                } else { // 评论别人,那么@他
                    // @回复人
                    if (atUid != null) {
                        User atUser = userService.getObjectById(atUid);
                        if (atUser == null) {
                            log.info("atUser is null");
                        } else {
                            Long atMessageId = messageService
                                    .insert(new Message(atUid, atUser
                                            .getNick(), "daily", did));

                            String format = new SimpleDateFormat(
                                    "yyyy年MM月dd号").format(daily
                                    .getDailyTime());

                            String atContent = "<span class=\\\"font-16px system-alert-outline \\\"><a data-mid="
                                    + atMessageId
                                    + " ng-click=\\\"sendAlertMsg(li.id)\\\" target=\"_blank\" href=\\\"/school/"
                                    + user.getId()
                                    + "/class\\\"><span class=\\\"font-green\\\">"
                                    //userNick有限制，内门以上展示昵称；以下显示学号
                                    + userNick
                                    + "</span></a> 回复了你对 "
                                    + "<a data-mid="
                                    + atMessageId
                                    + " ng-click=\\\"sendAlertMsg(li.id)\\\" class=\\\"font-orange\\\" target=\"_blank\" href=\\\"/daily/"
                                    + daily.getId()
                                    + "\\\">《修真院弟子【"
                                    + uid
                                    + "】 | "
                                    + format + "的日报》</a>" + " 的评论</span>";
                            adminSend(atUser.getMobile(), atContent);

                            Message atMessage = messageService
                                    .getObjectById(atMessageId);

                            log.info("the atmessage=====" + atMessage);
                            if (null != atMessage) {
                                atMessage.setContent(atContent);
                                messageService.update(atMessage);
                            }

                            log.info("the user is 1" + atUid);

                            // 获取用户,更改用户查看消息列表的状态
                            atUser.setIsLook(atUser.getIsLook() + 1);
                            atUser.setLatestMsg(Message.DAILY_TYPE);
                            userService.update(atUser);
                            log.info("the user is 2" + atUid);

                        }

                    }

                }

            }

        } else { // 在别人的日报下

            log.info("send to other==========");

            if (null != atUid) { // 回复评论

                if (uid - atUid == 0) { // 如果是自己回复自己,不处理

                } else { // 回复别人的回复

                    // 如果回复的是日报主人,那么给@
                    if (receiver.getId() - atUid == 0) {

                    } else { // 如果不是日报主人,那么额外给日报主人一个通知
                        // 存入系统消息
                        Message message = new Message();
                        message.setStatus(1);
                        message.setReceiveName(receiver.getNick());
                        message.setSendName("admin");
                        message.setSendId(0L);
                        message.setContent("");
                        message.setReceiveId(receiver.getId());
                        message.setUnread(1);
                        message.setType(Message.DAILY_TYPE);
                        message.setRelationId(did);
                        Long mid = messageService.insert(message);

                        // 发送系统信息
                        String content = "<span class=\\\"font-16px system-alert-outline\\\"><span class=\\\"font-green\\\">您</span> <a data-mid="
                                + mid
                                + " ng-click=\\\"sendAlertMsg(li.id)\\\" class=\\\"font-orange\\\" target=\"_blank\" "
                                + "href=\\\"/daily/"
                                + daily.getId()
                                + "\\\">"
                                + time
                                + "的日报</a> 已被 "
                                + "<a data-mid="
                                + mid
                                + " ng-click=\\\"sendAlertMsg(li.id)\\\" target=\"_blank\"  href=\\\"/school/"
                                + user.getId()
                                + "/class\\\"><span class=\\\"font-green\\\">"
                                + userNick + "</span> </a>评论</span>";
                        log.info("user : " + receiver.getMobile()
                                + " send : " + content);
                        adminSend(receiver.getMobile(), content);
                        log.info("@@@@@@@@@" + receiver.getMobile()
                                + receiver.getId() + "hh" + atUid);

                        message = messageService.getObjectById(mid);
                        message.setContent(content);
                        log.info("message is " + message);

                        Boolean result = messageService.update(message);
                        log.info("result is " + result);

                        // 获取用户,更改用户查看消息列表的状态
                        receiver.setIsLook(receiver.getIsLook() + 1);
                        receiver.setLatestMsg(Message.DAILY_TYPE);
                        userService.update(receiver);

                    }

                    User atUser = userService.getObjectById(atUid);
                    if (atUser == null) {
                        log.info("atUser is null");
                    } else {
                        Long atMessageId = messageService
                                .insert(new Message(atUid,
                                        atUser.getNick(), "daily", did));

                        String format = new SimpleDateFormat("yyyy年MM月dd号")
                                .format(daily.getDailyTime());

                        String atContent = "<span class=\\\"font-16px system-alert-outline \\\"><a data-mid="
                                + atMessageId
                                + " ng-click=\\\"sendAlertMsg(li.id)\\\" target=\"_blank\"  href=\\\"/school/"
                                + user.getId()
                                + "/class\\\"><span class=\\\"font-green\\\">"
                                /*+ user.getNick()*/
                                + userNick
                                + "</span> </a>回复了你对 "
                                + "<a data-mid="
                                + atMessageId
                                + " ng-click=\\\"sendAlertMsg(li.id)\\\" class=\\\"font-orange\\\" target=\"_blank\" href=\\\"/daily/"
                                + daily.getId()
                                + "\\\">《修真院弟子【"
                                + uid
                                + "】 | "
                                + format + "的日报》</a>" + " 的评论</span>";
                        adminSend(atUser.getMobile(), atContent);
                        log.info("@@@@@@@@@" + atUser.getMobile());
                        Message atMessage = messageService
                                .getObjectById(atMessageId);
                        atMessage.setContent(atContent);
                        messageService.update(atMessage);

                        // 获取用户,更改用户查看消息列表的状态
                        atUser.setIsLook(atUser.getIsLook() + 1);
                        atUser.setLatestMsg(Message.DAILY_TYPE);
                        userService.update(atUser);

                    }

                }
            } else {
                // 存入系统消息
                Message message = new Message();
                message.setStatus(1);
                message.setReceiveName(receiver.getNick());
                message.setSendName("admin");
                message.setSendId(0L);
                message.setContent("");
                message.setReceiveId(receiver.getId());
                message.setUnread(1);
                message.setType(Message.DAILY_TYPE);
                message.setRelationId(did);
                Long mid = messageService.insert(message);

                // 发送系统信息
                String content = "<span class=\\\"font-16px system-alert-outline\\\"><span class=\\\"font-green\\\">您</span> <a data-mid="
                        + mid
                        + " ng-click=\\\"sendAlertMsg(li.id)\\\" class=\\\"font-orange\\\" target=\"_blank\" "
                        + "href=\\\"/daily/"
                        + daily.getId()
                        + "\\\">"
                        + time
                        + "的日报</a> 已被 "
                        + "<a data-mid="
                        + mid
                        + " ng-click=\\\"sendAlertMsg(li.id)\\\" target=\"_blank\" href=\\\"/school/"
                        + user.getId()
                        + "/class\\\"><span class=\\\"font-green\\\">"
                        + userNick + "</span> </a>评论</span>";
                log.info("user : " + receiver.getMobile() + " send : "
                        + content);
                adminSend(receiver.getMobile(), content);

                message = messageService.getObjectById(mid);
                message.setContent(content);
                log.info("message is " + message);

                Boolean result = messageService.update(message);
                log.info("result is " + result);

                // 获取用户,更改用户查看消息列表的状态
                receiver.setIsLook(receiver.getIsLook() + 1);
                receiver.setLatestMsg(Message.DAILY_TYPE);
                userService.update(receiver);

            }

        }
        return commentId;
    }


    /**
     * @param
     * @return
     */

    // 27.修改评论
    @RequestMapping(value = "/a/u/comment/{commentId}", method = RequestMethod.PUT)
    public String updateComment(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model,
                                @PathVariable Long commentId, String comment) throws Exception {

        log.info("============================================");
        log.info("update comment : commentId is " + commentId + " comment is "
                + comment);

        if (StringUtil.isEmpty(comment)) {
            model.addAttribute("code", -1000);
            log.info("param is null");
            return "/common/success";
        }

        try {
            Comment comment1 = commentService.getObjectById(commentId);

            if (comment1 == null) {
                model.addAttribute("code", -5002);
                log.info("no this comment");
                return "/common/success";
            }
            User user = (User) request.getAttribute("user");
            Long uid = user.getId();
            if (!(uid.equals(comment1.getUid()))) {
                model.addAttribute("code", -5003);
                log.info("this is not your comment");
                return "/common/success";
            }

            comment1.setComment(comment);
            commentService.update(comment1);

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("update comment error,commentId is " + commentId
                    + " comment is " + comment);
            model.addAttribute("code", -100000);
        }

        return "/common/success";
    }

    /**
     * @param
     * @return
     */

    // 16.删除评论
    @RequestMapping(value = "/a/u/comment/{commentId}", method = RequestMethod.DELETE)
    public String deleteComment(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model,
                                @PathVariable Long commentId) throws Exception {

        log.info("============================================");
        log.info("delete comment : commentId is " + commentId);

        try {
            Comment comment1 = commentService.getObjectById(commentId);

            if (comment1 == null) {
                model.addAttribute("code", -5002);
                log.info("no this comment");
                return "/common/success";
            }
            User user = (User) request.getAttribute("user");
            Long uid = user.getId();
            Long did = comment1.getDid();
            Long commentUser = comment1.getUid();
            Article daily = articleService.getObjectById(did);
            Long dailyUser = daily.getUid();

            if (!(uid.equals(commentUser) || uid.equals(dailyUser))) {
                model.addAttribute("code", -5004);
                log.info("you have no authority to delete the comment");
                return "/common/success";
            }

            commentService.delete(commentId);
            log.info("deleteComment: [before:" + daily.getReply() + ",now:"
                    + (daily.getReply() - 1) + "]");
            daily.setReply(daily.getReply() - 1);
            articleService.update(daily);

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("delete comment error,commentId is " + commentId);
            model.addAttribute("code", -100000);
        }

        return "/common/success";
    }

    public String adminSend(String mobile, String content)
            throws ServiceException, ServiceDaoException {

        log.info("hhhhhhhhh");
        String param = "{\n" + "    \"target_type\" : \"users\", \n"
                + "    \"target\" : [\"" + mobile + "\"],   \n"
                + "                                   \n"
                + "                                   \n" + "    \"msg\" : {\n"
                + "        \"type\" : \"txt\",\n" + "        \"msg\" : \""
                + content + "\" \n" + "        },\n"
                + "    \"from\" : \"admin\"\n" + "}";

        String result = HttpClientUtil.sendPostRequestByJavaSetHeader(
                "https://a1.easemob.com/jnshu4/jnshu4/messages", param,
                "application/json", "Bearer " + this.easemob_token);
        log.info(param);
        log.info(result);

        log.info("hhhhhhhhh" + result);
        return result;
    }

    /**
     * 此处直接取DB里的Token。获取Token由Python完成。之后由Crontab控制，每天更新一次。
     *
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @RequestMapping(value = "/a/easemob/token/refresh", method = RequestMethod.GET)
    public String initEaseMob(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model)
            throws ServiceException, ServiceDaoException {

        updateEasemobToken();
        model.addAttribute("code", 0);
        return "/common/success";

    }

    @PostConstruct
    private void updateEasemobToken() throws ServiceException,
            ServiceDaoException {
        Long id = this.constantService.getConstantIdByTypeAndName(
                Constant.Type_EaseMob, Constant.Name_Token);
        if (id == null) {
            log.error(" get easemob failure ");
        } else {
            Constant constant = this.constantService.getObjectById(id);
            this.easemob_token = constant.getValue();
            log.info(id + " get token is " + constant);

        }
    }


    public static void main(String[] args) {

        // adminSend("13522023418",
        // "<h6 class=\\\"font-12px system-alert-outline\\\"><a href=\\\"/skill/daily/detail///2/69/25/831//45/js/look/\\\">您2016-02-29的日报</a>已被<a href=\\\"/skill/Information/69\\\">高高</a>评论</h6>");
    }

}
