package com.ptteng.common.skill.controller;

import com.gemantic.common.util.MyListUtil;
import com.ptteng.common.skill.model.Card;
import com.ptteng.common.skill.model.Clog;
import com.ptteng.common.skill.model.Ctype;
import com.ptteng.common.skill.model.User;
import com.ptteng.common.skill.service.CardService;
import com.ptteng.common.skill.service.ClogService;
import com.ptteng.common.skill.service.CtypeService;
import com.ptteng.common.skill.service.UserService;
import com.ptteng.common.skill.util.DynamicUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * Clog  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class ClogController {
	private static final Log log = LogFactory.getLog(ClogController.class);

	@Autowired
	private ClogService clogService;

	@Autowired
	private CtypeService ctypeService;


	@Autowired
	private CardService cardService;


	@Autowired
	private UserService userService;



	/**
	 * 卡券列表
	 * @return
	 * @throws Exception
	 * */
	@RequestMapping(value = "/a/u/clog/search", method = RequestMethod.GET)
	public String getClogList(HttpServletRequest request,
							  HttpServletResponse response,
							  ModelMap model, Integer page, Integer size,
							  String code, Long tid,
							  Long createId, Long issueId, Long ownerId, Long cessionId, Long verificationId,
							  Integer[] type,
							  Long createStartAt, Long createEndAt,
							  Long assignStartAt, Long assignEndAt,
							  Long applyStartAt, Long applyEndAt,
							  Long cessionStartAt, Long cessionEndAt,
							  Long verificationStartAt, Long verificationEndAt) throws Exception {

		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {
			Map<String, Object> param = DynamicUtil.getClogsQueryListParam(code, tid,
					createId, issueId, ownerId, cessionId, verificationId,
					type,
					createStartAt, createEndAt,
					assignStartAt, assignEndAt,
					applyStartAt, applyEndAt,
					cessionStartAt, cessionEndAt,
					verificationStartAt, verificationEndAt, false);

			List<Long> ids = clogService.getIdsByDynamicCondition(Clog.class, param, start, size);
			log.info("clogs ids is " + ids);
			if (CollectionUtils.isEmpty(ids)) {
				model.addAttribute("code",0);
				model.addAttribute("page", page);
				model.addAttribute("size", size);
				model.addAttribute("total", 0);
				model.addAttribute("clogList", ids);
				return "/common-skill-service/clog/json/clogListJson";
			} else {
				log.info("get clog ids is: " + ids);
			}

			List<Clog> clogList = clogService.getObjectsByIds(ids);
			log.info("get clog list length is: " + clogList.size());


			// 获取type use receive的内容
			Set<Long> tids = new HashSet<>();
			Set<Long> cids = new HashSet<>();
			Set<Long> uids = new HashSet<>();

			for (Clog clogTemp : clogList) {
				tids.add(clogTemp.getTid());
				cids.add(clogTemp.getCid());
				uids.add(clogTemp.getUseId());
				uids.add(clogTemp.getReceiveId());
			}
			log.info("ctype's tids is: " + tids);
			log.info("ctype's cids is: " + cids);
			log.info("ctype's uids is: " + uids);

			List<Ctype> ctypeList = ctypeService.getObjectsByIds(new ArrayList<Long>(tids));
			List<Card> cardList = cardService.getObjectsByIds(new ArrayList<Long>(cids));
			List<User> userList = userService.getObjectsByIds(new ArrayList<Long>(uids));

			Map<Long, Ctype> id_ctype = MyListUtil.convert2Map(Ctype.class.getDeclaredField("id"), ctypeList);
			Map<Long, Card> id_card = MyListUtil.convert2Map(Card.class.getDeclaredField("id"), cardList);
			Map<Long, User> id_user = MyListUtil.convert2Map(User.class.getDeclaredField("id"), userList);




			// get total
			Map<String, Object> paramCount = DynamicUtil.getClogsQueryListParam(code, tid,
					createId, issueId, ownerId, cessionId, verificationId,
					type,
					createStartAt, createEndAt,
					assignStartAt, assignEndAt,
					applyStartAt, applyEndAt,
					cessionStartAt, cessionEndAt,
					verificationStartAt, verificationEndAt, true);


			List<Long> totalList = clogService.getIdsByDynamicCondition(Clog.class, paramCount, 0, Integer.MAX_VALUE);
			Integer total = totalList.get(0).intValue();
			log.info("get clog size is " + total);


			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);

			model.addAttribute("total", total);

			model.addAttribute("clogList", clogList);
			model.addAttribute("idCtype", id_ctype);
			model.addAttribute("idCard", id_card);
			model.addAttribute("idUser", id_user);


		}  catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get clog list error");
			model.addAttribute("code", -21010);
		}


		return "/common-skill-service/clog/json/clogListJson";
	}




}

