package com.ptteng.common.skill.controller;

import com.gemantic.common.util.MyTimeUtil;
import com.gemantic.common.util.PasswordUtils;


import com.ptteng.common.skill.model.*;
import com.ptteng.common.skill.model.Ctype;
import com.ptteng.common.skill.service.*;
import com.ptteng.common.skill.util.CheckDataUtil;
import com.ptteng.common.skill.util.ConvertUtil;
import com.ptteng.common.skill.util.DynamicUtil;
import com.qding.common.util.HttpClientUtil;
import com.qding.common.util.http.cookie.CookieUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * Card  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class CardController {
	private static final Log log = LogFactory.getLog(CardController.class);
	private static final Integer MAX_CESSIONS = 3;

	@Autowired
	private CardService cardService;

	@Autowired
	private CtypeService ctypeService;

	@Autowired
	private ClogService clogService;

	@Autowired
	private UserService userService;

	@Autowired
	private MessageService messageService;

	@Autowired
	private ClassesService classesService;


	/**
	 * 使用卡券
	 * @param
	 * @param id
	 * @return
	 * @throws Exception
	 * */
	@RequestMapping(value = "/a/u/card/{id}/apply", method = RequestMethod.PUT)
	public String updateCards(HttpServletRequest request,
							  HttpServletResponse response,
							  ModelMap model,
							  @PathVariable Long id) throws Exception {

		// 传参检查
		log.info("update card id is: " + id);
		if (id == null) {
			model.addAttribute("code",-23004);
			return "/data/json";
		}

		// 根据id获取原来的卡券数据
		Card card = null;
		try {
			card = cardService.getObjectById(id);
			log.info("get card is success, by id: " + id);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update card error,id is " + id );
			model.addAttribute("code", -23005);
		}

		// 卡券禁用，无法进行修改操作
		if (card.getCardValid() == Card.CARD_VALID_DISABLE) {
			model.addAttribute("code",-23008);
			return "/data/json";
		} else {
			log.info(id + " card is enabled!");
		}

		// 获得请求接口用户的id
		User user = (User) request.getAttribute("user");
		Long uid = user.getId();
		if (CheckDataUtil.notEqual(uid, card.getOwnerId())) {
			model.addAttribute("code",-23009);
			return "/data/json";
		}

		card.setApplyAt(System.currentTimeMillis());
		card.setStatus(Card.STATUS_VERIFICATING);
		card.setUpdateBy(uid);
		try {
			Boolean isUpdate = cardService.update(card);
			if (isUpdate) {
				log.info("assign card update success");
				Clog clog = ConvertUtil.card2Clog(Clog.TYPE_APPLY, card.getId(), card.getTid(), null, uid, null, null);
				Long clogId = clogService.insert(clog);
				log.info("insert clog, id is: " + clogId);
				sendMessage(uid,null, Card.STATUS_VERIFICATING, card.getCode(), card.getTid());
			} else {
				log.info("assign card update failed");
				model.addAttribute("code",-23007);
				return "/data/json";
			}
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update card error,id is " + id );
			model.addAttribute("code", -23007);
		}

		model.addAttribute("code", 0);

		return "/data/json";
	}


	/**
	 * 卡券转让
	 * @param mobile
	 * @param id
	 * @return
	 * @throws Exception
	 * */
	@RequestMapping(value = "/a/u/card/{id}/cession", method = RequestMethod.PUT)
	public String cessionCard(HttpServletRequest request,
							  HttpServletResponse response,
							  ModelMap model,
							  @PathVariable Long id, Long ownerId, String mobile, String pwd) throws Exception {

		// 传参检查
		if (id == null) {
			model.addAttribute("code",-23004);
			return "/data/json";
		}if (ownerId == null) {
			model.addAttribute("code",-23016);
			return "/data/json";
		} else if (mobile == null) {
			model.addAttribute("code",-23012);
			return "/data/json";
		}else if (pwd == null) {
			model.addAttribute("code",-23020);
			return "/data/json";
		} else {
			log.info("card id is: " + id + ". mobile is: " + mobile);
		}

		// 获取用户信息
		User user = (User) request.getAttribute("user");
		Long userId = user.getId();
		if (userId == null) {
			model.addAttribute("code", -2000);
			return "/common/success";
		}
		// 验证密码
		String userMobile = user.getMobile();
		if (userMobile.equals(mobile)){
			model.addAttribute("code",-23021);
			return "/common/success";
		}
		// 判断是否转让给本人
		String pass = PasswordUtils.encode(pwd);
		Boolean verify = user.getPwd().equals(pass);
		if (verify) {
			log.info(userId + " login ");
		} else {
			log.info(mobile + " wrong pwd " + pwd);
			model.addAttribute("code", -2006);
			return "/common/success";
		}

		// 根据id获取原来的卡券数据
		Card orignCard = new Card();
		try {
			orignCard = cardService.getObjectById(id);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update card error,id is " + id );
			model.addAttribute("code", -23005);
		}

		// 检测卡券是不是ownerId的
		if (CheckDataUtil.notEqual(orignCard.getOwnerId(), ownerId)) {
			model.addAttribute("code",-23009);
			return "/data/json";
		}

		// 检测卡券禁用，无法进行修改操作
		if (orignCard.getCardValid() == Card.CARD_VALID_DISABLE) {
			model.addAttribute("code",-23008);
			return "/data/json";
		} else {
			log.info(id + " card is enabled!");
		}

		// 检测ownerId今日转让是否超过3次
		Integer[] typeList = {Clog.TYPE_CESSION};
		Map<String, Object>  ownerClogParam = DynamicUtil.getClogsQueryListParam(null, null,null,null,
				ownerId,null,null,typeList,MyTimeUtil.getTodayZeroTimeMillions(),System.currentTimeMillis(),null,null,null,null,null,null,null,null, true);
		List<Long> cessionList = clogService.getIdsByDynamicCondition(Clog.class, ownerClogParam, 0, Integer.MAX_VALUE);
		Integer cessionTimes = cessionList.get(0).intValue();
		log.info("card session times is: " + cessionTimes);
		if (cessionTimes > MAX_CESSIONS) {
			model.addAttribute("code",-23017);
			return "/data/json";
		}

		//卡券接收人id
		Long otherUserId = userService.getUserIdByMobile(mobile);
		orignCard.setOwnerId(otherUserId);
		orignCard.setUpdateAt(System.currentTimeMillis());
		orignCard.setUpdateBy(userId);
		try {
			Boolean update = cardService.update(orignCard);
			if (update) {
				log.info("cession card update success.");
				Clog clog = ConvertUtil.card2Clog(Clog.TYPE_CESSION, orignCard.getId(), orignCard.getTid(), null, orignCard.getOwnerId(), otherUserId, null);
				Long clogId = clogService.insert(clog);
				log.info("insert clog, id is: " + clogId);
				// 消息通知 uid：消息接收人、oid
				log.info("================sendMessage to uid===========================" + otherUserId);
				sendMessage(userId, otherUserId, Clog.TYPE_CESSION, orignCard.getCode(), orignCard.getTid());
				log.info("================sendMessage to oid===========================" + userId);
				sendMessage(otherUserId, userId, 10, orignCard.getCode(), orignCard.getTid());
			} else {
				log.info("cession card update failed.");
				model.addAttribute("code",-23007);
				return "/data/json";
			}

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update card error,id is " + id );
			model.addAttribute("code", -23007);
		}

		model.addAttribute("code", 0);

		return "/data/json";
	}


	/**
	 * 卡券列表
	 * @return
	 * @throws Exception
	 * */
	@RequestMapping(value = "/a/u/card/search", method = RequestMethod.GET)
	public String getCardList(HttpServletRequest request,
							  HttpServletResponse response,
							  ModelMap model, Integer page, Integer size,
							  String code, Long tid,
							  Long assignId,
							  Long verificationId,
							  Long createId,
							  Integer status, Integer cardValid,
							  Long assignStartAt, Long assignEndAt, Integer sort,
							  Long applyStartAt, Long applyEndAt,
							  Long verificationStartAt, Long verificationEndAt) throws Exception {
		log.info("card list, code = " + code + ", tid = " + tid + ", assignId = " + assignId +
				", verificationId = " + verificationId + ", createId = " + createId + ", status = " + status +
				", cardValid = " + cardValid  +
				", assignStartAt = " + assignStartAt + ", assignEndAt = " + assignEndAt + ", applyStartAt = " + applyStartAt +
				", applyEndAt = " + applyEndAt + ", verificationStartAt = " + verificationStartAt + ", verificationEndAt = " + verificationEndAt);

		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		//获取用户信息
		User user = (User) request.getAttribute("user");
		Long ownerId = user.getId();
		log.info("============userID is============" + ownerId);
		try {
			Map<String, Object> param = DynamicUtil.getCardsQueryListParam(code, tid, ownerId,assignId,verificationId,createId, status, cardValid, assignStartAt,
					assignEndAt, applyStartAt, applyEndAt, sort, verificationStartAt, verificationEndAt, false);
			List<Long> ids = cardService.getIdsByDynamicCondition(Card.class, param, start, size);
			log.info("get card list ids is: " + ids);
			if (CollectionUtils.isEmpty(ids)) {
				model.addAttribute("code",0);
				model.addAttribute("page", page);
				model.addAttribute("size", size);
				model.addAttribute("total", 0);
				model.addAttribute("cardList", ids);
				return "/common-skill-service/card/json/cardListJson";
			} else {
				log.info("get card ids is: " + ids);
			}
			List<Card> cardList = cardService.getObjectsByIds(ids);
			log.info("get card list success, length is: " + cardList.size());

			// 获取type的内容
			List<Long> tids = new ArrayList<>();
			for (Card cardTemp : cardList) {
				tids.add(cardTemp.getTid());
			}
			List<Ctype> ctypeList = ctypeService.getObjectsByIds(tids);
			log.info("get card type list success, length is: " + tids);


			// get total
			Map<String, Object> paramCount = DynamicUtil.getCardsQueryListParam(code, tid, ownerId, assignId,verificationId,createId,status, cardValid, assignStartAt,
					assignEndAt, applyStartAt, applyEndAt, sort, verificationStartAt, verificationEndAt,true);
			List<Long> totalList = cardService.getIdsByDynamicCondition(Card.class, paramCount, 0, Integer.MAX_VALUE);
			Integer total = totalList.get(0).intValue();
			log.info("get card size is " + total);


			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);

			model.addAttribute("total", total);

			model.addAttribute("cardList", cardList);
			model.addAttribute("ctypeList", ctypeList);

		}  catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get card list error");
			model.addAttribute("code", -21007);
		}


		return "/common-skill-service/card/json/cardListJson";
	}



	/**
	 * 卡券转让前验证手机和次数
	 * @return
	 * @throws Exception
	 * */
	@RequestMapping(value = "/a/u/card/verify/{mobile}", method = RequestMethod.GET)
	public String verifyCard(HttpServletRequest request,
							 HttpServletResponse response,
							 ModelMap model,
							 @PathVariable String mobile) throws Exception {

		if (mobile == null) {
			model.addAttribute("code",-23012);
			return "/data/json";
		}

		// 根据mobile获取用户信息
		Long userId;
		User user;
		User owner;
		Classes classes;
		try {
			userId = userService.getUserIdByMobile(mobile);
			if (userId != null) {
				user = userService.getObjectById(userId);
				classes = classesService.getObjectById(user.getCid());
			} else {
				model.addAttribute("code",-23019);
				return "/data/json";
			}
			//设置卡券不能转让给自己
			owner =(User) request.getAttribute("user");
			if (user.getMobile().equals(owner.getMobile())){
				model.addAttribute("code",-23021);
				return "/data/json";
			}

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get user id error, mobile is " + mobile );
			model.addAttribute("code", -23015);
			return "/data/json";
		}

		
		// 检测ownerId今日转让是否超过3次
		Integer[] typeList = {Clog.TYPE_CESSION};
		Map<String, Object>  ownerClogParam = DynamicUtil.getClogsQueryListParam(null, null,null,null,
				userId,null,null,typeList,MyTimeUtil.getTodayZeroTimeMillions(),System.currentTimeMillis(),null,null,null,null,null,null,null,null, true);
		List<Long> cessionList = clogService.getIdsByDynamicCondition(Clog.class, ownerClogParam, 0, Integer.MAX_VALUE);
		Integer cessionTimes = cessionList.get(0).intValue();
		log.info("card session times is: " + cessionTimes);


		model.addAttribute("code", 0);
		model.addAttribute("user", user);
		model.addAttribute("classes", classes);
		model.addAttribute("cessionTimes", cessionTimes);


		return "/common-skill-service/card/json/cardVerifyJson";


	}


	// 消息通知 uid:用户id oid：当前用户id type=10为给接收人发信息
	private void sendMessage(Long uid, Long oid, Integer type, String code, Long tid) throws Exception {

		//参数校验
		log.info("send message args, uid: " + uid + ". oid: "+ oid +". type: " + type + ". code: " + code + ". tid: " + tid);
		// 获取用户信息 uid为消息接收人


		User user = userService.getObjectById(uid);



		String userName = user.getNick();

		log.info("user name is: " + userName);

		// 获取卡券类型信息
		Ctype ctype = ctypeService.getObjectById(tid);
		String title = ctype.getTitle();

		//存入系统消息
		Message message = new Message();
		message.setSendName("admin");
		message.setSendId(0L);
		message.setReceiveName(userName);
		message.setReceiveId(uid);
		message.setContent("");
		message.setStatus(1);
		message.setUnread(1);
		message.setType(Message.CARD_TYPE);
		Long mid = messageService.insert(message);

		//发送系统信息
		String content = "";
		if (type == Clog.TYPE_APPLY) {
			// 使用
			content = "<span  class=\\\"font-16px system-alert-outline\\\">" +
					"你申请使用了一张<a data-mid=" + mid + " ng-click=\"sendAlertMsg(li.id)\" class=\\\"font-orange\\\" target=\"_blank\" href=\\\"/school/"+uid+"/myCard/////\\\">"+ title + "[" + code + "]" +"</a>，请等待审核" +
					"</span>";

		} else if (oid!=null) {
            User other = userService.getObjectById(oid);
            String otherName = other.getNick();
		    if (type == Clog.TYPE_CESSION ) {
                // 转让：你给{被转让人名称}转让了一张{卡券类型名称}
                content = "<span  class=\\\"font-16px system-alert-outline\\\">" +
                        "<span class=\"font-green\">您给"+
                        "<a data-mid=" + mid + " target=\"_blank\" href=\"/school/" + oid +"/class\"><span class=\"font-orange\">" + otherName + "</span></a>" +
                        "转让了一张</span>" +
                        "<a data-mid=" + mid + " class=\\\"font-orange\\\" target=\"_blank\" href=\\\"/school/"+uid+"/myCard/////\\\">"+ title + "[" + code + "]" +"</a>" +
                        "</span>";
            }else {
                // {转让人名称}给你转让了一张{卡券类型名称}
                content = "<span  class=\\\"font-16px system-alert-outline\\\">" +
                        "<a data-mid=" + mid + " target=\"_blank\" href=\"/school/" + oid +"/class\"><span class=\"font-orange\">" + otherName + "</span></a>" +
                        "<span class=\\\"font-green\\\">给您转让了一张</span>" +
                        "<a data-mid=" + mid + " class=\\\"font-orange\\\" target=\"_blank\" href=\\\"/school/"+oid+"/myCard/////\\\">"+ title + "[" + code + "]" +"</a>" +
                        "</span>";
            }

		} else {
			log.info("message error");
			return;
		}

		adminSend(user.getMobile(), content);
		message = messageService.getObjectById(mid);
		message.setContent(content);
		log.info("message mid is " + mid);

		Boolean result = messageService.update(message);
		log.info("message update result is " + result);


		//更新用户信息
		user.setIsLook(user.getIsLook() + 1);
		user.setLatestMsg(Message.CARD_TYPE);
		userService.update(user);

	}
	private static String adminSend(String mobile, String content) {


		String param = "{\n" +
				"    \"target_type\" : \"users\", \n" +
				"    \"target\" : [\"" + mobile + "\"],   \n" +
				"                                   \n" +
				"                                   \n" +
				"    \"msg\" : {\n" +
				"        \"type\" : \"txt\",\n" +
				"        \"msg\" : \"" + content + "\" \n" +
				"        },\n" +
				"    \"from\" : \"admin\"\n" +
				"}";
		String result = HttpClientUtil.sendPostRequestByJavaSetHeader("https://a1.easemob.com/jnshu4/jnshu4/messages", param, "application/json", "Bearer YWMtwJlMnN7iEeW93dWWI_R-hgAAAVRiEFRny8NEKnIG6-Gu_yibQ4d46AkTlmM");


		return result;
	}
	
}

