package com.ptteng.common.skill.controller;

import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import java.text.SimpleDateFormat;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ptteng.common.skill.model.*;
import com.ptteng.common.skill.model.Message;
import com.ptteng.common.skill.service.ConstantService;
import com.ptteng.common.skill.service.OccupationService;
import com.ptteng.common.skill.util.DynamicUtil;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;


import com.ptteng.common.skill.service.MessageService;
import com.ptteng.common.skill.service.UserService;
import com.qding.common.util.http.cookie.CookieUtil;
import com.gemantic.common.util.StringUtil;
import org.apache.commons.lang3.ArrayUtils;



/**
 * OccupationTypeRelation  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class MessageController {
    private static final Log log = LogFactory.getLog(MessageController.class);

    @Autowired
    private MessageService messageService;

    @Autowired
    private CookieUtil cookieUtil;

    @Autowired
    private UserService userService;

    @Autowired
    private ConstantService constantService;

    @Autowired
    private OccupationService occupationService;



    /**
     * 根据类型查询消息
     * @param request
     * @param response
     * @param model
     * @param page
     * @param size
     * @param status
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/receive/message/{type}/search", method = RequestMethod.GET)
    public String getReceiveMessageByType(HttpServletRequest request,
                                    HttpServletResponse response, ModelMap model, Integer page,
                                    Integer size, Integer status,@PathVariable String type , Long pid ) throws Exception {


        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        int end = start + size - 1;

        log.info("receive message :  start = " + start + " , size=" + size + " , status = " + status+" type = "+type);

        try {
            User user = (User) request.getAttribute("user");
            Long uid = user.getId();
            Map<String, Object> params = DynamicUtil.getMessageListParam(status,type,uid,null,false);
            log.info(params +"===================================");
            List<Long> ids = messageService.getIdsByDynamicCondition(Message.class,params, start, size);
            List<Message> messages=new ArrayList<>();
            List<Long> uids = new ArrayList<>();

            if (ids.equals(null)) {
                model.addAttribute("code", -7000);
                log.info("the user message is null");
                return "/common/success";
            }
            List<Long> mids = messageService.getMessageIdsByReceiveIdAndUnreadAndStatusAndType(uid, 1, 1, "like", 0, Integer.MAX_VALUE);

            if (!(mids==null)){
                List<Message> messageLikes = messageService.getObjectsByIds(mids);
                for(Message message:messageLikes){
                    message.setUnread(0);
                    messageService.update(message);
                }
            }

            if (type.equals(Message.RECEIVE_TYPE)){
//                谁发送给我。
                List<Long> messageReceiveIdList= messageService.getMessageIdsByReceiveIdAndStatusAndTypePrivate(uid,start,size);
                List<Message> messagesReceiveList = messageService.getObjectsByIds(messageReceiveIdList);

//                增加未读数。
                for (Message item : messagesReceiveList) {
//       通过sql语句查询几条未读。 unread=1 /未读
                    uids.add(item.getSendId());
                    if(!(item.getSendId().equals(uid))){
                        Integer unreadCount = messageService.countMessagesBySendIdAndReceiveId(item.getSendId(),item.getReceiveId());
                        item.setunreadCount(unreadCount);
                    }
                }
                messages.addAll(messagesReceiveList);
//                uSer信息
                List<User> receiveUserMessages = this.userService.getObjectsByIds(uids);
                model.addAttribute("users",receiveUserMessages.size());

                log.info( "messages is" + messages );
                log.info( "receiveUserMessages is" + receiveUserMessages );

                log.info( "==================================++++++++============================" );

            }
            else if(type.equals(Message.SEND_TYPE)){
//                我联系的谁
                List<Long>  messagesSendIdList= messageService.getMessageIdsBySendIdAndStatusAndType(uid,start,size);
                List<Message> messagesSendList = messageService.getObjectsByIds(messagesSendIdList);

//                增加未读数字
                for (Message item : messagesSendList) {
                    uids.add(item.getReceiveId());
//       通过sql语句查询几条未读。 unread=1 /未读
//                    if(!(item.getReceiveId().equals(uid))){
//                        Integer unreadCount = messageService.countMessagesBySendIdAndReceiveId(item.getSendId(),item.getReceiveId());
//                        item.setunreadCount(unreadCount);
//                    }

                }
                messages.addAll(messagesSendList);

//       发送人的基本信息
                List<User> sendUserMessages = userService.getObjectsByIds(uids);
                model.addAttribute("users",sendUserMessages);

                log.info( "messages is" + sendUserMessages.size() );
                log.info( "==============================================================" );
            }
            else if(type.equals(Message.PRIVATE_TYPE) &&  DataUtils.isNotNullOrEmpty(pid)){
                    //pid有值 那么查找2人的详细记录。
                List<Long>  messagesReceiveAndSendIdsList = messageService.getMessageIdsByReceiveIdAndSendId(uid,pid,start,size);
                List<Message> messagesReceiveAndSendList = messageService.getObjectsByIds(messagesReceiveAndSendIdsList);
                 uids.add(pid);
                List<User> receiveUserMessages = this.userService.getObjectsByIds(uids);
//                log.info(receiveUserMessages +"12222222222222222222222222222222222");
                log.info(receiveUserMessages.size());
                messages.addAll(messagesReceiveAndSendList);
                model.addAttribute("users",receiveUserMessages);
                log.info("messages"+ messages);
            }
            else if (type.equals(Message.PRIVATE_TYPE) &&  DataUtils.isNullOrEmpty(pid)){
                model.addAttribute("code", -1000);
                log.info("the  pid is null");
                return "/common/success";
            }

            else {
                messages = messageService.getObjectsByIds(ids);
                log.info("messages is " + messages.size());
            }


            List<Long> messageIds = messageService.getIdsByDynamicCondition(Message.class, params, 0, Integer.MAX_VALUE);
            boolean next = false;
            if (messageIds.size() > end + 1) {
                next = true;
            }
            params = DynamicUtil.getMessageListParam(status, Message.DAILY_TYPE, uid,Message.Status_Unread, false);
             ids = messageService.getIdsByDynamicCondition(Message.class, params, 0, Integer.MAX_VALUE);
            int daily = ids.size();
            params = DynamicUtil.getMessageListParam(status, Message.CLASS_TYPE, uid,Message.Status_Unread, false);
            ids = messageService.getIdsByDynamicCondition(Message.class, params, 0, Integer.MAX_VALUE);
            int classes = ids.size();
            params = DynamicUtil.getMessageListParam(status, Message.TASK_TYPE, uid, Message.Status_Unread,false);
            ids = messageService.getIdsByDynamicCondition(Message.class, params, 0, Integer.MAX_VALUE);
            int task = ids.size();
            params = DynamicUtil.getMessageListParam(status, Message.SCORE_TYPE, uid, Message.Status_Unread,false);
            ids = messageService.getIdsByDynamicCondition(Message.class, params, 0, Integer.MAX_VALUE);
            int score = ids.size();
            params = DynamicUtil.getMessageListParam(status, Message.PRIVATE_TYPE, uid, Message.Status_Unread,false);
            ids = messageService.getIdsByDynamicCondition(Message.class, params, 0, Integer.MAX_VALUE);
            int privateNum = ids.size();
            model.addAttribute("daily", daily);
            model.addAttribute("classes", classes);
            model.addAttribute("task", task);
            model.addAttribute("private", privateNum);
            model.addAttribute("score", score);
            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("next", next);
            model.addAttribute("total", messageIds.size());
            model.addAttribute("messages", messages);



        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get occupationTypeRelation list error,page is  " + start + " , size "
                    + size);
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/message/json/messageListJson";
    }




    /**
     * 查询所有消息--保留接口，用于APP
     * @param request
     * @param response
     * @param model
     * @param page
     * @param size
     * @param status
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/receive/message/list", method = RequestMethod.GET)
    public String getReceiveMessage(HttpServletRequest request,
                                    HttpServletResponse response, ModelMap model, Integer page,
                                    Integer size, Integer status) throws Exception {


        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        int end = start + size - 1;

        log.info("receive message :  start = " + start + " , size=" + size + " , status = " + status);

        try {
            User user = (User) request.getAttribute("user");
            Long uid = user.getId();
            List<Long> ids = messageService.getMessageIdsByReceiveIdAndStatus(uid, status, start, size);

            if (ids.equals(null)) {
                model.addAttribute("code", -7000);
                log.info("the user message is null");
                return "/common/success";
            }

            List<Long> mids = messageService.getMessageIdsByReceiveIdAndUnreadAndStatusAndType(uid, 1, 1, "like", 0, Integer.MAX_VALUE);

            if(!(mids==null)){
                List<Message> messageLikes = messageService.getObjectsByIds(mids);

                for(Message message:messageLikes){
                    message.setUnread(0);
                    messageService.update(message);
                }
            }

            List<Message> messages = messageService.getObjectsByIds(ids);
            log.info("messages is " + messages.size());
//            log.info("messagersss is " + messages);

            List<Long> messageIds = messageService.getMessageIdsByReceiveIdAndStatus(uid, 1, 0, Integer.MAX_VALUE);
            boolean next = false;
            if (messageIds.size() > end + 1) {
                next = true;
            }

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("next", next);
            model.addAttribute("total", messageIds.size());
            model.addAttribute("messages", messages);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get occupationTypeRelation list error,page is  " + start + " , size "
                    + size);
            // for test
            model.addAttribute("code", -1);
             return "/common/success";
        }

        return "/common-skill-service/message/json/messageListJson";
    }
//    发送私信
    /////////////////////////////////////

      @RequestMapping(value = "/a/u/message/private/", method = RequestMethod.POST)
         public String insertPrivateMessage(HttpServletRequest request,
                                          HttpServletResponse response, ModelMap model, Integer page,
                                          Integer size, Long uid, String content) throws Exception {

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("receive message :  start = " + start + " , size=" + size + "  + uid = "+uid + "content = "  + content );
        if(StringUtil.isEmpty(content) ){
            model.addAttribute("code",-7004);
            log.info("content is Null");
            return "/common/success";
        }
        if(uid == null){
            model.addAttribute("code",-1000);
            log.info("uid is Null");
            return "/common/success";
        }
        try {
            int privateMessageCount=0;
        //  获取登录用户的数据
            User user = (User) request.getAttribute("user");
            Long sendUid = user.getId();
            User receiveUser= userService.getObjectById(uid);
//            判断用户的身份信息
            String branch = null;
//            如果是线下地址是会有branch属性的。
            if (DataUtils.isNotNullOrEmpty(user.getBranch())){
                int userBranch = user.getBranch();
                if(userBranch == 10){
                    branch = "[北京分院]";
                }else if(userBranch == 20) {
                    branch = "[武汉分院]";
                }else if(userBranch == 30){
                    branch = "[成都分院]";
                }else if(userBranch == 40){
                    branch = "[郑州分院]";
                }else if(userBranch == 50){
                    branch = "[深圳分院]";
                }
            }
            //无名、散修和外门展示学号，只有内门及内门以上的用户展示昵称
            String userNick = null;
            String userOccupationName = null;
//            学号
            long userNumber = user.getStudyNumber();
//            用户
            Long userOid = user.getOid();

            if(userOid != -1){
                 userOccupationName = occupationService.getObjectById(userOid).getName();
            }
//            获取当前用户的职业信息

//            当前职业的职业名

            //用户身份
            int identity = user.getIdentity();

            if(identity == User.IDENTIFY_10){
                userNick = "[无名弟子] " +user.getNick();
            }else if (identity == User.IDENTIFY_20 ){
                userNick = "[散修弟子] " +  userOccupationName + "-" + String.valueOf(userNumber);
            }else if (identity == User.IDENTIFY_30){
                userNick = "[外门弟子] " + userOccupationName + "-" + String.valueOf(userNumber);
            }else if (identity == User.IDENTIFY_40){
                userNick = branch + "内门弟子] " + userOccupationName + "-" + user.getNick();
            }else if (identity == User.IDENTIFY_50){
                userNick = branch + "首席弟子] " + userOccupationName + "-" + user.getNick();
            }else if (identity == User.IDENTIFY_60){
                userNick = branch + "真传弟子] " + userOccupationName + "-" + user.getNick();
            }else if (identity == User.IDENTIFY_70){
                userNick = branch + "修真长老] " + userOccupationName + "-" + user.getNick();
            }
            log.info(userNick);
            String notifyMessage=  "<span class=\"font-16px  system-alert-outline  ng-scope\"><a data-mid=\"67054\" ng-click=\"sendAlertMsg(li.id)\" target=\"_blank\" href=\"/school/"+user.getId()+"/class\"><span class=\"font-green\">"+userNick +"</span> </a> 给你发送了一条" +"<a href=\"\"><span class='font-green'>私信</span></a></span>";

            Long timeStr= new Date().getTime() ;
            SimpleDateFormat timeType=new SimpleDateFormat("yyyy-MM-dd ");
            String nowTime = timeType.format(new Date(Long.parseLong(String.valueOf(timeStr))));
            Long minTodayUnix = timeType.parse(nowTime).getTime();
            List<Long> messagesTodayUnixList= messageService.getMessagesTodayUnixList (uid ,minTodayUnix,start,size);
            int TodayNum = messagesTodayUnixList.size();
            List<Long> users = this.constantService.getConstantIdsByType(Message.Type_privateCount,0, Integer.MAX_VALUE);
            List<Constant> constantsUsersList = constantService.getObjectsByIds(users);
            for (Constant constant : constantsUsersList) {

                if (Message.Name_privateMessageCount.equals(constant.getName())) {
                    privateMessageCount = Integer.valueOf(constant.getValue());
                }
            }
//                 获取当前时间戳。判断当天是否发送超过500条。
//                 从常量表里面 设定每天发送限制500条，然后进行判断；
             if(TodayNum<=privateMessageCount){
//                 生成一条系统通知 type 为notify

                 Message notifyItem = new Message();
                 notifyItem.setSendId(sendUid);
                 notifyItem.setReceiveId(receiveUser.getId());
                 notifyItem.setSendName(user.getNick());
                 notifyItem.setReceiveName(receiveUser.getNick());
                 notifyItem.setContent(notifyMessage);
                 notifyItem.setStatus(Message.STATUS_UNDELETE);
                 notifyItem.setUnread(Message.Status_Unread);
                 notifyItem.setType(Message.NOTIFY_TYPE);
                 notifyItem.setReceiveId(uid);
                 messageService.insert(notifyItem);

                 Message item = new Message();
                 item.setSendId(sendUid);
                 item.setReceiveId(receiveUser.getId());
                 item.setSendName(user.getNick());
                 item.setReceiveName(receiveUser.getNick());
                 item.setContent(content);
                 item.setStatus(Message.STATUS_UNDELETE);
                 item.setUnread(Message.Status_Unread);
                 item.setType(Message.PRIVATE_TYPE);
                 item.setReceiveId(uid);
                 messageService.insert(item);
                 model.addAttribute("code",   0);
             }else{
                 model.addAttribute("code", -7005);
                 log.info("the user messageNum is max");
                 return "/common/success";
             }




        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get occupationTypeRelation list error,page is  " + start + " , size "
                    + size);
            model.addAttribute("code", -1);
        }


        return "/common/success";
    }

    /////////////////////////////

    @RequestMapping(value = "/a/u/message/{mid}", method = RequestMethod.DELETE)
    public String deleteMessage(HttpServletRequest request,
                                                HttpServletResponse response, ModelMap model, @PathVariable Long mid)
            throws Exception {

        log.info("delete message : mid= " + mid);
        try {
            User user = (User) request.getAttribute("user");
            Long uid = user.getId();
            Message message = messageService.getObjectById(mid);

            if(message.equals(null)){
                model.addAttribute("code", -7000);
                log.info("no this user");
                return "/common/success";
            }

            if (message.getReceiveId().equals(uid)) {

                if (Message.Status_Unread.equals(message.getUnread())) {
                    //未读消息被删除，用户未读消息数减1
                    log.info(message.getId() + " is unread " + message.getUnread() + " ready to update user unread message count ");
                    Integer unreadNum = user.getIsLook() - 1;
                    user.setIsLook(unreadNum);
                    boolean result = this.userService.update(user);
                    log.info(message.getId() + " is unread " + message.getUnread() + "  update user " + user.getId() + " unread message count result is  " + result);

                }

                message.setStatus(0);
                message.setUnread(0);
                messageService.update(message);
                model.addAttribute("code", 0);

            } else {
                model.addAttribute("code", -7001);
                log.info("not your message");
                return "/common/success";
            }



        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete message error,mid is  " + mid);
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }



//    删除私信消息列表


        @RequestMapping(value = "/a/u/message/private/{uid}", method = RequestMethod.DELETE)
    public String deleteMessageByUid(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model, @PathVariable Long uid)
            throws Exception {

        log.info("delete message : uid= " + uid);
        try {
            User user = (User) request.getAttribute("user");
            Long userId = user.getId();
            Message message = messageService.getObjectById(uid);
            if (message.equals(null)) {
                model.addAttribute("code", -7000);
                log.info("no this user");
                return "/common/success";
            }



//            Sql语句查询所有聊天详情
            List<Long> messageIdsByReceiveIdAndSendIdList = messageService.getMessageIdsByReceiveIdAndSendId(userId, uid, 0, Integer.MAX_VALUE);
            List<Message> messageListByReceiveIdAndSendIdList = messageService.getObjectsByIds(messageIdsByReceiveIdAndSendIdList);
            log.info("messageListByReceiveIdAndSendIdList size :" + messageListByReceiveIdAndSendIdList.size());
            for (Message item : messageListByReceiveIdAndSendIdList) {
                log.info(item);
                if(Message.Status_Unread.equals(item.getUnread())){
                    item.setUnread(0);
                    Integer unreadNum = user.getIsLook() - 1;
                    user.setIsLook(unreadNum);
                }

//                    item.setStatus(1);
                if (!(item.getStatus().equals(4))) {
                    if (item.getSendId().equals(userId) && !(item.getStatus().equals(3))) {
                        item.setStatus(2);
                    } else if (item.getSendId().equals(userId) && item.getStatus().equals(3)) {
                        item.setStatus(4);
                    }
//                    当登录用户作为收件人删除信息
                    if (item.getReceiveId().equals(userId) && !(item.getStatus().equals(2))) {
                        item.setStatus(3);
                    } else if (item.getReceiveId().equals(userId) && item.getStatus().equals(2)) {
                        item.setStatus(4);
                    }
                    log.info(item);
                }
            }
                messageService.updateList(messageListByReceiveIdAndSendIdList);

                model.addAttribute("code", 0);

            } catch(Throwable t){
                t.printStackTrace();
                log.error(t.getMessage());
                log.error("delete message error,mid is  " + uid);
                model.addAttribute("code", -1);
            }

            return "/common/success";
        }


//        删除单个私信消息

    @RequestMapping(value = "/a/u/message/private/mid/{mid}", method = RequestMethod.DELETE)
    public String deleteMessageByMid(HttpServletRequest request,
                                     HttpServletResponse response, ModelMap model,  @PathVariable Long mid)
            throws Exception {

        try {
            User user = (User) request.getAttribute("user");
            Long userId = user.getId();
            log.info("mid is " +mid);
            log.info("userId is " +userId);
            if(null == mid){
                model.addAttribute("code", -1);
                return "/common/success";
            }
            Message  message = messageService.getObjectById(mid);

            if (!(message.getStatus().equals(4))) {
                if (message.getSendId().equals(userId) && !(message.getStatus().equals(3))) {
                    message.setStatus(2);
                } else if (message.getSendId().equals(userId) && message.getStatus().equals(3)) {
                    message.setStatus(4);
                }
//                    当登录用户作为收件人删除信息
                if (message.getReceiveId().equals(userId) && !(message.getStatus().equals(2))) {
                    message.setStatus(3);
                } else if (message.getReceiveId().equals(userId) && message.getStatus().equals(2)) {
                    message.setStatus(4);
                }

            }

            messageService.update(message);

            model.addAttribute("code", 0);

        } catch(Throwable t){
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete message error,mid is  " + mid);
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }



    //消息已读

        @RequestMapping(value = "/a/u/read/message/{mid}", method = RequestMethod.PUT)
        public String readMessage (HttpServletRequest request,
                HttpServletResponse response, ModelMap model, @PathVariable Long mid)
            throws Exception {

            log.info("read message : mid= " + mid);
            try {
                User user = (User) request.getAttribute("user");
                Long uid = user.getId();
                Message message = messageService.getObjectById(mid);

                if (message.equals(null)) {
                    model.addAttribute("code", -7002);
                    log.info("no this message");
                    return "/common/success";
                }

                if (!(message.getReceiveId().equals(uid))) {
                    model.addAttribute("code", -7001);
                    log.info("not your message");
                    return "/common/success";
                }

                if (message.getUnread().equals(0)) {
                    model.addAttribute("code", -7003);
                    log.info("already read the message");
                    return "/common/success";
                }

                message.setUnread(0);
                messageService.update(message);

                Integer unreadNum = user.getIsLook();
                user.setIsLook(unreadNum - 1);
                userService.update(user);

                model.addAttribute("code", 0);

            } catch (Throwable t) {
                t.printStackTrace();
                log.error(t.getMessage());
                log.error("read message error,mid is  " + mid);
                model.addAttribute("code", -1);
            }

            return "/common/success";
        }


    //全部已读

    @RequestMapping(value = "/a/u/read/message/all", method = RequestMethod.PUT)
    public String allReadMessage(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model)
            throws Exception {

        log.info("read message all");
        try {
            User user = (User) request.getAttribute("user");
            Long uid = user.getId();
            List<Long> messageIds = messageService.getMessageIdsByReceiveIdAndUnreadAndStatus(uid, 1, 1, 0, Integer.MAX_VALUE);
            List<Message> messages = messageService.getObjectsByIds(messageIds);

            for(Message message :messages){
                message.setUnread(0);
                messageService.update(message);
            }

            user.setIsLook(0);
            userService.update(user);

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("read message all error");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

}

