package com.ptteng.common.skill.controller;

import com.gemantic.common.util.MyTimeUtil;
import com.gemantic.common.util.PasswordUtils;
import com.ptteng.common.skill.interceptor.CookieConstant;
import com.ptteng.common.skill.model.*;
import com.ptteng.common.skill.service.*;
import com.ptteng.common.skill.util.CheckDataUtil;
import com.ptteng.common.skill.util.DynamicUtil;
import com.qding.common.util.HttpClientUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import com.qding.common.util.http.cookie.IdentityUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * Card  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class CardController {
	private static final Log log = LogFactory.getLog(CardController.class);
	private static final Integer MAX_CESSIONS = 3;

	@Autowired
	private CardService cardService;

	@Autowired
	private CtypeService ctypeService;

	@Autowired
	private ClogService clogService;

	@Autowired
	private UserService userService;

	@Autowired
	private MessageService messageService;

	@Autowired
	private ClassesService classesService;

	@Autowired
	private CookieUtil cookieUtil;

	/**
	 * 使用卡券状态
	 * @param
	 * @param id
	 * @return
	 * @throws Exception
	 * */
	@RequestMapping(value = "/a/u/card/{id}", method = RequestMethod.PUT)
	public String updateCards(HttpServletRequest request,
							  HttpServletResponse response,
							  ModelMap model,
							  @PathVariable Long id, Long ownerId, Integer status) throws Exception {

		// 传参检查
		if (id == null) {
			model.addAttribute("code",-23004);
			return "/data/json";
		} else {
			log.info("update card id is: " + id);
		}

		// 根据id获取原来的卡券数据
		Card orignCard = new Card();
		try {
			orignCard = cardService.getObjectById(id);
			log.info("orignCard is: " + orignCard);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update card error,id is " + id );
			model.addAttribute("code", -23005);
		}

		// 卡券禁用，无法进行修改操作
		if (orignCard.getCStatus() == Card.Cstatus_Disable) {
			model.addAttribute("code",-23008);
			return "/data/json";
		} else {
			log.info(id + " card is enabled!");
		}


		if (orignCard.getStatus() == Card.Status_Issued && status == Card.Status_Verificating) {
			// 使用2->3
			if (CheckDataUtil.notEqual(ownerId, orignCard.getOwnerId())) {
				model.addAttribute("code",-23009);
				return "/data/json";
			} else {
				orignCard.setApplyAt(System.currentTimeMillis());
				orignCard.setStatus(status);

				saveClog(Card.Status_Verificating, orignCard.getId(), orignCard.getTid(), ownerId, null);
			}
		}else {
			model.addAttribute("code",-23006);
			return "/data/json";
		}

		orignCard.setUpdateAt(System.currentTimeMillis());
		orignCard.setUpdateBy(ownerId);

		try {
			cardService.update(orignCard);
			log.info("update card is: " + orignCard);

			// 消息通知
			sendMessage(ownerId, status, orignCard.getCid(), orignCard.getTid());
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update card error,id is " + id );
			model.addAttribute("code", -23007);
		}

		model.addAttribute("code", 0);

		return "/data/json";
	}


	/**
	 * 卡券转让
	 * @param mobile
	 * @param id
	 * @return
	 * @throws Exception
	 * */
	@RequestMapping(value = "/a/u/card/{id}/cession", method = RequestMethod.PUT)
	public String cessionCard(HttpServletRequest request,
							  HttpServletResponse response,
							  ModelMap model,
							  @PathVariable Long id, Long ownerId, String mobile, String pwd) throws Exception {

		// 传参检查
		if (id == null) {
			model.addAttribute("code",-23004);
			return "/data/json";
		}if (ownerId == null) {
			model.addAttribute("code",-23016);
			return "/data/json";
		} else if (mobile == null) {
			model.addAttribute("code",-23012);
			return "/data/json";
		}else if (pwd == null) {
			model.addAttribute("code",-23020);
			return "/data/json";
		} else {
			log.info("card id is: " + id + ". mobile is: " + mobile);
		}

		// 验证密码
		Long userId = userService.getUserIdByMobile(mobile);
		if (userId == null) {
			model.addAttribute("code", -2000);
			return "/common/success";
		}
		User user = this.userService.getObjectById(userId);
		String pass = PasswordUtils.encode(pwd);
		Boolean verify = user.getPwd().equals(pass);
		if (verify) {
			log.info(userId + " login ");
		} else {
			log.info(mobile + " wrong pwd " + pwd);
			model.addAttribute("code", -2006);
			return "/common/success";

		}

		// 根据id获取原来的卡券数据
		Card orignCard = new Card();
		try {
			orignCard = cardService.getObjectById(id);
			log.info("orignCard is: " + orignCard);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update card error,id is " + id );
			model.addAttribute("code", -23005);
		}

		// 检测卡券是不是ownerId的
		if (CheckDataUtil.notEqual(orignCard.getOwnerId(), ownerId)) {
			model.addAttribute("code",-23009);
			return "/data/json";
		}

		// 检测ownerId今日转让是否超过3次
		Integer[] typeList = {Card.Status_Cession};
		Map<String, Object>  ownerClogParam = DynamicUtil.getClogsQueryListParam(null, null,null,null,
				ownerId,null,null,typeList,MyTimeUtil.getTodayZeroTimeMillions(),System.currentTimeMillis(),null,null,null,null,null,null,null,null, true);
		List<Long> cessionList = clogService.getIdsByDynamicCondition(Clog.class, ownerClogParam, 0, Integer.MAX_VALUE);
		Integer cessionTimes = cessionList.get(0).intValue();
		log.info("card session times is: " + cessionTimes);
		if (cessionTimes > MAX_CESSIONS) {
			model.addAttribute("code",-23017);
			return "/data/json";
		}


		// 转让状态判断
		if (orignCard.getStatus() != Card.Status_Issued || orignCard.getCStatus() == Card.Cstatus_Disable) {
			model.addAttribute("code",-23013);
			return "/data/json";
		}





		try {
			saveClog(Card.Status_Cession, orignCard.getId(), orignCard.getTid(), orignCard.getOwnerId(), userId);
			orignCard.setOwnerId(userId);
			orignCard.setUpdateAt(System.currentTimeMillis());
			orignCard.setUpdateBy(userId);
			cardService.update(orignCard);
			log.info("update card is: " + orignCard);

			// 消息通知
			sendMessage(userId, Card.Status_Cession, orignCard.getCid(), orignCard.getTid());
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update card error,id is " + id );
			model.addAttribute("code", -23007);
		}

		model.addAttribute("code", 0);

		return "/data/json";
	}


	/**
	 * 卡券列表
	 * @return
	 * @throws Exception
	 * */
	@RequestMapping(value = "/a/u/card/search", method = RequestMethod.GET)
	public String getCardList(HttpServletRequest request,
							  HttpServletResponse response,
							  ModelMap model, Integer page, Integer size,
							  String cid, Long tid,
							  Long ownerId,
							  Long assignId,
							  Long verificationId,
							  Long createId,
							  Integer status, Integer cStatus,
							  Long assignStartAt, Long assignEndAt,
							  Long applyStartAt, Long applyEndAt,
							  Long verificationStartAt, Long verificationEndAt) throws Exception {

		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {
			Map<String, Object> param = DynamicUtil.getCardsQueryListParam(cid, tid, ownerId,assignId,verificationId,createId, status, cStatus, assignStartAt,
					assignEndAt, applyStartAt, applyEndAt, verificationStartAt, verificationEndAt, false);
			log.info("card params is: " + param);

			List<Long> ids = cardService.getIdsByDynamicCondition(Card.class, param, start, size);
			log.info("cards ids is " + ids);

			List<Card> cardList = cardService.getObjectsByIds(ids);
			log.info("card list data is " + cardList);


			// 获取type的内容
			List<Long> tids = new ArrayList<>();
			for (Card cardTemp : cardList) {
				tids.add(cardTemp.getTid());
			}
			List<Ctype> ctypeList = ctypeService.getObjectsByIds(tids);
			log.info("card type id is " + tids);


			// get total
			Map<String, Object> paramCount = DynamicUtil.getCardsQueryListParam(cid, tid, ownerId, assignId,verificationId,createId,status, cStatus, assignStartAt,
					assignEndAt, applyStartAt, applyEndAt, verificationStartAt, verificationEndAt,true);
			List<Long> totalList = cardService.getIdsByDynamicCondition(Card.class, paramCount, 0, Integer.MAX_VALUE);
			Integer total = totalList.get(0).intValue();
			log.info("get card size is " + total);


			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);

			model.addAttribute("total", total);

			model.addAttribute("cardList", cardList);
			model.addAttribute("ctypeList", ctypeList);

		}  catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get card list error");
			model.addAttribute("code", -21007);
		}


		return "/common-skill-service/card/json/cardListJson";
	}



	/**
	 * 卡券转让前验证手机和次数
	 * @return
	 * @throws Exception
	 * */
	@RequestMapping(value = "/a/u/card/verify/{mobile}", method = RequestMethod.GET)
	public String verifyCard(HttpServletRequest request,
							 HttpServletResponse response,
							 ModelMap model,
							 @PathVariable String mobile) throws Exception {

		if (mobile == null) {
			model.addAttribute("code",-23012);
			return "/data/json";
		}

		// 根据mobile获取用户信息
		Long userId;
		User user;
		Classes classes;
		try {
			userId = userService.getUserIdByMobile(mobile);
			if (userId != null) {
				user = userService.getObjectById(userId);
				classes = classesService.getObjectById(user.getCid());
			} else {
				model.addAttribute("code",-23019);
				return "/data/json";
			}

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get user id error, mobile is " + mobile );
			model.addAttribute("code", -23015);
			return "/data/json";
		}


		// 检测ownerId今日转让是否超过3次
		Integer[] typeList = {Card.Status_Cession};
		Map<String, Object>  ownerClogParam = DynamicUtil.getClogsQueryListParam(null, null,null,null,
				userId,null,null,typeList,MyTimeUtil.getTodayZeroTimeMillions(),System.currentTimeMillis(),null,null,null,null,null,null,null,null, true);
		List<Long> cessionList = clogService.getIdsByDynamicCondition(Clog.class, ownerClogParam, 0, Integer.MAX_VALUE);
		Integer cessionTimes = cessionList.get(0).intValue();
		log.info("card session times is: " + cessionTimes);


		model.addAttribute("code", 0);
		model.addAttribute("user", user);
		model.addAttribute("classes", classes);
		model.addAttribute("cessionTimes", cessionTimes);


		return "/common-skill-service/card/json/cardVerifyJson";


	}


	// 存入卡券记录
	private void saveClog(Integer type, Long cid, Long tid, Long useId, Long receiveId) throws Exception {

		log.info("save clog, type: " + type + ". cid: " + cid + ". tid: " + tid);

		Clog clog = new Clog();
		clog.setType(type);
		clog.setCid(cid);
		clog.setTid(tid);
		clog.setAdminId(null);
		clog.setUseId(useId);
		clog.setReceiveId(receiveId);
		clog.setUpdateAt(System.currentTimeMillis());
		clog.setCreateAt(useId);
		clog.setCreateBy(useId);
		clog.setUpdateBy(useId);

		log.info("clog object is: " + clog);

		Long logId = clogService.insert(clog);
		log.info("new clog id is: " + logId);

	}


	// 消息通知
	private void sendMessage(Long uid, Integer type, String code, Long tid) throws Exception {

		log.info("send message args, uid: " + uid + ". type: " + type + ". code: " + code + ". tid: " + tid);
		// 获取用户信息
		User user = userService.getObjectById(uid);
		log.info("user object is: " + user);
		String userName = user.getNick();
		log.info("user name is: " + userName);

		// 获取卡券类型信息
		Ctype ctype = ctypeService.getObjectById(tid);
		String title = ctype.getTitle();

		//存入系统消息
		Message message = new Message();
		message.setSendName("admin");
		message.setSendId(0L);
		message.setReceiveName(userName);
		message.setReceiveId(uid);
		message.setContent("");
		message.setStatus(1);
		message.setUnread(1);
		message.setType(Message.CARD_TYPE);
		Long mid = messageService.insert(message);

		//发送系统信息
		String content = "";
		if (type == Card.Status_Issued) {
			// {发放人名称}给你发放了一张{卡券类型名称}
			content = "<span  class=\\\"font-16px system-alert-outline\\\">" +
					"<span class=\\\"font-green\\\">管理员</span>给您发放了一张" +
					"<a data-mid=" + mid + " class=\\\"font-orange\\\" target=\"_blank\" href=\\\"/skill/"+uid+"/myCard/\\\">"+ title + "[" + code + "]" +"</a>" +
					"</span>";
		} else if (type == Card.Status_Verificating) {
			// 使用
			return;
		} else if (type == Card.Status_Verificated) {
			// 核销通过：你的{卡券类型名称}{卡券编号}已审核通过并生效
			content = "<span  class=\\\"font-16px system-alert-outline\\\">" +
					"您的<a data-mid=" + mid + " class=\\\"font-orange\\\" target=\"_blank\" href=\\\"/skill/"+uid+"/myCard/\\\">"+ title + "[" + code + "]" +"</a>已审核通过并生效" +
					"</span>";
		} else if (type == Card.Status_Unverificated) {
			// 核销拒绝：你的{卡券类型名称}{卡券编号}已审核拒绝
			content = "<span  class=\\\"font-16px system-alert-outline\\\">" +
					"您的<a data-mid=" + mid + " class=\\\"font-orange\\\" target=\"_blank\" href=\\\"/skill/"+uid+"/myCard/\\\">"+ title + "[" + code + "]" +"</a>已审核拒绝" +
					"</span>";
		} else if (type == Card.Status_Cession) {
			// 转让：{转让人名称}给你转让了一张{卡券类型名称}
			content = "<span  class=\\\"font-16px system-alert-outline\\\">" +
					"<a data-mid=" + mid + " target=\"_blank\" href=\"/school/" + uid +"/class\"><span class=\"font-green\">" + userName + "</span></a>" +
					"<span class=\\\"font-green\\\">给您转让了一张</span>" +
					"<a data-mid=" + mid + " class=\\\"font-orange\\\" target=\"_blank\" href=\\\"/skill/"+uid+"/myCard/\\\">"+ title + "[" + code + "]" +"</a>" +
					"</span>";
		} else {
			log.info("message error");
			return;
		}

		adminSend(user.getMobile(), content);
		message = messageService.getObjectById(mid);
		message.setContent(content);
		log.info("message mid is " + mid);

		Boolean result = messageService.update(message);
		log.info("message update result is " + result);


		//更新用户信息
		user.setIsLook(user.getIsLook() + 1);
		user.setLatestMsg(Message.CARD_TYPE);
		userService.update(user);

	}
	private static String adminSend(String mobile, String content) {


		String param = "{\n" +
				"    \"target_type\" : \"users\", \n" +
				"    \"target\" : [\"" + mobile + "\"],   \n" +
				"                                   \n" +
				"                                   \n" +
				"    \"msg\" : {\n" +
				"        \"type\" : \"txt\",\n" +
				"        \"msg\" : \"" + content + "\" \n" +
				"        },\n" +
				"    \"from\" : \"admin\"\n" +
				"}";
		String result = HttpClientUtil.sendPostRequestByJavaSetHeader("https://a1.easemob.com/jnshu4/jnshu4/messages", param, "application/json", "Bearer YWMtwJlMnN7iEeW93dWWI_R-hgAAAVRiEFRny8NEKnIG6-Gu_yibQ4d46AkTlmM");


		return result;
	}
	
}

