package com.ptteng.common.skill.controller;

import com.gemantic.common.util.StringUtil;
import com.ptteng.common.skill.model.BranchInstitute;
import com.ptteng.common.skill.model.User;
import com.ptteng.common.skill.service.BranchInstituteService;
import com.ptteng.common.skill.service.UserService;
import com.ptteng.common.skill.util.DynamicUtil;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * BranchInstitute  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class BranchController {
    private static final Log log = LogFactory.getLog(BranchController.class);

    @Autowired
    private BranchInstituteService branchInstituteService;
    @Autowired
    private UserService userService;


    @RequestMapping(value = "/a/u/branchInstitute/{id}", method = RequestMethod.GET)
    public String getBranchInstituteJson(HttpServletRequest request,
                                         HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("get data : id= " + id);
        try {
            BranchInstitute branchInstitute = branchInstituteService.getObjectById(id);
            log.info("get branchInstitute data is " + branchInstitute);
            if (branchInstitute == null) {
                model.addAttribute("code", -18007);
                return "/common/success";
            }

            User user = new User();
            Long uid = branchInstitute.getUid();

            user = this.userService.getObjectById(uid);


            model.addAttribute("code", 0);

            model.addAttribute("branchInstitute", branchInstitute);
            model.addAttribute("user", user);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get branchInstitute error,id is  " + id);
            model.addAttribute("code", -100000);
        }

        return "/common-skill-service/branch/json/branchDetailJson";
    }




    //分院列表
    @RequestMapping(value = "/a/branch/search/query", method = RequestMethod.GET)
    public String searchDaily(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model, String name, Long uid,
                              String qq, Integer period, String phone, String url, String address, Integer status,
                              Integer page, Integer size, String nick, Integer orderBy, Integer sort) {

		/* 1 初始化参数 */
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        int limit = size + 1;
        boolean next = false;

        List<Long> idList = null;
        List<Long> totalList = null;
        List<Long> userIdList = null;
        List<User> userList = null;
        List<User> users = new ArrayList();
        Integer total = null;
        List<BranchInstitute> branchInstituteList = new ArrayList<>();
        BranchInstitute branchInstitute = new BranchInstitute();
        try {

            if (StringUtil.isEmpty(nick)) {
                Map<String, Object> param = DynamicUtil.getQueryBranchList(name, uid, qq, period, phone, url, address, status);
                idList = branchInstituteService.getIdsByDynamicCondition(BranchInstitute.class, param, start, size);
                log.info("====== idlist is " + idList);
                totalList = branchInstituteService.getIdsByDynamicCondition(BranchInstitute.class, param, 0, Integer.MAX_VALUE);

                branchInstituteList = branchInstituteService.getObjectsByIds(idList);
                total = totalList.size();
                List<Long> user1 = new ArrayList<>();
                List<Long> uids1 = new ArrayList<>();
                Long uid1 = 0L;
                Set<Long> uids = new HashSet();
                for (BranchInstitute branchInstitute1 : branchInstituteList) {
                    uids.add(branchInstitute1.getUid());
                }

                if (CollectionUtils.isEmpty(uids)) {

                } else {
                    users = this.userService.getObjectsByIds(new ArrayList(uids));
                }
            } else{

                Map<String, Object> param2 = DynamicUtil.getUserListParam2(nick);
                userIdList = userService.getIdsByDynamicCondition(User.class, param2, start, size);
                users = this.userService.getObjectsByIds(userIdList);
                log.info("============= users : " + users);
                List<Long> uids = new ArrayList<Long>();
                for (User user : users){
                    uids.add(user.getId());
                }
                log.info("========uids : is " + uids);
                uid = uids.get(0);
                Map<String, Object> param = DynamicUtil.getQueryBranchList(name, uid, qq, period, phone, url, address, status);
                idList = branchInstituteService.getIdsByDynamicCondition(BranchInstitute.class, param, start, size);
                uids.add(uid);
                branchInstituteList = branchInstituteService.getObjectsByIds(idList);
                log.info("branchInstituteList is " + branchInstituteList);



            }

            List<BranchInstitute> branchs = new ArrayList();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(idList)) {
                branchs = this.branchInstituteService.getObjectsByIds(idList);
                if (branchs.size() >= size) {
                    branchs = branchs.subList(0, size);
                    next = true;
                }
            }




            model.addAttribute("users", users);
            model.addAttribute("code", 0);
            model.addAttribute("branchInstituteList", branchInstituteList);
            model.addAttribute("total", total);
            model.addAttribute("size", size);
            model.addAttribute("next", next);
            model.addAttribute("page",page);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t);
            log.error(t.getMessage());
            log.error("get classesDailyList error,oid is ");
            model.addAttribute("code", -100000);
        }

        return "/common-skill-service/branch/json/branchListJson";

    }


}