package com.ptteng.common.skill.controller;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.ptteng.common.skill.model.*;
import com.ptteng.common.skill.service.*;
import com.ptteng.common.skill.util.DynamicUtil;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.*;

/**
 * UserArticleRelation  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class UserArticleRelationController {
	private static final Log log = LogFactory.getLog(UserArticleRelationController.class);

	@Autowired
	private UserArticleRelationService userArticleRelationService;
	@Autowired
	private ArticleService articleService;
	@Autowired
	private TaskService taskService;
	@Autowired
	private UserService userService;
	@Autowired
	private ClassesService classesService;

	/**
	 * 点赞-(日报/文档/视频)
	 * @param request
	 * @param response
	 * @param model
	 * @param type 类型
	 * @param did  id
	 * @param action 动作
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/love/{type}/{did}/{action}", method = RequestMethod.POST)
	public String loveJson(HttpServletRequest request,
											 HttpServletResponse response, ModelMap model,
											 @PathVariable String type,@PathVariable Long did,@PathVariable String action) throws Exception {

		log.info(" dian zan start,type =  " + type+" id = "+did+" action = "+action);
		User user = (User)request.getAttribute("user");
		Long uid = user.getId();
		try {
			if(Article.TYPE_DAILT.equals(type)){
				log.info(" update article love count ");
				//日报
				Article article = articleService.getObjectById(did);
				if(Article.LOVE.equals(action)){
					log.info(" user "+uid+" love this daily,id = "+did);
					Long userArticleId = userArticleRelationService.getUserArticleRelationIdByUidAndAidAndType(uid, did, UserArticleRelation.STATUS_LOVE);
					log.info(" Does user "+uid+" have loved this did ? ");
					if(DataUtils.isNotNullOrEmpty(userArticleId)){
						UserArticleRelation userArticleRelation = userArticleRelationService.getObjectById(userArticleId);
						log.info(" userArticleRelation weather = "+userArticleRelation.getWhether());
						if(UserArticleRelation.WHETHER_VALID==userArticleRelation.getWhether()){
							log.info(" yes ,he loved");
							model.addAttribute("code", -17003);
							return "/data/json";
						}else {
							log.info(" yes ,he canceled love ,now relove ");
							//之前取消了点赞，可以重新点赞
							//日报的点赞数+1
							Integer loveCount = article.getLove() == null ? 0 : article.getLove();
							article.setLove(++loveCount);
							userArticleRelation.setWhether(UserArticleRelation.WHETHER_VALID);
							userArticleRelationService.update(userArticleRelation);
						}

					}else {
						//完全没有点过赞，
						log.info(" no,he doesn't ");

						//日报的点赞数+1
						article.setLove(article.getLove() == null ? 0 : article.getLove());
						article.setLove(article.getLove()+1);
						//在userArticleRelation中新增
						UserArticleRelation userArticleRelation = new UserArticleRelation();
						userArticleRelation.setUid(uid);
						userArticleRelation.setAid(did);
						userArticleRelation.setType(UserArticleRelation.STATUS_LOVE);
						userArticleRelation.setWhether(UserArticleRelation.WHETHER_VALID);
						userArticleRelationService.insert(userArticleRelation);
					}

				}else {
					log.info(" user "+uid+" want to cancel love ");
					//取消点赞
					Long userArticleId = userArticleRelationService.getUserArticleRelationIdByUidAndAidAndType(uid,did,UserArticleRelation.STATUS_LOVE);
					log.info(" Does user " + uid + " have loved this did ? ");
					if(DataUtils.isNotNullOrEmpty(userArticleId)){
						log.info(" yes ,he loved");
						UserArticleRelation userArticleRelation = userArticleRelationService.getObjectById(userArticleId);
						userArticleRelation.setWhether(UserArticleRelation.WHETHER_INVALID);
						userArticleRelationService.update(userArticleRelation);
					}else {
						log.info(" no,he doesn't ");
						model.addAttribute("code", -17004);
						return "/data/json";
					}
					article.setLove(article.getLove()-1);
				}
				articleService.update(article);
			}else {
				model.addAttribute("code", -1003);
				return "/data/json";
			}

			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add userArticleRelation error ");
			model.addAttribute("code", -1);
		}

		return "/data/json";
	}

	/**
	 * 收藏-(日报/文档/视频)
	 * @param request
	 * @param response
	 * @param model
	 * @param type 类型
	 * @param did  id
	 * @param action 动作
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/collection/{type}/{did}/{action}", method = RequestMethod.POST)
	public String collectJson(HttpServletRequest request,
											 HttpServletResponse response, ModelMap model,
											 @PathVariable String type,@PathVariable Long did,@PathVariable String action) throws Exception {

		log.info(" dian zan start,type =  " + type+" id = "+did+" action = "+action);
		User user = (User)request.getAttribute("user");
		Long uid = user.getId();
		try {
			if(Article.TYPE_DAILT.equals(type)){
				log.info(" update article collect count ");
				//日报
				Article article = articleService.getObjectById(did);
				Integer collectionCount = article.getCollection()==null?0:article.getCollection();
				if(Article.LOVE.equals(action)){
					log.info(" user "+uid+" collect this daily,id = "+did);
					Long userArticleId = userArticleRelationService.getUserArticleRelationIdByUidAndAidAndType(uid,did,UserArticleRelation.STATUS_COLLECTION);
					log.info(" Does user "+uid+" have collected this did ? ");
					if(DataUtils.isNotNullOrEmpty(userArticleId)){
						UserArticleRelation userArticleRelation = userArticleRelationService.getObjectById(userArticleId);
						log.info(" userArticleRelation weather = "+userArticleRelation.getWhether());
						if(UserArticleRelation.WHETHER_VALID==userArticleRelation.getWhether()){
							log.info(" yes ,he collected");
							model.addAttribute("code", -17005);
							return "/data/json";
						}else {
							log.info(" yes ,he canceled collect ,now recollect ");
							//之前取消了收藏，重新收藏
							//日报的收藏数+1
							article.setCollection(collectionCount+ 1);
							userArticleRelation.setWhether(UserArticleRelation.WHETHER_VALID);
							userArticleRelationService.update(userArticleRelation);
						}

					}else {
						log.info(" no,he doesn't ");

						//日报的收藏数+1
						article.setCollection(article.getCollection()==null?0:article.getCollection() );
						article.setCollection(article.getCollection()+ 1);
						//在userArticleRelation中新增
						UserArticleRelation userArticleRelation = new UserArticleRelation();
						userArticleRelation.setUid(uid);
						userArticleRelation.setAid(did);
						userArticleRelation.setType(UserArticleRelation.STATUS_COLLECTION);
						userArticleRelation.setWhether(UserArticleRelation.WHETHER_VALID);
						userArticleRelationService.insert(userArticleRelation);
					}

				}else {
					log.info(" user "+uid+" want to cancel collect ");
					//取消收藏
					Long userArticleId = userArticleRelationService.getUserArticleRelationIdByUidAndAidAndType(uid,did,UserArticleRelation.STATUS_COLLECTION);
					log.info(" Does user "+uid+" have collected this did ? ");
					if(DataUtils.isNotNullOrEmpty(userArticleId)){
						log.info(" yes ,he collected");
						UserArticleRelation userArticleRelation = userArticleRelationService.getObjectById(userArticleId);
						userArticleRelation.setWhether(UserArticleRelation.WHETHER_INVALID);
						userArticleRelationService.update(userArticleRelation);
					}else {
						log.info(" no,he doesn't ");
						model.addAttribute("code", -17006);
						return "/data/json";
					}
					article.setCollection(collectionCount- 1);
				}
				articleService.update(article);
			}else {
				model.addAttribute("code", -1003);
				return "/data/json";
			}

			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add userArticleRelation error ");
			model.addAttribute("code", -1);
		}

		return "/data/json";
	}

	/**
	 * 获取用户点赞/收藏日报列表
	 * @param request
	 * @param response
	 * @param model
	 * @param page
	 * @param size
	 * @param type
	 * @param orderBy
	 * @param sort
	 * @return
	 * @throws Exception
	 */
		@RequestMapping(value = "/a/u/daily/{type}/sort/list", method = RequestMethod.GET)
	public String getUserArticleRelationIdsByUidAndTypeAndWhetherJsonList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page,
			Integer size,@PathVariable Integer type,Integer orderBy,Integer sort) throws Exception {
			log.info(" get user like dailys,type = "+type+" orderBy = "+orderBy+" sort = "+sort);
			User user = (User)request.getAttribute("user");
			Long uid = user.getId();
		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {
			int limit = size + 1;
			boolean next=false;


			if(DataUtils.isNullOrEmpty(orderBy)){
				orderBy = UserArticleRelation.ARTICLE_CREATE_AT;
			}
			if(DataUtils.isNullOrEmpty(sort)){
				sort = UserArticleRelation.DESC;
			}
			if(sort!=UserArticleRelation.ASC&&sort!=UserArticleRelation.DESC){
				log.info(" sort value is not currect ");
				model.addAttribute("code",-1003);
				return "/data/json";
			}
			if(orderBy!=UserArticleRelation.ARTICLE_CREATE_AT&&
					orderBy!=UserArticleRelation.LOVE&&
					orderBy!=UserArticleRelation.COLLECTION&&
					orderBy!=UserArticleRelation.COMMENT&&
					orderBy!=UserArticleRelation.READ){
				log.info(" orderBy value is not currect ");
				model.addAttribute("code",-1003);
				return "/data/json";
			}

			Map<String, Object> map = DynamicUtil.getUserLoveArticleList(type, orderBy,sort,uid,false);
			List<Long> ids= articleService.getIdsByDynamicCondition(Article.class, map, start, limit);
			List<Article> articles = new ArrayList<>();
			if(CollectionUtils.isEmpty(ids)){

			}else {
				articles = articleService.getObjectsByIds(ids);
				if (articles.size() >= size) {
					articles = articles.subList(0, size);
					next = true;
				}
			}

			int total = articleService. getIdsByDynamicCondition(Article.class, map, 0, Integer.MAX_VALUE).size();
			log.info("get userArticleRelation count is " + total);


			List<Task> tasks = new ArrayList();
			List<Classes> classes = new ArrayList();
			List<User> users = new ArrayList<>();


			Gson gson = new Gson();
			Type typeToken = new TypeToken<List<Long>>() {
			}.getType();
			Set<Long> uids = new HashSet();
			Set<Long> tids = new HashSet();
			Set<Long> cids = new HashSet();
			for (Article article : articles) {
				uids.add(article.getUid());
				cids.add(article.getCid());
				List<Long> taskIDS = gson.fromJson(article.getTids(), typeToken);
				if (taskIDS != null) {
					tids.addAll(taskIDS);
				}


			}

			if (org.springframework.util.CollectionUtils.isEmpty(tids)) {

			} else {
				tasks = this.taskService.getObjectsByIds(new ArrayList(tids));
				log.info(" get tasks is " + tids);
			}


			if (org.springframework.util.CollectionUtils.isEmpty(uids)) {

			} else {
				users = this.userService.getObjectsByIds(new ArrayList(uids));
				log.info(" get user is " + uids);
				classes = this.classesService.getObjectsByIds(new ArrayList(cids));
			}

			//用户是否点赞过或者收藏过
			Map<Long, Boolean> iflikeMap = new HashedMap(),
					ifCollectionMap = new HashedMap();
			Map<String, Object> paramRelation = DynamicUtil.getArticleRelationListParam(ids,uid,false);
			log.info("query relationId sql: " + paramRelation);
			List<Long> relationIds = userArticleRelationService.getIdsByDynamicCondition(UserArticleRelation.class, paramRelation, 0, Integer.MAX_VALUE);

			if (org.apache.commons.collections.CollectionUtils.isNotEmpty(relationIds)) {
				log.info("relationIds has:" + relationIds);
				List<UserArticleRelation> relationList = userArticleRelationService.getObjectsByIds(relationIds);

				int relationSize = relationList.size();
				for (int i = 0; i < relationSize; i++) {
					UserArticleRelation relation = relationList.get(i);
					Integer relationStatus = relation.getType();
					log.info(" relation id = "+relation.getId()+" aid = "+relation.getAid()+" relationStatus = "+relationStatus);
					Long aid = relation.getAid();

                /* 替换掉旧值 */
					log.info(" iflikeMap = "+iflikeMap+" ifCollectionMap = "+ifCollectionMap);
					switch (relationStatus) {
						case UserArticleRelation.STATUS_LOVE:
							iflikeMap.put(aid, true);
							break;
						case UserArticleRelation.STATUS_COLLECTION:
							ifCollectionMap.put(aid, true);
							break;
						default:
							break;
					}
					log.info(" iflikeMap = "+iflikeMap+" ifCollectionMap = "+ifCollectionMap);

				}
				for (int i = 0; i < articles.size(); i++) {
					Article article = articles.get(i);
					Long aid = article.getId();
					log.info(" aid = "+aid+" iflikeMap = "+iflikeMap+" ifCollectionMap = "+ifCollectionMap);
					article.setIfLike(iflikeMap.get(aid)==null?false:iflikeMap.get(aid));
					article.setIfCollection(ifCollectionMap.get(aid)==null?false:ifCollectionMap.get(aid));
				}
			}

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			model.addAttribute("total", total);
			model.addAttribute("next", next);
			model.addAttribute("aricles", articles);
			model.addAttribute("users", users);
			model.addAttribute("tasks", tasks);
			model.addAttribute("classesList", classes);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get userArticleRelation list error,page is  " + start + " , size "
					+ size);
			model.addAttribute("code", -100000);
		}

			return "/common-skill-service/article/json/articleListJson";
	}

	
	
		
			

	
		@RequestMapping(value = "/a/userArticleRelation2 ", method = RequestMethod.GET)
	public String getUserArticleRelationIdsByAidAndTypeAndWhetherJsonList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page,
			Integer size,Long aid,Integer type,Integer whether) throws Exception {


		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			List<Long> ids= userArticleRelationService.getUserArticleRelationIdsByAidAndTypeAndWhether(aid, type, whether, start, size);
		log.info("get countUserArticleRelationIdsByAidAndTypeAndWhether size is " + ids.size());

			List<UserArticleRelation> userArticleRelationList = userArticleRelationService.getObjectsByIds(ids);
			log.info("get userArticleRelation data is " + userArticleRelationList.size());

			Integer total = userArticleRelationService. countUserArticleRelationIdsByAidAndTypeAndWhether(aid, type, whether);
			log.info("get userArticleRelation count is " + total);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			
			model.addAttribute("total", total);

			model.addAttribute("userArticleRelationList", userArticleRelationList);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get userArticleRelation list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/userArticleRelation/json/userArticleRelationListJson";
	}

	
	
		
	
	

	@RequestMapping(value = "/a/userArticleRelation/{id}", method = RequestMethod.GET)
	public String getUserArticleRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			UserArticleRelation userArticleRelation = userArticleRelationService.getObjectById(id);
			log.info("get userArticleRelation data is " + userArticleRelation);

			model.addAttribute("code", 0);

			model.addAttribute("userArticleRelation", userArticleRelation);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get userArticleRelation error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/userArticleRelation/json/userArticleRelationDetailJson";
	}

	@RequestMapping(value = "/a/userArticleRelation/{id}", method = RequestMethod.PUT)
	public String updateUserArticleRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, UserArticleRelation userArticleRelation) throws Exception {
		
		log.info("update userArticleRelation : userArticleRelation= " + userArticleRelation);
		
		try {
			
			userArticleRelationService.update(userArticleRelation);

			model.addAttribute("code", 0);

			model.addAttribute("userArticleRelation", userArticleRelation);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update userArticleRelation error,id is  " + userArticleRelation.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}



	@RequestMapping(value = "/a/userArticleRelation/{id}", method = RequestMethod.DELETE)
	public String deleteUserArticleRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete userArticleRelation : id= " + id);
		try {
			userArticleRelationService.delete(id);

			log.info("add userArticleRelation success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete userArticleRelation error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}
	
	
	@RequestMapping(value = "/a/multi/userArticleRelation", method = RequestMethod.GET)
	public String getMultiUserArticleRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			
		List<Long> idList = new ArrayList();	
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			

			List<UserArticleRelation> userArticleRelationList = userArticleRelationService.getObjectsByIds(idList);
			log.info("get  userArticleRelation data is " + userArticleRelationList);

			model.addAttribute("code", 0);			
			model.addAttribute("total", userArticleRelationList.size());

			model.addAttribute("userArticleRelationList", userArticleRelationList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get userArticleRelation error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/userArticleRelation/json/userArticleRelationListJson";
	}
	
	public static void main(String[] args){
		Integer a = 1;
		a=a+1;
		System.out.print(" a = "+a);

	}
	
	
	
}

