package com.ptteng.common.skill.controller;

import com.ptteng.common.skill.model.Classes;
import com.ptteng.common.skill.model.User;
import com.ptteng.common.skill.model.UserScore;
import com.ptteng.common.skill.service.UserScoreService;
import com.ptteng.common.skill.service.UserService;
import com.sun.org.apache.bcel.internal.generic.NEW;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import com.qding.common.util.DataUtils;


import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * UserScore  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class UserScoreController {
	private static final Log log = LogFactory.getLog(UserScoreController.class);

	@Autowired
	private UserScoreService userScoreService;

	@Autowired
	private UserService userService;





    /**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/a/u/userScore", method = RequestMethod.GET)
	public String getUserScoreList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model , Integer page, Integer size,Long uid)
			throws Exception {
		log.info("/a/u/userScore uid=" + uid );

		List<Long> idList = new ArrayList();
		List<UserScore> userScoreList = new ArrayList();
		if(DataUtils.isNullOrEmpty(uid)){
			log.error("uid is null");
			model.addAttribute("code",-1);
			return "/common/success"
;		}


		log.info(" uid = "+uid);
		if (null == page) {
			page = 1;
		}
		if (null == size) {
			size = 20;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		try {
			idList = userScoreService.getUserScoreIdsByUid(uid,start,size);
			if (CollectionUtils.isEmpty(idList)) {
				log.info(" idList is null ");
			} else {
				log.info(" idList size =  " + idList.size());
				userScoreList = userScoreService.getObjectsByIds(idList);
			}

			model.addAttribute("code", 0);
			model.addAttribute("total", idList.size());
			model.addAttribute("userScoreList", userScoreList);
		}catch (Throwable t){
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get userScore error,id is  " + idList);
			model.addAttribute("code", -1);
		}

		log.info("/userScore  to /userScore/view/userScoreList");

		return "/common-skill-service/userScore/json/userScoreListJson";
	}


	@RequestMapping(value = "/a/u/userScore/{uid}", method = RequestMethod.POST)
	public String updateUserScore(HttpServletRequest request,
									  HttpServletResponse response, ModelMap model, Long score ,String comment
	,@PathVariable Long uid) throws Exception {


		log.info("update score:"+score+",update comment:"+comment+",get uid:"+uid+"");
		if(DataUtils.isNullOrEmpty(score)){
			log.error("score is null");
			model.addAttribute("code",-1);
			return "/common/success";
		}else {
			log.info("score is :" + score);
		}
		if(DataUtils.isNullOrEmpty(uid)){
			log.error("uid is null");
			model.addAttribute("code",-1);
			return "/common/success";
		}else {
			log.info("uid is :" + uid);
		}

		try {
			User user = userService.getObjectById(uid);
			log.info("user is ：" + user);
			int oldScore = user.getScore();
			long newScore =(long) oldScore + score;
			log.info("oldScore is " + oldScore + "newScore :" + newScore);

			log.info(" ====update self userInfo==== " + uid);
			 UserScore userScore= new UserScore();
			//设置userScore的对象属性
			userScore.setUid(uid);
			userScore.setScore(score);
			userScore.setComment(comment);
			user.setScore((int)newScore);
			log.info("user.score is :" + user.getScore());

			userScoreService.insert(userScore);
			userService.update(user);
			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update userScore error,score is "+score+"  comment is "+comment+"");
			model.addAttribute("code", -1);

		}

		return "/common/success";
	}
    
	
	@RequestMapping(value = "a/u/userScoreUpDown/{id}", method = RequestMethod.GET)
	public String getUserScore(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("/userScore/" + id + "  to /userScore/view/userScoreDeail");
		if(null != id){
			model.addAttribute("id", id);
		}else{
			model.addAttribute("id", 0);
		}

		return "/common-skill-service/userScore/view/userScoreDetail";
	}
	
	
	
	    
	

	@RequestMapping(value = "/a/userScore/{id}", method = RequestMethod.GET)
	public String getUserScoreJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			UserScore userScore = userScoreService.getObjectById(id);
			log.info("get userScore data is " + userScore);

			model.addAttribute("code", 0);

			model.addAttribute("userScore", userScore);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get userScore error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/userScore/json/userScoreDetailJson";
	}



	@RequestMapping(value = "/a/u/userScoreUpDown", method = RequestMethod.POST)
	public String addUserScoreJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, UserScore userScore) throws Exception {
		
		log.info("update userScore : userScore= " + userScore);
		
		try { 
			userScore.setId(null);

			userScoreService.insert(userScore);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add userScore error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/userScore/{id}", method = RequestMethod.DELETE)
	public String deleteUserScoreJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete userScore : id= " + id);
		try {
			userScoreService.delete(id);

			log.info("add userScore success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete userScore error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}
	
	
	@RequestMapping(value = "/a/multi/userScore", method = RequestMethod.GET)
	public String getMultiUserScoreJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			
		List<Long> idList = new ArrayList();	
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			

			List<UserScore> userScoreList = userScoreService.getObjectsByIds(idList);
			log.info("get  userScore data is " + userScoreList);

			model.addAttribute("code", 0);			
			model.addAttribute("total",userScoreList.size());

			model.addAttribute("userScoreList", userScoreList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get userScore error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/userScore/json/userScoreListJson";
	}
	
	
	
	
	
}

