package com.ptteng.common.skill.controller;

import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ptteng.common.skill.model.Article;
import com.ptteng.common.skill.util.DynamicUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.common.skill.model.Message;
import com.ptteng.common.skill.model.User;
import com.ptteng.common.skill.service.MessageService;
import com.ptteng.common.skill.service.UserService;
import com.qding.common.util.http.cookie.CookieUtil;

/**
 * OccupationTypeRelation  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class MessageController {
    private static final Log log = LogFactory.getLog(MessageController.class);

    @Autowired
    private MessageService messageService;

    @Autowired
    private CookieUtil cookieUtil;

    @Autowired
    private UserService userService;


    /**
     * 根据类型查询消息
     * @param request
     * @param response
     * @param model
     * @param page
     * @param size
     * @param status
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/receive/message/{type}/search", method = RequestMethod.GET)
    public String getReceiveMessageByType(HttpServletRequest request,
                                    HttpServletResponse response, ModelMap model, Integer page,
                                    Integer size, Integer status,@PathVariable String type ) throws Exception {


        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        int end = start + size - 1;

        log.info("receive message :  start = " + start + " , size=" + size + " , status = " + status+" type = "+type);

        try {
            User user = (User) request.getAttribute("user");
            Long uid = user.getId();
            Map<String, Object> params = DynamicUtil.getMessageListParam(status,type,uid,null,false);
            List<Long> ids = messageService.getIdsByDynamicCondition(Message.class,params, start, size);

            if (ids.equals(null)) {
                model.addAttribute("code", -7000);
                log.info("the user message is null");
                return "/common/success";
            }

            List<Long> mids = messageService.getMessageIdsByReceiveIdAndUnreadAndStatusAndType(uid, 1, 1, "like", 0, Integer.MAX_VALUE);

            if(!(mids==null)){
                List<Message> messageLikes = messageService.getObjectsByIds(mids);

                for(Message message:messageLikes){
                    message.setUnread(0);
                    messageService.update(message);
                }
            }

            List<Message> messages = messageService.getObjectsByIds(ids);
            log.info("messages is " + messages.size());

            List<Long> messageIds = messageService.getIdsByDynamicCondition(Message.class, params, 0, Integer.MAX_VALUE);
            boolean next = false;
            if (messageIds.size() > end + 1) {
                next = true;
            }

            params = DynamicUtil.getMessageListParam(status, Message.DAILY_TYPE, uid,Message.Status_Unread, false);
             ids = messageService.getIdsByDynamicCondition(Message.class, params, 0, Integer.MAX_VALUE);
            int daily = ids.size();
            params = DynamicUtil.getMessageListParam(status, Message.CLASS_TYPE, uid,Message.Status_Unread, false);
            ids = messageService.getIdsByDynamicCondition(Message.class, params, 0, Integer.MAX_VALUE);
            int classes = ids.size();
            params = DynamicUtil.getMessageListParam(status, Message.TASK_TYPE, uid, Message.Status_Unread,false);
            ids = messageService.getIdsByDynamicCondition(Message.class, params, 0, Integer.MAX_VALUE);
            int task = ids.size();
            model.addAttribute("daily", daily);
            model.addAttribute("classes", classes);
            model.addAttribute("task", task);
            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("next", next);
            model.addAttribute("total", messageIds.size());
            model.addAttribute("messages", messages);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get occupationTypeRelation list error,page is  " + start + " , size "
                    + size);
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/message/json/messageListJson";
    }




    /**
     * 查询所有消息--保留接口，用于APP
     * @param request
     * @param response
     * @param model
     * @param page
     * @param size
     * @param status
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/receive/message/list", method = RequestMethod.GET)
    public String getReceiveMessage(HttpServletRequest request,
                                    HttpServletResponse response, ModelMap model, Integer page,
                                    Integer size, Integer status) throws Exception {


        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        int end = start + size - 1;

        log.info("receive message :  start = " + start + " , size=" + size + " , status = " + status);

        try {
            User user = (User) request.getAttribute("user");
            Long uid = user.getId();
            List<Long> ids = messageService.getMessageIdsByReceiveIdAndStatus(uid, status, start, size);

            if (ids.equals(null)) {
                model.addAttribute("code", -7000);
                log.info("the user message is null");
                return "/common/success";
            }

            List<Long> mids = messageService.getMessageIdsByReceiveIdAndUnreadAndStatusAndType(uid, 1, 1, "like", 0, Integer.MAX_VALUE);

            if(!(mids==null)){
                List<Message> messageLikes = messageService.getObjectsByIds(mids);

                for(Message message:messageLikes){
                    message.setUnread(0);
                    messageService.update(message);
                }
            }

            List<Message> messages = messageService.getObjectsByIds(ids);
            log.info("messages is " + messages.size());

            List<Long> messageIds = messageService.getMessageIdsByReceiveIdAndStatus(uid, 1, 0, Integer.MAX_VALUE);
            boolean next = false;
            if (messageIds.size() > end + 1) {
                next = true;
            }

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("next", next);
            model.addAttribute("total", messageIds.size());
            model.addAttribute("messages", messages);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get occupationTypeRelation list error,page is  " + start + " , size "
                    + size);
            // for test
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/message/json/messageListJson";
    }



    @RequestMapping(value = "/a/u/message/{mid}", method = RequestMethod.DELETE)
    public String deleteMessage(HttpServletRequest request,
                                                HttpServletResponse response, ModelMap model, @PathVariable Long mid)
            throws Exception {

        log.info("delete message : mid= " + mid);
        try {
            User user = (User) request.getAttribute("user");
            Long uid = user.getId();
            Message message = messageService.getObjectById(mid);

            if(message.equals(null)){
                model.addAttribute("code", -7000);
                log.info("no this user");
                return "/common/success";
            }

            if (message.getReceiveId().equals(uid)) {

                if (Message.Status_Unread.equals(message.getUnread())) {
                    //未读消息被删除，用户未读消息数减1
                    log.info(message.getId() + " is unread " + message.getUnread() + " ready to update user unread message count ");
                    Integer unreadNum = user.getIsLook() - 1;
                    user.setIsLook(unreadNum);
                    boolean result = this.userService.update(user);
                    log.info(message.getId() + " is unread " + message.getUnread() + "  update user " + user.getId() + " unread message count result is  " + result);

                }

                message.setStatus(0);
                message.setUnread(0);
                messageService.update(message);


            } else {
                model.addAttribute("code", -7001);
                log.info("not your message");
                return "/common/success";
            }

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete message error,mid is  " + mid);
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

    //消息已读

    @RequestMapping(value = "/a/u/read/message/{mid}", method = RequestMethod.PUT)
    public String readMessage(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model, @PathVariable Long mid)
            throws Exception {

        log.info("read message : mid= " + mid);
        try {
            User user = (User) request.getAttribute("user");
            Long uid = user.getId();
            Message message = messageService.getObjectById(mid);

            if(message.equals(null)){
                model.addAttribute("code", -7002);
                log.info("no this message");
                return "/common/success";
            }

            if(!(message.getReceiveId().equals(uid))){
                model.addAttribute("code", -7001);
                log.info("not your message");
                return "/common/success";
            }

            if(message.getUnread().equals(0)){
                model.addAttribute("code", -7003);
                log.info("already read the message");
                return "/common/success";
            }

            message.setUnread(0);
            messageService.update(message);

            Integer unreadNum = user.getIsLook();
            user.setIsLook(unreadNum-1);
            userService.update(user);

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("read message error,mid is  " + mid);
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

    //全部已读

    @RequestMapping(value = "/a/u/read/message/all", method = RequestMethod.PUT)
    public String allReadMessage(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model)
            throws Exception {

        log.info("read message all");
        try {
            User user = (User) request.getAttribute("user");
            Long uid = user.getId();
            List<Long> messageIds = messageService.getMessageIdsByReceiveIdAndUnreadAndStatus(uid, 1, 1, 0, Integer.MAX_VALUE);
            List<Message> messages = messageService.getObjectsByIds(messageIds);

            for(Message message :messages){
                message.setUnread(0);
                messageService.update(message);
            }

            user.setIsLook(0);
            userService.update(user);

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("read message all error");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

}

