package com.ptteng.etl.skill.etl;

import com.ptteng.common.skill.model.ClassTimetable;
import com.ptteng.common.skill.service.ClassTimetableService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import java.util.*;

/**
 * @Description 小课堂定时任务：讲课时间过后，speakStatus 变为3，即未评级未提交审核
 * @Author 丶
 * @Date 2018/8/6 11:10
 **/

public class SmallClassSpeakStatusEtl {
    private static final Log log = LogFactory.getLog("SmallClassSpeakStatusEtl");
    // 一次任务检测的条数
    private static final int TASK_LEN = 200;
    // 空转任务间隔休息毫秒数
    private static final long SLEEP_MILLISECOND = 10 * 1000;

    private long interval = 12 * 60 * 60 * 1000; //等待时间24个小时


    private ClassTimetableService classTimetableService;

    /**
     * ETL主进程
     *
     * @throws InterruptedException
     */
    public void process() throws InterruptedException {

        while (true) {
            try {
                /* 获取当前时间点 */
                Long currentTime = System.currentTimeMillis();
                log.info(" currentTime =============" + currentTime);


                Map<String, Object> conditions = new HashMap<String, Object>();
                conditions.put("arrange_date & <=", currentTime);
                conditions.put("speak_status", ClassTimetable.APPOINT_PUBLISHED);
                conditions.put("@query", "id");
                conditions.put("@table", " class_timetable ");
                log.info("conditions======" + conditions);
                List<Long> ids = this.classTimetableService.getIdsByDynamicCondition(ClassTimetable.class, conditions, 0, TASK_LEN);
                log.info("expire small class ids is: " + ids);
                if (CollectionUtils.isEmpty(ids)) {
                    log.info("no small class need to change speakstatus==");
                } else {
                    for (Long smallClassId : ids) {
                        ClassTimetable classTimetable = classTimetableService.getObjectById(smallClassId);
                        classTimetable.setSpeakStatus(ClassTimetable.NO_LEVEL);
                        classTimetableService.update(classTimetable);
                    }
                }
                Thread.sleep(SLEEP_MILLISECOND);
            } catch (Throwable t) {
                t.printStackTrace();
                Thread.sleep(SLEEP_MILLISECOND);
                log.error("process check sendClassesMessage error ,sleep " + t.getMessage());
            }
        }
    }


    public ClassTimetableService getClassTimetableService() {
        return classTimetableService;
    }

    public void setClassTimetableService(ClassTimetableService classTimetableService) {
        this.classTimetableService = classTimetableService;
    }

    public long getInterval() {
        return interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }
}

