package com.ptteng.etl.skill.etl;

import com.ptteng.common.skill.model.ClassTimetable;
import com.ptteng.common.skill.model.Message;
import com.ptteng.common.skill.model.User;
import com.ptteng.common.skill.service.ClassTeamService;
import com.ptteng.common.skill.service.ClassTimetableService;
import com.ptteng.common.skill.service.MessageService;
import com.ptteng.common.skill.service.UserService;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.map.ObjectMapper;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @Description 小课堂定时任务：开课前7天，给小组人员发消息
 * @Author ruanshaonan
 * @Date 2018/7/11 11:10
 **/

public class SmallClassEtl {
    private static final Log log = LogFactory.getLog(SmallClassEtl.class);
    // 一次任务检测的条数
    private static final int TASK_LEN = Integer.MAX_VALUE;
    // 空转任务间隔休息毫秒数
    private static final long SLEEP_MILLISECOND = 24 * 60 * 60 * 1000;
    // 7天时间的毫秒数
    private static final long SEVEN_DAY_MILLISECOND = 7 * 24 * 60 * 60 * 1000;
    private static final long SIX_DAY_MILLISECOND = 6 * 24 * 60 * 60 * 1000;
    private long interval = 12 * 60 * 60 * 1000; //等待时间12个小时

    private MessageService messageService;
    private ClassTimetableService classTimetableService;
    private ClassTeamService classTeamService;
    private UserService userService;

    /**
     * ETL主进程
     *
     * @throws InterruptedException
     */
    public void process() throws InterruptedException {

        while (true) {
            try {
                /* 获取当前时间点 */
                Long currentTime = System.currentTimeMillis();
                log.info(" currentTime =============" + currentTime);
                log.info("Plan message already send currentTime =============" + currentTime);

                /* 开课时间距现在7天的时候，发1次消息 */
                Map<String, Object> conditions = new HashMap<String, Object>();
                conditions.put("arrange_date  & <", currentTime + SEVEN_DAY_MILLISECOND);
                conditions.put("arrange_date  & >", currentTime + SIX_DAY_MILLISECOND);
                conditions.put("@query", "id");
                conditions.put("@table", " class_timetable ");
                log.info("conditions======"+conditions);
                List<Long> ids = this.classTimetableService.getIdsByDynamicCondition(ClassTimetable.class, conditions, 0, TASK_LEN);
                log.info("expire small class ids is: " + ids);
                if (CollectionUtils.isEmpty(ids)) {
                    log.info("no small class need to send msg==");
                } else {
                    //给课堂小组的每个人发消息
                    for (Long smallClassId : ids) {
                        ClassTimetable classTimetable = classTimetableService.getObjectById(smallClassId);
                        if (DataUtils.isNotNullOrEmpty(classTimetable)) {
                            //给主讲人发消息
                            Long speakerId = classTimetable.getTeachUid();
                            Message message = new Message();
                            message.setReceiveId(speakerId);
                            message.setType(Message.CLASS_TYPE);
                            message.setUnread(Message.Status_Unread);
                            message.setStatus(Message.STATUS_UNDELETE);
                            message.setTemplate(Message.TEMPLATE_5);
                            message.setCreateAt(System.currentTimeMillis());
                            message.setUpdateAt(System.currentTimeMillis());
                            message.setSendId(0L);
                            message.setRelationId(classTimetable.getId());

                            List<Map> list = new ArrayList<>();
                            Map<String, Object> map = new HashMap<>();
                            String content = "您" +  "XXX" + "的小课堂将在七天后开始！";
                            map.put("content", content);
                            Map<String, Object> map1 = new HashMap<>();
                            map1.put("childContent", classTimetable.getArrangeDate());
                            map1.put("skip", true);
                            map1.put("lessonId", smallClassId);
                            list.add(map);
                            list.add(map1);

                            //把list转成json格式的String字符串
                            ObjectMapper json = new ObjectMapper();
                            String contentStr = json.writeValueAsString(list);
                            message.setContent(contentStr);
                            log.info(list);
                            Long mid = messageService.insert(message);
                            log.info("insert success==" + message);
                            //更新用户的未读消息数量和最后一条消息类型
                            User speaker = userService.getObjectById(speakerId);
                            speaker.setIsLook(speaker.getIsLook() + 1);
                            speaker.setLatestMsg(Message.CLASS_TYPE);
                            userService.update(speaker);
                            log.info("Plan message already send===="+mid);
                        }
                    }
                }
                Thread.sleep(SLEEP_MILLISECOND);
            } catch (Throwable t) {
                t.printStackTrace();
                Thread.sleep(SLEEP_MILLISECOND);
                log.error("process check sendClassesMessage error ,sleep " + t.getMessage());
            }
        }
    }

    public MessageService getMessageService() {
        return messageService;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    public ClassTimetableService getClassTimetableService() {
        return classTimetableService;
    }

    public void setClassTimetableService(ClassTimetableService classTimetableService) {
        this.classTimetableService = classTimetableService;
    }

    public ClassTeamService getClassTeamService() {
        return classTeamService;
    }

    public void setClassTeamService(ClassTeamService classTeamService) {
        this.classTeamService = classTeamService;
    }

    public UserService getUserService() {
        return userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public long getInterval() {
        return interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }
}
