package com.ptteng.etl.skill.etl;

import com.ptteng.common.skill.model.Ctype;
import com.ptteng.common.skill.model.UserStatistics;
import com.ptteng.common.skill.service.CtypeService;
import com.ptteng.common.skill.service.UserStatisticsService;
import com.ptteng.common.skill.model.Card;
import com.ptteng.common.skill.service.CardService;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.CollectionUtils;
import java.util.*;

public class CardEtl {

    private static final int TASK_LEN = 200;// 一次任务检测的条数

    private static final long SLEEP_MILLISECOND = 10 * 1000;// 空转任务间隔休息毫秒数


    private static final Log log = LogFactory.getLog("autoScan");

    private CardService cardService;

    private CtypeService ctypeService;

    private UserStatisticsService userStatisticsService;


    /**
     * ETL主进程
     * @throws InterruptedException
     */
    public void process() throws InterruptedException {

        while (true) {
            try {
                /* 获取到期时间点 */
                Long currentTime = System.currentTimeMillis();
                log.info(" currentTime =============" + currentTime);



                /* 获取超时订单,单次最多200条 */
                Map<String, Object> conditions = new HashMap<String, Object>();
                conditions.put("status", Card.STATUS_ISSUED);
                conditions.put("expire_at & <=", currentTime);
                conditions.put("@query", "id ");
                conditions.put("@table"," card ");
                List<Long> ids = this.cardService.getIdsByDynamicCondition(Card.class, conditions, 0, TASK_LEN);
                log.info("expire cards ids is: " + ids);


                 /* 校验是否有超期accountIds */
                /* 没有,则休眠一段时间后再启动一次 */
                if(CollectionUtils.isEmpty(ids)){
                    log.info("card-expire-etl don`t get any id ,sleep " + SLEEP_MILLISECOND + " ms ");
                    Thread.sleep(SLEEP_MILLISECOND);
                /* 有,则按accountIds获取订单进行处理 */
                } else {
                    log.info("card-expire-etl get accountIds :" + ids.size());
                    List<Card> cards = this.cardService.getObjectsByIds(ids);

                    for(Card card: cards) {
                        card.setStatus(Card.STATUS_EXPIRE);
                    }
                    cardService.updateList(cards);

                    setCardTypeStatistics(cards);
                    setUserStatistics(cards);
                }



            } catch (Throwable t) {
                t.printStackTrace();
                Thread.sleep(SLEEP_MILLISECOND);
                log.error("process check expire-card error ,sleep " + t.getMessage());
            }
        }
    }


    private void setCardTypeStatistics(List<Card> cards) {

        List<Long> tids = new ArrayList<>();
        for(Card card: cards) {
            Long tid = card.getTid();
            tids.add(tid);
        }

        if (tids.size() == 0) {
            return;
        }

        try {
            List<Ctype> ctypes = ctypeService.getObjectsByIds(tids);
            for(Ctype ctype: ctypes) {
                ctype.setAssignCount(ctype.getAssignCount() - 1);
                ctype.setExpiredCount(ctype.getExpiredCount() + 1);
            }
            Boolean update = ctypeService.updateList(ctypes);
            if (update) {
                log.info("update card type statistics success");
            }
        } catch (Throwable t) {
            t.printStackTrace();
            log.error("set card type statistics error.");
        }
    }

    private void setUserStatistics(List<Card> cards) {
        List<Long> uids = new ArrayList<>();
        for(Card card: cards) {
            Long oid = card.getOwnerId();
            uids.add(oid);
        }

        if (uids.size() == 0) {
            return;
        }

        try {
            List<UserStatistics> userStatistics = userStatisticsService.getObjectsByIds(uids);
            for(UserStatistics userStatistic: userStatistics) {
                userStatistic.setCardExpired(userStatistic.getCardExpired() + 1);
                userStatistic.setCardUnused(userStatistic.getCardUnused() - 1);
            }
            Boolean update = userStatisticsService.updateList(userStatistics);
            if (update) {
                log.info("update user card statistics success");
            }
        } catch (Throwable t) {
            t.printStackTrace();
            log.error("set user card statistics error.");
        }
    }



    public CardService getCardService() {
        return cardService;
    }

    public void setCardService(CardService cardService) {
        this.cardService = cardService;
    }

    public CtypeService getCtypeService() {
        return ctypeService;
    }

    public void setCtypeService(CtypeService ctypeService) {
        this.ctypeService = ctypeService;
    }

    public UserStatisticsService getUserStatisticsService() {
        return userStatisticsService;
    }

    public void setUserStatisticsService(UserStatisticsService userStatisticsService) {
        this.userStatisticsService = userStatisticsService;
    }


}
